/*
 * Decompiled with CFR 0.152.
 */
package dmillerw.passiveenchants.block;

import cpw.mods.fml.common.registry.GameData;
import dmillerw.passiveenchants.PassiveEnchants;
import dmillerw.passiveenchants.client.render.block.RenderBlockAlter;
import dmillerw.passiveenchants.core.ModCreativeTab;
import dmillerw.passiveenchants.enchant.EnchantmentHandler;
import dmillerw.passiveenchants.lib.UtilEntity;
import dmillerw.passiveenchants.tile.TileAlter;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.material.Material;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemEnchantedBook;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class BlockAlter
extends BlockContainer {
    public static List<Block> materialExclusions = new ArrayList<Block>();

    public static ItemStack getAlter(ItemStack material) {
        ItemStack stack;
        if (material == null) {
            material = new ItemStack(Blocks.field_150348_b);
        }
        NBTTagCompound nbt = (stack = new ItemStack(PassiveEnchants.blockAlter)).func_77942_o() ? stack.func_77978_p() : new NBTTagCompound();
        NBTTagCompound item = new NBTTagCompound();
        material.func_77955_b(item);
        nbt.func_74782_a("material", (NBTBase)item);
        stack.func_77982_d(nbt);
        return stack;
    }

    public static List<ItemStack> getStoneBlocks() {
        ArrayList<ItemStack> blocks = new ArrayList<ItemStack>();
        for (int i = 0; i < 4096; ++i) {
            Block block = (Block)GameData.blockRegistry.get(i);
            if (block.func_149688_o() != Material.field_151576_e || block == PassiveEnchants.blockAlter || materialExclusions.contains(block)) continue;
            for (int j = 0; j < 16; ++j) {
                ItemStack stack = new ItemStack(block, 1, j);
                if (stack == null) continue;
                blocks.add(stack);
            }
        }
        return blocks;
    }

    public BlockAlter() {
        super(Material.field_151576_e);
        this.func_149711_c(2.0f);
        this.func_149752_b(2.0f);
        this.func_149647_a(ModCreativeTab.TAB);
    }

    public boolean func_149727_a(World world, int x, int y, int z, EntityPlayer player, int side, float fx, float fy, float fz) {
        if (!world.field_72995_K && !player.func_70093_af() && side == 1) {
            TileAlter tile = (TileAlter)world.func_147438_o(x, y, z);
            ItemStack held = player.func_70694_bm();
            if (!tile.flaming) {
                if (tile.getBook() == null && tile.getRing() == null && held != null && held.func_77973_b() instanceof ItemEnchantedBook && held.func_77942_o() && held.func_77978_p().func_150297_b("StoredEnchantments", 9)) {
                    int[] enchant = EnchantmentHandler.getEnchantmentData(held);
                    if (enchant.length == 2 && EnchantmentHandler.hasDelegate(enchant[0])) {
                        tile.setBook(held.func_77946_l(), UtilEntity.get2DFacingRotation((EntityLivingBase)player));
                        player.func_70062_b(0, null);
                    }
                } else if (tile.getBook() != null && tile.getRing() == null && held == null) {
                    player.func_70062_b(0, tile.getBook().func_77946_l());
                    tile.setBook(null, ForgeDirection.UNKNOWN);
                }
                if (tile.getBook() != null && tile.getRing() == null && held != null && held.func_77973_b() == PassiveEnchants.itemRing && EnchantmentHelper.func_82781_a((ItemStack)held).size() == 0) {
                    tile.setRing(held.func_77946_l());
                    player.func_70062_b(0, null);
                } else if (tile.getRing() != null && held == null) {
                    if (tile.finished) {
                        tile.finished = false;
                    }
                    player.func_70062_b(0, tile.getRing().func_77946_l());
                    tile.setRing(null);
                }
                if (tile.getBook() != null && tile.getRing() != null && held.func_77973_b() == Items.field_151033_d) {
                    tile.burn();
                    world.func_72908_a((double)x + 0.5, (double)y + 0.5, (double)z + 0.5, "fire.ignite", 1.0f, new Random().nextFloat() * 0.4f + 0.8f);
                    held.func_77972_a(1, (EntityLivingBase)player);
                }
            }
        }
        return !player.func_70093_af();
    }

    public boolean removedByPlayer(World world, EntityPlayer player, int x, int y, int z) {
        player.func_71020_j(0.025f);
        ItemStack stack = new ItemStack((Block)this, 1, 0);
        TileAlter tile = (TileAlter)world.func_147438_o(x, y, z);
        if (tile != null) {
            stack = BlockAlter.getAlter(tile.getMaterial());
        }
        if ((!player.field_71075_bZ.field_75098_d || player.func_70093_af()) && !world.field_72995_K && world.func_82736_K().func_82766_b("doTileDrops")) {
            float f = 0.7f;
            double d0 = (double)(world.field_73012_v.nextFloat() * f) + (double)(1.0f - f) * 0.5;
            double d1 = (double)(world.field_73012_v.nextFloat() * f) + (double)(1.0f - f) * 0.5;
            double d2 = (double)(world.field_73012_v.nextFloat() * f) + (double)(1.0f - f) * 0.5;
            EntityItem entityitem = new EntityItem(world, (double)x + d0, (double)y + d1, (double)z + d2, stack);
            entityitem.field_145804_b = 10;
            world.func_72838_d((Entity)entityitem);
        }
        return world.func_147468_f(x, y, z);
    }

    public void func_149749_a(World world, int x, int y, int z, Block block, int meta) {
        super.func_149749_a(world, x, y, z, block, meta);
        TileAlter tile = (TileAlter)world.func_147438_o(x, y, z);
        if (tile != null) {
            tile.breakBlock();
        }
    }

    public void func_149636_a(World par1World, EntityPlayer par2EntityPlayer, int par3, int par4, int par5, int par6) {
    }

    public void func_149666_a(Item item, CreativeTabs tab, List list) {
        list.add(BlockAlter.getAlter(new ItemStack(Blocks.field_150348_b)));
    }

    public void func_149719_a(IBlockAccess world, int i, int j, int k) {
        this.func_149676_a(0.125f, 0.0f, 0.125f, 0.875f, 1.0f, 0.875f);
    }

    public boolean func_149686_d() {
        return false;
    }

    public boolean func_149662_c() {
        return false;
    }

    public int func_149645_b() {
        return RenderBlockAlter.renderID;
    }

    public IIcon func_149691_a(int side, int meta) {
        return Blocks.field_150348_b.func_149691_a(0, 0);
    }

    public TileEntity func_149915_a(World var1, int var2) {
        return new TileAlter();
    }

    static {
        materialExclusions.add(Blocks.field_150357_h);
        materialExclusions.add(Blocks.field_150381_bn);
        materialExclusions.add(Blocks.field_150384_bq);
        materialExclusions.add(Blocks.field_150378_br);
        materialExclusions.add(Blocks.field_150474_ac);
        materialExclusions.add(Blocks.field_150460_al);
        materialExclusions.add(Blocks.field_150470_am);
        materialExclusions.add(Blocks.field_150367_z);
        materialExclusions.add(Blocks.field_150409_cd);
    }
}

