/*
 * Decompiled with CFR 0.152.
 */
package dmillerw.passiveenchants.enchant;

import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import dmillerw.passiveenchants.PassiveEnchants;
import dmillerw.passiveenchants.enchant.enchantment.Delegate;
import dmillerw.passiveenchants.enchant.enchantment.DelegateFireAspect;
import dmillerw.passiveenchants.enchant.enchantment.DelegateKnockback;
import dmillerw.passiveenchants.enchant.enchantment.DelegateProtection;
import dmillerw.passiveenchants.enchant.enchantment.DelegateSharpness;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.DamageSource;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.player.AttackEntityEvent;

public class EnchantmentHandler {
    public static Map<Integer, Delegate> delegates = new HashMap<Integer, Delegate>();

    public static void registerDelegate(Delegate delegate) {
        delegates.put(delegate.enchantment.field_77352_x, delegate);
    }

    public static boolean hasDelegate(int id) {
        return delegates.containsKey(id);
    }

    public static int[] getEnchantmentData(ItemStack stack) {
        NBTTagCompound enchant;
        if (stack == null) {
            return new int[0];
        }
        if (!stack.func_77942_o()) {
            return new int[0];
        }
        NBTTagCompound nBTTagCompound = enchant = stack.func_77973_b() == Items.field_151134_bR ? Items.field_151134_bR.func_92110_g(stack).func_150305_b(0) : stack.func_77986_q().func_150305_b(0);
        if (enchant == null) {
            return new int[0];
        }
        return new int[]{enchant.func_74765_d("id"), enchant.func_74765_d("lvl")};
    }

    public static ItemStack[] getRings(EntityPlayer player) {
        ArrayList<ItemStack> rings = new ArrayList<ItemStack>();
        for (int i = 0; i < (PassiveEnchants.hotbarOnly ? 9 : 36); ++i) {
            ItemStack stack = player.field_71071_by.func_70301_a(i);
            if (stack == null || stack.func_77973_b() != PassiveEnchants.itemRing) continue;
            rings.add(stack);
        }
        return rings.toArray(new ItemStack[rings.size()]);
    }

    @SubscribeEvent
    public void onPlayerHit(LivingHurtEvent event) {
        if (!(event.entityLiving instanceof EntityPlayer)) {
            return;
        }
        ArrayList<Integer> ignore = new ArrayList<Integer>();
        EntityPlayer player = (EntityPlayer)event.entityLiving;
        DamageSource source = event.source;
        float damage = event.ammount;
        for (ItemStack stack : EnchantmentHandler.getRings(player)) {
            int[] enchant = EnchantmentHandler.getEnchantmentData(stack);
            if (enchant.length != 2) {
                return;
            }
            if (ignore.contains(enchant[0]) || !EnchantmentHandler.hasDelegate(enchant[0])) continue;
            Delegate delegate = delegates.get(enchant[0]);
            damage = delegate.onPlayerDamaged(enchant[1], player, source, damage);
            if (damage != event.ammount) {
                stack.func_77972_a(1, (EntityLivingBase)player);
            }
            if (delegate.stackEffects()) continue;
            ignore.add(enchant[0]);
        }
        event.ammount = damage;
    }

    @SubscribeEvent
    public void onPlayerAttack(AttackEntityEvent event) {
        if (!(event.target instanceof EntityLivingBase)) {
            return;
        }
        ArrayList<Integer> ignore = new ArrayList<Integer>();
        EntityLivingBase target = (EntityLivingBase)event.target;
        EntityPlayer player = event.entityPlayer;
        if (!target.func_85031_j((Entity)player)) {
            for (ItemStack stack : EnchantmentHandler.getRings(player)) {
                int[] enchant = EnchantmentHandler.getEnchantmentData(stack);
                if (enchant.length != 2) {
                    return;
                }
                if (ignore.contains(enchant[0]) || !EnchantmentHandler.hasDelegate(enchant[0])) continue;
                Delegate delegate = delegates.get(enchant[0]);
                if (delegate.onPlayerAttack(enchant[1], player, target)) {
                    stack.func_77972_a(1, (EntityLivingBase)player);
                }
                if (delegate.stackEffects()) continue;
                ignore.add(enchant[0]);
            }
        }
    }

    static {
        EnchantmentHandler.registerDelegate(new DelegateProtection(Enchantment.field_77332_c));
        EnchantmentHandler.registerDelegate(new DelegateProtection(Enchantment.field_77327_f));
        EnchantmentHandler.registerDelegate(new DelegateProtection(Enchantment.field_77329_d));
        EnchantmentHandler.registerDelegate(new DelegateProtection(Enchantment.field_77328_g));
        EnchantmentHandler.registerDelegate(new DelegateProtection(Enchantment.field_77330_e));
        EnchantmentHandler.registerDelegate(new DelegateSharpness());
        EnchantmentHandler.registerDelegate(new DelegateFireAspect());
        EnchantmentHandler.registerDelegate(new DelegateKnockback());
    }
}

