/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.jordz98;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.World;

public class ArraysAPI {
    public static ArrayList<Location> LoadArrayFromFile(File f) throws IOException {
        String line;
        ArrayList<Location> list = new ArrayList<Location>();
        BufferedReader br = new BufferedReader(new FileReader(f));
        while ((line = br.readLine()) != null) {
            list.add(ArraysAPI.stringToLoc(line));
        }
        br.close();
        return list;
    }

    public static void WriteLocArrayToFile(ArrayList<Location> a, File f) throws IOException {
        BufferedWriter bw = new BufferedWriter(new FileWriter(f));
        int i = 0;
        while (i < a.size()) {
            bw.write(ArraysAPI.locToString(a.get(i)));
            bw.write("\n");
            ++i;
        }
        bw.close();
    }

    public static void WriteNameArrayToFile(ArrayList<String> a, File f) throws IOException {
        BufferedWriter bw = new BufferedWriter(new FileWriter(f));
        int i = 0;
        while (i < a.size()) {
            bw.write(a.get(i));
            bw.write("\n");
            ++i;
        }
        bw.close();
    }

    public static ArrayList<String> LoadNameArrayFromFile(File f) throws IOException {
        String line;
        ArrayList<String> list = new ArrayList<String>();
        BufferedReader br = new BufferedReader(new FileReader(f));
        while ((line = br.readLine()) != null) {
            list.add(line);
        }
        br.close();
        return list;
    }

    public static String locToString(Location l) {
        return l.getWorld().getName() + "," + l.getX() + "," + l.getY() + "," + l.getZ() + "," + l.getYaw() + "," + l.getPitch();
    }

    public static Location stringToLoc(String s) {
        try {
            String[] parts = s.split(",", 6);
            if (parts.length != 6) {
                throw new IllegalArgumentException("Invalid location. It did not contain all the parts");
            }
            World w = Bukkit.getWorld((String)parts[0]);
            double x = Double.parseDouble(parts[1]);
            double y = Double.parseDouble(parts[2]);
            double z = Double.parseDouble(parts[3]);
            float yaw = Float.parseFloat(parts[4]);
            float pitch = Float.parseFloat(parts[5]);
            if (w == null) {
                throw new IllegalStateException("World cannot be null");
            }
            return new Location(w, x, y, z, yaw, pitch);
        }
        catch (Exception ex) {
            return null;
        }
    }
}

