/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.jordz98;

import com.gmail.jordz98.ArraysAPI;
import com.gmail.jordz98.MyBlockListener;
import com.gmail.jordz98.Updater;
import java.io.File;
import java.io.IOException;
import java.util.logging.Level;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class ChestProtectPlugin
extends JavaPlugin {
    public MyBlockListener blockListener;
    public static int PlayerDamage;
    public String EnderChests;
    public String EnderChestsAccessed;
    private boolean food = false;
    public String EnderChestsEnabled;
    public static boolean EnderChestsOn;
    public static boolean EnderChestsProtected;
    public static boolean EnderChestsAccessedEnabled;
    public static File protectedWork;
    public static File protectedBlocks;
    public static File publicBlocks;
    public static File protectedNames;
    public static boolean AutoSave;

    static {
        EnderChestsOn = false;
        EnderChestsProtected = false;
        EnderChestsAccessedEnabled = false;
        protectedWork = new File("plugins/ChestProtect/ProtectedWorkBench.txt");
        protectedBlocks = new File("plugins/ChestProtect/ProtectedBlocks.txt");
        publicBlocks = new File("plugins/ChestProtect/PublicBlocks.txt");
        protectedNames = new File("plugins/ChestProtect/ProtectionNames.txt");
        AutoSave = false;
    }

    public void onEnable() {
        this.blockListener = new MyBlockListener(this);
        if (protectedBlocks.exists()) {
            try {
                MyBlockListener.protect = ArraysAPI.LoadArrayFromFile(protectedBlocks);
                this.getLogger().info("Loaded protected blocks!");
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        } else {
            try {
                protectedBlocks.createNewFile();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            this.getLogger().log(Level.WARNING, "Cannot find protected blocks file! (If this is your first time running ChestProtect, ignore this)");
        }
        if (publicBlocks.exists()) {
            try {
                MyBlockListener.publicChests = ArraysAPI.LoadArrayFromFile(publicBlocks);
                this.getLogger().info("Loaded public chests!");
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        } else {
            try {
                publicBlocks.createNewFile();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            this.getLogger().log(Level.WARNING, "Cannot find public blocks file! (If this is your first time running ChestProtect, ignore this)");
        }
        if (protectedNames.exists()) {
            try {
                MyBlockListener.usernames = ArraysAPI.LoadNameArrayFromFile(protectedNames);
                this.getLogger().info("Loaded protection owners!");
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        } else {
            try {
                protectedNames.createNewFile();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            this.getLogger().log(Level.WARNING, "Cannot find protection owners file! (If this is your first time running ChestProtect, ignore this)");
        }
        this.getLogger().info("Plugin enabled!");
        this.getConfig().options().copyDefaults(true);
        this.saveConfig();
        this.EnderChests = this.getConfig().getString("EnderChestProtection");
        this.EnderChestsAccessed = this.getConfig().getString("EnderChestsAccessed");
        this.EnderChestsEnabled = this.getConfig().getString("EnderChestEnabled");
        String AutoUpdate = this.getConfig().getString("AutoUpdate");
        String AutoSaveS = this.getConfig().getString("AutoSave");
        if (this.EnderChestsEnabled == "true") {
            EnderChestsOn = true;
        }
        if (this.EnderChestsAccessed == "true") {
            EnderChestsAccessedEnabled = true;
        }
        if (this.EnderChests == "true") {
            EnderChestsProtected = true;
        }
        if (AutoUpdate == "true") {
            Updater updater = new Updater((Plugin)this, 68051, this.getFile(), Updater.UpdateType.DEFAULT, true);
        }
        if (AutoSaveS == "true") {
            AutoSave = true;
        }
        PlayerDamage = this.getConfig().getInt("DamagePlayer");
    }

    public void onDisable() {
        this.saveData();
        this.getLogger().info("Plugin disabled!");
    }

    public void saveData() {
        try {
            ArraysAPI.WriteLocArrayToFile(MyBlockListener.protect, protectedBlocks);
            ArraysAPI.WriteNameArrayToFile(MyBlockListener.usernames, protectedNames);
            ArraysAPI.WriteLocArrayToFile(MyBlockListener.publicChests, publicBlocks);
            this.getLogger().info("Saved protection owners and blocks to file!");
        }
        catch (IOException e) {
            e.printStackTrace();
            this.getLogger().log(Level.SEVERE, "Could not save protection locations/owners to file!");
        }
    }

    public boolean onCommand(CommandSender sender, Command cmd, String label, String[] args) {
        if (cmd.getName().equalsIgnoreCase("protect")) {
            Player s = (Player)sender;
            Location toProtect = s.getTargetBlock(null, 200).getLocation();
            if (toProtect.getBlock().getType() == Material.CHEST) {
                if (!MyBlockListener.protect.contains(toProtect)) {
                    MyBlockListener.protect.add(toProtect);
                    MyBlockListener.usernames.add(String.valueOf(MyBlockListener.protect.indexOf(toProtect)) + s.getName() + ";");
                    s.sendMessage(ChatColor.YELLOW + "[ChestProtect] Protected " + s.getName() + "'s chest.");
                } else {
                    s.sendMessage(ChatColor.RED + "[ChestProtect] That chest is already protected!");
                }
            }
            EnderChestsOn = true;
            if (true && toProtect.getBlock().getType() == Material.ENDER_CHEST) {
                if (!MyBlockListener.protect.contains(toProtect)) {
                    MyBlockListener.protect.add(toProtect);
                    MyBlockListener.usernames.add(String.valueOf(MyBlockListener.protect.indexOf(toProtect)) + s.getName());
                    s.sendMessage(ChatColor.YELLOW + "[ChestProtect] Protected your ender chest.");
                } else {
                    s.sendMessage(ChatColor.RED + "[ChestProtect] That chest is already protected!");
                }
            }
            return true;
        }
        if (cmd.getName().equalsIgnoreCase("protectadd")) {
            Player s = (Player)sender;
            Location toAddTo = s.getTargetBlock(null, 200).getLocation();
            if (MyBlockListener.usernames.get(MyBlockListener.protect.indexOf(toAddTo)).contains(s.getName())) {
                MyBlockListener.usernames.set(MyBlockListener.protect.indexOf(toAddTo), String.valueOf(MyBlockListener.protect.indexOf(toAddTo)) + ";" + s.getName() + ";" + args[0] + ";");
                s.sendMessage(ChatColor.YELLOW + "[ChestProtect] Player added to protection successfully.");
            } else {
                s.sendMessage(ChatColor.RED + "[ChestProtect] You do not own this protection!");
            }
            return true;
        }
        if (cmd.getName().equalsIgnoreCase("protectrem")) {
            Player s = (Player)sender;
            Location toAddTo = s.getTargetBlock(null, 200).getLocation();
            if (MyBlockListener.usernames.get(MyBlockListener.protect.indexOf(toAddTo)).contains(s.getName())) {
                MyBlockListener.usernames.set(MyBlockListener.protect.indexOf(toAddTo), MyBlockListener.usernames.get(MyBlockListener.protect.indexOf(toAddTo)).replace(args[0], ""));
                s.sendMessage(ChatColor.YELLOW + "[ChestProtect] Deleted player successfully.");
            } else {
                s.sendMessage(ChatColor.RED + "[ChestProtect] You do not own this protection!");
            }
            return true;
        }
        if (cmd.getName().equalsIgnoreCase("protectpublic")) {
            Player s = (Player)sender;
            Location toAddTo = s.getTargetBlock(null, 200).getLocation();
            if (MyBlockListener.usernames.get(MyBlockListener.protect.indexOf(toAddTo)).contains(s.getName())) {
                if (MyBlockListener.publicChests.contains(toAddTo)) {
                    s.sendMessage(ChatColor.RED + "[ChestProtect] This protection is already public!");
                    return true;
                }
                MyBlockListener.publicChests.add(toAddTo);
                s.sendMessage(ChatColor.YELLOW + "[ChestProtect] Protection is now public.");
            } else {
                s.sendMessage(ChatColor.RED + "[ChestProtect] You do not own this protection!");
            }
            return true;
        }
        if (cmd.getName().equalsIgnoreCase("protectprivate")) {
            Player s = (Player)sender;
            Location toMakePriv = s.getTargetBlock(null, 200).getLocation();
            if (MyBlockListener.usernames.get(MyBlockListener.protect.indexOf(toMakePriv)).contains(s.getName())) {
                if (MyBlockListener.publicChests.contains(toMakePriv)) {
                    MyBlockListener.publicChests.remove(toMakePriv);
                    s.sendMessage(ChatColor.YELLOW + "[ChestProtect] Protection is no longer public.");
                } else {
                    s.sendMessage(ChatColor.RED + "[ChestProtect] This chest is not public!");
                }
            } else {
                s.sendMessage(ChatColor.RED + "[ChestProtect] You do not own this protection!");
            }
            return true;
        }
        if (cmd.getName().equalsIgnoreCase("protectinfo")) {
            Player s = (Player)sender;
            Location toCheckOn = s.getTargetBlock(null, 200).getLocation();
            Block block = s.getTargetBlock(null, 200);
            if (MyBlockListener.protect.contains(toCheckOn)) {
                String[] returner = MyBlockListener.usernames.get(MyBlockListener.protect.indexOf(toCheckOn)).split(";");
                s.sendMessage(ChatColor.YELLOW + "[ChestProtect] This protection is owned by: " + returner[1]);
                if (MyBlockListener.publicChests.contains(toCheckOn)) {
                    if (block.getType() == Material.FURNACE) {
                        s.sendMessage(ChatColor.YELLOW + "[ChestProtect] This Furnace is public.");
                    } else if (block.getType() == Material.WORKBENCH) {
                        s.sendMessage(ChatColor.YELLOW + "[ChestProtect] This Crafting Table is public.");
                    } else {
                        s.sendMessage(ChatColor.YELLOW + "[ChestProtect] This Chest is public.");
                    }
                } else if (block.getType() == Material.FURNACE) {
                    s.sendMessage(ChatColor.RED + "[ChestProtect] This Furnace is private.");
                } else if (block.getType() == Material.WORKBENCH) {
                    s.sendMessage(ChatColor.RED + "[ChestProtect] This Crafting Table is private.");
                } else {
                    s.sendMessage(ChatColor.RED + "[ChestProtect] This Chest is private.");
                }
            }
            return true;
        }
        return false;
    }
}

