/*
 * Decompiled with CFR 0.152.
 */
package com.kegare.caveworld.block;

import com.kegare.caveworld.block.CaveBlocks;
import com.kegare.caveworld.core.Caveworld;
import com.kegare.caveworld.core.Config;
import com.kegare.caveworld.inventory.InventoryCaveworldPortal;
import com.kegare.caveworld.world.TeleporterCaveworld;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockPortal;
import net.minecraft.block.material.Material;
import net.minecraft.client.particle.EntityFX;
import net.minecraft.client.particle.EntityReddustFX;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemMonsterPlacer;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.util.Direction;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.Teleporter;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;

public class BlockPortalCaveworld
extends BlockPortal {
    private InventoryCaveworldPortal inventory;
    @SideOnly(value=Side.CLIENT)
    public IIcon portalIcon;

    public BlockPortalCaveworld(String name) {
        this.func_149663_c(name);
        this.func_149658_d("caveworld:caveworld_portal");
        this.func_149722_s();
        this.func_149713_g(3);
        this.func_149715_a(0.6f);
        this.func_149672_a(field_149778_k);
        this.func_149649_H();
        this.func_149647_a(CreativeTabs.field_78031_c);
    }

    public InventoryCaveworldPortal getInventory() {
        if (this.inventory == null) {
            this.inventory = new InventoryCaveworldPortal().loadInventoryFromNBT();
        }
        return this.inventory;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149651_a(IIconRegister iconRegister) {
        this.field_149761_L = iconRegister.func_94245_a(this.func_149641_N() + "_block");
        this.portalIcon = iconRegister.func_94245_a(this.func_149641_N());
    }

    public int func_149645_b() {
        return Config.RENDER_TYPE_PORTAL;
    }

    public void func_149719_a(IBlockAccess world, int x, int y, int z) {
        int metadata = BlockPortalCaveworld.func_149999_b((int)world.func_72805_g(x, y, z));
        if (metadata == 0) {
            metadata = world.func_147439_a(x - 1, y, z) != this && world.func_147439_a(x + 1, y, z) != this ? 2 : 1;
            if (world instanceof World && !((World)world).field_72995_K) {
                ((World)world).func_72921_c(x, y, z, metadata, 2);
            }
        }
        float var1 = 0.15f;
        float var2 = 0.15f;
        if (metadata == 1) {
            var1 = 0.5f;
        } else if (metadata == 2) {
            var2 = 0.5f;
        }
        this.func_149676_a(0.5f - var1, 0.0f, 0.5f - var2, 0.5f + var1, 1.0f, 0.5f + var2);
    }

    public boolean func_150000_e(World world, int x, int y, int z) {
        Size size1 = new Size(world, x, y, z, 1);
        Size size2 = new Size(world, x, y, z, 2);
        if (size1.canCreatePortal() && size1.portalBlockCount == 0) {
            size1.setPortalBlocks();
            return true;
        }
        if (size2.canCreatePortal() && size2.portalBlockCount == 0) {
            size2.setPortalBlocks();
            return true;
        }
        return false;
    }

    public void func_149695_a(World world, int x, int y, int z, Block block) {
        int metadata = BlockPortalCaveworld.func_149999_b((int)world.func_72805_g(x, y, z));
        Size size1 = new Size(world, x, y, z, 1);
        Size size2 = new Size(world, x, y, z, 2);
        if (!(metadata != 1 || size1.canCreatePortal() && size1.portalBlockCount >= size1.portalWidth * size1.portalHeight)) {
            world.func_147449_b(x, y, z, Blocks.field_150350_a);
        } else if (!(metadata != 2 || size2.canCreatePortal() && size2.portalBlockCount >= size2.portalWidth * size2.portalHeight)) {
            world.func_147449_b(x, y, z, Blocks.field_150350_a);
        } else if (metadata == 0 && !size1.canCreatePortal() && !size2.canCreatePortal()) {
            world.func_147449_b(x, y, z, Blocks.field_150350_a);
        }
    }

    public boolean func_149727_a(World world, int x, int y, int z, EntityPlayer player, int side, float hitX, float hitY, float hitZ) {
        if (!world.field_72995_K) {
            world.func_72956_a((Entity)player, "random.click", 0.8f, 1.5f);
            player.func_71007_a((IInventory)this.getInventory().setPortalPosition(x, y, z));
        }
        return true;
    }

    public void func_149670_a(World world, int x, int y, int z, Entity entity) {
        if (!world.field_72995_K && entity.func_70089_S() && (entity.field_71093_bK == 0 || !Config.hardcoreEnabled && entity.field_71093_bK == Config.dimensionCaveworld)) {
            MinecraftServer server = Caveworld.proxy.getServer();
            int dimOld = entity.field_71093_bK;
            int dimNew = dimOld == 0 ? Config.dimensionCaveworld : 0;
            WorldServer worldOld = server.func_71218_a(dimOld);
            WorldServer worldNew = server.func_71218_a(dimNew);
            TeleporterCaveworld teleporter = new TeleporterCaveworld(worldNew);
            if (entity.field_71088_bW <= 0) {
                entity.field_70170_p.func_72900_e(entity);
                entity.field_70128_L = false;
                if (entity instanceof EntityPlayerMP) {
                    EntityPlayerMP player = (EntityPlayerMP)entity;
                    if (!player.func_70093_af() && !player.func_70644_a(Potion.field_76431_k)) {
                        player.func_71053_j();
                        worldOld.func_85173_a((EntityPlayer)player, "caveworld:caveworld_portal", 0.5f, 1.0f);
                        server.func_71203_ab().transferPlayerToDimension(player, dimNew, (Teleporter)teleporter);
                        player.func_82242_a(0);
                        player.func_70690_d(new PotionEffect(Potion.field_76431_k.func_76396_c(), 120));
                        player.func_70690_d(new PotionEffect(Potion.field_76440_q.func_76396_c(), 20));
                        worldNew.func_72956_a((Entity)player, "caveworld:caveworld_portal", 0.75f, 1.0f);
                    }
                    player.field_71088_bW = player.func_82147_ab();
                } else {
                    entity.field_71093_bK = dimNew;
                    server.func_71203_ab().transferEntityToWorld(entity, dimOld, worldOld, worldNew, (Teleporter)teleporter);
                    Entity target = EntityList.func_75620_a((String)EntityList.func_75621_b((Entity)entity), (World)worldNew);
                    if (target != null) {
                        worldOld.func_72908_a((double)x + 0.5, (double)y + 0.5, (double)z + 0.5, "caveworld:caveworld_portal", 0.25f, 1.15f);
                        target.func_82141_a(entity, true);
                        target.field_98038_p = true;
                        target.field_71088_bW = target.func_82147_ab();
                        worldNew.func_72838_d(target);
                        worldNew.func_72956_a(target, "caveworld:caveworld_portal", 0.5f, 1.15f);
                    }
                    entity.func_70106_y();
                    worldOld.func_82742_i();
                    worldNew.func_82742_i();
                }
            } else {
                entity.field_71088_bW = entity.func_82147_ab();
            }
        }
    }

    public void func_149674_a(World world, int x, int y, int z, Random random) {
        if (!world.field_72995_K && world.field_73011_w.field_76574_g == 0 && world.func_82736_K().func_82766_b("doMobSpawning") && !world.func_72935_r() && random.nextInt(300) < world.field_73013_u.func_151525_a()) {
            Entity entity;
            while (!World.func_147466_a((IBlockAccess)world, (int)x, (int)y, (int)z) && y > 0) {
                --y;
            }
            if (y > 0 && !world.func_147439_a(x, y + 1, z).func_149637_q() && (entity = ItemMonsterPlacer.func_77840_a((World)world, (int)65, (double)((double)x + 0.5), (double)((double)y + 1.0), (double)((double)z + 0.5))) != null) {
                entity.field_71088_bW = entity.func_82147_ab();
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149734_b(World world, int x, int y, int z, Random random) {
        if (random.nextInt(200) == 0) {
            world.func_72980_b((double)x + 0.5, (double)y + 0.5, (double)z + 0.5, "ambient.cave.cave", 0.25f, random.nextFloat() * 0.4f + 0.8f, false);
        }
        if (random.nextInt(3) == 0) {
            double ptX = (float)x + random.nextFloat();
            double ptY = (double)y + 0.5;
            double ptZ = (float)z + random.nextFloat();
            EntityReddustFX entityFX = new EntityReddustFX(world, ptX, ptY, ptZ, 0.5f, 1.0f, 1.0f);
            Caveworld.proxy.addEffect((EntityFX)entityFX);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public Item func_149694_d(World world, int x, int y, int z) {
        return Item.func_150898_a((Block)this);
    }

    public static class Size {
        private final World worldObj;
        private final int portalMetadata;
        private final int field_150863_d;
        private final int field_150866_c;
        private ChunkCoordinates portalCoord;
        private int portalWidth;
        private int portalHeight;
        private int portalBlockCount = 0;

        public Size(World world, int x, int y, int z, int metadata) {
            this.worldObj = world;
            this.portalMetadata = metadata;
            this.field_150863_d = BlockPortal.field_150001_a[metadata][0];
            this.field_150866_c = BlockPortal.field_150001_a[metadata][1];
            int i = y;
            while (y > i - 21 && y > 0 && this.isReplaceablePortal(world.func_147439_a(x, y - 1, z))) {
                --y;
            }
            i = this.getPortalWidth(x, y, z, this.field_150863_d) - 1;
            if (i >= 0) {
                this.portalCoord = new ChunkCoordinates(x + i * Direction.field_71583_a[this.field_150863_d], y, z + i * Direction.field_71581_b[this.field_150863_d]);
                this.portalWidth = this.getPortalWidth(this.portalCoord.field_71574_a, this.portalCoord.field_71572_b, this.portalCoord.field_71573_c, this.field_150866_c);
                if (this.portalWidth < 2 || this.portalWidth > 21) {
                    this.portalCoord = null;
                    this.portalWidth = 0;
                }
            }
            if (this.portalCoord != null) {
                this.portalHeight = this.getPortalHeight();
            }
        }

        protected int getPortalWidth(int x, int y, int z, int par4) {
            int i;
            int var1 = Direction.field_71583_a[par4];
            int var2 = Direction.field_71581_b[par4];
            for (i = 0; i < 22 && this.isReplaceablePortal(this.worldObj.func_147439_a(x + var1 * i, y, z + var2 * i)) && this.worldObj.func_147439_a(x + var1 * i, y - 1, z + var2 * i) == Blocks.field_150341_Y; ++i) {
            }
            return this.worldObj.func_147439_a(x + var1 * i, y, z + var2 * i) == Blocks.field_150341_Y ? i : 0;
        }

        protected int getPortalHeight() {
            int l;
            int k;
            int j;
            int i;
            this.portalHeight = 0;
            block0: while (this.portalHeight < 21) {
                i = this.portalCoord.field_71572_b + this.portalHeight;
                for (j = 0; j < this.portalWidth; ++j) {
                    k = this.portalCoord.field_71574_a + j * Direction.field_71583_a[this.field_150866_c];
                    l = this.portalCoord.field_71573_c + j * Direction.field_71581_b[this.field_150866_c];
                    Block block = this.worldObj.func_147439_a(k, i, l);
                    if (!this.isReplaceablePortal(block)) break block0;
                    if (block == CaveBlocks.caveworld_portal) {
                        ++this.portalBlockCount;
                    }
                    if (j == 0 ? (block = this.worldObj.func_147439_a(k + Direction.field_71583_a[this.field_150863_d], i, l + Direction.field_71581_b[this.field_150863_d])) != Blocks.field_150341_Y : j == this.portalWidth - 1 && (block = this.worldObj.func_147439_a(k + Direction.field_71583_a[this.field_150866_c], i, l + Direction.field_71581_b[this.field_150866_c])) != Blocks.field_150341_Y) break block0;
                }
                ++this.portalHeight;
            }
            for (i = 0; i < this.portalWidth; ++i) {
                j = this.portalCoord.field_71574_a + i * Direction.field_71583_a[this.field_150866_c];
                k = this.portalCoord.field_71572_b + this.portalHeight;
                l = this.portalCoord.field_71573_c + i * Direction.field_71581_b[this.field_150866_c];
                if (this.worldObj.func_147439_a(j, k, l) == Blocks.field_150341_Y) continue;
                this.portalHeight = 0;
                break;
            }
            if (this.portalHeight <= 21 && this.portalHeight >= 3) {
                return this.portalHeight;
            }
            this.portalCoord = null;
            this.portalWidth = 0;
            this.portalHeight = 0;
            return 0;
        }

        protected boolean isReplaceablePortal(Block block) {
            return block.func_149688_o() == Material.field_151579_a || block == CaveBlocks.caveworld_portal;
        }

        public boolean canCreatePortal() {
            if (this.portalCoord != null && this.portalWidth >= 2 && this.portalWidth <= 21 && this.portalHeight >= 3 && this.portalHeight <= 21) {
                for (int i = 0; i < this.portalWidth; ++i) {
                    int x = this.portalCoord.field_71574_a + Direction.field_71583_a[this.field_150866_c] * i;
                    int z = this.portalCoord.field_71573_c + Direction.field_71581_b[this.field_150866_c] * i;
                    for (int j = 0; j < this.portalHeight; ++j) {
                        if (this.portalMetadata == 1) {
                            if (this.worldObj.func_147439_a(x, this.portalCoord.field_71572_b + j, z + 1) == CaveBlocks.caveworld_portal) {
                                return false;
                            }
                            if (this.worldObj.func_147439_a(x, this.portalCoord.field_71572_b + j, z - 1) != CaveBlocks.caveworld_portal) continue;
                            return false;
                        }
                        if (this.portalMetadata != 2) continue;
                        if (this.worldObj.func_147439_a(x + 1, this.portalCoord.field_71572_b + j, z) == CaveBlocks.caveworld_portal) {
                            return false;
                        }
                        if (this.worldObj.func_147439_a(x - 1, this.portalCoord.field_71572_b + j, z) != CaveBlocks.caveworld_portal) continue;
                        return false;
                    }
                }
                return true;
            }
            return false;
        }

        public void setPortalBlocks() {
            for (int i = 0; i < this.portalWidth; ++i) {
                int x = this.portalCoord.field_71574_a + Direction.field_71583_a[this.field_150866_c] * i;
                int z = this.portalCoord.field_71573_c + Direction.field_71581_b[this.field_150866_c] * i;
                for (int j = 0; j < this.portalHeight; ++j) {
                    this.worldObj.func_147465_d(x, this.portalCoord.field_71572_b + j, z, (Block)CaveBlocks.caveworld_portal, this.portalMetadata, 2);
                }
            }
        }
    }
}

