/*
 * Decompiled with CFR 0.152.
 */
package com.kegare.caveworld.core;

import com.google.common.base.Charsets;
import com.google.common.base.Joiner;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.common.io.Files;
import com.google.common.io.LineProcessor;
import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import com.kegare.caveworld.core.Config;
import com.kegare.caveworld.util.CaveLog;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.Random;
import java.util.SortedSet;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.util.WeightedRandom;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraftforge.common.BiomeDictionary;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.apache.commons.lang3.text.StrBuilder;
import org.apache.logging.log4j.Level;

public class CaveBiomeManager {
    private static final SortedSet<CaveBiome> CAVE_BIOMES = Sets.newTreeSet((Comparator)new Comparator<CaveBiome>(){

        @Override
        public int compare(CaveBiome o1, CaveBiome o2) {
            return Integer.valueOf(o1.biome.field_76756_M).compareTo(o2.biome.field_76756_M);
        }
    });
    private static final Map<Integer, Integer> genWeightMap = Maps.newHashMap();
    private static final Map<Integer, Block> terrainBlockMap = Maps.newHashMap();

    private static void initCaveBiomes() {
        CaveBiomeManager.clearCaveBiomes();
        CaveBiomeManager.addCaveBiome(new CaveBiome(BiomeGenBase.field_76771_b, 30));
        CaveBiomeManager.addCaveBiome(new CaveBiome(BiomeGenBase.field_76772_c, 100));
        CaveBiomeManager.addCaveBiome(new CaveBiome(BiomeGenBase.field_76769_d, 90));
        CaveBiomeManager.addCaveBiome(new CaveBiome(BiomeGenBase.field_76786_s, 10));
        CaveBiomeManager.addCaveBiome(new CaveBiome(BiomeGenBase.field_76767_f, 100));
        CaveBiomeManager.addCaveBiome(new CaveBiome(BiomeGenBase.field_76785_t, 15));
        CaveBiomeManager.addCaveBiome(new CaveBiome(BiomeGenBase.field_76768_g, 100));
        CaveBiomeManager.addCaveBiome(new CaveBiome(BiomeGenBase.field_76784_u, 15));
        CaveBiomeManager.addCaveBiome(new CaveBiome(BiomeGenBase.field_76782_w, 90));
        CaveBiomeManager.addCaveBiome(new CaveBiome(BiomeGenBase.field_76792_x, 10));
        CaveBiomeManager.addCaveBiome(new CaveBiome(BiomeGenBase.field_76780_h, 50));
        CaveBiomeManager.addCaveBiome(new CaveBiome(BiomeGenBase.field_76770_e, 30));
        CaveBiomeManager.addCaveBiome(new CaveBiome(BiomeGenBase.field_76783_v, 10));
        CaveBiomeManager.addCaveBiome(new CaveBiome(BiomeGenBase.field_76774_n, 20));
        CaveBiomeManager.addCaveBiome(new CaveBiome(BiomeGenBase.field_76775_o, 20));
        CaveBiomeManager.addCaveBiome(new CaveBiome(BiomeGenBase.field_76787_r, 3));
        CaveBiomeManager.addCaveBiome(new CaveBiome(BiomeGenBase.field_76781_i, 3));
        CaveBiomeManager.addCaveBiome(new CaveBiome(BiomeGenBase.field_76789_p, 2));
        CaveBiomeManager.addCaveBiome(new CaveBiome(BiomeGenBase.field_76788_q, 1));
        CaveBiomeManager.addCaveBiome(new CaveBiome(BiomeGenBase.field_150588_X, 30));
        CaveBiomeManager.addCaveBiome(new CaveBiome(BiomeGenBase.field_150589_Z, 3));
        CaveBiomeManager.addCaveBiome(new CaveBiome(BiomeGenBase.field_76778_j, 0, Blocks.field_150424_aL));
        CaveBiomeManager.addCaveBiome(new CaveBiome(BiomeGenBase.field_76779_k, 0, Blocks.field_150377_bs));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static boolean loadCaveBiomes() {
        block15: {
            boolean data2;
            File file;
            block14: {
                String data2;
                file = Config.getConfigFile("biomes");
                if (!file.exists() || !file.canRead() || Strings.isNullOrEmpty((String)(data2 = (String)Files.readLines((File)file, (Charset)Charsets.US_ASCII, (LineProcessor)new LineProcessor<String>(){
                    private final StringBuilder builder = new StringBuilder();

                    public boolean processLine(String line) throws IOException {
                        if (!Strings.isNullOrEmpty((String)line) && !(line = StringUtils.deleteWhitespace((String)line)).startsWith("#")) {
                            this.builder.append(line);
                        }
                        return true;
                    }

                    public String getResult() {
                        return this.builder.toString();
                    }
                }))) || !CaveBiomeManager.loadCaveBiomesFromString(data2)) break block14;
                boolean bl = true;
                if (CAVE_BIOMES.isEmpty()) {
                    CaveBiomeManager.initCaveBiomes();
                }
                for (BiomeGenBase biome : BiomeGenBase.func_150565_n()) {
                    if (biome == null) continue;
                    CaveBiomeManager.addCaveBiome(new CaveBiome(biome, 0));
                }
                CaveLog.info("Loaded %d cave biomes", CaveBiomeManager.getActiveBiomeCount());
                CaveBiomeManager.saveCaveBiomes();
                return bl;
            }
            try {
                boolean bl = data2 = !CAVE_BIOMES.isEmpty();
            }
            catch (Exception e) {
                try {
                    File dest = new File(file.getParentFile(), file.getName() + ".bak");
                    if (dest.exists()) {
                        dest.delete();
                    }
                    file.renameTo(dest);
                    CaveLog.severe("A critical error occured reading the " + file.getName() + " file, defaults will be used - the invalid file is backed up at " + dest.getName(), e);
                }
                catch (Throwable throwable) {
                    if (CAVE_BIOMES.isEmpty()) {
                        CaveBiomeManager.initCaveBiomes();
                    }
                    for (BiomeGenBase biome : BiomeGenBase.func_150565_n()) {
                        if (biome == null) continue;
                        CaveBiomeManager.addCaveBiome(new CaveBiome(biome, 0));
                    }
                    CaveLog.info("Loaded %d cave biomes", CaveBiomeManager.getActiveBiomeCount());
                    CaveBiomeManager.saveCaveBiomes();
                    throw throwable;
                }
                if (CAVE_BIOMES.isEmpty()) {
                    CaveBiomeManager.initCaveBiomes();
                }
                for (BiomeGenBase biome : BiomeGenBase.func_150565_n()) {
                    if (biome == null) continue;
                    CaveBiomeManager.addCaveBiome(new CaveBiome(biome, 0));
                }
                CaveLog.info("Loaded %d cave biomes", CaveBiomeManager.getActiveBiomeCount());
                CaveBiomeManager.saveCaveBiomes();
                break block15;
            }
            if (CAVE_BIOMES.isEmpty()) {
                CaveBiomeManager.initCaveBiomes();
            }
            for (BiomeGenBase biome : BiomeGenBase.func_150565_n()) {
                if (biome == null) continue;
                CaveBiomeManager.addCaveBiome(new CaveBiome(biome, 0));
            }
            CaveLog.info("Loaded %d cave biomes", CaveBiomeManager.getActiveBiomeCount());
            CaveBiomeManager.saveCaveBiomes();
            return data2;
        }
        return false;
    }

    public static boolean loadCaveBiomesFromString(String data) {
        Map json = (Map)new Gson().fromJson(data, new TypeToken<Map<String, Map<String, Object>>>(){}.getType());
        for (String key : json.keySet()) {
            Block block;
            Map entry = (Map)json.get(key);
            int weight = entry.containsKey("genWeight") ? ((Number)entry.get("genWeight")).intValue() : 1;
            Block block2 = block = entry.containsKey("terrainBlock") ? Block.func_149684_b((String)((String)entry.get("terrainBlock"))) : Blocks.field_150348_b;
            if (block == null || block.func_149688_o().func_76224_d() || !block.func_149688_o().func_76220_a() || block.func_149688_o().func_76222_j()) {
                block = Blocks.field_150348_b;
            }
            if (key.matches("^[0-9]{1,3}$")) {
                BiomeGenBase biome;
                int id = NumberUtils.toInt((String)key, (int)-1);
                if (id < 0 || id >= BiomeGenBase.func_150565_n().length || (biome = BiomeGenBase.func_150565_n()[id]) == null) continue;
                CaveBiomeManager.addCaveBiome(new CaveBiome(biome, weight, block));
                continue;
            }
            BiomeDictionary.Type type = BiomeDictionary.Type.valueOf((String)key.toUpperCase(Locale.ENGLISH));
            if (type == null) continue;
            for (BiomeGenBase biome : BiomeDictionary.getBiomesForType((BiomeDictionary.Type)type)) {
                CaveBiomeManager.addCaveBiome(new CaveBiome(biome, weight, block));
            }
        }
        return !CAVE_BIOMES.isEmpty();
    }

    static boolean saveCaveBiomes() {
        try {
            File file = Config.getConfigFile("biomes");
            String dest = null;
            if (file.exists() && file.canRead()) {
                dest = FileUtils.readFileToString((File)file);
            }
            StrBuilder builder = new StrBuilder(dest == null ? 2048 : dest.length());
            builder.appendln("# Configuration file - Caveworld biomes");
            builder.appendNewLine();
            builder.appendln('{');
            Iterator biomes = CAVE_BIOMES.iterator();
            while (biomes.hasNext()) {
                CaveBiome caveBiome = (CaveBiome)((Object)biomes.next());
                BiomeGenBase biome = caveBiome.biome;
                builder.append("  # ").append(biome.field_76791_y);
                if (BiomeDictionary.isBiomeRegistered((BiomeGenBase)biome)) {
                    HashSet types = Sets.newHashSet();
                    for (BiomeDictionary.Type type : BiomeDictionary.getTypesForBiome((BiomeGenBase)biome)) {
                        types.add(type.name());
                    }
                    builder.append(" [").append(Joiner.on((String)", ").skipNulls().join((Iterable)types)).append(']');
                }
                builder.appendNewLine();
                builder.append("  \"").append(biome.field_76756_M).appendln("\": {");
                builder.append("    \"genWeight\": ").append(caveBiome.field_76292_a);
                if (caveBiome.terrainBlock != Blocks.field_150348_b) {
                    builder.appendln(',');
                    builder.append("    \"terrainBlock\": \"").append(Block.field_149771_c.func_148750_c((Object)caveBiome.terrainBlock)).append("\"");
                }
                builder.appendNewLine();
                builder.append("  }");
                if (biomes.hasNext()) {
                    builder.append(',');
                }
                builder.appendNewLine();
            }
            String data = builder.append('}').toString();
            if (dest != null && data.equals(dest)) {
                return false;
            }
            FileUtils.writeStringToFile((File)file, (String)data);
            return true;
        }
        catch (Exception e) {
            CaveLog.log(Level.ERROR, e, "An error occurred trying to saving cave biomes", new Object[0]);
            return false;
        }
    }

    public static boolean addCaveBiome(CaveBiome biome) {
        for (CaveBiome caveBiome : CAVE_BIOMES) {
            if (caveBiome.biome.field_76756_M != biome.biome.field_76756_M) continue;
            caveBiome.field_76292_a += biome.field_76292_a;
            return false;
        }
        return CAVE_BIOMES.add(biome);
    }

    public static boolean removeCaveBiome(BiomeGenBase biome) {
        for (CaveBiome caveBiome : CAVE_BIOMES) {
            if (caveBiome.biome.field_76756_M != biome.field_76756_M) continue;
            return CAVE_BIOMES.remove((Object)caveBiome);
        }
        return false;
    }

    public static int getActiveBiomeCount() {
        int count = 0;
        for (CaveBiome caveBiome : CAVE_BIOMES) {
            if (caveBiome.field_76292_a <= 0) continue;
            ++count;
        }
        return count;
    }

    public static int getBiomeGenWeight(BiomeGenBase biome) {
        if (genWeightMap.containsKey(biome.field_76756_M)) {
            return genWeightMap.get(biome.field_76756_M);
        }
        for (CaveBiome caveBiome : CAVE_BIOMES) {
            if (caveBiome.biome.field_76756_M != biome.field_76756_M) continue;
            genWeightMap.put(biome.field_76756_M, caveBiome.field_76292_a);
            return caveBiome.field_76292_a;
        }
        return 0;
    }

    public static Block getBiomeTerrainBlock(BiomeGenBase biome) {
        if (terrainBlockMap.containsKey(biome.field_76756_M)) {
            return terrainBlockMap.get(biome.field_76756_M);
        }
        for (CaveBiome caveBiome : CAVE_BIOMES) {
            if (caveBiome.biome.field_76756_M != biome.field_76756_M) continue;
            Block block = caveBiome.terrainBlock;
            if (block == null || block.func_149688_o().func_76224_d() || !block.func_149688_o().func_76220_a() || block.func_149688_o().func_76222_j()) {
                block = Blocks.field_150348_b;
            }
            terrainBlockMap.put(biome.field_76756_M, block);
            return block;
        }
        return Blocks.field_150348_b;
    }

    public static BiomeGenBase getRandomBiome(Random random) {
        try {
            return ((CaveBiome)WeightedRandom.func_76271_a((Random)random, CaveBiomeManager.CAVE_BIOMES)).biome;
        }
        catch (Exception e) {
            return BiomeGenBase.field_76772_c;
        }
    }

    public static void clearCaveBiomes() {
        CAVE_BIOMES.clear();
    }

    public static ImmutableSet<CaveBiome> getCaveBiomes() {
        return new ImmutableSet.Builder().addAll(CAVE_BIOMES).build();
    }

    public static ImmutableList<BiomeGenBase> getBiomeList() {
        HashSet biomes = Sets.newHashSet();
        for (CaveBiome caveBiome : CAVE_BIOMES) {
            biomes.add(caveBiome.biome);
        }
        return new ImmutableList.Builder().addAll((Iterable)biomes).build();
    }

    public static class CaveBiome
    extends WeightedRandom.Item {
        public final BiomeGenBase biome;
        public final Block terrainBlock;

        public CaveBiome(BiomeGenBase biome, int weight) {
            this(biome, weight, Blocks.field_150348_b);
        }

        public CaveBiome(BiomeGenBase biome, int weight, Block block) {
            super(weight);
            this.biome = biome;
            this.terrainBlock = block;
        }

        public String toString() {
            return "\"" + this.biome.field_76756_M + "\":{\"genWeight\":" + this.field_76292_a + ',' + "\"terrainBlock\":\"" + Block.field_149771_c.func_148750_c((Object)this.terrainBlock) + "\"}";
        }

        public boolean equals(Object target) {
            return target instanceof CaveBiome && this.biome.field_76756_M == ((CaveBiome)((Object)target)).biome.field_76756_M;
        }
    }
}

