/*
 * Decompiled with CFR 0.152.
 */
package com.kegare.caveworld.core;

import com.google.common.base.Joiner;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.kegare.caveworld.core.Caveworld;
import com.kegare.caveworld.packet.MiningCountPacket;
import com.kegare.caveworld.world.WorldProviderCaveworld;
import java.util.HashSet;
import java.util.Map;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTTagCompound;
import org.apache.commons.lang3.math.NumberUtils;

public class CaveMiningManager {
    private static final Map<String, Integer> MINING_COUNTS = Maps.newHashMap();

    public static void loadMiningData() {
        NBTTagCompound data = WorldProviderCaveworld.getDimData();
        if (data.func_74764_b("Caveworld:MiningCount")) {
            for (String str : data.func_74779_i("Caveworld:MiningCount").split(";")) {
                String[] entry = str.split(":");
                MINING_COUNTS.put(entry[0], NumberUtils.toInt((String)entry[1]));
            }
        }
    }

    public static void saveMiningData() {
        NBTTagCompound data = WorldProviderCaveworld.getDimData();
        if (!MINING_COUNTS.isEmpty()) {
            HashSet entries = Sets.newHashSet();
            for (String key : MINING_COUNTS.keySet()) {
                entries.add(key + ":" + MINING_COUNTS.get(key));
            }
            if (!entries.isEmpty()) {
                data.func_74778_a("Caveworld:MiningCount", Joiner.on((char)';').skipNulls().join((Iterable)entries));
            }
        }
    }

    public static void clearMiningData() {
        MINING_COUNTS.clear();
    }

    public static void setMiningCount(EntityPlayer player, int count) {
        MINING_COUNTS.put(player.func_70005_c_(), Math.max(count, 0));
    }

    public static void setMiningLevel(EntityPlayer player, int level) {
        CaveMiningManager.setMiningCount(player, level * 500);
    }

    public static int addMiningCount(EntityPlayer player, int count) {
        String key = player.func_70005_c_();
        if (MINING_COUNTS.containsKey(key)) {
            int dest = CaveMiningManager.getMiningCount(player);
            MINING_COUNTS.put(key, Math.max(dest += count, 0));
        } else {
            CaveMiningManager.setMiningCount(player, Math.max(count, 0));
        }
        return CaveMiningManager.syncMiningCount(player);
    }

    public static int addMiningLevel(EntityPlayer player, int level) {
        return CaveMiningManager.addMiningCount(player, level * 500);
    }

    public static int getMiningCount(EntityPlayer player) {
        String key = player.func_70005_c_();
        if (MINING_COUNTS.containsKey(key)) {
            return Math.max(MINING_COUNTS.get(key), 0);
        }
        return 0;
    }

    public static int getMiningLevel(EntityPlayer player) {
        return CaveMiningManager.getMiningCount(player) / 500;
    }

    public static int syncMiningCount(EntityPlayer player) {
        int count = CaveMiningManager.getMiningCount(player);
        if (player instanceof EntityPlayerMP) {
            Caveworld.packetPipeline.sendPacketToPlayer(new MiningCountPacket(count), (EntityPlayerMP)player);
        }
        return count;
    }
}

