/*
 * Decompiled with CFR 0.152.
 */
package com.kegare.caveworld.core;

import com.google.common.base.Charsets;
import com.google.common.base.Splitter;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import com.google.common.io.Files;
import com.google.common.io.LineProcessor;
import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import com.kegare.caveworld.core.Config;
import com.kegare.caveworld.util.CaveLog;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.SortedSet;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.init.Blocks;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraft.world.gen.feature.WorldGenerator;
import net.minecraftforge.common.BiomeDictionary;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.apache.commons.lang3.text.StrBuilder;
import org.apache.logging.log4j.Level;

public class CaveOreManager {
    private static final LinkedHashSet<CaveOre> CAVE_ORES = Sets.newLinkedHashSet();

    private static void initCaveOres() {
        CaveOreManager.clearCaveOres();
        CaveOreManager.addCaveOre(new CaveOre(Blocks.field_150365_q).setGenBlockCount(16).setGenRarity(20));
        CaveOreManager.addCaveOre(new CaveOre(Blocks.field_150366_p).setGenBlockCount(10).setGenRarity(28));
        CaveOreManager.addCaveOre(new CaveOre(Blocks.field_150352_o).setGenBlockCount(8).setGenRarity(2).setGenMaxHeight(127));
        CaveOreManager.addCaveOre(new CaveOre(Blocks.field_150450_ax).setGenBlockCount(7).setGenRarity(8).setGenMaxHeight(40));
        CaveOreManager.addCaveOre(new CaveOre(Blocks.field_150369_x).setGenBlockCount(5).setGenMaxHeight(40));
        CaveOreManager.addCaveOre(new CaveOre(Blocks.field_150482_ag).setGenBlockCount(8).setGenMaxHeight(20));
        CaveOreManager.addCaveOre(new CaveOre(Blocks.field_150412_bA).setGenBlockCount(5).setGenRarity(3).setGenMinHeight(50).addGenBiomes(BiomeDictionary.Type.MOUNTAIN, BiomeDictionary.Type.HILLS));
        CaveOreManager.addCaveOre(new CaveOre(Blocks.field_150449_bY).setGenBlockCount(10).setGenRarity(16).setGenTargetBlock(Blocks.field_150424_aL).addGenBiomes(BiomeDictionary.Type.NETHER));
        CaveOreManager.addCaveOre(new CaveOre(Blocks.field_150346_d).setGenBlockCount(24).setGenRarity(18));
        CaveOreManager.addCaveOre(new CaveOre(Blocks.field_150351_n).setGenBlockCount(20).setGenRarity(6));
        CaveOreManager.addCaveOre(new CaveOre(Blocks.field_150354_m).setGenBlockCount(20).setGenRarity(8).addGenBiomes(BiomeDictionary.Type.DESERT));
        CaveOreManager.addCaveOre(new CaveOre(Blocks.field_150354_m).setGenBlockCount(20).setGenRarity(8).setGenMinHeight(20).setGenTargetBlock(Blocks.field_150351_n).addGenBiomes(BiomeDictionary.Type.DESERT));
        CaveOreManager.addCaveOre(new CaveOre(Blocks.field_150425_aM).setGenBlockCount(20).setGenRarity(10).setGenTargetBlock(Blocks.field_150424_aL).addGenBiomes(BiomeDictionary.Type.NETHER));
        CaveOreManager.addCaveOre(new CaveOre(Blocks.field_150405_ch).setBlockMetadata(1).setGenBlockCount(24).setGenRarity(20).setGenTargetBlock(Blocks.field_150346_d).addGenBiomes(BiomeGenBase.field_150589_Z, BiomeGenBase.field_150608_ab, BiomeGenBase.field_150607_aa));
        CaveOreManager.addCaveOre(new CaveOre(Blocks.field_150405_ch).setBlockMetadata(12).setGenBlockCount(24).setGenRarity(14).setGenTargetBlock(Blocks.field_150346_d).addGenBiomes(BiomeGenBase.field_150589_Z, BiomeGenBase.field_150608_ab, BiomeGenBase.field_150607_aa));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static boolean loadCaveOres() {
        boolean data222;
        File file;
        block7: {
            String data222;
            file = Config.getConfigFile("ores");
            if (!file.exists() || !file.canRead() || Strings.isNullOrEmpty((String)(data222 = (String)Files.readLines((File)file, (Charset)Charsets.US_ASCII, (LineProcessor)new LineProcessor<String>(){
                private final StringBuilder builder = new StringBuilder();

                public boolean processLine(String line) throws IOException {
                    if (!Strings.isNullOrEmpty((String)line) && !(line = StringUtils.deleteWhitespace((String)line)).startsWith("#")) {
                        this.builder.append(line);
                    }
                    return true;
                }

                public String getResult() {
                    return this.builder.toString();
                }
            }))) || !CaveOreManager.loadCaveOresFromString(data222)) break block7;
            boolean bl = true;
            CaveLog.info("Loaded %d cave ores", CAVE_ORES.size());
            CaveOreManager.saveCaveOres();
            return bl;
        }
        try {
            CaveOreManager.initCaveOres();
            data222 = !CAVE_ORES.isEmpty();
        }
        catch (Exception e) {
            try {
                File dest;
                if (CAVE_ORES.isEmpty()) {
                    CaveOreManager.initCaveOres();
                }
                if ((dest = new File(file.getParentFile(), file.getName() + ".bak")).exists()) {
                    dest.delete();
                }
                file.renameTo(dest);
                CaveLog.severe("A critical error occured reading the " + file.getName() + " file, defaults will be used - the invalid file is backed up at " + dest.getName(), e);
            }
            catch (Throwable throwable) {
                CaveLog.info("Loaded %d cave ores", CAVE_ORES.size());
                CaveOreManager.saveCaveOres();
                throw throwable;
            }
            CaveLog.info("Loaded %d cave ores", CAVE_ORES.size());
            CaveOreManager.saveCaveOres();
            return false;
        }
        CaveLog.info("Loaded %d cave ores", CAVE_ORES.size());
        CaveOreManager.saveCaveOres();
        return data222;
    }

    public static boolean loadCaveOresFromString(String data) {
        List json = (List)new Gson().fromJson(data, new TypeToken<List<Map<String, Object>>>(){}.getType());
        for (Map entry : json) {
            Block block = entry.containsKey("block") ? Block.func_149684_b((String)((String)entry.get("block"))) : null;
            if (block == null || block.func_149688_o().func_76224_d() || !block.func_149688_o().func_76220_a() || block.func_149688_o().func_76222_j()) continue;
            CaveOre ore = new CaveOre(block);
            if (entry.containsKey("blockMetadata")) {
                ore.setBlockMetadata(((Number)entry.get("blockMetadata")).intValue());
            }
            if (entry.containsKey("genBlockCount")) {
                ore.setGenBlockCount(((Number)entry.get("genBlockCount")).intValue());
            }
            if (entry.containsKey("genRarity")) {
                ore.setGenRarity(((Number)entry.get("genRarity")).intValue());
            }
            if (entry.containsKey("genMinHeight")) {
                ore.setGenMinHeight(((Number)entry.get("genMinHeight")).intValue());
            }
            if (entry.containsKey("genMaxHeight")) {
                ore.setGenMaxHeight(((Number)entry.get("genMaxHeight")).intValue());
            }
            if (entry.containsKey("genTargetBlock")) {
                ore.setGenTargetBlock(Block.func_149684_b((String)((String)entry.get("genTargetBlock"))));
            }
            if (entry.containsKey("genBiomes")) {
                for (String str : Splitter.on((char)',').omitEmptyStrings().split((CharSequence)((String)entry.get("genBiomes")))) {
                    if (str.matches("^[0-9]{1,3}$")) {
                        int id = NumberUtils.toInt((String)str, (int)-1);
                        if (id < 0 || id >= 256) continue;
                        ore.addGenBiomes(id);
                        continue;
                    }
                    BiomeDictionary.Type type = BiomeDictionary.Type.valueOf((String)str.toUpperCase(Locale.ENGLISH));
                    if (type == null) continue;
                    ore.addGenBiomes(type);
                }
            }
            CaveOreManager.addCaveOre(ore);
        }
        return !CAVE_ORES.isEmpty();
    }

    static boolean saveCaveOres() {
        try {
            File file = Config.getConfigFile("ores");
            String dest = null;
            if (file.exists() && file.canRead()) {
                dest = FileUtils.readFileToString((File)file);
            }
            StrBuilder builder = new StrBuilder(dest == null ? 2048 : dest.length());
            builder.appendln("# Configuration file - Caveworld ores");
            builder.appendNewLine();
            builder.appendln('[');
            Iterator ores = CAVE_ORES.iterator();
            while (ores.hasNext()) {
                CaveOre ore = (CaveOre)((Object)ores.next());
                builder.appendln("  {");
                builder.append("    \"block\": \"").append(Block.field_149771_c.func_148750_c((Object)ore.block)).appendln("\",");
                if (ore.blockMetadata != 0) {
                    builder.append("    \"blockMetadata\": ").append(ore.blockMetadata).appendln(',');
                }
                builder.append("    \"genBlockCount\": ").append(ore.genBlockCount).appendln(',');
                builder.append("    \"genRarity\": ").append(ore.genRarity).appendln(',');
                builder.append("    \"genMinHeight\": ").append(ore.genMinHeight).appendln(',');
                builder.append("    \"genMaxHeight\": ").append(ore.genMaxHeight);
                if (ore.genTargetBlock != Blocks.field_150348_b) {
                    builder.appendln(',');
                    builder.append("    \"genTargetBlock\": \"").append(Block.field_149771_c.func_148750_c((Object)ore.genTargetBlock)).append("\"");
                }
                if (!ore.genBiomeTypes.isEmpty() || !ore.genBiomeIds.isEmpty()) {
                    builder.appendln(',');
                    builder.append("    \"genBiomes\": \"");
                    Iterator types = ore.genBiomeTypes.iterator();
                    while (types.hasNext()) {
                        builder.append(((BiomeDictionary.Type)types.next()).name());
                        if (!types.hasNext() && ore.genBiomeIds.isEmpty()) continue;
                        builder.append(',');
                    }
                    Iterator ids = ore.genBiomeIds.iterator();
                    while (ids.hasNext()) {
                        builder.append(String.valueOf(ids.next()));
                        if (!ids.hasNext()) continue;
                        builder.append(',');
                    }
                    builder.append("\"");
                }
                builder.appendNewLine();
                builder.append("  }");
                if (ores.hasNext()) {
                    builder.append(',');
                }
                builder.appendNewLine();
            }
            String data = builder.append(']').toString();
            if (dest != null && data.equals(dest)) {
                return false;
            }
            FileUtils.writeStringToFile((File)file, (String)data);
            return true;
        }
        catch (Exception e) {
            CaveLog.log(Level.ERROR, e, "An error occurred trying to saving cave ores", new Object[0]);
            return false;
        }
    }

    public static boolean addCaveOre(CaveOre ore) {
        for (CaveOre caveOre : CAVE_ORES) {
            if (caveOre.block != ore.block || caveOre.blockMetadata != ore.blockMetadata || caveOre.genTargetBlock != ore.genTargetBlock) continue;
            caveOre.genBlockCount += ore.genBlockCount;
            caveOre.genRarity += ore.genRarity;
            caveOre.setGenMinHeight(Math.min(caveOre.genMinHeight, ore.genMinHeight));
            caveOre.setGenMaxHeight(Math.max(caveOre.genMaxHeight, ore.genMaxHeight));
            for (BiomeGenBase biome : ore.genBiomes) {
                caveOre.addGenBiomes(biome);
            }
            return false;
        }
        return CAVE_ORES.add(ore);
    }

    public static int removeCaveOre(Block block, int metadata) {
        Iterator ores = CAVE_ORES.iterator();
        int count = 0;
        while (ores.hasNext()) {
            CaveOre ore = (CaveOre)((Object)ores.next());
            if (ore.block != block || ore.blockMetadata != metadata) continue;
            ores.remove();
            ++count;
        }
        return count;
    }

    public static boolean containsOre(Block block, int metadata) {
        for (CaveOre ore : CAVE_ORES) {
            if (ore.block != block || ore.blockMetadata != metadata) continue;
            return ore.block.func_149688_o() == Material.field_151576_e;
        }
        return false;
    }

    public static ImmutableSet<CaveOre> getCaveOres() {
        return new ImmutableSet.Builder().addAll(CAVE_ORES).build();
    }

    public static void clearCaveOres() {
        CAVE_ORES.clear();
    }

    public static class CaveOre
    extends WorldGenerator {
        private final Block block;
        private int blockMetadata = 0;
        private int genBlockCount = 1;
        private int genRarity = 1;
        private int genMinHeight = 0;
        private int genMaxHeight = 255;
        private Block genTargetBlock = Blocks.field_150348_b;
        private final Set<BiomeGenBase> genBiomes = Sets.newHashSet();
        private final SortedSet<BiomeDictionary.Type> genBiomeTypes = Sets.newTreeSet();
        private final SortedSet<Integer> genBiomeIds = Sets.newTreeSet();

        public CaveOre(Block block) {
            this.block = block;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder(128);
            builder.append('{');
            builder.append("\"block\":\"").append(Block.field_149771_c.func_148750_c((Object)this.block)).append("\",");
            builder.append("\"blockMetadata\":").append(this.blockMetadata).append(',');
            builder.append("\"genBlockCount\":").append(this.genBlockCount).append(',');
            builder.append("\"genRarity\":").append(this.genRarity).append(',');
            builder.append("\"genMinHeight\":").append(this.genMinHeight).append(',');
            builder.append("\"genMaxHeight\":").append(this.genMaxHeight).append(',');
            builder.append("\"genTargetBlock\":\"").append(Block.field_149771_c.func_148750_c((Object)this.genTargetBlock)).append('\"');
            if (!this.genBiomeTypes.isEmpty() || !this.genBiomeIds.isEmpty()) {
                builder.append(',').append("\"genBiomes\":\"");
                Iterator types = this.genBiomeTypes.iterator();
                while (types.hasNext()) {
                    builder.append(((BiomeDictionary.Type)types.next()).name());
                    if (!types.hasNext() && this.genBiomeIds.isEmpty()) continue;
                    builder.append(',');
                }
                Iterator ids = this.genBiomeIds.iterator();
                while (ids.hasNext()) {
                    builder.append(ids.next());
                    if (!ids.hasNext()) continue;
                    builder.append(',');
                }
                builder.append('\"');
            }
            builder.append('}');
            return builder.toString();
        }

        public CaveOre setBlockMetadata(int metadata) {
            this.blockMetadata = metadata;
            return this;
        }

        public CaveOre setGenBlockCount(int count) {
            this.genBlockCount = MathHelper.func_76125_a((int)count, (int)1, (int)100);
            return this;
        }

        public CaveOre setGenRarity(int rarity) {
            this.genRarity = MathHelper.func_76125_a((int)rarity, (int)1, (int)100);
            return this;
        }

        public CaveOre setGenMinHeight(int min) {
            this.genMinHeight = MathHelper.func_76125_a((int)min, (int)0, (int)255);
            return this;
        }

        public CaveOre setGenMaxHeight(int max) {
            this.genMaxHeight = MathHelper.func_76125_a((int)max, (int)1, (int)255);
            return this;
        }

        public CaveOre setGenTargetBlock(Block target) {
            this.genTargetBlock = target == null ? Blocks.field_150348_b : target;
            return this;
        }

        public CaveOre addGenBiomes(Object ... objects) {
            for (Object obj : objects) {
                BiomeGenBase biome;
                if (obj instanceof BiomeDictionary.Type) {
                    BiomeDictionary.Type type = (BiomeDictionary.Type)obj;
                    Collections.addAll(this.genBiomes, BiomeDictionary.getBiomesForType((BiomeDictionary.Type)type));
                    this.genBiomeTypes.add(type);
                    continue;
                }
                if (obj instanceof BiomeGenBase) {
                    biome = (BiomeGenBase)obj;
                    this.genBiomes.add(biome);
                    this.genBiomeIds.add(biome.field_76756_M);
                    continue;
                }
                if (!(obj instanceof Integer) || (biome = BiomeGenBase.func_150568_d((int)((Integer)obj))) == null) continue;
                this.genBiomes.add(biome);
                this.genBiomeIds.add(biome.field_76756_M);
            }
            return this;
        }

        public Block getBlock() {
            return this.block;
        }

        public int getBlockMetadata() {
            return this.blockMetadata;
        }

        public int getGenBlockCount() {
            return MathHelper.func_76125_a((int)this.genBlockCount, (int)1, (int)100);
        }

        public int getGenRarity() {
            return MathHelper.func_76125_a((int)this.genRarity, (int)1, (int)100);
        }

        public int getGenMinHeight() {
            return MathHelper.func_76125_a((int)this.genMinHeight, (int)0, (int)255);
        }

        public int getGenMaxHeight() {
            return MathHelper.func_76125_a((int)this.genMaxHeight, (int)1, (int)255);
        }

        public Block getGenTargetBlock() {
            return this.genTargetBlock == null ? Blocks.field_150348_b : this.genTargetBlock;
        }

        public ImmutableSet<BiomeGenBase> getGenBiomes() {
            return new ImmutableSet.Builder().addAll(this.genBiomes).build();
        }

        public void clearGenBiomes(boolean flag) {
            this.genBiomes.clear();
            if (flag) {
                this.genBiomeTypes.clear();
                this.genBiomeIds.clear();
            }
        }

        public boolean func_76484_a(World world, Random random, int x, int y, int z) {
            float var1 = random.nextFloat() * (float)Math.PI;
            double var2 = (float)(x + 8) + MathHelper.func_76126_a((float)var1) * (float)this.genBlockCount / 8.0f;
            double var3 = (float)(x + 8) - MathHelper.func_76126_a((float)var1) * (float)this.genBlockCount / 8.0f;
            double var4 = (float)(z + 8) + MathHelper.func_76134_b((float)var1) * (float)this.genBlockCount / 8.0f;
            double var5 = (float)(z + 8) - MathHelper.func_76134_b((float)var1) * (float)this.genBlockCount / 8.0f;
            double var6 = y + random.nextInt(3) - 2;
            double var7 = y + random.nextInt(3) - 2;
            for (int count = 0; count <= this.genBlockCount; ++count) {
                double var8 = var2 + (var3 - var2) * (double)count / (double)this.genBlockCount;
                double var9 = var6 + (var7 - var6) * (double)count / (double)this.genBlockCount;
                double var10 = var4 + (var5 - var4) * (double)count / (double)this.genBlockCount;
                double var11 = random.nextDouble() * (double)this.genBlockCount / 16.0;
                double var12 = (double)(MathHelper.func_76126_a((float)((float)count * (float)Math.PI / (float)this.genBlockCount)) + 1.0f) * var11 + 1.0;
                double var13 = (double)(MathHelper.func_76126_a((float)((float)count * (float)Math.PI / (float)this.genBlockCount)) + 1.0f) * var11 + 1.0;
                int minX = MathHelper.func_76128_c((double)(var8 - var12 / 2.0));
                int maxX = MathHelper.func_76128_c((double)(var8 + var12 / 2.0));
                int minY = MathHelper.func_76128_c((double)(var9 - var13 / 2.0));
                int maxY = MathHelper.func_76128_c((double)(var9 + var13 / 2.0));
                int minZ = MathHelper.func_76128_c((double)(var10 - var12 / 2.0));
                int maxZ = MathHelper.func_76128_c((double)(var10 + var12 / 2.0));
                for (int blockX = minX; blockX <= maxX; ++blockX) {
                    double xScale = ((double)blockX + 0.5 - var8) / (var12 / 2.0);
                    if (!(xScale * xScale < 1.0)) continue;
                    for (int blockY = minY; blockY <= maxY; ++blockY) {
                        double yScale = ((double)blockY + 0.5 - var9) / (var13 / 2.0);
                        if (!(xScale * xScale + yScale * yScale < 1.0)) continue;
                        for (int blockZ = minZ; blockZ <= maxZ; ++blockZ) {
                            double zScale = ((double)blockZ + 0.5 - var10) / (var12 / 2.0);
                            if (!(xScale * xScale + yScale * yScale + zScale * zScale < 1.0) || !world.func_147439_a(blockX, blockY, blockZ).isReplaceableOreGen(world, blockX, blockY, blockZ, this.genTargetBlock)) continue;
                            BiomeGenBase biome = world.func_72807_a(blockX, blockZ);
                            boolean flag = false;
                            if (this.genBiomes.isEmpty()) {
                                flag = true;
                            } else {
                                for (BiomeGenBase obj : this.genBiomes) {
                                    if (obj.field_76756_M != biome.field_76756_M) continue;
                                    flag = true;
                                    break;
                                }
                            }
                            if (!flag) continue;
                            world.func_147465_d(blockX, blockY, blockZ, this.block, this.blockMetadata, 2);
                        }
                    }
                }
            }
            return true;
        }
    }
}

