/*
 * Decompiled with CFR 0.152.
 */
package com.kegare.caveworld.core;

import com.kegare.caveworld.block.CaveBlocks;
import com.kegare.caveworld.core.CaveAchievementList;
import com.kegare.caveworld.core.CaveBiomeManager;
import com.kegare.caveworld.core.CaveOreManager;
import com.kegare.caveworld.core.CommandCaveworld;
import com.kegare.caveworld.core.Config;
import com.kegare.caveworld.handler.CaveEventHooks;
import com.kegare.caveworld.packet.CaveBiomeSyncPacket;
import com.kegare.caveworld.packet.CaveOreSyncPacket;
import com.kegare.caveworld.packet.ConfigSyncPacket;
import com.kegare.caveworld.packet.DataSyncPacket;
import com.kegare.caveworld.packet.MiningCountPacket;
import com.kegare.caveworld.packet.PacketPipeline;
import com.kegare.caveworld.packet.PlayCaveSoundPacket;
import com.kegare.caveworld.proxy.CommonProxy;
import com.kegare.caveworld.util.Version;
import com.kegare.caveworld.world.WorldProviderCaveworld;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.ModMetadata;
import cpw.mods.fml.common.SidedProxy;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLPostInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.event.FMLServerStartingEvent;
import cpw.mods.fml.common.registry.GameRegistry;
import net.minecraft.block.Block;
import net.minecraft.command.ICommand;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.AchievementPage;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.common.MinecraftForge;

@Mod(modid="kegare.caveworld")
public class Caveworld {
    public static final PacketPipeline packetPipeline = new PacketPipeline();
    @Mod.Metadata(value="kegare.caveworld")
    public static ModMetadata metadata;
    @SidedProxy(modId="kegare.caveworld", clientSide="com.kegare.caveworld.proxy.ClientProxy", serverSide="com.kegare.caveworld.proxy.CommonProxy")
    public static CommonProxy proxy;

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        Version.versionCheck();
        Config.buildConfig();
        CaveBlocks.configure();
        this.registerRecipes();
    }

    private void registerRecipes() {
        if (Version.DEV_DEBUG || Config.portalCraftRecipe) {
            GameRegistry.addShapedRecipe((ItemStack)new ItemStack((Block)CaveBlocks.caveworld_portal), (Object[])new Object[]{" E ", "EPE", " D ", Character.valueOf('E'), Items.field_151166_bC, Character.valueOf('P'), Items.field_151079_bi, Character.valueOf('D'), Items.field_151045_i});
        }
        if (Version.DEV_DEBUG || Config.mossStoneCraftRecipe) {
            GameRegistry.addShapedRecipe((ItemStack)new ItemStack(Blocks.field_150341_Y), (Object[])new Object[]{" V ", "VCV", " V ", Character.valueOf('V'), Blocks.field_150395_bd, Character.valueOf('C'), Blocks.field_150347_e});
        }
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
        proxy.registerRenderers();
        AchievementPage.registerAchievementPage((AchievementPage)new AchievementPage("Caveworld", CaveAchievementList.getAchievementArray()));
        DimensionManager.registerProviderType((int)Config.dimensionCaveworld, WorldProviderCaveworld.class, (boolean)true);
        DimensionManager.registerDimension((int)Config.dimensionCaveworld, (int)Config.dimensionCaveworld);
        MinecraftForge.EVENT_BUS.register((Object)CaveEventHooks.instance);
        FMLCommonHandler.instance().bus().register((Object)CaveEventHooks.instance);
        packetPipeline.init("kegare.caveworld");
        packetPipeline.registerPacket(ConfigSyncPacket.class);
        packetPipeline.registerPacket(DataSyncPacket.class);
        packetPipeline.registerPacket(CaveBiomeSyncPacket.class);
        packetPipeline.registerPacket(CaveOreSyncPacket.class);
        packetPipeline.registerPacket(PlayCaveSoundPacket.class);
        packetPipeline.registerPacket(MiningCountPacket.class);
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent event) {
        CaveBiomeManager.loadCaveBiomes();
        CaveOreManager.loadCaveOres();
        packetPipeline.postInit();
    }

    @Mod.EventHandler
    public void serverStarting(FMLServerStartingEvent event) {
        event.registerServerCommand((ICommand)new CommandCaveworld());
        if (event.getSide().isServer() && (Version.DEV_DEBUG || Config.versionNotify && Version.isOutdated())) {
            event.getServer().func_71244_g("A new Caveworld version is available : " + Version.getLatest());
        }
    }
}

