/*
 * Decompiled with CFR 0.152.
 */
package com.kegare.caveworld.core;

import com.google.common.collect.Lists;
import com.kegare.caveworld.core.CaveMiningManager;
import com.kegare.caveworld.core.Caveworld;
import com.kegare.caveworld.core.Config;
import com.kegare.caveworld.util.CaveUtils;
import com.kegare.caveworld.util.Version;
import cpw.mods.fml.common.Loader;
import java.awt.Desktop;
import java.net.URI;
import java.util.List;
import java.util.Locale;
import net.minecraft.command.CommandBase;
import net.minecraft.command.CommandNotFoundException;
import net.minecraft.command.ICommand;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.event.ClickEvent;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.ChatStyle;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.MathHelper;
import net.minecraft.world.ChunkPosition;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;

public class CommandCaveworld
implements ICommand {
    public int compareTo(Object obj) {
        return this.func_71517_b().compareTo(((ICommand)obj).func_71517_b());
    }

    public String func_71517_b() {
        return "caveworld";
    }

    public String func_71518_a(ICommandSender sender) {
        throw new CommandNotFoundException();
    }

    public List func_71514_a() {
        return null;
    }

    public void func_71515_b(ICommandSender sender, String[] args) {
        if (args.length == 0 || args[0].equalsIgnoreCase("version")) {
            ChatStyle style = new ChatStyle();
            style.func_150241_a(new ClickEvent(ClickEvent.Action.OPEN_URL, Caveworld.metadata.url));
            StringBuilder builder = new StringBuilder();
            builder.append(EnumChatFormatting.AQUA).append(" Caveworld ").append(EnumChatFormatting.RESET).append(Version.getCurrent());
            if (Version.DEV_DEBUG) {
                builder.append(EnumChatFormatting.RED).append(" dev").append(EnumChatFormatting.RESET);
            } else if (Config.hardcoreEnabled) {
                builder.append(EnumChatFormatting.RED).append(" hardcore").append(EnumChatFormatting.RESET);
            }
            builder.append(" for ").append(Loader.instance().getMCVersionString());
            builder.append(EnumChatFormatting.GRAY).append(" (Latest: ").append(Version.getLatest()).append(")");
            sender.func_145747_a(new ChatComponentText(sender instanceof EntityPlayerMP ? builder.toString() : CaveUtils.stripControlCodes(builder.toString())).func_150255_a(style));
            sender.func_145747_a(new ChatComponentText("  " + Caveworld.metadata.description).func_150255_a(style));
            sender.func_145747_a(new ChatComponentText("  " + Caveworld.metadata.url).func_150255_a(style.func_150206_m().func_150238_a(EnumChatFormatting.DARK_GRAY)));
        } else if (args[0].equalsIgnoreCase("forum") || args[0].equalsIgnoreCase("url")) {
            try {
                Desktop.getDesktop().browse(new URI(Caveworld.metadata.url));
            }
            catch (Exception ignored) {}
        } else if (Version.DEV_DEBUG && sender instanceof EntityPlayerMP && ((EntityPlayerMP)sender).field_71075_bZ.field_75098_d) {
            EntityPlayerMP player = (EntityPlayerMP)sender;
            if (args[0].equalsIgnoreCase("mineshaft")) {
                WorldServer world = player.func_71121_q();
                int x = MathHelper.func_76128_c((double)player.field_70165_t);
                int y = MathHelper.func_76128_c((double)player.field_70163_u);
                int z = MathHelper.func_76128_c((double)player.field_70161_v);
                ChunkPosition pos = world.func_72863_F().func_147416_a((World)world, "Mineshaft", x, y, z);
                if (pos != null) {
                    player.field_71135_a.func_147364_a((double)pos.field_151329_a, (double)pos.field_151327_b + 1.5, (double)pos.field_151328_c, player.field_70177_z, player.field_70125_A);
                }
            } else if (args[0].equalsIgnoreCase("stronghold")) {
                WorldServer world = player.func_71121_q();
                int x = MathHelper.func_76128_c((double)player.field_70165_t);
                int y = MathHelper.func_76128_c((double)player.field_70163_u);
                int z = MathHelper.func_76128_c((double)player.field_70161_v);
                ChunkPosition pos = world.func_72863_F().func_147416_a((World)world, "Stronghold", x, y, z);
                if (pos != null) {
                    player.field_71135_a.func_147364_a((double)pos.field_151329_a, (double)pos.field_151327_b + 1.5, (double)pos.field_151328_c, player.field_70177_z, player.field_70125_A);
                }
            } else if (args[0].equalsIgnoreCase("mining") && args.length > 2) {
                String str = args[2];
                boolean flag = str.toUpperCase(Locale.ENGLISH).endsWith("L");
                if (flag) {
                    str = str.substring(0, str.length() - 1);
                }
                int value = 0;
                if (args[1].equalsIgnoreCase("add")) {
                    value = CommandBase.func_71532_a((ICommandSender)sender, (String)str, (int)Short.MIN_VALUE, (int)Short.MAX_VALUE);
                } else if (args[1].equalsIgnoreCase("remove") || args[1].equalsIgnoreCase("reduce")) {
                    value = -CommandBase.func_71532_a((ICommandSender)sender, (String)str, (int)Short.MIN_VALUE, (int)Short.MAX_VALUE);
                }
                if (value != 0) {
                    if (flag) {
                        CaveMiningManager.addMiningLevel((EntityPlayer)player, value);
                    } else {
                        CaveMiningManager.addMiningCount((EntityPlayer)player, value);
                    }
                }
            }
        }
    }

    public boolean func_71519_b(ICommandSender sender) {
        return sender instanceof MinecraftServer || sender instanceof EntityPlayerMP;
    }

    public List func_71516_a(ICommandSender sender, String[] args) {
        return Lists.newArrayList((Object[])new String[]{"version", "forum"});
    }

    public boolean func_82358_a(String[] args, int index) {
        return false;
    }
}

