/*
 * Decompiled with CFR 0.152.
 */
package com.kegare.caveworld.handler;

import com.kegare.caveworld.block.CaveBlocks;
import com.kegare.caveworld.core.CaveAchievementList;
import com.kegare.caveworld.core.CaveMiningManager;
import com.kegare.caveworld.core.CaveOreManager;
import com.kegare.caveworld.core.Caveworld;
import com.kegare.caveworld.core.Config;
import com.kegare.caveworld.packet.CaveBiomeSyncPacket;
import com.kegare.caveworld.packet.CaveOreSyncPacket;
import com.kegare.caveworld.packet.ConfigSyncPacket;
import com.kegare.caveworld.packet.DataSyncPacket;
import com.kegare.caveworld.packet.PlayCaveSoundPacket;
import com.kegare.caveworld.util.Version;
import com.kegare.caveworld.world.WorldProviderCaveworld;
import cpw.mods.fml.client.FMLClientHandler;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.PlayerEvent;
import cpw.mods.fml.common.gameevent.TickEvent;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.security.SecureRandom;
import net.minecraft.block.Block;
import net.minecraft.block.BlockBed;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.passive.EntityBat;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.event.ClickEvent;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.stats.StatBase;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.ChatComponentTranslation;
import net.minecraft.util.ChatStyle;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.MathHelper;
import net.minecraft.util.StatCollector;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.living.LivingDropsEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.entity.player.PlayerSleepInBedEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.event.world.WorldEvent;

public class CaveEventHooks {
    public static final CaveEventHooks instance = new CaveEventHooks();

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public void onRenderGameOverlay(RenderGameOverlayEvent.Text event) {
        Minecraft mc = FMLClientHandler.instance().getClient();
        if (mc.field_71439_g != null && mc.field_71439_g.field_71093_bK == Config.dimensionCaveworld) {
            int count;
            ItemStack current = mc.field_71439_g.func_71045_bC();
            if (mc.field_71474_y.field_74330_P) {
                event.left.add("dim: Caveworld");
            } else if ((mc.field_71474_y.field_82882_x || mc.field_71439_g.func_70093_af()) && current != null && current.func_77973_b().getToolClasses(current).contains("pickaxe") && (count = CaveMiningManager.getMiningCount((EntityPlayer)mc.field_71439_g)) > 0) {
                int level = CaveMiningManager.getMiningLevel((EntityPlayer)mc.field_71439_g);
                StringBuilder builder = new StringBuilder();
                builder.append(I18n.func_135052_a((String)"caveworld.mining.count", (Object[])new Object[0])).append(": ").append(count);
                if (level > 0) {
                    builder.append(" (").append(level).append(')');
                }
                event.right.add(builder.toString());
            }
        }
    }

    @SubscribeEvent
    public void onPlayerLoggedIn(PlayerEvent.PlayerLoggedInEvent event) {
        if (event.player instanceof EntityPlayerMP) {
            EntityPlayerMP player = (EntityPlayerMP)event.player;
            Caveworld.packetPipeline.sendPacketToPlayer(new ConfigSyncPacket(), player);
            Caveworld.packetPipeline.sendPacketToPlayer(new DataSyncPacket(), player);
            Caveworld.packetPipeline.sendPacketToPlayer(new CaveBiomeSyncPacket(), player);
            Caveworld.packetPipeline.sendPacketToPlayer(new CaveOreSyncPacket(), player);
            CaveMiningManager.syncMiningCount((EntityPlayer)player);
            if (Version.DEV_DEBUG || Config.versionNotify && Version.isOutdated()) {
                ChatStyle style = new ChatStyle();
                style.func_150241_a(new ClickEvent(ClickEvent.Action.OPEN_URL, Caveworld.metadata.url));
                player.func_145747_a(new ChatComponentText(StatCollector.func_74837_a((String)"caveworld.version.message", (Object[])new Object[]{EnumChatFormatting.AQUA + "Caveworld" + EnumChatFormatting.RESET}) + " : " + EnumChatFormatting.YELLOW + Version.getLatest()).func_150255_a(style));
            }
        }
    }

    @SubscribeEvent
    public void onPlayerRespawn(PlayerEvent.PlayerRespawnEvent event) {
        if (event.player instanceof EntityPlayerMP) {
            EntityPlayerMP player = (EntityPlayerMP)event.player;
            if (player.field_71093_bK == Config.dimensionCaveworld) {
                player.setSpawnChunk(null, true, player.field_71093_bK);
            }
        }
    }

    @SubscribeEvent
    public void onPlayerChangedDimension(PlayerEvent.PlayerChangedDimensionEvent event) {
        if (event.player instanceof EntityPlayerMP) {
            EntityPlayerMP player = (EntityPlayerMP)event.player;
            WorldServer world = player.func_71121_q();
            if (event.toDim == Config.dimensionCaveworld) {
                NBTTagCompound data = player.getEntityData();
                if (!player.func_147099_x().func_77443_a(CaveAchievementList.caveworld) || data.func_74763_f("Caveworld:LastTeleportTime") + 18000L < world.func_82737_E()) {
                    Caveworld.packetPipeline.sendPacketToPlayer(new PlayCaveSoundPacket("ambient.cave"), player);
                }
                player.func_71029_a((StatBase)CaveAchievementList.caveworld);
                data.func_74772_a("Caveworld:LastTeleportTime", world.func_82737_E());
            }
        }
    }

    @SubscribeEvent
    public void onHarvestDrops(BlockEvent.HarvestDropsEvent event) {
        if (event.harvester != null && event.harvester instanceof EntityPlayerMP) {
            EntityPlayerMP player = (EntityPlayerMP)event.harvester;
            if (player.field_71093_bK == Config.dimensionCaveworld) {
                ItemStack current = player.func_71045_bC();
                Block block = event.block;
                int metadata = event.blockMetadata;
                if (current != null && current.func_77973_b().getToolClasses(current).contains("pickaxe") && CaveOreManager.containsOre(block, metadata)) {
                    int count = CaveMiningManager.getMiningCount((EntityPlayer)player);
                    if (count >= 500 && count % 500 == 0) {
                        player.func_71029_a((StatBase)CaveAchievementList.miner);
                    }
                    CaveMiningManager.addMiningCount((EntityPlayer)player, 1);
                }
            }
        }
    }

    @SubscribeEvent
    public void onBreakSpeed(PlayerEvent.BreakSpeed event) {
        EntityPlayer player = event.entityPlayer;
        if (player != null && player.field_71093_bK == Config.dimensionCaveworld && player.func_70093_af()) {
            ItemStack current = player.func_71045_bC();
            Block block = event.block;
            int metadata = event.metadata;
            if (current != null && current.func_77973_b().getToolClasses(current).contains("pickaxe") && CaveOreManager.containsOre(block, metadata)) {
                int level = CaveMiningManager.getMiningLevel(player);
                if (level > 2) {
                    event.newSpeed *= 2.0f;
                } else if (level > 0) {
                    event.newSpeed *= 1.75f;
                }
            }
        }
    }

    @SubscribeEvent
    public void onPlayerInteract(PlayerInteractEvent event) {
        if (event.entityPlayer instanceof EntityPlayerMP) {
            EntityPlayerMP player = (EntityPlayerMP)event.entityPlayer;
            WorldServer world = player.func_71121_q();
            int x = event.x;
            int y = event.y;
            int z = event.z;
            int face = event.face;
            ItemStack current = player.func_71045_bC();
            if (event.action == PlayerInteractEvent.Action.RIGHT_CLICK_BLOCK) {
                if (!player.func_70093_af() && current != null && current.func_77973_b() == Item.func_150898_a((Block)Blocks.field_150477_bB)) {
                    if (face == 0) {
                        --y;
                    } else if (face == 1) {
                        ++y;
                    } else if (face == 2) {
                        --z;
                    } else if (face == 3) {
                        ++z;
                    } else if (face == 4) {
                        --x;
                    } else if (face == 5) {
                        ++x;
                    }
                    if (CaveBlocks.caveworld_portal.func_150000_e((World)world, x, y, z)) {
                        world.func_72908_a((double)x + 0.5, (double)y + 0.5, (double)z + 0.5, CaveBlocks.caveworld_portal.field_149762_H.func_150496_b(), 1.0f, 2.0f);
                        event.setCanceled(true);
                    }
                } else if (player.field_71093_bK == Config.dimensionCaveworld && world.func_147439_a(x, y, z).isBed((IBlockAccess)world, x, y, z, (EntityLivingBase)player)) {
                    EntityPlayer.EnumStatus status;
                    int metadata = world.func_72805_g(x, y, z);
                    if (!BlockBed.func_149975_b((int)metadata)) {
                        int var1 = BlockBed.func_149895_l((int)metadata);
                        if (!world.func_147439_a(x += BlockBed.field_149981_a[var1][0], y, z += BlockBed.field_149981_a[var1][1]).isBed((IBlockAccess)world, x, y, z, (EntityLivingBase)player)) {
                            return;
                        }
                        metadata = world.func_72805_g(x, y, z);
                    }
                    if (BlockBed.func_149976_c((int)metadata)) {
                        for (Object obj : world.field_73010_i) {
                            EntityPlayer target = (EntityPlayer)obj;
                            if (!target.func_70608_bn()) continue;
                            ChunkCoordinates coord = target.field_71081_bT;
                            if (coord.field_71574_a != x || coord.field_71572_b != y || coord.field_71573_c != z) continue;
                            player.func_146105_b((IChatComponent)new ChatComponentTranslation("tile.bed.occupied", new Object[0]));
                            return;
                        }
                        BlockBed.func_149979_a((World)world, (int)x, (int)y, (int)z, (boolean)false);
                    }
                    if ((status = player.func_71018_a(x, y, z)) == EntityPlayer.EnumStatus.OK) {
                        BlockBed.func_149979_a((World)world, (int)x, (int)y, (int)z, (boolean)true);
                    } else if (status == EntityPlayer.EnumStatus.NOT_POSSIBLE_NOW) {
                        player.func_146105_b((IChatComponent)new ChatComponentTranslation("tile.bed.noSleep", new Object[0]));
                    } else if (status == EntityPlayer.EnumStatus.NOT_SAFE) {
                        player.func_146105_b((IChatComponent)new ChatComponentTranslation("tile.bed.notSafe", new Object[0]));
                    }
                    event.setCanceled(true);
                }
            }
        }
    }

    @SubscribeEvent
    public void onPlayerSleepInBed(PlayerSleepInBedEvent event) {
        if (event.entityPlayer instanceof EntityPlayerMP) {
            EntityPlayerMP player = (EntityPlayerMP)event.entityPlayer;
            WorldServer world = player.func_71121_q();
            if (player.field_71093_bK == Config.dimensionCaveworld && !player.field_71075_bZ.field_75098_d) {
                NBTTagCompound data = player.getEntityData();
                ChunkCoordinates spawn = player.getBedLocation(player.field_71093_bK);
                if (data.func_74763_f("Caveworld:LastSleepTime") + 6000L > world.func_82737_E()) {
                    event.result = EntityPlayer.EnumStatus.OTHER_PROBLEM;
                } else if (spawn != null && player.func_70011_f((double)spawn.field_71574_a, (double)spawn.field_71572_b, (double)spawn.field_71573_c) <= 32.0) {
                    event.result = EntityPlayer.EnumStatus.OTHER_PROBLEM;
                }
                if (event.result == null) {
                    data.func_74772_a("Caveworld:LastSleepTime", world.func_82737_E());
                }
            }
        }
    }

    @SubscribeEvent
    public void onEntityJoinWorld(EntityJoinWorldEvent event) {
        World world = event.world;
        Entity entity = event.entity;
        if (!world.field_72995_K && entity.field_71093_bK == Config.dimensionCaveworld && entity instanceof EntityLiving && MathHelper.func_76128_c((double)entity.field_70163_u) >= world.field_73011_w.getActualHeight()) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void onLivingUpdate(LivingEvent.LivingUpdateEvent event) {
        EntityPlayerMP player;
        if (event.entityLiving.field_71093_bK == Config.dimensionCaveworld && event.entityLiving.field_70173_aa % 20 == 0 && event.entityLiving instanceof EntityPlayerMP && (player = (EntityPlayerMP)event.entityLiving).func_70608_bn() && player.func_71060_bI() >= 80) {
            player.func_70999_a(true, true, false);
            player.setSpawnChunk(player.field_71081_bT, true, player.field_71093_bK);
        }
    }

    @SubscribeEvent
    public void onLivingDrops(LivingDropsEvent event) {
        SecureRandom random = new SecureRandom();
        DamageSource source = event.source;
        Entity entity = source.func_76346_g();
        EntityLivingBase living = event.entityLiving;
        World world = living.field_70170_p;
        double posX = living.field_70165_t;
        double posY = living.field_70163_u;
        double posZ = living.field_70161_v;
        int looting = Math.max(event.lootingLevel, 0);
        if (!world.field_72995_K && living.field_71093_bK == Config.dimensionCaveworld && entity != null && entity instanceof EntityPlayerMP && living instanceof EntityBat) {
            event.drops.add(new EntityItem(world, posX, posY + 0.5, posZ, new ItemStack(Items.field_151044_h, random.nextInt(3) + Math.min(looting, 3))));
            if (random.nextInt(3) == Math.min(looting, 2)) {
                event.drops.add(new EntityItem(world, posX, posY + 0.25, posZ, new ItemStack(Items.field_151116_aA, 1)));
            }
        }
    }

    @SubscribeEvent
    public void onWorldUnload(WorldEvent.Load event) {
        World world = event.world;
        if (!world.field_72995_K && world.field_73011_w.field_76574_g == Config.dimensionCaveworld) {
            CaveMiningManager.loadMiningData();
        }
    }

    @SubscribeEvent
    public void onWorldUnload(WorldEvent.Unload event) {
        World world = event.world;
        if (!world.field_72995_K && world.field_73011_w.field_76574_g == Config.dimensionCaveworld) {
            CaveMiningManager.saveMiningData();
            CaveMiningManager.clearMiningData();
            WorldProviderCaveworld.writeDimData();
            WorldProviderCaveworld.clearDimData();
        }
    }

    @SubscribeEvent
    public void onWorldSave(WorldEvent.Save event) {
        World world = event.world;
        if (!world.field_72995_K && world.field_73011_w.field_76574_g == Config.dimensionCaveworld) {
            CaveBlocks.caveworld_portal.getInventory().saveInventoryToNBT();
        }
    }

    @SubscribeEvent
    public void onWorldTick(TickEvent.WorldTickEvent event) {
        if (event.side.isServer() && event.phase == TickEvent.Phase.END) {
            World world = event.world;
            int dim = world.field_73011_w.field_76574_g;
            if (dim == Config.dimensionCaveworld && world.func_82737_E() % 20000L == 0L && world.field_73012_v.nextBoolean()) {
                Caveworld.packetPipeline.sendPacketToAllInDimension(new PlayCaveSoundPacket("ambient.cave"), dim);
            }
        }
    }
}

