/*
 * Decompiled with CFR 0.152.
 */
package com.kegare.caveworld.packet;

import com.google.common.base.Strings;
import com.kegare.caveworld.core.CaveOreManager;
import com.kegare.caveworld.packet.AbstractPacket;
import com.kegare.caveworld.util.CaveLog;
import cpw.mods.fml.common.network.ByteBufUtils;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.entity.player.EntityPlayerMP;
import org.apache.logging.log4j.Level;

public class CaveOreSyncPacket
extends AbstractPacket {
    private String data;

    public CaveOreSyncPacket() {
        StringBuilder builder = new StringBuilder(1024);
        builder.append('[');
        for (CaveOreManager.CaveOre ore : CaveOreManager.getCaveOres()) {
            builder.append((Object)ore).append(',');
        }
        this.data = builder.deleteCharAt(builder.lastIndexOf(",")).append(']').toString();
    }

    @Override
    public void encodeInto(ChannelHandlerContext ctx, ByteBuf buffer) {
        ByteBufUtils.writeUTF8String((ByteBuf)buffer, (String)this.data);
    }

    @Override
    public void decodeInto(ChannelHandlerContext ctx, ByteBuf buffer) {
        this.data = ByteBufUtils.readUTF8String((ByteBuf)buffer);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void handleClientSide(EntityPlayerSP player) {
        if (!Strings.isNullOrEmpty((String)this.data)) {
            CaveOreManager.clearCaveOres();
            try {
                if (CaveOreManager.loadCaveOresFromString(this.data)) {
                    CaveLog.info("Loaded %d cave ores from server", CaveOreManager.getCaveOres().size());
                }
            }
            catch (Exception e) {
                CaveLog.log(Level.WARN, e, "An error occurred trying to loading cave ores from server", new Object[0]);
            }
        }
    }

    @Override
    @SideOnly(value=Side.SERVER)
    public void handleServerSide(EntityPlayerMP player) {
    }
}

