/*
 * Decompiled with CFR 0.152.
 */
package com.kegare.caveworld.util;

import com.google.common.base.Optional;
import com.google.common.base.Strings;
import com.google.common.io.ByteStreams;
import com.google.gson.Gson;
import com.kegare.caveworld.core.Caveworld;
import com.kegare.caveworld.core.Config;
import com.kegare.caveworld.util.CaveLog;
import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.versioning.DefaultArtifactVersion;
import java.io.File;
import java.io.InputStream;
import java.net.URL;
import java.util.Map;
import net.minecraftforge.classloading.FMLForgePlugin;
import org.apache.commons.io.FilenameUtils;
import org.apache.logging.log4j.Level;

public class Version {
    private static Optional<String> CURRENT = Optional.absent();
    private static Optional<String> LATEST = Optional.absent();
    public static boolean DEV_DEBUG = false;
    private static Status status = Status.PENDING;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void initialize() {
        CURRENT = Optional.of((Object)Caveworld.metadata.version);
        try {
            File file = Loader.instance().activeModContainer().getSource();
            if (file != null && file.exists()) {
                if (file.isFile()) {
                    String name = FilenameUtils.getBaseName((String)file.getName());
                    if (name.endsWith("dev")) {
                        DEV_DEBUG = true;
                    } else if (name.endsWith("hardcore")) {
                        Config.hardcoreEnabled = true;
                    }
                } else if (file.isDirectory()) {
                    DEV_DEBUG = true;
                }
            }
        }
        catch (Exception e) {
            DEV_DEBUG = false;
        }
        finally {
            if (!FMLForgePlugin.RUNTIME_DEOBF) {
                DEV_DEBUG = true;
            }
        }
        if (DEV_DEBUG) {
            Caveworld.metadata.version = Caveworld.metadata.version + "-dev";
        } else if (Config.hardcoreEnabled) {
            Caveworld.metadata.version = Caveworld.metadata.version + "-hardcore";
        }
    }

    public static void versionCheck() {
        Version.initialize();
        new Thread("Caveworld Version Check"){

            @Override
            public void run() {
                try {
                    URL url = new URL(Caveworld.metadata.updateUrl);
                    InputStream con = url.openStream();
                    String data = new String(ByteStreams.toByteArray((InputStream)con));
                    con.close();
                    Map json = (Map)new Gson().fromJson(data, Map.class);
                    if (json.containsKey("homepage")) {
                        Caveworld.metadata.url = (String)json.get("homepage");
                    }
                    Map versions = (Map)json.get("versions");
                    String version = (String)versions.get("1.7.2");
                    DefaultArtifactVersion current = new DefaultArtifactVersion((String)CURRENT.or((Object)"1.0.0"));
                    if (!Strings.isNullOrEmpty((String)version)) {
                        DefaultArtifactVersion latest = new DefaultArtifactVersion(version);
                        int diff = latest.compareTo((Object)current);
                        if (diff == 0) {
                            status = Status.UP_TO_DATE;
                        } else if (diff < 0) {
                            status = Status.AHEAD;
                        } else {
                            status = Status.OUTDATED;
                        }
                        LATEST = Optional.of((Object)version);
                    } else {
                        version = (String)versions.get("latest");
                        if (!Strings.isNullOrEmpty((String)version)) {
                            LATEST = Optional.of((Object)version);
                        }
                        status = Status.FAILED;
                    }
                }
                catch (Exception e) {
                    CaveLog.log(Level.WARN, e, "An error occurred trying to version check", new Object[0]);
                    status = Status.FAILED;
                }
            }
        }.start();
    }

    public static String getCurrent() {
        return (String)CURRENT.orNull();
    }

    public static String getLatest() {
        return (String)LATEST.or((Object)Version.getCurrent());
    }

    public static Status getStatus() {
        return status == null ? Status.FAILED : status;
    }

    public static boolean isOutdated() {
        return status == Status.OUTDATED;
    }

    public static enum Status {
        PENDING,
        FAILED,
        UP_TO_DATE,
        OUTDATED,
        AHEAD;

    }
}

