/*
 * Decompiled with CFR 0.152.
 */
package com.kegare.caveworld.world;

import com.kegare.caveworld.core.CaveBiomeManager;
import com.kegare.caveworld.core.CaveOreManager;
import com.kegare.caveworld.core.Config;
import com.kegare.caveworld.world.gen.MapGenCavesCaveworld;
import com.kegare.caveworld.world.gen.MapGenRavineCaveworld;
import com.kegare.caveworld.world.gen.MapGenStrongholdCaveworld;
import cpw.mods.fml.common.eventhandler.Event;
import java.util.Arrays;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockFalling;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.init.Blocks;
import net.minecraft.util.IProgressUpdate;
import net.minecraft.util.MathHelper;
import net.minecraft.world.ChunkPosition;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeDecorator;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.gen.MapGenBase;
import net.minecraft.world.gen.feature.WorldGenDungeons;
import net.minecraft.world.gen.feature.WorldGenGlowStone1;
import net.minecraft.world.gen.feature.WorldGenLakes;
import net.minecraft.world.gen.feature.WorldGenLiquids;
import net.minecraft.world.gen.feature.WorldGenVines;
import net.minecraft.world.gen.feature.WorldGenerator;
import net.minecraft.world.gen.structure.MapGenMineshaft;
import net.minecraft.world.gen.structure.MapGenStronghold;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.terraingen.DecorateBiomeEvent;
import net.minecraftforge.event.terraingen.InitMapGenEvent;
import net.minecraftforge.event.terraingen.OreGenEvent;
import net.minecraftforge.event.terraingen.PopulateChunkEvent;
import net.minecraftforge.event.terraingen.TerrainGen;

public class ChunkProviderCaveworld
implements IChunkProvider {
    private final World worldObj;
    private final Random random;
    private final boolean generateStructures;
    private MapGenBase caveGenerator = new MapGenCavesCaveworld();
    private MapGenBase ravineGenerator = new MapGenRavineCaveworld();
    private MapGenStronghold strongholdGenerator = new MapGenStrongholdCaveworld();
    private MapGenMineshaft mineshaftGenerator = new MapGenMineshaft();
    private final WorldGenerator lakeWaterGen = new WorldGenLakes(Blocks.field_150355_j);
    private final WorldGenerator lakeLavaGen = new WorldGenLakes(Blocks.field_150353_l);
    private final WorldGenerator dungeonGen = new WorldGenDungeons();
    private final WorldGenerator glowStoneGen = new WorldGenGlowStone1();
    private final WorldGenerator liquidWaterGen = new WorldGenLiquids((Block)Blocks.field_150358_i);
    private final WorldGenerator liquidLavaGen = new WorldGenLiquids((Block)Blocks.field_150356_k);
    private final WorldGenerator vinesGen = new WorldGenVines();

    public ChunkProviderCaveworld(World world) {
        this.caveGenerator = TerrainGen.getModdedMapGen((MapGenBase)this.caveGenerator, (InitMapGenEvent.EventType)InitMapGenEvent.EventType.CAVE);
        this.ravineGenerator = TerrainGen.getModdedMapGen((MapGenBase)this.ravineGenerator, (InitMapGenEvent.EventType)InitMapGenEvent.EventType.RAVINE);
        this.strongholdGenerator = (MapGenStronghold)TerrainGen.getModdedMapGen((MapGenBase)this.strongholdGenerator, (InitMapGenEvent.EventType)InitMapGenEvent.EventType.STRONGHOLD);
        this.mineshaftGenerator = (MapGenMineshaft)TerrainGen.getModdedMapGen((MapGenBase)this.mineshaftGenerator, (InitMapGenEvent.EventType)InitMapGenEvent.EventType.MINESHAFT);
        this.worldObj = world;
        this.random = new Random(world.func_72905_C());
        this.generateStructures = world.func_72912_H().func_76089_r();
    }

    public Chunk func_73154_d(int chunkX, int chunkZ) {
        this.random.setSeed((long)chunkX * 341873128712L + (long)chunkZ * 132897987541L);
        BiomeGenBase biome = this.worldObj.func_72959_q().func_76935_a(chunkX << 4, chunkZ << 4);
        int worldHeight = this.worldObj.field_73011_w.getActualHeight();
        Object[] blocks = new Block[256 * MathHelper.func_76125_a((int)worldHeight, (int)128, (int)256)];
        Block block = CaveBiomeManager.getBiomeTerrainBlock(biome);
        Arrays.fill(blocks, block);
        if (Config.generateCaves) {
            this.caveGenerator.func_151539_a((IChunkProvider)this, this.worldObj, chunkX, chunkZ, (Block[])blocks);
        }
        if (Config.generateRavine) {
            this.ravineGenerator.func_151539_a((IChunkProvider)this, this.worldObj, chunkX, chunkZ, (Block[])blocks);
        }
        if (this.generateStructures) {
            if (Config.generateMineshaft) {
                this.mineshaftGenerator.func_151539_a((IChunkProvider)this, this.worldObj, chunkX, chunkZ, (Block[])blocks);
            }
            if (Config.generateStronghold) {
                this.strongholdGenerator.func_151539_a((IChunkProvider)this, this.worldObj, chunkX, chunkZ, (Block[])blocks);
            }
        }
        Chunk chunk = new Chunk(this.worldObj, (Block[])blocks, chunkX, chunkZ);
        Arrays.fill(chunk.func_76605_m(), (byte)biome.field_76756_M);
        for (int x = 0; x < 16; ++x) {
            for (int z = 0; z < 16; ++z) {
                chunk.func_150807_a(x, 0, z, Blocks.field_150357_h, 0);
                chunk.func_150807_a(x, worldHeight - 1, z, Blocks.field_150357_h, 0);
                chunk.func_150807_a(x, worldHeight - 2, z, block, 0);
                for (int y = worldHeight; worldHeight < 128 && y < 128; ++y) {
                    chunk.func_150807_a(x, y, z, Blocks.field_150350_a, 0);
                }
            }
        }
        chunk.func_76613_n();
        return chunk;
    }

    public Chunk func_73158_c(int chunkX, int chunkZ) {
        return this.func_73154_d(chunkX, chunkZ);
    }

    public void func_73153_a(IChunkProvider chunkProvider, int chunkX, int chunkZ) {
        int i;
        int z;
        int y;
        int x;
        BlockFalling.field_149832_M = true;
        int worldX = chunkX << 4;
        int worldZ = chunkZ << 4;
        BiomeGenBase biome = this.worldObj.func_72807_a(worldX, worldZ);
        BiomeDecorator decorator = biome.field_76760_I;
        int worldHeight = this.worldObj.field_73011_w.getActualHeight();
        long worldSeed = this.worldObj.func_72905_C();
        this.random.setSeed(worldSeed);
        long xSeed = this.random.nextLong() >> 3;
        long zSeed = this.random.nextLong() >> 3;
        this.random.setSeed((long)chunkX * xSeed + (long)chunkZ * zSeed ^ worldSeed);
        MinecraftForge.EVENT_BUS.post((Event)new PopulateChunkEvent.Pre(chunkProvider, this.worldObj, this.random, chunkX, chunkZ, false));
        if (this.generateStructures) {
            if (Config.generateMineshaft) {
                this.mineshaftGenerator.func_75051_a(this.worldObj, this.random, chunkX, chunkZ);
            }
            if (Config.generateStronghold) {
                this.strongholdGenerator.func_75051_a(this.worldObj, this.random, chunkX, chunkZ);
            }
        }
        if (BiomeDictionary.isBiomeOfType((BiomeGenBase)biome, (BiomeDictionary.Type)BiomeDictionary.Type.NETHER)) {
            if (Config.generateLakes && this.random.nextInt(4) == 0 && TerrainGen.populate((IChunkProvider)chunkProvider, (World)this.worldObj, (Random)this.random, (int)chunkX, (int)chunkZ, (boolean)false, (PopulateChunkEvent.Populate.EventType)PopulateChunkEvent.Populate.EventType.LAVA)) {
                x = worldX + this.random.nextInt(16) + 8;
                y = this.random.nextInt(worldHeight - 16);
                z = worldZ + this.random.nextInt(16) + 8;
                this.lakeLavaGen.func_76484_a(this.worldObj, this.random, x, y, z);
            }
            if (TerrainGen.populate((IChunkProvider)chunkProvider, (World)this.worldObj, (Random)this.random, (int)chunkX, (int)chunkZ, (boolean)false, (PopulateChunkEvent.Populate.EventType)PopulateChunkEvent.Populate.EventType.GLOWSTONE)) {
                x = worldX + this.random.nextInt(16) + 8;
                y = this.random.nextInt(worldHeight - 10) + 10;
                z = worldZ + this.random.nextInt(16) + 8;
                this.glowStoneGen.func_76484_a(this.worldObj, this.random, x, y, z);
            }
        } else if (!BiomeDictionary.isBiomeOfType((BiomeGenBase)biome, (BiomeDictionary.Type)BiomeDictionary.Type.END)) {
            if (Config.generateLakes) {
                if (!BiomeDictionary.isBiomeOfType((BiomeGenBase)biome, (BiomeDictionary.Type)BiomeDictionary.Type.DESERT) && this.random.nextInt(4) == 0 && TerrainGen.populate((IChunkProvider)chunkProvider, (World)this.worldObj, (Random)this.random, (int)chunkX, (int)chunkZ, (boolean)false, (PopulateChunkEvent.Populate.EventType)PopulateChunkEvent.Populate.EventType.LAKE)) {
                    x = worldX + this.random.nextInt(16) + 8;
                    y = this.random.nextInt(worldHeight - 16);
                    z = worldZ + this.random.nextInt(16) + 8;
                    this.lakeWaterGen.func_76484_a(this.worldObj, this.random, x, y, z);
                }
                if (this.random.nextInt(20) == 0 && TerrainGen.populate((IChunkProvider)chunkProvider, (World)this.worldObj, (Random)this.random, (int)chunkX, (int)chunkZ, (boolean)false, (PopulateChunkEvent.Populate.EventType)PopulateChunkEvent.Populate.EventType.LAVA)) {
                    x = worldX + this.random.nextInt(16) + 8;
                    y = this.random.nextInt(worldHeight / 2);
                    z = worldZ + this.random.nextInt(16) + 8;
                    this.lakeLavaGen.func_76484_a(this.worldObj, this.random, x, y, z);
                }
            }
            if (Config.generateDungeons && this.generateStructures && TerrainGen.populate((IChunkProvider)chunkProvider, (World)this.worldObj, (Random)this.random, (int)chunkX, (int)chunkZ, (boolean)false, (PopulateChunkEvent.Populate.EventType)PopulateChunkEvent.Populate.EventType.DUNGEON)) {
                for (i = 0; i < 8; ++i) {
                    x = worldX + this.random.nextInt(16) + 8;
                    y = this.random.nextInt(worldHeight - 24);
                    z = worldZ + this.random.nextInt(16) + 8;
                    this.dungeonGen.func_76484_a(this.worldObj, this.random, x, y, z);
                }
            }
        }
        MinecraftForge.ORE_GEN_BUS.post((Event)new OreGenEvent.Pre(this.worldObj, this.random, worldX, worldZ));
        for (CaveOreManager.CaveOre ore : CaveOreManager.getCaveOres()) {
            this.generateOre(ore.getGenRarity(), ore, worldX, worldZ, ore.getGenMinHeight(), ore.getGenMaxHeight());
        }
        MinecraftForge.ORE_GEN_BUS.post((Event)new OreGenEvent.Post(this.worldObj, this.random, worldX, worldZ));
        MinecraftForge.EVENT_BUS.post((Event)new DecorateBiomeEvent.Pre(this.worldObj, this.random, worldX, worldZ));
        if (TerrainGen.decorate((World)this.worldObj, (Random)this.random, (int)worldX, (int)worldZ, (DecorateBiomeEvent.Decorate.EventType)DecorateBiomeEvent.Decorate.EventType.SHROOM)) {
            i = 0;
            if (BiomeDictionary.isBiomeOfType((BiomeGenBase)biome, (BiomeDictionary.Type)BiomeDictionary.Type.MUSHROOM)) {
                i += 2;
            } else if (BiomeDictionary.isBiomeOfType((BiomeGenBase)biome, (BiomeDictionary.Type)BiomeDictionary.Type.NETHER)) {
                ++i;
            }
            if (this.random.nextInt(3) <= i) {
                x = worldX + this.random.nextInt(16) + 8;
                y = this.random.nextInt(worldHeight - 16) + 4;
                z = worldZ + this.random.nextInt(16) + 8;
                decorator.field_76828_s.func_76484_a(this.worldObj, this.random, x, y, z);
            }
            if (this.random.nextInt(8) <= i) {
                x = worldX + this.random.nextInt(16) + 8;
                y = this.random.nextInt(worldHeight - 16) + 4;
                z = worldZ + this.random.nextInt(16) + 8;
                decorator.field_76827_t.func_76484_a(this.worldObj, this.random, x, y, z);
            }
        }
        if (decorator.field_76808_K && TerrainGen.decorate((World)this.worldObj, (Random)this.random, (int)worldX, (int)worldZ, (DecorateBiomeEvent.Decorate.EventType)DecorateBiomeEvent.Decorate.EventType.LAKE)) {
            if (BiomeDictionary.isBiomeOfType((BiomeGenBase)biome, (BiomeDictionary.Type)BiomeDictionary.Type.NETHER)) {
                for (i = 0; i < 40; ++i) {
                    x = worldX + this.random.nextInt(16) + 8;
                    y = this.random.nextInt(worldHeight - 12) + 10;
                    z = worldZ + this.random.nextInt(16) + 8;
                    this.liquidLavaGen.func_76484_a(this.worldObj, this.random, x, y, z);
                }
            } else if (BiomeDictionary.isBiomeOfType((BiomeGenBase)biome, (BiomeDictionary.Type)BiomeDictionary.Type.WATER)) {
                for (i = 0; i < 65; ++i) {
                    x = worldX + this.random.nextInt(16) + 8;
                    y = this.random.nextInt(this.random.nextInt(worldHeight - 16) + 10);
                    z = worldZ + this.random.nextInt(16) + 8;
                    this.liquidWaterGen.func_76484_a(this.worldObj, this.random, x, y, z);
                }
            } else if (!BiomeDictionary.isBiomeOfType((BiomeGenBase)biome, (BiomeDictionary.Type)BiomeDictionary.Type.END)) {
                for (i = 0; i < 50; ++i) {
                    x = worldX + this.random.nextInt(16) + 8;
                    y = this.random.nextInt(this.random.nextInt(worldHeight - 16) + 10);
                    z = worldZ + this.random.nextInt(16) + 8;
                    this.liquidWaterGen.func_76484_a(this.worldObj, this.random, x, y, z);
                }
                for (i = 0; i < 20; ++i) {
                    x = worldX + this.random.nextInt(16) + 8;
                    y = this.random.nextInt(worldHeight / 2);
                    z = worldZ + this.random.nextInt(16) + 8;
                    this.liquidLavaGen.func_76484_a(this.worldObj, this.random, x, y, z);
                }
            }
        }
        if (Config.decorateVines && (BiomeDictionary.isBiomeOfType((BiomeGenBase)biome, (BiomeDictionary.Type)BiomeDictionary.Type.FOREST) || BiomeDictionary.isBiomeOfType((BiomeGenBase)biome, (BiomeDictionary.Type)BiomeDictionary.Type.MOUNTAIN)) && this.random.nextInt(6) == 0) {
            for (i = 0; i < 50; ++i) {
                x = worldX + this.random.nextInt(16) + 8;
                y = this.random.nextInt(worldHeight - 40) + 40;
                z = worldZ + this.random.nextInt(16) + 8;
                this.vinesGen.func_76484_a(this.worldObj, this.random, x, y, z);
            }
        }
        MinecraftForge.EVENT_BUS.post((Event)new DecorateBiomeEvent.Post(this.worldObj, this.random, worldX, worldZ));
        MinecraftForge.EVENT_BUS.post((Event)new PopulateChunkEvent.Post(chunkProvider, this.worldObj, this.random, chunkX, chunkZ, false));
        BlockFalling.field_149832_M = false;
    }

    private void generateOre(int rarity, WorldGenerator worldGenerator, int worldX, int worldZ, int minY, int maxY) {
        int worldHeight = this.worldObj.func_72940_L();
        if (rarity > 0 && minY < worldHeight && minY < maxY) {
            for (int i = 0; i < rarity; ++i) {
                int x = worldX + this.random.nextInt(16);
                int y = this.random.nextInt(Math.min(maxY, worldHeight - 1) - minY) + minY;
                int z = worldZ + this.random.nextInt(16);
                worldGenerator.func_76484_a(this.worldObj, this.random, x, y, z);
            }
        }
    }

    public boolean func_73149_a(int chunkX, int chunkZ) {
        return true;
    }

    public boolean func_73151_a(boolean flag, IProgressUpdate progress) {
        return true;
    }

    public void func_104112_b() {
    }

    public boolean func_73156_b() {
        return false;
    }

    public boolean func_73157_c() {
        return true;
    }

    public String func_73148_d() {
        return "CaveworldRandomLevelSource";
    }

    public List func_73155_a(EnumCreatureType creature, int x, int y, int z) {
        BiomeGenBase biome = this.worldObj.func_72807_a(x, z);
        return biome == null ? null : biome.func_76747_a(creature);
    }

    public ChunkPosition func_147416_a(World world, String name, int x, int y, int z) {
        return "Mineshaft".equals(name) ? this.mineshaftGenerator.func_151545_a(world, x, y, z) : ("Stronghold".equals(name) ? this.strongholdGenerator.func_151545_a(world, x, y, z) : null);
    }

    public int func_73152_e() {
        return 0;
    }

    public void func_82695_e(int chunkX, int chunkZ) {
        if (this.generateStructures) {
            if (Config.generateMineshaft) {
                this.mineshaftGenerator.func_151539_a((IChunkProvider)this, this.worldObj, chunkX, chunkZ, null);
            }
            if (Config.generateStronghold) {
                this.strongholdGenerator.func_151539_a((IChunkProvider)this, this.worldObj, chunkX, chunkZ, null);
            }
        }
    }
}

