/*
 * Decompiled with CFR 0.152.
 */
package com.kegare.caveworld.world;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.kegare.caveworld.block.CaveBlocks;
import com.kegare.caveworld.core.Config;
import java.util.Iterator;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.util.Direction;
import net.minecraft.util.MathHelper;
import net.minecraft.world.ChunkCoordIntPair;
import net.minecraft.world.Teleporter;
import net.minecraft.world.WorldServer;

public class TeleporterCaveworld
extends Teleporter {
    private final WorldServer worldObj;
    private final Random random;
    private final Map<Long, Teleporter.PortalPosition> coordCache = Maps.newHashMap();
    private final Set<Long> coordKeys = Sets.newHashSet();

    public TeleporterCaveworld(WorldServer worldServer) {
        super(worldServer);
        this.worldObj = worldServer;
        this.worldObj.customTeleporters.add(this);
        this.random = new Random(worldServer.func_72905_C());
    }

    public void func_77185_a(Entity entity, double posX, double posY, double posZ, float rotationYaw) {
        if (!this.func_77184_b(entity, posX, posY, posZ, rotationYaw)) {
            this.func_85188_a(entity);
            this.func_77184_b(entity, posX, posY, posZ, rotationYaw);
        }
    }

    public boolean func_77184_b(Entity entity, double posX, double posY, double posZ, float rotationYaw) {
        int worldHeight = this.worldObj.field_73011_w.getActualHeight();
        int x = MathHelper.func_76128_c((double)entity.field_70165_t);
        int z = MathHelper.func_76128_c((double)entity.field_70161_v);
        long chunkSeed = ChunkCoordIntPair.func_77272_a((int)x, (int)z);
        int blockX = 0;
        int blockY = this.worldObj.field_73011_w.func_76557_i();
        int blockZ = 0;
        boolean flag = true;
        double var1 = -1.0;
        if (this.coordCache.containsKey(chunkSeed)) {
            Teleporter.PortalPosition portal = this.coordCache.get(chunkSeed);
            var1 = 0.0;
            blockX = portal.field_71574_a;
            blockY = portal.field_71572_b;
            blockZ = portal.field_71573_c;
            portal.field_85087_d = this.worldObj.func_82737_E();
            flag = false;
        } else {
            for (int var2 = x - 128; var2 <= x + 128; ++var2) {
                double xScale = (double)var2 + 0.5 - entity.field_70165_t;
                for (int var3 = z - 128; var3 <= z + 128; ++var3) {
                    double zScale = (double)var3 + 0.5 - entity.field_70161_v;
                    for (int y = worldHeight - 1; y >= 0; --y) {
                        if (this.worldObj.func_147439_a(var2, y, var3) != CaveBlocks.caveworld_portal) continue;
                        while (this.worldObj.func_147439_a(var2, y - 1, var3) == CaveBlocks.caveworld_portal) {
                            --y;
                        }
                        double yScale = (double)y + 0.5 - entity.field_70163_u;
                        double var4 = xScale * xScale + yScale * yScale + zScale * zScale;
                        if (!(var1 < 0.0) && !(var4 < var1)) continue;
                        var1 = var4;
                        blockX = var2;
                        blockY = y;
                        blockZ = var3;
                    }
                }
            }
        }
        if (var1 >= 0.0) {
            if (flag) {
                this.coordCache.put(chunkSeed, new Teleporter.PortalPosition((Teleporter)this, blockX, blockY, blockZ, this.worldObj.func_82737_E()));
                this.coordKeys.add(chunkSeed);
            }
            double var2 = (double)blockX + 0.5;
            double var3 = (double)blockY + 0.5;
            double var4 = (double)blockZ + 0.5;
            int var5 = -1;
            if (this.worldObj.func_147439_a(blockX - 1, blockY, blockZ) == CaveBlocks.caveworld_portal) {
                var5 = 2;
            }
            if (this.worldObj.func_147439_a(blockX + 1, blockY, blockZ) == CaveBlocks.caveworld_portal) {
                var5 = 0;
            }
            if (this.worldObj.func_147439_a(blockX, blockY, blockZ - 1) == CaveBlocks.caveworld_portal) {
                var5 = 3;
            }
            if (this.worldObj.func_147439_a(blockX, blockY, blockZ + 1) == CaveBlocks.caveworld_portal) {
                var5 = 1;
            }
            if (var5 > -1) {
                boolean var13;
                int var6 = entity.func_82148_at();
                int var8 = Direction.field_71583_a[var5];
                int var7 = Direction.field_71578_g[var5];
                int var10 = Direction.field_71583_a[var7];
                int var9 = Direction.field_71581_b[var5];
                int var11 = Direction.field_71581_b[var7];
                boolean var12 = !this.worldObj.func_147437_c(blockX + var8 + var10, blockY, blockZ + var9 + var11) || !this.worldObj.func_147437_c(blockX + var8 + var10, blockY + 1, blockZ + var9 + var11);
                boolean bl = var13 = !this.worldObj.func_147437_c(blockX + var8, blockY, blockZ + var9) || !this.worldObj.func_147437_c(blockX + var8, blockY + 1, blockZ + var9);
                if (var12 && var13) {
                    var5 = Direction.field_71580_e[var5];
                    var7 = Direction.field_71580_e[var7];
                    var8 = Direction.field_71583_a[var5];
                    var9 = Direction.field_71581_b[var5];
                    var10 = Direction.field_71583_a[var7];
                    var11 = Direction.field_71581_b[var7];
                    x = blockX - var10;
                    var2 -= (double)var10;
                    z = blockZ - var11;
                    var4 -= (double)var11;
                    var12 = !this.worldObj.func_147437_c(x + var8 + var10, blockY, z + var9 + var11) || !this.worldObj.func_147437_c(x + var8 + var10, blockY + 1, z + var9 + var11);
                    var13 = !this.worldObj.func_147437_c(x + var8, blockY, z + var9) || !this.worldObj.func_147437_c(x + var8, blockY + 1, z + var9);
                }
                float var14 = 0.5f;
                float var15 = 0.5f;
                if (!var12 && var13) {
                    var14 = 1.0f;
                } else if (var12 && !var13) {
                    var14 = 0.0f;
                } else if (var12) {
                    var15 = 0.0f;
                }
                var2 += (double)((float)var10 * var14 + var15 * (float)var8);
                var4 += (double)((float)var11 * var14 + var15 * (float)var9);
                var14 = 0.0f;
                var15 = 0.0f;
                float var18 = 0.0f;
                float var19 = 0.0f;
                if (var5 == var6) {
                    var14 = 1.0f;
                    var15 = 1.0f;
                } else if (var5 == Direction.field_71580_e[var6]) {
                    var14 = -1.0f;
                    var15 = -1.0f;
                } else if (var5 == Direction.field_71577_f[var6]) {
                    var18 = 1.0f;
                    var19 = -1.0f;
                } else {
                    var18 = -1.0f;
                    var19 = 1.0f;
                }
                double var20 = entity.field_70159_w;
                double var21 = entity.field_70179_y;
                entity.field_70159_w = var20 * (double)var14 + var21 * (double)var19;
                entity.field_70179_y = var20 * (double)var18 + var21 * (double)var15;
                entity.field_70177_z = rotationYaw - (float)(var6 * 90) + (float)(var5 * 90);
            } else {
                entity.field_70179_y = 0.0;
                entity.field_70181_x = 0.0;
                entity.field_70159_w = 0.0;
            }
            entity.func_70012_b(var2, var3, var4, entity.field_70177_z, entity.field_70125_A);
            if (Config.hardcoreEnabled && entity.field_71093_bK == Config.dimensionCaveworld && entity instanceof EntityPlayer) {
                blockX = MathHelper.func_76128_c((double)var2);
                blockY = MathHelper.func_76128_c((double)var3);
                blockZ = MathHelper.func_76128_c((double)var4);
                ((EntityPlayer)entity).setSpawnChunk(new ChunkCoordinates(blockX, blockY, blockZ), true, entity.field_71093_bK);
            }
            return true;
        }
        return false;
    }

    public boolean func_85188_a(Entity entity) {
        boolean flag;
        double var15;
        double var16;
        int var13;
        int var14;
        int var11;
        int var12;
        int var9;
        int var10;
        int var7;
        int var8;
        int blockY;
        double zScale;
        int blockZ;
        double xScale;
        int blockX;
        int worldHeight = this.worldObj.field_73011_w.getActualHeight();
        int x = MathHelper.func_76128_c((double)entity.field_70165_t);
        int y = MathHelper.func_76128_c((double)entity.field_70163_u);
        int z = MathHelper.func_76128_c((double)entity.field_70161_v);
        double var1 = -1.0;
        int var2 = x;
        int var3 = y;
        int var4 = z;
        int var5 = 0;
        int var6 = this.random.nextInt(4);
        for (blockX = x - 16; blockX <= x + 16; ++blockX) {
            xScale = (double)blockX + 0.5 - entity.field_70165_t;
            for (blockZ = z - 16; blockZ <= z + 16; ++blockZ) {
                zScale = (double)blockZ + 0.5 - entity.field_70161_v;
                block2: for (blockY = worldHeight - 2; blockY >= 0; --blockY) {
                    if (!this.worldObj.func_147437_c(blockX, blockY, blockZ)) continue;
                    while (blockY > 0 && this.worldObj.func_147437_c(blockX, blockY - 1, blockZ)) {
                        --blockY;
                    }
                    for (var8 = var6; var8 < var6 + 4; ++var8) {
                        var7 = var8 % 2;
                        var10 = 1 - var7;
                        if (var8 % 4 >= 2) {
                            var7 = -var7;
                            var10 = -var10;
                        }
                        for (var9 = 0; var9 < 3; ++var9) {
                            for (var12 = 0; var12 < 4; ++var12) {
                                for (var11 = -1; var11 < 4; ++var11) {
                                    var14 = blockX + (var12 - 1) * var7 + var9 * var10;
                                    var13 = blockY + var11;
                                    int var17 = blockZ + (var12 - 1) * var10 - var9 * var7;
                                    if (var11 < 0 && !this.worldObj.func_147439_a(var14, var13, var17).func_149688_o().func_76220_a() || var11 >= 0 && !this.worldObj.func_147437_c(var14, var13, var17)) continue block2;
                                }
                            }
                        }
                        var16 = (double)blockY + 0.5 - entity.field_70163_u;
                        var15 = xScale * xScale + var16 * var16 + zScale * zScale;
                        if (!(var1 < 0.0) && !(var15 < var1)) continue;
                        var1 = var15;
                        var2 = blockX;
                        var3 = blockY;
                        var4 = blockZ;
                        var5 = var8 % 4;
                    }
                }
            }
        }
        if (var1 < 0.0) {
            for (blockX = x - 16; blockX <= x + 16; ++blockX) {
                xScale = (double)blockX + 0.5 - entity.field_70165_t;
                for (blockZ = z - 16; blockZ <= z + 16; ++blockZ) {
                    zScale = (double)blockZ + 0.5 - entity.field_70161_v;
                    block10: for (blockY = worldHeight - 2; blockY >= 0; --blockY) {
                        if (!this.worldObj.func_147437_c(blockX, blockY, blockZ)) continue;
                        while (blockY > 0 && this.worldObj.func_147437_c(blockX, blockY - 1, blockZ)) {
                            --blockY;
                        }
                        for (var8 = var6; var8 < var6 + 2; ++var8) {
                            var7 = var8 % 2;
                            var10 = 1 - var7;
                            for (var9 = 0; var9 < 4; ++var9) {
                                for (var12 = -1; var12 < 4; ++var12) {
                                    var11 = blockX + (var9 - 1) * var7;
                                    var14 = blockY + var12;
                                    var13 = blockZ + (var9 - 1) * var10;
                                    if (var12 < 0 && !this.worldObj.func_147439_a(var11, var14, var13).func_149688_o().func_76220_a() || var12 >= 0 && !this.worldObj.func_147437_c(var11, var14, var13)) continue block10;
                                }
                            }
                            var16 = (double)blockY + 0.5 - entity.field_70163_u;
                            var15 = xScale * xScale + var16 * var16 + zScale * zScale;
                            if (!(var1 < 0.0) && !(var15 < var1)) continue;
                            var1 = var15;
                            var2 = blockX;
                            var3 = blockY;
                            var4 = blockZ;
                            var5 = var8 % 2;
                        }
                    }
                }
            }
        }
        var13 = var5 % 2;
        var14 = 1 - var13;
        if (var5 % 4 >= 2) {
            var13 = -var13;
            var14 = -var14;
        }
        if (var1 < 0.0) {
            var3 = MathHelper.func_76125_a((int)var3, (int)10, (int)(worldHeight - 10));
            for (var6 = -1; var6 <= 1; ++var6) {
                for (var8 = 1; var8 < 3; ++var8) {
                    for (var7 = -1; var7 < 3; ++var7) {
                        var10 = var2 + (var8 - 1) * var13 + var6 * var14;
                        var9 = var3 + var7;
                        var12 = var4 + (var8 - 1) * var14 - var6 * var13;
                        flag = var7 < 0;
                        this.worldObj.func_147449_b(var10, var9, var12, flag ? Blocks.field_150341_Y : Blocks.field_150350_a);
                    }
                }
            }
        }
        for (var8 = 0; var8 < 4; ++var8) {
            for (var7 = -1; var7 < 4; ++var7) {
                var10 = var2 + (var8 - 1) * var13;
                var9 = var3 + var7;
                var12 = var4 + (var8 - 1) * var14;
                boolean bl = flag = var8 == 0 || var8 == 3 || var7 == -1 || var7 == 3;
                if (var7 < 0 && this.worldObj.func_147439_a(var10, var9, var12) == Blocks.field_150357_h) {
                    ++var9;
                }
                this.worldObj.func_147465_d(var10, var9, var12, (Block)(flag ? Blocks.field_150341_Y : CaveBlocks.caveworld_portal), 0, 2);
            }
        }
        return true;
    }

    public void func_85189_a(long time) {
        if (time % 100L == 0L) {
            Iterator<Long> iterator = this.coordKeys.iterator();
            long var1 = time - 600L;
            while (iterator.hasNext()) {
                long chunkSeed = iterator.next();
                Teleporter.PortalPosition portal = this.coordCache.get(chunkSeed);
                if (portal != null && portal.field_85087_d >= var1) continue;
                iterator.remove();
                this.coordCache.remove(chunkSeed);
            }
        }
    }
}

