/*
 * Decompiled with CFR 0.152.
 */
package com.kegare.caveworld.world;

import com.kegare.caveworld.core.Caveworld;
import com.kegare.caveworld.core.Config;
import com.kegare.caveworld.renderer.EmptyRenderer;
import com.kegare.caveworld.util.CaveLog;
import com.kegare.caveworld.world.ChunkProviderCaveworld;
import com.kegare.caveworld.world.WorldChunkManagerCaveworld;
import com.kegare.caveworld.world.gen.MapGenStrongholdCaveworld;
import com.kegare.caveworld.world.gen.StructureStrongholdPiecesCaveworld;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.io.File;
import java.security.SecureRandom;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.MathHelper;
import net.minecraft.util.Vec3;
import net.minecraft.world.WorldProvider;
import net.minecraft.world.WorldType;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.gen.structure.MapGenStructureIO;
import net.minecraftforge.client.IRenderHandler;
import net.minecraftforge.common.DimensionManager;
import org.apache.logging.log4j.Level;

public class WorldProviderCaveworld
extends WorldProvider {
    public static long dimensionSeed;
    public static int subsurfaceHeight;
    private static NBTTagCompound dimData;

    public static NBTTagCompound getDimData() {
        if (dimData == null) {
            dimData = WorldProviderCaveworld.readDimData();
        }
        return dimData;
    }

    public static File getDimDir() {
        File root = DimensionManager.getCurrentSaveRootDirectory();
        if (root == null || !root.exists() || root.isFile()) {
            return null;
        }
        File dir = new File(root, "DIM-Caveworld");
        if (!dir.exists()) {
            dir.mkdirs();
        }
        return dir;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static NBTTagCompound readDimData() {
        NBTTagCompound data = null;
        try {
            data = CompressedStreamTools.func_74797_a((File)new File(WorldProviderCaveworld.getDimDir(), "caveworld.dat"));
        }
        catch (Exception e) {
            CaveLog.log(Level.ERROR, e, "An error occurred trying to reading Caveworld dimension data", new Object[0]);
        }
        finally {
            if (data == null) {
                data = new NBTTagCompound();
            }
        }
        return data;
    }

    public static void writeDimData() {
        try {
            CompressedStreamTools.func_74795_b((NBTTagCompound)WorldProviderCaveworld.getDimData(), (File)new File(WorldProviderCaveworld.getDimDir(), "caveworld.dat"));
        }
        catch (Exception e) {
            CaveLog.log(Level.ERROR, e, "An error occurred trying to writing Caveworld dimension data", new Object[0]);
        }
    }

    public static void clearDimData() {
        dimensionSeed = 0L;
        subsurfaceHeight = 0;
        dimData = null;
    }

    protected void func_76572_b() {
        this.field_76578_c = new WorldChunkManagerCaveworld(this.field_76579_a);
        this.field_76574_g = Config.dimensionCaveworld;
        this.field_76576_e = true;
        MapGenStructureIO.func_143034_b(MapGenStrongholdCaveworld.Start.class, (String)"Caveworld.Stronghold");
        StructureStrongholdPiecesCaveworld.registerStrongholdPieces();
    }

    public IChunkProvider func_76555_c() {
        return new ChunkProviderCaveworld(this.field_76579_a);
    }

    public boolean func_76566_a(int x, int z) {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public float[] func_76560_a(float angle, float ticks) {
        return null;
    }

    @SideOnly(value=Side.CLIENT)
    public Vec3 func_76562_b(float angle, float ticks) {
        return this.field_76579_a.func_82732_R().func_72345_a(0.01, 0.01, 0.01);
    }

    public boolean func_76567_e() {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public float func_76571_f() {
        return this.getActualHeight();
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_76561_g() {
        return false;
    }

    public int func_76557_i() {
        return 10;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_76564_j() {
        return this.field_76577_b != WorldType.field_77138_c;
    }

    public String func_80007_l() {
        return "Caveworld";
    }

    public String getSaveFolder() {
        return "DIM-Caveworld";
    }

    public String getWelcomeMessage() {
        return "Entering the Caveworld";
    }

    public String getDepartMessage() {
        return "Leaving the Caveworld";
    }

    public double getMovementFactor() {
        return 3.0;
    }

    @SideOnly(value=Side.CLIENT)
    public IRenderHandler getSkyRenderer() {
        return new EmptyRenderer();
    }

    @SideOnly(value=Side.CLIENT)
    public IRenderHandler getCloudRenderer() {
        return new EmptyRenderer();
    }

    public boolean shouldMapSpin(String entity, double posX, double posY, double posZ) {
        return false;
    }

    public int getRespawnDimension(EntityPlayerMP player) {
        if (Config.hardcoreEnabled || player.getBedLocation(this.field_76574_g) != null) {
            return this.field_76574_g;
        }
        return super.getRespawnDimension(player);
    }

    public boolean isDaytime() {
        return Caveworld.proxy.getServer().func_130014_f_().func_72935_r();
    }

    @SideOnly(value=Side.CLIENT)
    public Vec3 getSkyColor(Entity entity, float ticks) {
        return this.field_76579_a.func_82732_R().func_72345_a(0.01, 0.01, 0.01);
    }

    @SideOnly(value=Side.CLIENT)
    public Vec3 drawClouds(float ticks) {
        return this.field_76579_a.func_82732_R().func_72345_a(0.01, 0.01, 0.01);
    }

    @SideOnly(value=Side.CLIENT)
    public float getStarBrightness(float ticks) {
        return 0.0f;
    }

    public void calculateInitialWeather() {
    }

    public void updateWeather() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getSeed() {
        if (!this.field_76579_a.field_72995_K && dimensionSeed == 0L) {
            try {
                NBTTagCompound data = WorldProviderCaveworld.getDimData();
                if (!data.func_74764_b("DimSeed")) {
                    data.func_74772_a("DimSeed", new SecureRandom().nextLong());
                }
                dimensionSeed = data.func_74763_f("DimSeed");
            }
            finally {
                if (dimensionSeed == 0L) {
                    dimensionSeed = Long.reverseBytes(super.getSeed());
                }
            }
        }
        return dimensionSeed;
    }

    public int getActualHeight() {
        if (!this.field_76579_a.field_72995_K && subsurfaceHeight == 0) {
            NBTTagCompound data = WorldProviderCaveworld.getDimData();
            if (!data.func_74764_b("SubsurfaceHeight")) {
                data.func_74768_a("SubsurfaceHeight", Config.subsurfaceHeight);
            }
            subsurfaceHeight = MathHelper.func_76125_a((int)data.func_74762_e("SubsurfaceHeight"), (int)63, (int)255);
        }
        return subsurfaceHeight + 1;
    }

    public double getHorizon() {
        return (double)this.getActualHeight() - 1.0;
    }

    public boolean canDoLightning(Chunk chunk) {
        return false;
    }

    public boolean canDoRainSnowIce(Chunk chunk) {
        return false;
    }
}

