/*
 * Decompiled with CFR 0.152.
 */
package com.kegare.caveworld.world.gen;

import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;
import net.minecraft.world.gen.MapGenCaves;

public class MapGenCavesCaveworld
extends MapGenCaves {
    protected void func_151541_a(long caveSeed, int chunkX, int chunkZ, Block[] blocks, double blockX, double blockY, double blockZ, float scale, float leftRightRadian, float upDownRadian, int currentY, int targetY, double scaleHeight) {
        boolean chance;
        int worldHeight = this.field_75039_c.func_72940_L();
        Random random = new Random(caveSeed);
        double centerX = (chunkX << 4) + 8;
        double centerZ = (chunkZ << 4) + 8;
        float leftRightChange = 0.0f;
        float upDownChange = 0.0f;
        if (targetY <= 0) {
            int blockRangeY = this.field_75040_a * 16 - 16;
            targetY = blockRangeY - random.nextInt(blockRangeY / 4);
        }
        boolean createFinalRoom = false;
        if (currentY == -1) {
            currentY = targetY / 2;
            createFinalRoom = true;
        }
        int nextInterHeight = random.nextInt(targetY / 2) + targetY / 4;
        boolean bl = chance = random.nextInt(6) == 0;
        while (currentY < targetY) {
            double roomWidth = 1.5 + (double)(MathHelper.func_76126_a((float)((float)currentY * (float)Math.PI / (float)targetY)) * scale * 1.0f);
            double roomHeight = roomWidth * scaleHeight;
            float moveHorizontal = MathHelper.func_76134_b((float)upDownRadian);
            float moveVertical = MathHelper.func_76126_a((float)upDownRadian);
            blockX += (double)(MathHelper.func_76134_b((float)leftRightRadian) * moveHorizontal);
            blockY += (double)moveVertical;
            blockZ += (double)(MathHelper.func_76126_a((float)leftRightRadian) * moveHorizontal);
            upDownRadian = chance ? (upDownRadian *= 0.92f) : (upDownRadian *= 0.7f);
            upDownRadian += upDownChange * 0.1f;
            leftRightRadian += leftRightChange * 0.1f;
            upDownChange *= 0.9f;
            leftRightChange *= 0.75f;
            upDownChange += (random.nextFloat() - random.nextFloat()) * random.nextFloat() * 2.0f;
            leftRightChange += (random.nextFloat() - random.nextFloat()) * random.nextFloat() * 4.0f;
            if (!createFinalRoom && currentY == nextInterHeight && scale > 1.0f && targetY > 0) {
                this.func_151541_a(random.nextLong(), chunkX, chunkZ, blocks, blockX, blockY, blockZ, random.nextFloat() * 0.5f + 0.5f, leftRightRadian - 1.5707964f, upDownRadian / 3.0f, currentY, targetY, 1.0);
                this.func_151541_a(random.nextLong(), chunkX, chunkZ, blocks, blockX, blockY, blockZ, random.nextFloat() * 0.5f + 0.5f, leftRightRadian + 1.5707964f, upDownRadian / 3.0f, currentY, targetY, 1.0);
                return;
            }
            if (createFinalRoom || random.nextInt(4) != 0) {
                double distanceX = blockX - centerX;
                double distanceZ = blockZ - centerZ;
                double distanceY = targetY - currentY;
                double maxDistance = scale + 2.0f + 16.0f;
                if (distanceX * distanceX + distanceZ * distanceZ - distanceY * distanceY > maxDistance * maxDistance) {
                    return;
                }
                if (blockX >= centerX - 16.0 - roomWidth * 2.0 && blockZ >= centerZ - 16.0 - roomWidth * 2.0 && blockX <= centerX + 16.0 + roomWidth * 2.0 && blockZ <= centerZ + 16.0 + roomWidth * 2.0) {
                    int xLow = Math.max(MathHelper.func_76128_c((double)(blockX - roomWidth)) - (chunkX << 4) - 1, 0);
                    int xHigh = Math.min(MathHelper.func_76128_c((double)(blockX + roomWidth)) - (chunkX << 4) + 1, 16);
                    int yLow = Math.max(MathHelper.func_76128_c((double)(blockY - roomHeight)) - 1, 1);
                    int yHigh = Math.min(MathHelper.func_76128_c((double)(blockY + roomHeight)) + 1, worldHeight - 8);
                    int zLow = Math.max(MathHelper.func_76128_c((double)(blockZ - roomWidth)) - (chunkZ << 4) - 1, 0);
                    int zHigh = Math.min(MathHelper.func_76128_c((double)(blockZ + roomWidth)) - (chunkZ << 4) + 1, 16);
                    for (int x = xLow; x < xHigh; ++x) {
                        double xScale = ((double)((chunkX << 4) + x) + 0.5 - blockX) / roomWidth;
                        for (int z = zLow; z < zHigh; ++z) {
                            double zScale = ((double)((chunkZ << 4) + z) + 0.5 - blockZ) / roomWidth;
                            int index = ((x << 4) + z) * 128 + yHigh;
                            if (!(xScale * xScale + zScale * zScale < 1.0)) continue;
                            for (int y = yHigh - 1; y >= yLow; --y) {
                                double yScale = ((double)y + 0.5 - blockY) / roomHeight;
                                if (yScale > -0.7 && xScale * xScale + yScale * yScale + zScale * zScale < 1.0) {
                                    this.digBlock(blocks, index, x, y, z, chunkX, chunkZ, false);
                                }
                                --index;
                            }
                        }
                    }
                    if (createFinalRoom) break;
                }
            }
            ++currentY;
        }
    }

    protected void func_151538_a(World world, int x, int z, int chunkX, int chunkZ, Block[] blocks) {
        int worldHeight = world.field_73011_w.getActualHeight();
        int chance = this.field_75038_b.nextInt(this.field_75038_b.nextInt(this.field_75038_b.nextInt(15) + 1) + 1);
        if (this.field_75038_b.nextInt(6) != 0) {
            chance = 0;
        }
        for (int i = 0; i < chance; ++i) {
            double blockX = (x << 4) + this.field_75038_b.nextInt(16);
            double blockY = this.field_75038_b.nextInt(this.field_75038_b.nextInt(worldHeight - 8) + 8);
            double blockZ = (z << 4) + this.field_75038_b.nextInt(16);
            int count = 1;
            if (this.field_75038_b.nextInt(4) == 0) {
                this.func_151542_a(this.field_75038_b.nextLong(), chunkX, chunkZ, blocks, blockX, blockY, blockZ);
                count += this.field_75038_b.nextInt(4);
            }
            for (int j = 0; j < count; ++j) {
                float leftRightRadian = this.field_75038_b.nextFloat() * (float)Math.PI * 2.0f;
                float upDownRadian = (this.field_75038_b.nextFloat() - 0.5f) * 2.0f / 8.0f;
                float scale = this.field_75038_b.nextFloat() * 2.0f + this.field_75038_b.nextFloat();
                if (this.field_75038_b.nextInt(10) == 0) {
                    scale *= this.field_75038_b.nextFloat() * this.field_75038_b.nextFloat() * 3.0f + 1.0f;
                }
                this.func_151541_a(this.field_75038_b.nextLong(), chunkX, chunkZ, blocks, blockX, blockY, blockZ, scale, leftRightRadian, upDownRadian, 0, 0, 1.0);
            }
        }
    }

    protected void digBlock(Block[] blocks, int index, int x, int y, int z, int chunkX, int chunkZ, boolean foundTop) {
        blocks[index] = y < 10 ? Blocks.field_150353_l : null;
    }
}

