/*
 * Decompiled with CFR 0.152.
 */
package com.kegare.caveworld.world.gen;

import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.util.MathHelper;
import net.minecraft.world.gen.MapGenRavine;

public class MapGenRavineCaveworld
extends MapGenRavine {
    private final float[] field_75046_d = new float[1024];

    protected void func_151540_a(long ravineSeed, int chunkX, int chunkZ, Block[] blocks, double blockX, double blockY, double blockZ, float scale, float leftRightRadian, float upDownRadian, int currentY, int targetY, double scaleHeight) {
        int worldHeight = this.field_75039_c.func_72940_L();
        Random random = new Random(ravineSeed);
        double centerX = (chunkX << 4) + 8;
        double centerZ = (chunkZ << 4) + 8;
        float leftRightChange = 0.0f;
        float upDownChange = 0.0f;
        if (targetY <= 0) {
            int blockRangeY = this.field_75040_a * 16 - 16;
            targetY = blockRangeY - random.nextInt(blockRangeY / 4);
        }
        boolean createFinalRoom = false;
        if (currentY == -1) {
            currentY = targetY / 2;
            createFinalRoom = true;
        }
        float nextInterHeight = 1.0f;
        for (int y = 0; y < worldHeight; ++y) {
            if (y == 0 || random.nextInt(3) == 0) {
                nextInterHeight = 1.0f + random.nextFloat() * random.nextFloat() * 1.0f;
            }
            this.field_75046_d[y] = nextInterHeight * nextInterHeight;
        }
        while (currentY < targetY) {
            double roomWidth = 1.5 + (double)(MathHelper.func_76126_a((float)((float)currentY * (float)Math.PI / (float)targetY)) * scale * 1.0f);
            double roomHeight = roomWidth * scaleHeight;
            roomWidth *= (double)random.nextFloat() * 0.25 + 0.75;
            roomHeight *= (double)random.nextFloat() * 0.25 + 0.75;
            float moveHorizontal = MathHelper.func_76134_b((float)upDownRadian);
            float moveVertical = MathHelper.func_76126_a((float)upDownRadian);
            blockX += (double)(MathHelper.func_76134_b((float)leftRightRadian) * moveHorizontal);
            blockY += (double)moveVertical;
            blockZ += (double)(MathHelper.func_76126_a((float)leftRightRadian) * moveHorizontal);
            upDownRadian *= 0.7f;
            upDownRadian += upDownChange * 0.05f;
            leftRightRadian += leftRightChange * 0.05f;
            upDownChange *= 0.8f;
            leftRightChange *= 0.5f;
            upDownChange += (random.nextFloat() - random.nextFloat()) * random.nextFloat() * 2.0f;
            leftRightChange += (random.nextFloat() - random.nextFloat()) * random.nextFloat() * 4.0f;
            if (createFinalRoom || random.nextInt(4) != 0) {
                double distanceX = blockX - centerX;
                double distanceZ = blockZ - centerZ;
                double distanceY = targetY - currentY;
                double maxDistance = scale + 2.0f + 16.0f;
                if (distanceX * distanceX + distanceZ * distanceZ - distanceY * distanceY > maxDistance * maxDistance) {
                    return;
                }
                if (blockX >= centerX - 16.0 - roomWidth * 2.0 && blockZ >= centerZ - 16.0 - roomWidth * 2.0 && blockX <= centerX + 16.0 + roomWidth * 2.0 && blockZ <= centerZ + 16.0 + roomWidth * 2.0) {
                    int xLow = Math.max(MathHelper.func_76128_c((double)(blockX - roomWidth)) - (chunkX << 4) - 1, 0);
                    int xHigh = Math.min(MathHelper.func_76128_c((double)(blockX + roomWidth)) - (chunkX << 4) + 1, 16);
                    int yLow = Math.max(MathHelper.func_76128_c((double)(blockY - roomHeight)) - 1, 1);
                    int yHigh = Math.min(MathHelper.func_76128_c((double)(blockY + roomHeight)) + 1, worldHeight - 8);
                    int zLow = Math.max(MathHelper.func_76128_c((double)(blockZ - roomWidth)) - (chunkZ << 4) - 1, 0);
                    int zHigh = Math.min(MathHelper.func_76128_c((double)(blockZ + roomWidth)) - (chunkZ << 4) + 1, 16);
                    for (int x = xLow; x < xHigh; ++x) {
                        double xScale = ((double)((chunkX << 4) + x) + 0.5 - blockX) / roomWidth;
                        for (int z = zLow; z < zHigh; ++z) {
                            double zScale = ((double)((chunkZ << 4) + z) + 0.5 - blockZ) / roomWidth;
                            int index = ((x << 4) + z) * 128 + yHigh;
                            if (!(xScale * xScale + zScale * zScale < 1.0)) continue;
                            for (int y = yHigh - 1; y >= yLow; --y) {
                                double yScale = ((double)y + 0.5 - blockY) / roomHeight;
                                if ((xScale * xScale + zScale * zScale) * (double)this.field_75046_d[y] + yScale * yScale / 6.0 < 1.0) {
                                    this.digBlock(blocks, index, x, y, z, chunkX, chunkZ, false);
                                }
                                --index;
                            }
                        }
                    }
                    if (createFinalRoom) break;
                }
            }
            ++currentY;
        }
    }

    protected void digBlock(Block[] blocks, int index, int x, int y, int z, int chunkX, int chunkZ, boolean foundTop) {
        blocks[index] = y < 10 ? Blocks.field_150356_k : null;
    }
}

