/*
 * Decompiled with CFR 0.152.
 */
package com.kegare.caveworld.world.gen;

import com.google.common.collect.Lists;
import com.kegare.caveworld.world.gen.StructureStrongholdPiecesCaveworld;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.world.ChunkCoordIntPair;
import net.minecraft.world.World;
import net.minecraft.world.gen.structure.MapGenStronghold;
import net.minecraft.world.gen.structure.StructureComponent;
import net.minecraft.world.gen.structure.StructureStart;

public class MapGenStrongholdCaveworld
extends MapGenStronghold {
    private ChunkCoordIntPair[] structureCoords = new ChunkCoordIntPair[5];
    private double structureDistance = 32.0;
    private int structureSpread = 1;
    private boolean initStructureCoords;

    public String func_143025_a() {
        return "Caveworld.Stronghold";
    }

    protected boolean func_75047_a(int chunkX, int chunkZ) {
        if (!this.initStructureCoords) {
            Random random = new Random();
            random.setSeed(this.field_75039_c.func_72905_C());
            double var1 = random.nextDouble() * Math.PI * 2.0;
            int var2 = 1;
            for (int i = 0; i < this.structureCoords.length; ++i) {
                double var3 = (1.3 * (double)var2 + random.nextDouble()) * this.structureDistance * (double)var2;
                int x = (int)Math.round(Math.cos(var1) * var3);
                int z = (int)Math.round(Math.sin(var1) * var3);
                this.structureCoords[i] = new ChunkCoordIntPair(x, z);
                var1 += Math.PI * 2 * (double)var2 / (double)this.structureSpread;
                if (i != this.structureSpread) continue;
                var2 += 2 + random.nextInt(5);
                this.structureSpread += 1 + random.nextInt(2);
            }
            this.initStructureCoords = true;
        }
        for (ChunkCoordIntPair coord : this.structureCoords) {
            if (chunkX != coord.field_77276_a || chunkZ != coord.field_77275_b) continue;
            return true;
        }
        return false;
    }

    protected List func_75052_o_() {
        ArrayList list = Lists.newArrayList();
        for (ChunkCoordIntPair coord : this.structureCoords) {
            if (coord == null) continue;
            list.add(coord.func_151349_a(64));
        }
        return list;
    }

    protected StructureStart func_75049_b(int chunkX, int chunkZ) {
        Start start = new Start(this.field_75039_c, this.field_75038_b, chunkX, chunkZ);
        while (start.func_75073_b().isEmpty() || ((StructureStrongholdPiecesCaveworld.Stairs2)((Object)start.func_75073_b().get((int)0))).strongholdPortalRoom == null) {
            start = new Start(this.field_75039_c, this.field_75038_b, chunkX, chunkZ);
        }
        return start;
    }

    public static class Start
    extends StructureStart {
        public Start() {
        }

        public Start(World world, Random random, int chunkX, int chunkZ) {
            super(chunkX, chunkZ);
            StructureStrongholdPiecesCaveworld.prepareStructurePieces();
            StructureStrongholdPiecesCaveworld.Stairs2 stairs2 = new StructureStrongholdPiecesCaveworld.Stairs2(0, random, (chunkX << 4) + 2, (chunkZ << 4) + 2);
            this.field_75075_a.add(stairs2);
            stairs2.func_74861_a(stairs2, this.field_75075_a, random);
            List list = stairs2.field_75026_c;
            while (!list.isEmpty()) {
                StructureComponent structureComponent = (StructureComponent)list.remove(random.nextInt(list.size()));
                structureComponent.func_74861_a((StructureComponent)stairs2, (List)this.field_75075_a, random);
            }
            this.func_75072_c();
            this.func_75067_a(world, random, 10);
        }
    }
}

