/*
 * Decompiled with CFR 0.152.
 */
package com.kegare.caveworld.world.gen;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntityMobSpawner;
import net.minecraft.world.ChunkPosition;
import net.minecraft.world.World;
import net.minecraft.world.gen.structure.MapGenStructureIO;
import net.minecraft.world.gen.structure.StructureBoundingBox;
import net.minecraft.world.gen.structure.StructureComponent;
import net.minecraft.world.gen.structure.StructureStrongholdPieces;
import net.minecraftforge.common.ChestGenHooks;

public class StructureStrongholdPiecesCaveworld {
    private static final PieceWeight[] pieceWeightArray = new PieceWeight[]{new PieceWeight(PortalRoom.class, 20, 1){

        @Override
        public boolean canSpawnMoreStructuresOfType(int type) {
            return super.canSpawnMoreStructuresOfType(type) && type > 5;
        }
    }, new PieceWeight(Library.class, 10, 3){

        @Override
        public boolean canSpawnMoreStructuresOfType(int type) {
            return super.canSpawnMoreStructuresOfType(type) && type > 4;
        }
    }, new PieceWeight(Straight.class, 40, 0), new PieceWeight(LeftTurn.class, 20, 0), new PieceWeight(RightTurn.class, 20, 0), new PieceWeight(RoomCrossing.class, 10, 6), new PieceWeight(Crossing.class, 5, 4), new PieceWeight(Stairs.class, 5, 5), new PieceWeight(StairsStraight.class, 5, 5), new PieceWeight(ChestCorridor.class, 6, 6), new PieceWeight(Prison.class, 5, 5)};
    private static final LinkedHashSet<PieceWeight> structurePieces = Sets.newLinkedHashSet();
    private static Class strongholdComponentType;
    private static int totalWeight;
    private static final Stones strongholdStones;

    public static void registerStrongholdPieces() {
        MapGenStructureIO.func_143031_a(Stairs2.class, (String)"CW:SHStart");
        MapGenStructureIO.func_143031_a(PortalRoom.class, (String)"CW:SHPR");
        MapGenStructureIO.func_143031_a(Library.class, (String)"CW:SHLi");
        MapGenStructureIO.func_143031_a(Straight.class, (String)"CW:SHS");
        MapGenStructureIO.func_143031_a(LeftTurn.class, (String)"CW:SHLT");
        MapGenStructureIO.func_143031_a(RightTurn.class, (String)"CW:SHRT");
        MapGenStructureIO.func_143031_a(RoomCrossing.class, (String)"CW:SHRC");
        MapGenStructureIO.func_143031_a(Crossing.class, (String)"CW:SH5C");
        MapGenStructureIO.func_143031_a(Stairs.class, (String)"CW:SHSD");
        MapGenStructureIO.func_143031_a(StairsStraight.class, (String)"CW:SHSSD");
        MapGenStructureIO.func_143031_a(Corridor.class, (String)"CW:SHFC");
        MapGenStructureIO.func_143031_a(ChestCorridor.class, (String)"CW:SHCC");
        MapGenStructureIO.func_143031_a(Prison.class, (String)"CW:SHPH");
    }

    public static void prepareStructurePieces() {
        structurePieces.clear();
        for (PieceWeight pieceWeight : pieceWeightArray) {
            pieceWeight.instancesSpawned = 0;
            structurePieces.add(pieceWeight);
        }
        strongholdComponentType = null;
    }

    private static boolean canAddStructurePieces() {
        totalWeight = 0;
        boolean flag = false;
        for (PieceWeight pieceWeight : structurePieces) {
            if (pieceWeight.instancesLimit > 0 && pieceWeight.instancesSpawned < pieceWeight.instancesLimit) {
                flag = true;
            }
            totalWeight += pieceWeight.pieceWeight;
        }
        return flag;
    }

    private static Stronghold getStrongholdComponentFromWeightedPiece(Class clazz, List list, Random random, int x, int y, int z, int mode, int type) {
        Stronghold object = null;
        if (clazz == PortalRoom.class) {
            object = PortalRoom.findValidPlacement(list, random, x, y, z, mode, type);
        } else if (clazz == Library.class) {
            object = Library.findValidPlacement(list, random, x, y, z, mode, type);
        } else if (clazz == Straight.class) {
            object = Straight.findValidPlacement(list, random, x, y, z, mode, type);
        } else if (clazz == LeftTurn.class) {
            object = LeftTurn.findValidPlacement(list, random, x, y, z, mode, type);
        } else if (clazz == RightTurn.class) {
            object = RightTurn.findValidPlacement(list, random, x, y, z, mode, type);
        } else if (clazz == RoomCrossing.class) {
            object = RoomCrossing.findValidPlacement(list, random, x, y, z, mode, type);
        } else if (clazz == Crossing.class) {
            object = Crossing.findValidPlacement(list, random, x, y, z, mode, type);
        } else if (clazz == Stairs.class) {
            object = Stairs.getStrongholdStairsComponent(list, random, x, y, z, mode, type);
        } else if (clazz == StairsStraight.class) {
            object = StairsStraight.findValidPlacement(list, random, x, y, z, mode, type);
        } else if (clazz == ChestCorridor.class) {
            object = ChestCorridor.findValidPlacement(list, random, x, y, z, mode, type);
        } else if (clazz == Prison.class) {
            object = Prison.findValidPlacement(list, random, x, y, z, mode, type);
        }
        return object;
    }

    private static Stronghold getNextComponent(Stairs2 stairs2, List list, Random random, int x, int y, int z, int mode, int type) {
        if (!StructureStrongholdPiecesCaveworld.canAddStructurePieces()) {
            return null;
        }
        if (strongholdComponentType != null) {
            Stronghold stronghold = StructureStrongholdPiecesCaveworld.getStrongholdComponentFromWeightedPiece(strongholdComponentType, list, random, x, y, z, mode, type);
            strongholdComponentType = null;
            if (stronghold != null) {
                return stronghold;
            }
        }
        block0: for (int i = 0; i < 5; ++i) {
            int weight = random.nextInt(totalWeight);
            for (PieceWeight pieceWeight : structurePieces) {
                if ((weight -= pieceWeight.pieceWeight) >= 0) continue;
                if (!pieceWeight.canSpawnMoreStructuresOfType(type) || pieceWeight == stairs2.strongholdPieceWeight) continue block0;
                Stronghold stronghold1 = StructureStrongholdPiecesCaveworld.getStrongholdComponentFromWeightedPiece(pieceWeight.pieceClass, list, random, x, y, z, mode, type);
                if (stronghold1 == null) continue;
                ++pieceWeight.instancesSpawned;
                stairs2.strongholdPieceWeight = pieceWeight;
                if (!pieceWeight.canSpawnMoreStructures()) {
                    structurePieces.remove(pieceWeight);
                }
                return stronghold1;
            }
        }
        StructureBoundingBox structureBoundingBox = Corridor.func_74992_a(list, random, x, y, z, mode);
        if (structureBoundingBox != null && structureBoundingBox.field_78895_b > 1) {
            return new Corridor(type, random, structureBoundingBox, mode);
        }
        return null;
    }

    private static StructureComponent getNextValidComponent(Stairs2 stairs2, List list, Random random, int x, int y, int z, int mode, int type) {
        if (type > 50) {
            return null;
        }
        if (Math.abs(x - stairs2.func_74874_b().field_78897_a) <= 112 && Math.abs(z - stairs2.func_74874_b().field_78896_c) <= 112) {
            Stronghold stronghold = StructureStrongholdPiecesCaveworld.getNextComponent(stairs2, list, random, x, y, z, mode, type + 1);
            if (stronghold != null) {
                list.add(stronghold);
                stairs2.field_75026_c.add(stronghold);
            }
            return stronghold;
        }
        return null;
    }

    static {
        strongholdStones = new Stones();
    }

    private static class PieceWeight {
        public final Class pieceClass;
        public final int pieceWeight;
        public final int instancesLimit;
        public int instancesSpawned;

        public PieceWeight(Class clazz, int weight, int limit) {
            this.pieceClass = clazz;
            this.pieceWeight = weight;
            this.instancesLimit = limit;
        }

        public boolean canSpawnMoreStructuresOfType(int type) {
            return this.instancesLimit == 0 || this.instancesSpawned < this.instancesLimit;
        }

        public boolean canSpawnMoreStructures() {
            return this.instancesLimit == 0 || this.instancesSpawned < this.instancesLimit;
        }
    }

    static final class SwitchDoor {
        static final int[] doorEnum = new int[StructureStrongholdPieces.Stronghold.Door.values().length];

        SwitchDoor() {
        }

        static {
            try {
                SwitchDoor.doorEnum[StructureStrongholdPieces.Stronghold.Door.OPENING.ordinal()] = 1;
            }
            catch (NoSuchFieldError ignored) {
                // empty catch block
            }
            try {
                SwitchDoor.doorEnum[StructureStrongholdPieces.Stronghold.Door.WOOD_DOOR.ordinal()] = 2;
            }
            catch (NoSuchFieldError ignored) {
                // empty catch block
            }
            try {
                SwitchDoor.doorEnum[StructureStrongholdPieces.Stronghold.Door.GRATES.ordinal()] = 3;
            }
            catch (NoSuchFieldError ignored) {
                // empty catch block
            }
            try {
                SwitchDoor.doorEnum[StructureStrongholdPieces.Stronghold.Door.IRON_DOOR.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
        }
    }

    public static class Corridor
    extends Stronghold {
        private int field_74993_a;

        public Corridor() {
        }

        public Corridor(int type, Random random, StructureBoundingBox structureBoundingBox, int mode) {
            super(type);
            this.field_74885_f = mode;
            this.field_74887_e = structureBoundingBox;
            this.field_74993_a = mode != 2 && mode != 0 ? structureBoundingBox.func_78883_b() : structureBoundingBox.func_78880_d();
        }

        @Override
        protected void func_143012_a(NBTTagCompound nbtTagCompound) {
            super.func_143012_a(nbtTagCompound);
            nbtTagCompound.func_74768_a("Steps", this.field_74993_a);
        }

        @Override
        protected void func_143011_b(NBTTagCompound nbtTagCompound) {
            super.func_143011_b(nbtTagCompound);
            this.field_74993_a = nbtTagCompound.func_74762_e("Steps");
        }

        public static StructureBoundingBox func_74992_a(List list, Random random, int x, int y, int z, int mode) {
            StructureBoundingBox structureBoundingBox = StructureBoundingBox.func_78889_a((int)x, (int)y, (int)z, (int)-1, (int)-1, (int)0, (int)5, (int)5, (int)4, (int)mode);
            StructureComponent structureComponent = StructureComponent.func_74883_a((List)list, (StructureBoundingBox)structureBoundingBox);
            if (structureComponent == null) {
                return null;
            }
            if (structureComponent.func_74874_b().field_78895_b == structureBoundingBox.field_78895_b) {
                for (int i = 3; i >= 1; --i) {
                    structureBoundingBox = StructureBoundingBox.func_78889_a((int)x, (int)y, (int)z, (int)-1, (int)-1, (int)0, (int)5, (int)5, (int)(i - 1), (int)mode);
                    if (structureComponent.func_74874_b().func_78884_a(structureBoundingBox)) continue;
                    return StructureBoundingBox.func_78889_a((int)x, (int)y, (int)z, (int)-1, (int)-1, (int)0, (int)5, (int)5, (int)i, (int)mode);
                }
            }
            return null;
        }

        public boolean func_74875_a(World world, Random random, StructureBoundingBox structureBoundingBox) {
            if (this.func_74860_a(world, structureBoundingBox)) {
                return false;
            }
            for (int i = 0; i < this.field_74993_a; ++i) {
                this.func_151550_a(world, Blocks.field_150417_aV, 0, 0, 0, i, structureBoundingBox);
                this.func_151550_a(world, Blocks.field_150417_aV, 0, 1, 0, i, structureBoundingBox);
                this.func_151550_a(world, Blocks.field_150417_aV, 0, 2, 0, i, structureBoundingBox);
                this.func_151550_a(world, Blocks.field_150417_aV, 0, 3, 0, i, structureBoundingBox);
                this.func_151550_a(world, Blocks.field_150417_aV, 0, 4, 0, i, structureBoundingBox);
                for (int j = 1; j <= 3; ++j) {
                    this.func_151550_a(world, Blocks.field_150417_aV, 0, 0, j, i, structureBoundingBox);
                    this.func_151550_a(world, Blocks.field_150350_a, 0, 1, j, i, structureBoundingBox);
                    this.func_151550_a(world, Blocks.field_150350_a, 0, 2, j, i, structureBoundingBox);
                    this.func_151550_a(world, Blocks.field_150350_a, 0, 3, j, i, structureBoundingBox);
                    this.func_151550_a(world, Blocks.field_150417_aV, 0, 4, j, i, structureBoundingBox);
                }
                this.func_151550_a(world, Blocks.field_150417_aV, 0, 0, 4, i, structureBoundingBox);
                this.func_151550_a(world, Blocks.field_150417_aV, 0, 1, 4, i, structureBoundingBox);
                this.func_151550_a(world, Blocks.field_150417_aV, 0, 2, 4, i, structureBoundingBox);
                this.func_151550_a(world, Blocks.field_150417_aV, 0, 3, 4, i, structureBoundingBox);
                this.func_151550_a(world, Blocks.field_150417_aV, 0, 4, 4, i, structureBoundingBox);
            }
            return true;
        }
    }

    public static class Crossing
    extends Stronghold {
        private boolean field_74996_b;
        private boolean field_74997_c;
        private boolean field_74995_d;
        private boolean field_74999_h;

        public Crossing() {
        }

        public Crossing(int type, Random random, StructureBoundingBox structureBoundingBox, int mode) {
            super(type);
            this.field_74885_f = mode;
            this.door = this.getRandomDoor(random);
            this.field_74887_e = structureBoundingBox;
            this.field_74996_b = random.nextBoolean();
            this.field_74997_c = random.nextBoolean();
            this.field_74995_d = random.nextBoolean();
            this.field_74999_h = random.nextInt(3) > 0;
        }

        @Override
        protected void func_143012_a(NBTTagCompound nbtTagCompound) {
            super.func_143012_a(nbtTagCompound);
            nbtTagCompound.func_74757_a("leftLow", this.field_74996_b);
            nbtTagCompound.func_74757_a("leftHigh", this.field_74997_c);
            nbtTagCompound.func_74757_a("rightLow", this.field_74995_d);
            nbtTagCompound.func_74757_a("rightHigh", this.field_74999_h);
        }

        @Override
        protected void func_143011_b(NBTTagCompound nbtTagCompound) {
            super.func_143011_b(nbtTagCompound);
            this.field_74996_b = nbtTagCompound.func_74767_n("leftLow");
            this.field_74997_c = nbtTagCompound.func_74767_n("leftHigh");
            this.field_74995_d = nbtTagCompound.func_74767_n("rightLow");
            this.field_74999_h = nbtTagCompound.func_74767_n("rightHigh");
        }

        public void func_74861_a(StructureComponent structureComponent, List list, Random random) {
            int var1 = 3;
            int var2 = 5;
            if (this.field_74885_f == 1 || this.field_74885_f == 2) {
                var1 = 8 - var1;
                var2 = 8 - var2;
            }
            this.getNextComponentNormal((Stairs2)structureComponent, list, random, 5, 1);
            if (this.field_74996_b) {
                this.getNextComponentX((Stairs2)structureComponent, list, random, var1, 1);
            }
            if (this.field_74997_c) {
                this.getNextComponentX((Stairs2)structureComponent, list, random, var2, 7);
            }
            if (this.field_74995_d) {
                this.getNextComponentZ((Stairs2)structureComponent, list, random, var1, 1);
            }
            if (this.field_74999_h) {
                this.getNextComponentZ((Stairs2)structureComponent, list, random, var2, 7);
            }
        }

        public static Crossing findValidPlacement(List list, Random random, int x, int y, int z, int mode, int type) {
            StructureBoundingBox structureboundingbox = StructureBoundingBox.func_78889_a((int)x, (int)y, (int)z, (int)-4, (int)-3, (int)0, (int)10, (int)9, (int)11, (int)mode);
            return Crossing.canStrongholdGoDeeper(structureboundingbox) && StructureComponent.func_74883_a((List)list, (StructureBoundingBox)structureboundingbox) == null ? new Crossing(type, random, structureboundingbox, mode) : null;
        }

        public boolean func_74875_a(World world, Random random, StructureBoundingBox structureBoundingBox) {
            if (this.func_74860_a(world, structureBoundingBox)) {
                return false;
            }
            this.func_74882_a(world, structureBoundingBox, 0, 0, 0, 9, 8, 10, true, random, strongholdStones);
            this.placeDoor(world, random, structureBoundingBox, this.door, 4, 3, 0);
            if (this.field_74996_b) {
                this.func_151549_a(world, structureBoundingBox, 0, 3, 1, 0, 5, 3, Blocks.field_150350_a, Blocks.field_150350_a, false);
            }
            if (this.field_74995_d) {
                this.func_151549_a(world, structureBoundingBox, 9, 3, 1, 9, 5, 3, Blocks.field_150350_a, Blocks.field_150350_a, false);
            }
            if (this.field_74997_c) {
                this.func_151549_a(world, structureBoundingBox, 0, 5, 7, 0, 7, 9, Blocks.field_150350_a, Blocks.field_150350_a, false);
            }
            if (this.field_74999_h) {
                this.func_151549_a(world, structureBoundingBox, 9, 5, 7, 9, 7, 9, Blocks.field_150350_a, Blocks.field_150350_a, false);
            }
            this.func_151549_a(world, structureBoundingBox, 5, 1, 10, 7, 3, 10, Blocks.field_150350_a, Blocks.field_150350_a, false);
            this.func_74882_a(world, structureBoundingBox, 1, 2, 1, 8, 2, 6, false, random, strongholdStones);
            this.func_74882_a(world, structureBoundingBox, 4, 1, 5, 4, 4, 9, false, random, strongholdStones);
            this.func_74882_a(world, structureBoundingBox, 8, 1, 5, 8, 4, 9, false, random, strongholdStones);
            this.func_74882_a(world, structureBoundingBox, 1, 4, 7, 3, 4, 9, false, random, strongholdStones);
            this.func_74882_a(world, structureBoundingBox, 1, 3, 5, 3, 3, 6, false, random, strongholdStones);
            this.func_151549_a(world, structureBoundingBox, 1, 3, 4, 3, 3, 4, (Block)Blocks.field_150333_U, (Block)Blocks.field_150333_U, false);
            this.func_151549_a(world, structureBoundingBox, 1, 4, 6, 3, 4, 6, (Block)Blocks.field_150333_U, (Block)Blocks.field_150333_U, false);
            this.func_74882_a(world, structureBoundingBox, 5, 1, 7, 7, 1, 8, false, random, strongholdStones);
            this.func_151549_a(world, structureBoundingBox, 5, 1, 9, 7, 1, 9, (Block)Blocks.field_150333_U, (Block)Blocks.field_150333_U, false);
            this.func_151549_a(world, structureBoundingBox, 5, 2, 7, 7, 2, 7, (Block)Blocks.field_150333_U, (Block)Blocks.field_150333_U, false);
            this.func_151549_a(world, structureBoundingBox, 4, 5, 7, 4, 5, 9, (Block)Blocks.field_150333_U, (Block)Blocks.field_150333_U, false);
            this.func_151549_a(world, structureBoundingBox, 8, 5, 7, 8, 5, 9, (Block)Blocks.field_150333_U, (Block)Blocks.field_150333_U, false);
            this.func_151549_a(world, structureBoundingBox, 5, 5, 7, 7, 5, 9, (Block)Blocks.field_150334_T, (Block)Blocks.field_150334_T, false);
            this.func_151550_a(world, Blocks.field_150478_aa, 0, 6, 5, 6, structureBoundingBox);
            return true;
        }
    }

    public static abstract class Stronghold
    extends StructureComponent {
        protected StructureStrongholdPieces.Stronghold.Door door = StructureStrongholdPieces.Stronghold.Door.OPENING;

        public Stronghold() {
        }

        protected Stronghold(int type) {
            super(type);
        }

        protected void func_143012_a(NBTTagCompound nbtTagCompound) {
            nbtTagCompound.func_74778_a("EntryDoor", this.door.name());
        }

        protected void func_143011_b(NBTTagCompound nbtTagCompound) {
            this.door = StructureStrongholdPieces.Stronghold.Door.valueOf((String)nbtTagCompound.func_74779_i("EntryDoor"));
        }

        protected void placeDoor(World world, Random random, StructureBoundingBox structureBoundingBox, StructureStrongholdPieces.Stronghold.Door enumDoor, int x, int y, int z) {
            switch (SwitchDoor.doorEnum[enumDoor.ordinal()]) {
                default: {
                    this.func_151549_a(world, structureBoundingBox, x, y, z, x + 3 - 1, y + 3 - 1, z, Blocks.field_150350_a, Blocks.field_150350_a, false);
                    break;
                }
                case 2: {
                    this.func_151550_a(world, Blocks.field_150417_aV, 0, x, y, z, structureBoundingBox);
                    this.func_151550_a(world, Blocks.field_150417_aV, 0, x, y + 1, z, structureBoundingBox);
                    this.func_151550_a(world, Blocks.field_150417_aV, 0, x, y + 2, z, structureBoundingBox);
                    this.func_151550_a(world, Blocks.field_150417_aV, 0, x + 1, y + 2, z, structureBoundingBox);
                    this.func_151550_a(world, Blocks.field_150417_aV, 0, x + 2, y + 2, z, structureBoundingBox);
                    this.func_151550_a(world, Blocks.field_150417_aV, 0, x + 2, y + 1, z, structureBoundingBox);
                    this.func_151550_a(world, Blocks.field_150417_aV, 0, x + 2, y, z, structureBoundingBox);
                    this.func_151550_a(world, Blocks.field_150466_ao, 0, x + 1, y, z, structureBoundingBox);
                    this.func_151550_a(world, Blocks.field_150466_ao, 8, x + 1, y + 1, z, structureBoundingBox);
                    break;
                }
                case 3: {
                    this.func_151550_a(world, Blocks.field_150350_a, 0, x + 1, y, z, structureBoundingBox);
                    this.func_151550_a(world, Blocks.field_150350_a, 0, x + 1, y + 1, z, structureBoundingBox);
                    this.func_151550_a(world, Blocks.field_150411_aY, 0, x, y, z, structureBoundingBox);
                    this.func_151550_a(world, Blocks.field_150411_aY, 0, x, y + 1, z, structureBoundingBox);
                    this.func_151550_a(world, Blocks.field_150411_aY, 0, x, y + 2, z, structureBoundingBox);
                    this.func_151550_a(world, Blocks.field_150411_aY, 0, x + 1, y + 2, z, structureBoundingBox);
                    this.func_151550_a(world, Blocks.field_150411_aY, 0, x + 2, y + 2, z, structureBoundingBox);
                    this.func_151550_a(world, Blocks.field_150411_aY, 0, x + 2, y + 1, z, structureBoundingBox);
                    this.func_151550_a(world, Blocks.field_150411_aY, 0, x + 2, y, z, structureBoundingBox);
                    break;
                }
                case 4: {
                    this.func_151550_a(world, Blocks.field_150417_aV, 0, x, y, z, structureBoundingBox);
                    this.func_151550_a(world, Blocks.field_150417_aV, 0, x, y + 1, z, structureBoundingBox);
                    this.func_151550_a(world, Blocks.field_150417_aV, 0, x, y + 2, z, structureBoundingBox);
                    this.func_151550_a(world, Blocks.field_150417_aV, 0, x + 1, y + 2, z, structureBoundingBox);
                    this.func_151550_a(world, Blocks.field_150417_aV, 0, x + 2, y + 2, z, structureBoundingBox);
                    this.func_151550_a(world, Blocks.field_150417_aV, 0, x + 2, y + 1, z, structureBoundingBox);
                    this.func_151550_a(world, Blocks.field_150417_aV, 0, x + 2, y, z, structureBoundingBox);
                    this.func_151550_a(world, Blocks.field_150454_av, 0, x + 1, y, z, structureBoundingBox);
                    this.func_151550_a(world, Blocks.field_150454_av, 8, x + 1, y + 1, z, structureBoundingBox);
                    this.func_151550_a(world, Blocks.field_150430_aB, this.func_151555_a(Blocks.field_150430_aB, 4), x + 2, y + 1, z + 1, structureBoundingBox);
                    this.func_151550_a(world, Blocks.field_150430_aB, this.func_151555_a(Blocks.field_150430_aB, 3), x + 2, y + 1, z - 1, structureBoundingBox);
                }
            }
        }

        protected StructureStrongholdPieces.Stronghold.Door getRandomDoor(Random random) {
            int i = random.nextInt(5);
            switch (i) {
                default: {
                    return StructureStrongholdPieces.Stronghold.Door.OPENING;
                }
                case 2: {
                    return StructureStrongholdPieces.Stronghold.Door.WOOD_DOOR;
                }
                case 3: {
                    return StructureStrongholdPieces.Stronghold.Door.GRATES;
                }
                case 4: 
            }
            return StructureStrongholdPieces.Stronghold.Door.IRON_DOOR;
        }

        protected StructureComponent getNextComponentNormal(Stairs2 stairs2, List list, Random random, int par4, int par5) {
            switch (this.field_74885_f) {
                case 0: {
                    return StructureStrongholdPiecesCaveworld.getNextValidComponent(stairs2, list, random, this.field_74887_e.field_78897_a + par4, this.field_74887_e.field_78895_b + par5, this.field_74887_e.field_78892_f + 1, this.field_74885_f, this.func_74877_c());
                }
                case 1: {
                    return StructureStrongholdPiecesCaveworld.getNextValidComponent(stairs2, list, random, this.field_74887_e.field_78897_a - 1, this.field_74887_e.field_78895_b + par5, this.field_74887_e.field_78896_c + par4, this.field_74885_f, this.func_74877_c());
                }
                case 2: {
                    return StructureStrongholdPiecesCaveworld.getNextValidComponent(stairs2, list, random, this.field_74887_e.field_78897_a + par4, this.field_74887_e.field_78895_b + par5, this.field_74887_e.field_78896_c - 1, this.field_74885_f, this.func_74877_c());
                }
                case 3: {
                    return StructureStrongholdPiecesCaveworld.getNextValidComponent(stairs2, list, random, this.field_74887_e.field_78893_d + 1, this.field_74887_e.field_78895_b + par5, this.field_74887_e.field_78896_c + par4, this.field_74885_f, this.func_74877_c());
                }
            }
            return null;
        }

        protected StructureComponent getNextComponentX(Stairs2 stairs2, List list, Random random, int par4, int par5) {
            switch (this.field_74885_f) {
                case 0: {
                    return StructureStrongholdPiecesCaveworld.getNextValidComponent(stairs2, list, random, this.field_74887_e.field_78897_a - 1, this.field_74887_e.field_78895_b + par4, this.field_74887_e.field_78896_c + par5, 1, this.func_74877_c());
                }
                case 1: {
                    return StructureStrongholdPiecesCaveworld.getNextValidComponent(stairs2, list, random, this.field_74887_e.field_78897_a + par5, this.field_74887_e.field_78895_b + par4, this.field_74887_e.field_78896_c - 1, 2, this.func_74877_c());
                }
                case 2: {
                    return StructureStrongholdPiecesCaveworld.getNextValidComponent(stairs2, list, random, this.field_74887_e.field_78897_a - 1, this.field_74887_e.field_78895_b + par4, this.field_74887_e.field_78896_c + par5, 1, this.func_74877_c());
                }
                case 3: {
                    return StructureStrongholdPiecesCaveworld.getNextValidComponent(stairs2, list, random, this.field_74887_e.field_78897_a + par5, this.field_74887_e.field_78895_b + par4, this.field_74887_e.field_78896_c - 1, 2, this.func_74877_c());
                }
            }
            return null;
        }

        protected StructureComponent getNextComponentZ(Stairs2 stairs2, List list, Random random, int par4, int par5) {
            switch (this.field_74885_f) {
                case 0: {
                    return StructureStrongholdPiecesCaveworld.getNextValidComponent(stairs2, list, random, this.field_74887_e.field_78893_d + 1, this.field_74887_e.field_78895_b + par4, this.field_74887_e.field_78896_c + par5, 3, this.func_74877_c());
                }
                case 1: {
                    return StructureStrongholdPiecesCaveworld.getNextValidComponent(stairs2, list, random, this.field_74887_e.field_78897_a + par5, this.field_74887_e.field_78895_b + par4, this.field_74887_e.field_78892_f + 1, 0, this.func_74877_c());
                }
                case 2: {
                    return StructureStrongholdPiecesCaveworld.getNextValidComponent(stairs2, list, random, this.field_74887_e.field_78893_d + 1, this.field_74887_e.field_78895_b + par4, this.field_74887_e.field_78896_c + par5, 3, this.func_74877_c());
                }
                case 3: {
                    return StructureStrongholdPiecesCaveworld.getNextValidComponent(stairs2, list, random, this.field_74887_e.field_78897_a + par5, this.field_74887_e.field_78895_b + par4, this.field_74887_e.field_78892_f + 1, 0, this.func_74877_c());
                }
            }
            return null;
        }

        protected static boolean canStrongholdGoDeeper(StructureBoundingBox structureBoundingBox) {
            return structureBoundingBox != null && structureBoundingBox.field_78895_b > 10;
        }
    }

    private static class Stones
    extends StructureComponent.BlockSelector {
        private Stones() {
        }

        public void func_75062_a(Random random, int x, int y, int z, boolean flag) {
            if (flag) {
                this.field_151562_a = Blocks.field_150417_aV;
                float var1 = random.nextFloat();
                if (var1 < 0.2f) {
                    this.field_75065_b = 2;
                } else if (var1 < 0.5f) {
                    this.field_75065_b = 1;
                } else if (var1 < 0.55f) {
                    this.field_151562_a = Blocks.field_150418_aU;
                    this.field_75065_b = 2;
                } else {
                    this.field_75065_b = 0;
                }
            } else {
                this.field_151562_a = Blocks.field_150350_a;
                this.field_75065_b = 0;
            }
        }
    }

    public static class RightTurn
    extends LeftTurn {
        @Override
        public void func_74861_a(StructureComponent structureComponent, List list, Random random) {
            if (this.field_74885_f != 2 && this.field_74885_f != 3) {
                this.getNextComponentX((Stairs2)structureComponent, list, random, 1, 1);
            } else {
                this.getNextComponentZ((Stairs2)structureComponent, list, random, 1, 1);
            }
        }

        @Override
        public boolean func_74875_a(World world, Random random, StructureBoundingBox structureBoundingBox) {
            if (this.func_74860_a(world, structureBoundingBox)) {
                return false;
            }
            this.func_74882_a(world, structureBoundingBox, 0, 0, 0, 4, 4, 4, true, random, strongholdStones);
            this.placeDoor(world, random, structureBoundingBox, this.door, 1, 1, 0);
            if (this.field_74885_f != 2 && this.field_74885_f != 3) {
                this.func_151549_a(world, structureBoundingBox, 0, 1, 1, 0, 3, 3, Blocks.field_150350_a, Blocks.field_150350_a, false);
            } else {
                this.func_151549_a(world, structureBoundingBox, 4, 1, 1, 4, 3, 3, Blocks.field_150350_a, Blocks.field_150350_a, false);
            }
            return true;
        }
    }

    public static class LeftTurn
    extends Stronghold {
        public LeftTurn() {
        }

        public LeftTurn(int type, Random random, StructureBoundingBox structureBoundingBox, int mode) {
            super(type);
            this.field_74885_f = mode;
            this.door = this.getRandomDoor(random);
            this.field_74887_e = structureBoundingBox;
        }

        public void func_74861_a(StructureComponent structureComponent, List list, Random random) {
            if (this.field_74885_f != 2 && this.field_74885_f != 3) {
                this.getNextComponentZ((Stairs2)structureComponent, list, random, 1, 1);
            } else {
                this.getNextComponentX((Stairs2)structureComponent, list, random, 1, 1);
            }
        }

        public static LeftTurn findValidPlacement(List par0List, Random par1Random, int par2, int par3, int par4, int par5, int par6) {
            StructureBoundingBox structureboundingbox = StructureBoundingBox.func_78889_a((int)par2, (int)par3, (int)par4, (int)-1, (int)-1, (int)0, (int)5, (int)5, (int)5, (int)par5);
            return LeftTurn.canStrongholdGoDeeper(structureboundingbox) && StructureComponent.func_74883_a((List)par0List, (StructureBoundingBox)structureboundingbox) == null ? new LeftTurn(par6, par1Random, structureboundingbox, par5) : null;
        }

        public boolean func_74875_a(World world, Random random, StructureBoundingBox structureBoundingBox) {
            if (this.func_74860_a(world, structureBoundingBox)) {
                return false;
            }
            this.func_74882_a(world, structureBoundingBox, 0, 0, 0, 4, 4, 4, true, random, strongholdStones);
            this.placeDoor(world, random, structureBoundingBox, this.door, 1, 1, 0);
            if (this.field_74885_f != 2 && this.field_74885_f != 3) {
                this.func_151549_a(world, structureBoundingBox, 4, 1, 1, 4, 3, 3, Blocks.field_150350_a, Blocks.field_150350_a, false);
            } else {
                this.func_151549_a(world, structureBoundingBox, 0, 1, 1, 0, 3, 3, Blocks.field_150350_a, Blocks.field_150350_a, false);
            }
            return true;
        }
    }

    public static class Prison
    extends Stronghold {
        public Prison() {
        }

        public Prison(int type, Random random, StructureBoundingBox structureBoundingBox, int mode) {
            super(type);
            this.field_74885_f = mode;
            this.door = this.getRandomDoor(random);
            this.field_74887_e = structureBoundingBox;
        }

        public void func_74861_a(StructureComponent structureComponent, List list, Random random) {
            this.getNextComponentNormal((Stairs2)structureComponent, list, random, 1, 1);
        }

        public static Prison findValidPlacement(List list, Random random, int x, int y, int z, int mode, int type) {
            StructureBoundingBox structureboundingbox = StructureBoundingBox.func_78889_a((int)x, (int)y, (int)z, (int)-1, (int)-1, (int)0, (int)9, (int)5, (int)11, (int)mode);
            return Prison.canStrongholdGoDeeper(structureboundingbox) && StructureComponent.func_74883_a((List)list, (StructureBoundingBox)structureboundingbox) == null ? new Prison(type, random, structureboundingbox, mode) : null;
        }

        public boolean func_74875_a(World world, Random random, StructureBoundingBox structureBoundingBox) {
            if (this.func_74860_a(world, structureBoundingBox)) {
                return false;
            }
            this.func_74882_a(world, structureBoundingBox, 0, 0, 0, 8, 4, 10, true, random, strongholdStones);
            this.placeDoor(world, random, structureBoundingBox, this.door, 1, 1, 0);
            this.func_151549_a(world, structureBoundingBox, 1, 1, 10, 3, 3, 10, Blocks.field_150350_a, Blocks.field_150350_a, false);
            this.func_74882_a(world, structureBoundingBox, 4, 1, 1, 4, 3, 1, false, random, strongholdStones);
            this.func_74882_a(world, structureBoundingBox, 4, 1, 3, 4, 3, 3, false, random, strongholdStones);
            this.func_74882_a(world, structureBoundingBox, 4, 1, 7, 4, 3, 7, false, random, strongholdStones);
            this.func_74882_a(world, structureBoundingBox, 4, 1, 9, 4, 3, 9, false, random, strongholdStones);
            this.func_151549_a(world, structureBoundingBox, 4, 1, 4, 4, 3, 6, Blocks.field_150411_aY, Blocks.field_150411_aY, false);
            this.func_151549_a(world, structureBoundingBox, 5, 1, 5, 7, 3, 5, Blocks.field_150411_aY, Blocks.field_150411_aY, false);
            this.func_151550_a(world, Blocks.field_150411_aY, 0, 4, 3, 2, structureBoundingBox);
            this.func_151550_a(world, Blocks.field_150411_aY, 0, 4, 3, 8, structureBoundingBox);
            this.func_151550_a(world, Blocks.field_150454_av, this.func_151555_a(Blocks.field_150454_av, 3), 4, 1, 2, structureBoundingBox);
            this.func_151550_a(world, Blocks.field_150454_av, this.func_151555_a(Blocks.field_150454_av, 3) + 8, 4, 2, 2, structureBoundingBox);
            this.func_151550_a(world, Blocks.field_150454_av, this.func_151555_a(Blocks.field_150454_av, 3), 4, 1, 8, structureBoundingBox);
            this.func_151550_a(world, Blocks.field_150454_av, this.func_151555_a(Blocks.field_150454_av, 3) + 8, 4, 2, 8, structureBoundingBox);
            return true;
        }
    }

    public static class Stairs2
    extends Stairs {
        public PieceWeight strongholdPieceWeight;
        public PortalRoom strongholdPortalRoom;
        public List field_75026_c = Lists.newArrayList();

        public Stairs2() {
        }

        public Stairs2(int type, Random random, int par3, int par4) {
            super(0, random, par3, par4);
        }

        public ChunkPosition func_151553_a() {
            return this.strongholdPortalRoom != null ? this.strongholdPortalRoom.func_151553_a() : super.func_151553_a();
        }
    }

    public static class StairsStraight
    extends Stronghold {
        public StairsStraight() {
        }

        public StairsStraight(int type, Random random, StructureBoundingBox structureBoundingBox, int mode) {
            super(type);
            this.field_74885_f = mode;
            this.door = this.getRandomDoor(random);
            this.field_74887_e = structureBoundingBox;
        }

        public void func_74861_a(StructureComponent structureComponent, List list, Random random) {
            this.getNextComponentNormal((Stairs2)structureComponent, list, random, 1, 1);
        }

        public static StairsStraight findValidPlacement(List list, Random random, int x, int y, int z, int mode, int type) {
            StructureBoundingBox structureboundingbox = StructureBoundingBox.func_78889_a((int)x, (int)y, (int)z, (int)-1, (int)-7, (int)0, (int)5, (int)11, (int)8, (int)mode);
            return StairsStraight.canStrongholdGoDeeper(structureboundingbox) && StructureComponent.func_74883_a((List)list, (StructureBoundingBox)structureboundingbox) == null ? new StairsStraight(type, random, structureboundingbox, mode) : null;
        }

        public boolean func_74875_a(World world, Random random, StructureBoundingBox structureBoundingBox) {
            if (this.func_74860_a(world, structureBoundingBox)) {
                return false;
            }
            this.func_74882_a(world, structureBoundingBox, 0, 0, 0, 4, 10, 7, true, random, strongholdStones);
            this.placeDoor(world, random, structureBoundingBox, this.door, 1, 7, 0);
            this.placeDoor(world, random, structureBoundingBox, StructureStrongholdPieces.Stronghold.Door.OPENING, 1, 1, 7);
            int i = this.func_151555_a(Blocks.field_150446_ar, 2);
            for (int j = 0; j < 6; ++j) {
                this.func_151550_a(world, Blocks.field_150446_ar, i, 1, 6 - j, 1 + j, structureBoundingBox);
                this.func_151550_a(world, Blocks.field_150446_ar, i, 2, 6 - j, 1 + j, structureBoundingBox);
                this.func_151550_a(world, Blocks.field_150446_ar, i, 3, 6 - j, 1 + j, structureBoundingBox);
                if (j >= 5) continue;
                this.func_151550_a(world, Blocks.field_150417_aV, 0, 1, 5 - j, 1 + j, structureBoundingBox);
                this.func_151550_a(world, Blocks.field_150417_aV, 0, 2, 5 - j, 1 + j, structureBoundingBox);
                this.func_151550_a(world, Blocks.field_150417_aV, 0, 3, 5 - j, 1 + j, structureBoundingBox);
            }
            return true;
        }
    }

    public static class RoomCrossing
    extends Stronghold {
        protected int roomType;

        public RoomCrossing() {
        }

        public RoomCrossing(int type, Random random, StructureBoundingBox structureBoundingBox, int mode) {
            super(type);
            this.field_74885_f = mode;
            this.door = this.getRandomDoor(random);
            this.field_74887_e = structureBoundingBox;
            this.roomType = random.nextInt(5);
        }

        @Override
        protected void func_143012_a(NBTTagCompound nbtTagCompound) {
            super.func_143012_a(nbtTagCompound);
            nbtTagCompound.func_74768_a("Type", this.roomType);
        }

        @Override
        protected void func_143011_b(NBTTagCompound nbtTagCompound) {
            super.func_143011_b(nbtTagCompound);
            this.roomType = nbtTagCompound.func_74762_e("Type");
        }

        public void func_74861_a(StructureComponent structureComponent, List list, Random random) {
            this.getNextComponentNormal((Stairs2)structureComponent, list, random, 4, 1);
            this.getNextComponentX((Stairs2)structureComponent, list, random, 1, 4);
            this.getNextComponentZ((Stairs2)structureComponent, list, random, 1, 4);
        }

        public static RoomCrossing findValidPlacement(List list, Random random, int x, int y, int z, int mode, int type) {
            StructureBoundingBox structureboundingbox = StructureBoundingBox.func_78889_a((int)x, (int)y, (int)z, (int)-4, (int)-1, (int)0, (int)11, (int)7, (int)11, (int)mode);
            return RoomCrossing.canStrongholdGoDeeper(structureboundingbox) && StructureComponent.func_74883_a((List)list, (StructureBoundingBox)structureboundingbox) == null ? new RoomCrossing(type, random, structureboundingbox, mode) : null;
        }

        public boolean func_74875_a(World world, Random random, StructureBoundingBox structureBoundingBox) {
            if (this.func_74860_a(world, structureBoundingBox)) {
                return false;
            }
            this.func_74882_a(world, structureBoundingBox, 0, 0, 0, 10, 6, 10, true, random, strongholdStones);
            this.placeDoor(world, random, structureBoundingBox, this.door, 4, 1, 0);
            this.func_151549_a(world, structureBoundingBox, 4, 1, 10, 6, 3, 10, Blocks.field_150350_a, Blocks.field_150350_a, false);
            this.func_151549_a(world, structureBoundingBox, 0, 1, 4, 0, 3, 6, Blocks.field_150350_a, Blocks.field_150350_a, false);
            this.func_151549_a(world, structureBoundingBox, 10, 1, 4, 10, 3, 6, Blocks.field_150350_a, Blocks.field_150350_a, false);
            switch (this.roomType) {
                case 0: {
                    this.func_151550_a(world, Blocks.field_150417_aV, 0, 5, 1, 5, structureBoundingBox);
                    this.func_151550_a(world, Blocks.field_150417_aV, 0, 5, 2, 5, structureBoundingBox);
                    this.func_151550_a(world, Blocks.field_150417_aV, 0, 5, 3, 5, structureBoundingBox);
                    this.func_151550_a(world, Blocks.field_150478_aa, 0, 4, 3, 5, structureBoundingBox);
                    this.func_151550_a(world, Blocks.field_150478_aa, 0, 6, 3, 5, structureBoundingBox);
                    this.func_151550_a(world, Blocks.field_150478_aa, 0, 5, 3, 4, structureBoundingBox);
                    this.func_151550_a(world, Blocks.field_150478_aa, 0, 5, 3, 6, structureBoundingBox);
                    this.func_151550_a(world, (Block)Blocks.field_150333_U, 0, 4, 1, 4, structureBoundingBox);
                    this.func_151550_a(world, (Block)Blocks.field_150333_U, 0, 4, 1, 5, structureBoundingBox);
                    this.func_151550_a(world, (Block)Blocks.field_150333_U, 0, 4, 1, 6, structureBoundingBox);
                    this.func_151550_a(world, (Block)Blocks.field_150333_U, 0, 6, 1, 4, structureBoundingBox);
                    this.func_151550_a(world, (Block)Blocks.field_150333_U, 0, 6, 1, 5, structureBoundingBox);
                    this.func_151550_a(world, (Block)Blocks.field_150333_U, 0, 6, 1, 6, structureBoundingBox);
                    this.func_151550_a(world, (Block)Blocks.field_150333_U, 0, 5, 1, 4, structureBoundingBox);
                    this.func_151550_a(world, (Block)Blocks.field_150333_U, 0, 5, 1, 6, structureBoundingBox);
                    break;
                }
                case 1: {
                    for (int i = 0; i < 5; ++i) {
                        this.func_151550_a(world, Blocks.field_150417_aV, 0, 3, 1, 3 + i, structureBoundingBox);
                        this.func_151550_a(world, Blocks.field_150417_aV, 0, 7, 1, 3 + i, structureBoundingBox);
                        this.func_151550_a(world, Blocks.field_150417_aV, 0, 3 + i, 1, 3, structureBoundingBox);
                        this.func_151550_a(world, Blocks.field_150417_aV, 0, 3 + i, 1, 7, structureBoundingBox);
                    }
                    this.func_151550_a(world, Blocks.field_150417_aV, 0, 5, 1, 5, structureBoundingBox);
                    this.func_151550_a(world, Blocks.field_150417_aV, 0, 5, 2, 5, structureBoundingBox);
                    this.func_151550_a(world, Blocks.field_150417_aV, 0, 5, 3, 5, structureBoundingBox);
                    this.func_151550_a(world, (Block)Blocks.field_150358_i, 0, 5, 4, 5, structureBoundingBox);
                    break;
                }
                case 2: {
                    int i;
                    for (i = 1; i <= 9; ++i) {
                        this.func_151550_a(world, Blocks.field_150347_e, 0, 1, 3, i, structureBoundingBox);
                        this.func_151550_a(world, Blocks.field_150347_e, 0, 9, 3, i, structureBoundingBox);
                    }
                    for (i = 1; i <= 9; ++i) {
                        this.func_151550_a(world, Blocks.field_150347_e, 0, i, 3, 1, structureBoundingBox);
                        this.func_151550_a(world, Blocks.field_150347_e, 0, i, 3, 9, structureBoundingBox);
                    }
                    this.func_151550_a(world, Blocks.field_150347_e, 0, 5, 1, 4, structureBoundingBox);
                    this.func_151550_a(world, Blocks.field_150347_e, 0, 5, 1, 6, structureBoundingBox);
                    this.func_151550_a(world, Blocks.field_150347_e, 0, 5, 3, 4, structureBoundingBox);
                    this.func_151550_a(world, Blocks.field_150347_e, 0, 5, 3, 6, structureBoundingBox);
                    this.func_151550_a(world, Blocks.field_150347_e, 0, 4, 1, 5, structureBoundingBox);
                    this.func_151550_a(world, Blocks.field_150347_e, 0, 6, 1, 5, structureBoundingBox);
                    this.func_151550_a(world, Blocks.field_150347_e, 0, 4, 3, 5, structureBoundingBox);
                    this.func_151550_a(world, Blocks.field_150347_e, 0, 6, 3, 5, structureBoundingBox);
                    for (i = 1; i <= 3; ++i) {
                        this.func_151550_a(world, Blocks.field_150347_e, 0, 4, i, 4, structureBoundingBox);
                        this.func_151550_a(world, Blocks.field_150347_e, 0, 6, i, 4, structureBoundingBox);
                        this.func_151550_a(world, Blocks.field_150347_e, 0, 4, i, 6, structureBoundingBox);
                        this.func_151550_a(world, Blocks.field_150347_e, 0, 6, i, 6, structureBoundingBox);
                    }
                    this.func_151550_a(world, Blocks.field_150478_aa, 0, 5, 3, 5, structureBoundingBox);
                    for (i = 2; i <= 8; ++i) {
                        this.func_151550_a(world, Blocks.field_150344_f, 0, 2, 3, i, structureBoundingBox);
                        this.func_151550_a(world, Blocks.field_150344_f, 0, 3, 3, i, structureBoundingBox);
                        if (i <= 3 || i >= 7) {
                            this.func_151550_a(world, Blocks.field_150344_f, 0, 4, 3, i, structureBoundingBox);
                            this.func_151550_a(world, Blocks.field_150344_f, 0, 5, 3, i, structureBoundingBox);
                            this.func_151550_a(world, Blocks.field_150344_f, 0, 6, 3, i, structureBoundingBox);
                        }
                        this.func_151550_a(world, Blocks.field_150344_f, 0, 7, 3, i, structureBoundingBox);
                        this.func_151550_a(world, Blocks.field_150344_f, 0, 8, 3, i, structureBoundingBox);
                    }
                    this.func_151550_a(world, Blocks.field_150468_ap, this.func_151555_a(Blocks.field_150468_ap, 4), 9, 1, 3, structureBoundingBox);
                    this.func_151550_a(world, Blocks.field_150468_ap, this.func_151555_a(Blocks.field_150468_ap, 4), 9, 2, 3, structureBoundingBox);
                    this.func_151550_a(world, Blocks.field_150468_ap, this.func_151555_a(Blocks.field_150468_ap, 4), 9, 3, 3, structureBoundingBox);
                    this.func_74879_a(world, structureBoundingBox, random, 3, 4, 8, ChestGenHooks.getItems((String)"strongholdCrossing", (Random)random), ChestGenHooks.getCount((String)"strongholdCrossing", (Random)random));
                }
            }
            return true;
        }
    }

    public static class ChestCorridor
    extends Stronghold {
        private boolean hasMadeChest;

        public ChestCorridor() {
        }

        public ChestCorridor(int type, Random random, StructureBoundingBox structureBoundingBox, int mode) {
            super(type);
            this.field_74885_f = mode;
            this.door = this.getRandomDoor(random);
            this.field_74887_e = structureBoundingBox;
        }

        @Override
        protected void func_143012_a(NBTTagCompound nbtTagCompound) {
            super.func_143012_a(nbtTagCompound);
            nbtTagCompound.func_74757_a("Chest", this.hasMadeChest);
        }

        @Override
        protected void func_143011_b(NBTTagCompound nbtTagCompound) {
            super.func_143011_b(nbtTagCompound);
            this.hasMadeChest = nbtTagCompound.func_74767_n("Chest");
        }

        public void func_74861_a(StructureComponent structureComponent, List list, Random random) {
            this.getNextComponentNormal((Stairs2)structureComponent, list, random, 1, 1);
        }

        public static ChestCorridor findValidPlacement(List list, Random random, int x, int y, int z, int mode, int type) {
            StructureBoundingBox structureboundingbox = StructureBoundingBox.func_78889_a((int)x, (int)y, (int)z, (int)-1, (int)-1, (int)0, (int)5, (int)5, (int)7, (int)mode);
            return ChestCorridor.canStrongholdGoDeeper(structureboundingbox) && StructureComponent.func_74883_a((List)list, (StructureBoundingBox)structureboundingbox) == null ? new ChestCorridor(type, random, structureboundingbox, mode) : null;
        }

        public boolean func_74875_a(World world, Random random, StructureBoundingBox structureBoundingBox) {
            int i;
            if (this.func_74860_a(world, structureBoundingBox)) {
                return false;
            }
            this.func_74882_a(world, structureBoundingBox, 0, 0, 0, 4, 4, 6, true, random, strongholdStones);
            this.placeDoor(world, random, structureBoundingBox, this.door, 1, 1, 0);
            this.placeDoor(world, random, structureBoundingBox, StructureStrongholdPieces.Stronghold.Door.OPENING, 1, 1, 6);
            this.func_151549_a(world, structureBoundingBox, 3, 1, 2, 3, 1, 4, Blocks.field_150417_aV, Blocks.field_150417_aV, false);
            this.func_151550_a(world, (Block)Blocks.field_150333_U, 5, 3, 1, 1, structureBoundingBox);
            this.func_151550_a(world, (Block)Blocks.field_150333_U, 5, 3, 1, 5, structureBoundingBox);
            this.func_151550_a(world, (Block)Blocks.field_150333_U, 5, 3, 2, 2, structureBoundingBox);
            this.func_151550_a(world, (Block)Blocks.field_150333_U, 5, 3, 2, 4, structureBoundingBox);
            for (i = 2; i <= 4; ++i) {
                this.func_151550_a(world, (Block)Blocks.field_150333_U, 5, 2, 1, i, structureBoundingBox);
            }
            if (!this.hasMadeChest) {
                int z;
                i = this.func_74862_a(2);
                int x = this.func_74865_a(3, 3);
                if (structureBoundingBox.func_78890_b(x, i, z = this.func_74873_b(3, 3))) {
                    this.hasMadeChest = true;
                    this.func_74879_a(world, structureBoundingBox, random, 3, 2, 3, ChestGenHooks.getItems((String)"strongholdCorridor", (Random)random), ChestGenHooks.getCount((String)"strongholdCorridor", (Random)random));
                }
            }
            return true;
        }
    }

    public static class PortalRoom
    extends Stronghold {
        private boolean hasSpawner;

        public PortalRoom() {
        }

        public PortalRoom(int type, Random random, StructureBoundingBox structureBoundingBox, int mode) {
            super(type);
            this.field_74885_f = mode;
            this.field_74887_e = structureBoundingBox;
        }

        @Override
        protected void func_143012_a(NBTTagCompound nbtTagCompound) {
            super.func_143012_a(nbtTagCompound);
            nbtTagCompound.func_74757_a("Mob", this.hasSpawner);
        }

        @Override
        protected void func_143011_b(NBTTagCompound nbtTagCompound) {
            super.func_143011_b(nbtTagCompound);
            this.hasSpawner = nbtTagCompound.func_74767_n("Mob");
        }

        public void func_74861_a(StructureComponent structureComponent, List list, Random random) {
            if (structureComponent != null) {
                ((Stairs2)structureComponent).strongholdPortalRoom = this;
            }
        }

        public static PortalRoom findValidPlacement(List list, Random random, int x, int y, int z, int mode, int type) {
            StructureBoundingBox structureBoundingBox = StructureBoundingBox.func_78889_a((int)x, (int)y, (int)z, (int)-4, (int)-1, (int)0, (int)11, (int)8, (int)16, (int)mode);
            return PortalRoom.canStrongholdGoDeeper(structureBoundingBox) && StructureComponent.func_74883_a((List)list, (StructureBoundingBox)structureBoundingBox) == null ? new PortalRoom(type, random, structureBoundingBox, mode) : null;
        }

        public boolean func_74875_a(World world, Random random, StructureBoundingBox structureBoundingBox) {
            int i;
            this.func_74882_a(world, structureBoundingBox, 0, 0, 0, 10, 7, 15, false, random, strongholdStones);
            this.placeDoor(world, random, structureBoundingBox, StructureStrongholdPieces.Stronghold.Door.GRATES, 4, 1, 0);
            this.func_74882_a(world, structureBoundingBox, 1, 6, 1, 1, 6, 14, false, random, strongholdStones);
            this.func_74882_a(world, structureBoundingBox, 9, 6, 1, 9, 6, 14, false, random, strongholdStones);
            this.func_74882_a(world, structureBoundingBox, 2, 6, 1, 8, 6, 2, false, random, strongholdStones);
            this.func_74882_a(world, structureBoundingBox, 2, 6, 14, 8, 6, 14, false, random, strongholdStones);
            this.func_74882_a(world, structureBoundingBox, 1, 1, 1, 2, 1, 4, false, random, strongholdStones);
            this.func_74882_a(world, structureBoundingBox, 8, 1, 1, 9, 1, 4, false, random, strongholdStones);
            this.func_151549_a(world, structureBoundingBox, 1, 1, 1, 1, 1, 3, (Block)Blocks.field_150356_k, (Block)Blocks.field_150356_k, false);
            this.func_151549_a(world, structureBoundingBox, 9, 1, 1, 9, 1, 3, (Block)Blocks.field_150356_k, (Block)Blocks.field_150356_k, false);
            this.func_74882_a(world, structureBoundingBox, 3, 1, 8, 7, 1, 12, false, random, strongholdStones);
            this.func_151549_a(world, structureBoundingBox, 4, 1, 9, 6, 1, 11, (Block)Blocks.field_150356_k, (Block)Blocks.field_150356_k, false);
            for (i = 3; i < 14; i += 2) {
                this.func_151549_a(world, structureBoundingBox, 0, 3, i, 0, 4, i, Blocks.field_150411_aY, Blocks.field_150411_aY, false);
                this.func_151549_a(world, structureBoundingBox, 10, 3, i, 10, 4, i, Blocks.field_150411_aY, Blocks.field_150411_aY, false);
            }
            for (i = 2; i < 9; i += 2) {
                this.func_151549_a(world, structureBoundingBox, i, 3, 15, i, 4, 15, Blocks.field_150411_aY, Blocks.field_150411_aY, false);
            }
            i = this.func_151555_a(Blocks.field_150390_bg, 3);
            this.func_74882_a(world, structureBoundingBox, 4, 1, 5, 6, 1, 7, false, random, strongholdStones);
            this.func_74882_a(world, structureBoundingBox, 4, 2, 6, 6, 2, 7, false, random, strongholdStones);
            this.func_74882_a(world, structureBoundingBox, 4, 3, 7, 6, 3, 7, false, random, strongholdStones);
            for (int j = 4; j <= 6; ++j) {
                this.func_151550_a(world, Blocks.field_150390_bg, i, j, 1, 4, structureBoundingBox);
                this.func_151550_a(world, Blocks.field_150390_bg, i, j, 2, 5, structureBoundingBox);
                this.func_151550_a(world, Blocks.field_150390_bg, i, j, 3, 6, structureBoundingBox);
            }
            if (!this.hasSpawner) {
                int z;
                i = this.func_74862_a(3);
                int x = this.func_74865_a(5, 6);
                if (structureBoundingBox.func_78890_b(x, i, z = this.func_74873_b(5, 6))) {
                    this.hasSpawner = true;
                    world.func_147465_d(x, i, z, Blocks.field_150474_ac, 0, 2);
                    TileEntityMobSpawner spawner = (TileEntityMobSpawner)world.func_147438_o(x, i, z);
                    if (spawner != null) {
                        spawner.func_145881_a().func_98272_a("Silverfish");
                    }
                }
            }
            return true;
        }
    }

    public static class Library
    extends Stronghold {
        private boolean isLargeRoom;

        public Library() {
        }

        public Library(int type, Random random, StructureBoundingBox structureBoundingBox, int mode) {
            super(type);
            this.field_74885_f = mode;
            this.door = this.getRandomDoor(random);
            this.field_74887_e = structureBoundingBox;
            this.isLargeRoom = structureBoundingBox.func_78882_c() > 6;
        }

        @Override
        protected void func_143012_a(NBTTagCompound nbtTagCompound) {
            super.func_143012_a(nbtTagCompound);
            nbtTagCompound.func_74757_a("Tall", this.isLargeRoom);
        }

        @Override
        protected void func_143011_b(NBTTagCompound nbtTagCompound) {
            super.func_143011_b(nbtTagCompound);
            this.isLargeRoom = nbtTagCompound.func_74767_n("Tall");
        }

        public static Library findValidPlacement(List list, Random random, int x, int y, int z, int mode, int type) {
            StructureBoundingBox structureBoundingBox = StructureBoundingBox.func_78889_a((int)x, (int)y, (int)z, (int)-4, (int)-1, (int)0, (int)14, (int)11, (int)15, (int)mode);
            if (!(Library.canStrongholdGoDeeper(structureBoundingBox) && StructureComponent.func_74883_a((List)list, (StructureBoundingBox)structureBoundingBox) == null || Library.canStrongholdGoDeeper(structureBoundingBox = StructureBoundingBox.func_78889_a((int)x, (int)y, (int)z, (int)-4, (int)-1, (int)0, (int)14, (int)6, (int)15, (int)mode)) && StructureComponent.func_74883_a((List)list, (StructureBoundingBox)structureBoundingBox) == null)) {
                return null;
            }
            return new Library(type, random, structureBoundingBox, mode);
        }

        public boolean func_74875_a(World world, Random random, StructureBoundingBox structureBoundingBox) {
            int i;
            if (this.func_74860_a(world, structureBoundingBox)) {
                return false;
            }
            int var1 = 11;
            if (!this.isLargeRoom) {
                var1 = 6;
            }
            this.func_74882_a(world, structureBoundingBox, 0, 0, 0, 13, var1 - 1, 14, true, random, strongholdStones);
            this.placeDoor(world, random, structureBoundingBox, this.door, 4, 1, 0);
            this.func_151551_a(world, structureBoundingBox, random, 0.07f, 2, 1, 1, 11, 4, 13, Blocks.field_150321_G, Blocks.field_150321_G, false);
            for (i = 1; i <= 13; ++i) {
                if ((i - 1) % 4 == 0) {
                    this.func_151549_a(world, structureBoundingBox, 1, 1, i, 1, 4, i, Blocks.field_150344_f, Blocks.field_150344_f, false);
                    this.func_151549_a(world, structureBoundingBox, 12, 1, i, 12, 4, i, Blocks.field_150344_f, Blocks.field_150344_f, false);
                    this.func_151550_a(world, Blocks.field_150478_aa, 0, 2, 3, i, structureBoundingBox);
                    this.func_151550_a(world, Blocks.field_150478_aa, 0, 11, 3, i, structureBoundingBox);
                    if (!this.isLargeRoom) continue;
                    this.func_151549_a(world, structureBoundingBox, 1, 6, i, 1, 9, i, Blocks.field_150344_f, Blocks.field_150344_f, false);
                    this.func_151549_a(world, structureBoundingBox, 12, 6, i, 12, 9, i, Blocks.field_150344_f, Blocks.field_150344_f, false);
                    continue;
                }
                this.func_151549_a(world, structureBoundingBox, 1, 1, i, 1, 4, i, Blocks.field_150342_X, Blocks.field_150342_X, false);
                this.func_151549_a(world, structureBoundingBox, 12, 1, i, 12, 4, i, Blocks.field_150342_X, Blocks.field_150342_X, false);
                if (!this.isLargeRoom) continue;
                this.func_151549_a(world, structureBoundingBox, 1, 6, i, 1, 9, i, Blocks.field_150342_X, Blocks.field_150342_X, false);
                this.func_151549_a(world, structureBoundingBox, 12, 6, i, 12, 9, i, Blocks.field_150342_X, Blocks.field_150342_X, false);
            }
            for (i = 3; i < 12; i += 2) {
                this.func_151549_a(world, structureBoundingBox, 3, 1, i, 4, 3, i, Blocks.field_150342_X, Blocks.field_150342_X, false);
                this.func_151549_a(world, structureBoundingBox, 6, 1, i, 7, 3, i, Blocks.field_150342_X, Blocks.field_150342_X, false);
                this.func_151549_a(world, structureBoundingBox, 9, 1, i, 10, 3, i, Blocks.field_150342_X, Blocks.field_150342_X, false);
            }
            if (this.isLargeRoom) {
                this.func_151549_a(world, structureBoundingBox, 1, 5, 1, 3, 5, 13, Blocks.field_150344_f, Blocks.field_150344_f, false);
                this.func_151549_a(world, structureBoundingBox, 10, 5, 1, 12, 5, 13, Blocks.field_150344_f, Blocks.field_150344_f, false);
                this.func_151549_a(world, structureBoundingBox, 4, 5, 1, 9, 5, 2, Blocks.field_150344_f, Blocks.field_150344_f, false);
                this.func_151549_a(world, structureBoundingBox, 4, 5, 12, 9, 5, 13, Blocks.field_150344_f, Blocks.field_150344_f, false);
                this.func_151550_a(world, Blocks.field_150344_f, 0, 9, 5, 11, structureBoundingBox);
                this.func_151550_a(world, Blocks.field_150344_f, 0, 8, 5, 11, structureBoundingBox);
                this.func_151550_a(world, Blocks.field_150344_f, 0, 9, 5, 10, structureBoundingBox);
                this.func_151549_a(world, structureBoundingBox, 3, 6, 2, 3, 6, 12, Blocks.field_150422_aJ, Blocks.field_150422_aJ, false);
                this.func_151549_a(world, structureBoundingBox, 10, 6, 2, 10, 6, 10, Blocks.field_150422_aJ, Blocks.field_150422_aJ, false);
                this.func_151549_a(world, structureBoundingBox, 4, 6, 2, 9, 6, 2, Blocks.field_150422_aJ, Blocks.field_150422_aJ, false);
                this.func_151549_a(world, structureBoundingBox, 4, 6, 12, 8, 6, 12, Blocks.field_150422_aJ, Blocks.field_150422_aJ, false);
                this.func_151550_a(world, Blocks.field_150422_aJ, 0, 9, 6, 11, structureBoundingBox);
                this.func_151550_a(world, Blocks.field_150422_aJ, 0, 8, 6, 11, structureBoundingBox);
                this.func_151550_a(world, Blocks.field_150422_aJ, 0, 9, 6, 10, structureBoundingBox);
                i = this.func_151555_a(Blocks.field_150468_ap, 3);
                this.func_151550_a(world, Blocks.field_150468_ap, i, 10, 1, 13, structureBoundingBox);
                this.func_151550_a(world, Blocks.field_150468_ap, i, 10, 2, 13, structureBoundingBox);
                this.func_151550_a(world, Blocks.field_150468_ap, i, 10, 3, 13, structureBoundingBox);
                this.func_151550_a(world, Blocks.field_150468_ap, i, 10, 4, 13, structureBoundingBox);
                this.func_151550_a(world, Blocks.field_150468_ap, i, 10, 5, 13, structureBoundingBox);
                this.func_151550_a(world, Blocks.field_150468_ap, i, 10, 6, 13, structureBoundingBox);
                this.func_151550_a(world, Blocks.field_150468_ap, i, 10, 7, 13, structureBoundingBox);
                int var2 = 7;
                int var3 = 7;
                this.func_151550_a(world, Blocks.field_150422_aJ, 0, var2 - 1, 9, var3, structureBoundingBox);
                this.func_151550_a(world, Blocks.field_150422_aJ, 0, var2, 9, var3, structureBoundingBox);
                this.func_151550_a(world, Blocks.field_150422_aJ, 0, var2 - 1, 8, var3, structureBoundingBox);
                this.func_151550_a(world, Blocks.field_150422_aJ, 0, var2, 8, var3, structureBoundingBox);
                this.func_151550_a(world, Blocks.field_150422_aJ, 0, var2 - 1, 7, var3, structureBoundingBox);
                this.func_151550_a(world, Blocks.field_150422_aJ, 0, var2, 7, var3, structureBoundingBox);
                this.func_151550_a(world, Blocks.field_150422_aJ, 0, var2 - 2, 7, var3, structureBoundingBox);
                this.func_151550_a(world, Blocks.field_150422_aJ, 0, var2 + 1, 7, var3, structureBoundingBox);
                this.func_151550_a(world, Blocks.field_150422_aJ, 0, var2 - 1, 7, var3 - 1, structureBoundingBox);
                this.func_151550_a(world, Blocks.field_150422_aJ, 0, var2 - 1, 7, var3 + 1, structureBoundingBox);
                this.func_151550_a(world, Blocks.field_150422_aJ, 0, var2, 7, var3 - 1, structureBoundingBox);
                this.func_151550_a(world, Blocks.field_150422_aJ, 0, var2, 7, var3 + 1, structureBoundingBox);
                this.func_151550_a(world, Blocks.field_150478_aa, 0, var2 - 2, 8, var3, structureBoundingBox);
                this.func_151550_a(world, Blocks.field_150478_aa, 0, var2 + 1, 8, var3, structureBoundingBox);
                this.func_151550_a(world, Blocks.field_150478_aa, 0, var2 - 1, 8, var3 - 1, structureBoundingBox);
                this.func_151550_a(world, Blocks.field_150478_aa, 0, var2 - 1, 8, var3 + 1, structureBoundingBox);
                this.func_151550_a(world, Blocks.field_150478_aa, 0, var2, 8, var3 - 1, structureBoundingBox);
                this.func_151550_a(world, Blocks.field_150478_aa, 0, var2, 8, var3 + 1, structureBoundingBox);
            }
            ChestGenHooks info = ChestGenHooks.getInfo((String)"strongholdLibrary");
            this.func_74879_a(world, structureBoundingBox, random, 3, 3, 5, info.getItems(random), info.getCount(random));
            if (this.isLargeRoom) {
                this.func_151550_a(world, Blocks.field_150350_a, 0, 12, 9, 1, structureBoundingBox);
                this.func_74879_a(world, structureBoundingBox, random, 12, 8, 1, info.getItems(random), info.getCount(random));
            }
            return true;
        }
    }

    public static class Straight
    extends Stronghold {
        private boolean expandsX;
        private boolean expandsZ;

        public Straight() {
        }

        public Straight(int type, Random random, StructureBoundingBox structureBoundingBox, int mode) {
            super(type);
            this.field_74885_f = mode;
            this.door = this.getRandomDoor(random);
            this.field_74887_e = structureBoundingBox;
            this.expandsX = random.nextInt(2) == 0;
            this.expandsZ = random.nextInt(2) == 0;
        }

        @Override
        protected void func_143012_a(NBTTagCompound nbtTagCompound) {
            super.func_143012_a(nbtTagCompound);
            nbtTagCompound.func_74757_a("Left", this.expandsX);
            nbtTagCompound.func_74757_a("Right", this.expandsZ);
        }

        @Override
        protected void func_143011_b(NBTTagCompound nbtTagCompound) {
            super.func_143011_b(nbtTagCompound);
            this.expandsX = nbtTagCompound.func_74767_n("Left");
            this.expandsZ = nbtTagCompound.func_74767_n("Right");
        }

        public void func_74861_a(StructureComponent structureComponent, List list, Random random) {
            this.getNextComponentNormal((Stairs2)structureComponent, list, random, 1, 1);
            if (this.expandsX) {
                this.getNextComponentX((Stairs2)structureComponent, list, random, 1, 2);
            }
            if (this.expandsZ) {
                this.getNextComponentZ((Stairs2)structureComponent, list, random, 1, 2);
            }
        }

        public static Straight findValidPlacement(List list, Random random, int x, int y, int z, int mode, int type) {
            StructureBoundingBox structureboundingbox = StructureBoundingBox.func_78889_a((int)x, (int)y, (int)z, (int)-1, (int)-1, (int)0, (int)5, (int)5, (int)7, (int)mode);
            return Straight.canStrongholdGoDeeper(structureboundingbox) && StructureComponent.func_74883_a((List)list, (StructureBoundingBox)structureboundingbox) == null ? new Straight(type, random, structureboundingbox, mode) : null;
        }

        public boolean func_74875_a(World world, Random random, StructureBoundingBox structureBoundingBox) {
            if (this.func_74860_a(world, structureBoundingBox)) {
                return false;
            }
            this.func_74882_a(world, structureBoundingBox, 0, 0, 0, 4, 4, 6, true, random, strongholdStones);
            this.placeDoor(world, random, structureBoundingBox, this.door, 1, 1, 0);
            this.placeDoor(world, random, structureBoundingBox, StructureStrongholdPieces.Stronghold.Door.OPENING, 1, 1, 6);
            this.func_151552_a(world, structureBoundingBox, random, 0.1f, 1, 2, 1, Blocks.field_150478_aa, 0);
            this.func_151552_a(world, structureBoundingBox, random, 0.1f, 3, 2, 1, Blocks.field_150478_aa, 0);
            this.func_151552_a(world, structureBoundingBox, random, 0.1f, 1, 2, 5, Blocks.field_150478_aa, 0);
            this.func_151552_a(world, structureBoundingBox, random, 0.1f, 3, 2, 5, Blocks.field_150478_aa, 0);
            if (this.expandsX) {
                this.func_151549_a(world, structureBoundingBox, 0, 1, 2, 0, 3, 4, Blocks.field_150350_a, Blocks.field_150350_a, false);
            }
            if (this.expandsZ) {
                this.func_151549_a(world, structureBoundingBox, 4, 1, 2, 4, 3, 4, Blocks.field_150350_a, Blocks.field_150350_a, false);
            }
            return true;
        }
    }

    public static class Stairs
    extends Stronghold {
        private boolean field_75024_a;

        public Stairs() {
        }

        public Stairs(int type, Random random, int par3, int par4) {
            super(type);
            this.field_75024_a = true;
            this.field_74885_f = random.nextInt(4);
            this.door = StructureStrongholdPieces.Stronghold.Door.OPENING;
            switch (this.field_74885_f) {
                case 0: 
                case 2: {
                    this.field_74887_e = new StructureBoundingBox(par3, 64, par4, par3 + 5 - 1, 74, par4 + 5 - 1);
                    break;
                }
                default: {
                    this.field_74887_e = new StructureBoundingBox(par3, 64, par4, par3 + 5 - 1, 74, par4 + 5 - 1);
                }
            }
        }

        public Stairs(int type, Random random, StructureBoundingBox structureBoundingBox, int mode) {
            super(type);
            this.field_75024_a = false;
            this.field_74885_f = mode;
            this.door = this.getRandomDoor(random);
            this.field_74887_e = structureBoundingBox;
        }

        @Override
        protected void func_143012_a(NBTTagCompound nbtTagCompound) {
            super.func_143012_a(nbtTagCompound);
            nbtTagCompound.func_74757_a("Source", this.field_75024_a);
        }

        @Override
        protected void func_143011_b(NBTTagCompound nbtTagCompound) {
            super.func_143011_b(nbtTagCompound);
            this.field_75024_a = nbtTagCompound.func_74767_n("Source");
        }

        public void func_74861_a(StructureComponent structureComponent, List list, Random random) {
            if (this.field_75024_a) {
                strongholdComponentType = Crossing.class;
            }
            this.getNextComponentNormal((Stairs2)structureComponent, list, random, 1, 1);
        }

        public static Stairs getStrongholdStairsComponent(List list, Random random, int x, int y, int z, int mode, int type) {
            StructureBoundingBox structureBoundingBox = StructureBoundingBox.func_78889_a((int)x, (int)y, (int)z, (int)-1, (int)-7, (int)0, (int)5, (int)11, (int)5, (int)mode);
            return Stairs.canStrongholdGoDeeper(structureBoundingBox) && StructureComponent.func_74883_a((List)list, (StructureBoundingBox)structureBoundingBox) == null ? new Stairs(type, random, structureBoundingBox, mode) : null;
        }

        public boolean func_74875_a(World world, Random random, StructureBoundingBox structureBoundingBox) {
            if (this.func_74860_a(world, structureBoundingBox)) {
                return false;
            }
            this.func_74882_a(world, structureBoundingBox, 0, 0, 0, 4, 10, 4, true, random, strongholdStones);
            this.placeDoor(world, random, structureBoundingBox, this.door, 1, 7, 0);
            this.placeDoor(world, random, structureBoundingBox, StructureStrongholdPieces.Stronghold.Door.OPENING, 1, 1, 4);
            this.func_151550_a(world, Blocks.field_150417_aV, 0, 2, 6, 1, structureBoundingBox);
            this.func_151550_a(world, Blocks.field_150417_aV, 0, 1, 5, 1, structureBoundingBox);
            this.func_151550_a(world, (Block)Blocks.field_150333_U, 0, 1, 6, 1, structureBoundingBox);
            this.func_151550_a(world, Blocks.field_150417_aV, 0, 1, 5, 2, structureBoundingBox);
            this.func_151550_a(world, Blocks.field_150417_aV, 0, 1, 4, 3, structureBoundingBox);
            this.func_151550_a(world, (Block)Blocks.field_150333_U, 0, 1, 5, 3, structureBoundingBox);
            this.func_151550_a(world, Blocks.field_150417_aV, 0, 2, 4, 3, structureBoundingBox);
            this.func_151550_a(world, Blocks.field_150417_aV, 0, 3, 3, 3, structureBoundingBox);
            this.func_151550_a(world, (Block)Blocks.field_150333_U, 0, 3, 4, 3, structureBoundingBox);
            this.func_151550_a(world, Blocks.field_150417_aV, 0, 3, 3, 2, structureBoundingBox);
            this.func_151550_a(world, Blocks.field_150417_aV, 0, 3, 2, 1, structureBoundingBox);
            this.func_151550_a(world, (Block)Blocks.field_150333_U, 0, 3, 3, 1, structureBoundingBox);
            this.func_151550_a(world, Blocks.field_150417_aV, 0, 2, 2, 1, structureBoundingBox);
            this.func_151550_a(world, Blocks.field_150417_aV, 0, 1, 1, 1, structureBoundingBox);
            this.func_151550_a(world, (Block)Blocks.field_150333_U, 0, 1, 2, 1, structureBoundingBox);
            this.func_151550_a(world, Blocks.field_150417_aV, 0, 1, 1, 2, structureBoundingBox);
            this.func_151550_a(world, (Block)Blocks.field_150333_U, 0, 1, 1, 3, structureBoundingBox);
            return true;
        }
    }
}

