/*
 * Decompiled with CFR 0.152.
 */
package fr.toss.launcher.util;

import fr.toss.launcher.util.Log;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.LinkedList;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import javax.swing.JProgressBar;

public class Util {
    public static void download(String link, File directory, JProgressBar progress) {
        try {
            int read;
            URL url = new URL(link);
            URLConnection connection = url.openConnection();
            String fileName = url.getFile().substring(url.getFile().lastIndexOf(47) + 1);
            connection.getContentType();
            int fileLength = connection.getContentLength();
            InputStream is = connection.getInputStream();
            FileOutputStream os = new FileOutputStream(directory + File.separator + fileName);
            File file = new File(directory + File.separator + fileName);
            byte[] buffer = new byte[1024];
            while ((read = is.read(buffer)) > 0) {
                os.write(buffer, 0, read);
                int percent = new Long(file.length() * 100L / (long)fileLength).intValue();
                progress.setValue(percent);
                progress.setString("Downloading... " + progress.getValue() + "%");
            }
            os.flush();
        }
        catch (MalformedURLException ex) {
            ex.printStackTrace();
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    public static OS getPlatform() {
        String osName = System.getProperty("os.name").toLowerCase();
        if (osName.contains("win")) {
            return OS.WINDOWS;
        }
        if (osName.contains("mac")) {
            return OS.MACOS;
        }
        if (osName.contains("linux")) {
            return OS.LINUX;
        }
        if (osName.contains("unix")) {
            return OS.LINUX;
        }
        return OS.UNKNOWN;
    }

    public static File getWorkingDirectory(String applicationName) {
        String applicationData;
        String userHome = System.getProperty("user.home", ".");
        File workingDirectory = Util.getPlatform() == OS.SOLARIS || Util.getPlatform() == OS.LINUX ? new File(userHome, String.valueOf('.') + applicationName + '/') : (Util.getPlatform() == OS.WINDOWS ? ((applicationData = System.getenv("APPDATA")) != null ? new File(applicationData, "." + applicationName + '/') : new File(userHome, String.valueOf('.') + applicationName + '/')) : (Util.getPlatform() == OS.MACOS ? new File(userHome, "Library/Application Support/" + applicationName) : new File(userHome, String.valueOf(applicationName) + '/')));
        if (!workingDirectory.exists() && !workingDirectory.mkdirs()) {
            throw new RuntimeException("Le r\u00c3\u00a9pertoire de travail n'a pas pu \u00c3\u0192\u00c2\u00aatre cr\u00c3\u00a9e: " + workingDirectory);
        }
        return workingDirectory;
    }

    private static String dirpart(String name) {
        int s = name.lastIndexOf(File.separatorChar);
        return s == -1 ? null : name.substring(0, s);
    }

    public static void extract(File zipFile, File outDir) {
        try {
            ZipEntry entry;
            ZipInputStream zin = new ZipInputStream(new FileInputStream(zipFile));
            while ((entry = zin.getNextEntry()) != null) {
                String name = entry.getName();
                if (entry.isDirectory()) {
                    Util.mkdirs(outDir, name);
                    continue;
                }
                String dir = Util.dirpart(name);
                if (dir != null) {
                    Util.mkdirs(outDir, dir);
                }
                Util.extractFile(zin, outDir, name);
            }
            zin.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private static void extractFile(ZipInputStream in, File outdir, String name) throws IOException {
        byte[] buffer = new byte[1024];
        BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(new File(outdir, name)));
        int count = -1;
        while ((count = in.read(buffer)) != -1) {
            out.write(buffer, 0, count);
        }
        out.close();
    }

    private static void mkdirs(File outdir, String path) {
        File d = new File(outdir, path);
        if (!d.exists()) {
            d.mkdirs();
        }
    }

    public static List<String> getNews(URL url) {
        LinkedList<String> list = new LinkedList<String>();
        String phrase = "";
        int rang = 0;
        try {
            InputStream is = url.openStream();
            BufferedReader br = new BufferedReader(new InputStreamReader(is));
            do {
                list.add(phrase);
                Log.print("[REQUETE GET LIST]", "Phrases obtenues au rang " + rang + " : " + (String)list.get(rang));
                ++rang;
            } while ((phrase = br.readLine()) != null && phrase.length() > 10);
        }
        catch (Exception e) {
            Log.print("[REQUETE GET]", "Une erreur est survenu.");
        }
        return list;
    }

    public static enum OS {
        LINUX,
        MACOS,
        SOLARIS,
        UNKNOWN,
        WINDOWS;

    }
}

