/*
 * Decompiled with CFR 0.152.
 */
package ckathode.archimedes.network;

import ckathode.archimedes.chunk.MobileChunkClient;
import ckathode.archimedes.entity.EntityShip;
import ckathode.archimedes.network.ASMessageShip;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufInputStream;
import io.netty.buffer.ByteBufOutputStream;
import io.netty.channel.ChannelHandlerContext;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;

public class MsgTileEntities
extends ASMessageShip {
    private NBTTagCompound tagCompound = null;

    public MsgTileEntities() {
    }

    public MsgTileEntities(EntityShip entityship) {
        super(entityship);
    }

    @Override
    public void encodeInto(ChannelHandlerContext ctx, ByteBuf buf) throws IOException {
        super.encodeInto(ctx, buf);
        this.tagCompound = new NBTTagCompound();
        NBTTagList list = new NBTTagList();
        for (TileEntity te : this.ship.getShipChunk().chunkTileEntityMap.values()) {
            NBTTagCompound nbt = new NBTTagCompound();
            te.func_145841_b(nbt);
            list.func_74742_a((NBTBase)nbt);
        }
        this.tagCompound.func_74782_a("list", (NBTBase)list);
        DataOutputStream out = new DataOutputStream((OutputStream)new ByteBufOutputStream(buf));
        try {
            CompressedStreamTools.func_74800_a((NBTTagCompound)this.tagCompound, (DataOutput)out);
            out.flush();
        }
        catch (IOException e) {
            throw e;
        }
        finally {
            out.close();
        }
    }

    @Override
    public void decodeInto(ChannelHandlerContext ctx, ByteBuf buf, EntityPlayer player) throws IOException {
        super.decodeInto(ctx, buf, player);
        if (this.ship != null) {
            DataInputStream in = new DataInputStream((InputStream)new ByteBufInputStream(buf));
            try {
                this.tagCompound = CompressedStreamTools.func_74794_a((DataInput)in);
            }
            catch (IOException e) {
                throw e;
            }
            finally {
                in.close();
            }
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void handleClientSide(EntityPlayer player) {
        if (this.ship != null && this.tagCompound != null) {
            NBTTagList list = this.tagCompound.func_150295_c("list", 10);
            for (int i = 0; i < list.func_74745_c(); ++i) {
                TileEntity te;
                NBTTagCompound nbt = list.func_150305_b(i);
                if (nbt == null || (te = TileEntity.func_145827_c((NBTTagCompound)nbt)) == null) continue;
                this.ship.getShipChunk().addTileEntity(te);
            }
            ((MobileChunkClient)this.ship.getShipChunk()).getRenderer().markDirty();
        }
    }

    @Override
    public void handleServerSide(EntityPlayer player) {
    }
}

