/*
 * Decompiled with CFR 0.152.
 */
package ckathode.archimedes;

import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.init.Blocks;
import net.minecraftforge.common.config.Configuration;
import org.apache.commons.lang3.ArrayUtils;
import org.lwjgl.input.Keyboard;

public class ArchimedesConfig {
    public static final int CONTROL_TYPE_VANILLA = 0;
    public static final int CONTROL_TYPE_ARCHIMEDES = 1;
    private Configuration config;
    private Map<String, Object> materialStringMap;
    public boolean enableAirShips;
    public boolean enableArchimedesLaw;
    public int shipEntitySyncRate;
    public int maxShipChunkBlocks;
    public float flyBalloonRatio;
    public boolean connectDiagonalBlocks1;
    public boolean connectDiagonalBlocks2;
    public Set<Block> forbiddenBlocks;
    public Set<Block> overwritableBlocks;
    public int shipControlType;
    public float turnSpeed;
    public float speedLimit;
    @SideOnly(value=Side.CLIENT)
    public KeyBinding kbUp;
    @SideOnly(value=Side.CLIENT)
    public KeyBinding kbDown;
    @SideOnly(value=Side.CLIENT)
    public KeyBinding kbBrake;
    @SideOnly(value=Side.CLIENT)
    public KeyBinding kbAlign;
    @SideOnly(value=Side.CLIENT)
    public KeyBinding kbDecompile;
    @SideOnly(value=Side.CLIENT)
    public KeyBinding kbShipInv;
    public boolean decompileOnDismount;

    public ArchimedesConfig(Configuration configuration) {
        this.config = configuration;
        this.forbiddenBlocks = new HashSet<Block>();
        this.overwritableBlocks = new HashSet<Block>();
    }

    public void loadAndSave() {
        Block[] defaultForbiddenBlocks = new Block[]{Blocks.field_150346_d, Blocks.field_150349_c, Blocks.field_150354_m, Blocks.field_150351_n, Blocks.field_150435_aG, Blocks.field_150432_aD, Blocks.field_150355_j, Blocks.field_150358_i, Blocks.field_150356_k, Blocks.field_150353_l, Blocks.field_150433_aE, Blocks.field_150392_bi, Blocks.field_150424_aL, Blocks.field_150425_aM, Blocks.field_150329_H};
        Block[] defaultOverwritableBlocks = new Block[]{Blocks.field_150329_H, Blocks.field_150392_bi};
        String[] forbiddenblocksnames = new String[defaultForbiddenBlocks.length];
        for (int i = 0; i < defaultForbiddenBlocks.length; ++i) {
            forbiddenblocksnames[i] = Block.field_149771_c.func_148750_c((Object)defaultForbiddenBlocks[i]);
        }
        String[] overwritableblocksnames = new String[defaultOverwritableBlocks.length];
        for (int i = 0; i < defaultOverwritableBlocks.length; ++i) {
            overwritableblocksnames[i] = Block.field_149771_c.func_148750_c((Object)defaultOverwritableBlocks[i]);
        }
        this.config.load();
        this.shipEntitySyncRate = this.config.get("settings", "sync_rate", 20, "The amount of ticks between a server-client synchronization. Higher numbers reduce network traffic. Lower numbers increase multiplayer experience. 20 ticks = 1 second").getInt();
        this.enableAirShips = this.config.get("settings", "enable_air_ships", true, "Enable or disable air ships.").getBoolean(true);
        this.enableArchimedesLaw = this.config.get("settings", "enable_advanced_floating_physics", false, "Enable advanced floating physics using Archimedes' law. Will make most iron and stone ships sink, use floater blocks to make sure ships float.").getBoolean(false);
        this.shipControlType = this.config.get("control", "control_type", 1, "Set to 0 to use vanilla boat controls, set to 1 to use the new Archimedes controls.").getInt();
        this.turnSpeed = (float)this.config.get("control", "turn_speed", 1.0, "A multiplier of the ship's turn speed.").getDouble(1.0);
        this.speedLimit = (float)this.config.get("control", "speed_limit", 30.0, "The maximum velocity a ship can have, in meter per second. This does not affect acceleration.").getDouble(30.0);
        this.speedLimit /= 20.0f;
        this.decompileOnDismount = this.config.get("control", "decompile_on_dismount", false).getBoolean(false);
        this.maxShipChunkBlocks = this.config.get("mobile_chunk", "max_chunk_blocks", 2048, "The maximum amount of blocks that a mobile ship chunk may contain.").getInt();
        this.flyBalloonRatio = (float)this.config.get("mobile_chunk", "airship_balloon_ratio", 0.4, "The part of the total amount of blocks that should be balloon blocks in order to make an airship.").getDouble(0.4);
        this.connectDiagonalBlocks1 = this.config.get("mobile_chunk", "connect_diagonal_blocks_1", false, "Blocks connected diagonally on one axis will also be added to the ship when this value is set to 'true'.").getBoolean(false);
        String[] forbiddenblocks = this.config.get("mobile_chunk", "forbidden_blocks", forbiddenblocksnames, "A list of blocks that will not be added to a ship.").getStringList();
        String[] overwritableblocks = this.config.get("mobile_chunk", "overwritable_blocks", overwritableblocksnames, "A list of blocks that may be overwritten when decompiling a ship.").getStringList();
        for (String id : forbiddenblocks) {
            this.forbiddenBlocks.add(Block.func_149684_b((String)id));
        }
        for (String id : overwritableblocks) {
            this.overwritableBlocks.add(Block.func_149684_b((String)id));
        }
        if (FMLCommonHandler.instance().getSide().isClient()) {
            this.loadKeybindings();
        }
        this.config.save();
    }

    @SideOnly(value=Side.CLIENT)
    private void loadKeybindings() {
        this.kbUp = new KeyBinding("key.archimedes.up", this.getKeyIndex(this.config, "key_ascent", 45), "Archimedes");
        this.kbDown = new KeyBinding("key.archimedes.down", this.getKeyIndex(this.config, "key_descent", 44), "Archimedes");
        this.kbBrake = new KeyBinding("key.archimedes.brake", this.getKeyIndex(this.config, "key_brake", 46), "Archimedes");
        this.kbAlign = new KeyBinding("key.archimedes.align", this.getKeyIndex(this.config, "key_align", 13), "Archimedes");
        this.kbDecompile = new KeyBinding("key.archimedes.decompile", this.getKeyIndex(this.config, "key_decompile", 43), "Archimedes");
        this.kbShipInv = new KeyBinding("key.archimedes.shipinv", this.getKeyIndex(this.config, "key_shipinv", 37), "Archimedes");
        Minecraft mc = Minecraft.func_71410_x();
        mc.field_71474_y.field_74324_K = (KeyBinding[])ArrayUtils.addAll((Object[])mc.field_71474_y.field_74324_K, (Object[])new KeyBinding[]{this.kbUp, this.kbDown, this.kbBrake, this.kbAlign, this.kbDecompile, this.kbShipInv});
    }

    private int getKeyIndex(Configuration config, String name, int defaultkey) {
        return Keyboard.getKeyIndex((String)config.get("control", name, Keyboard.getKeyName((int)defaultkey)).getString());
    }
}

