/*
 * Decompiled with CFR 0.152.
 */
package ckathode.archimedes.blockitem;

import ckathode.archimedes.ArchimedesShipMod;
import ckathode.archimedes.chunk.ChunkCompiler;
import ckathode.archimedes.chunk.CompileResult;
import ckathode.archimedes.entity.EntityShip;
import ckathode.archimedes.entity.IShipTileEntity;
import ckathode.archimedes.entity.ShipInfo;
import ckathode.archimedes.network.MsgCompileResult;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S35PacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.IChatComponent;

public class TileEntityHelm
extends TileEntity
implements IShipTileEntity {
    private EntityShip activeShip = null;
    private ShipInfo info = new ShipInfo();
    private CompileResult compileResult = null;
    private CompileResult prevResult = null;

    public ShipInfo getShipInfo() {
        return this.info;
    }

    public CompileResult getCompileResult() {
        return this.compileResult;
    }

    public CompileResult getPrevCompileResult() {
        return this.prevResult;
    }

    public void setShipInfo(ShipInfo shipinfo) {
        if (shipinfo == null) {
            throw new NullPointerException("Cannot set null ship info");
        }
        this.info = shipinfo;
    }

    public void setCompileResult(CompileResult result) {
        this.compileResult = result;
    }

    public void setPrevCompileResult(CompileResult result) {
        this.prevResult = result;
    }

    @Override
    public void setParentShip(EntityShip entityship) {
        this.activeShip = entityship;
    }

    @Override
    public EntityShip getParentShip() {
        return this.activeShip;
    }

    public boolean compileShip(EntityPlayer player) {
        if (!this.field_145850_b.field_72995_K) {
            this.prevResult = this.compileResult;
            ChunkCompiler compiler = new ChunkCompiler(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e);
            this.compileResult = compiler.doCompile();
            this.sendCompileResult(player, false);
            this.sendCompileResult(player, true);
            if (this.compileResult.getCode() == 1) {
                return true;
            }
            if (this.compileResult.getCode() == 2) {
                ChatComponentText c = new ChatComponentText("Cannot create vehicle with more than " + ArchimedesShipMod.instance.modConfig.maxShipChunkBlocks + " blocks");
                player.func_145747_a((IChatComponent)c);
            } else if (this.compileResult.getCode() == 3) {
                ChatComponentText c = new ChatComponentText("Cannot create vehicle with no vehicle marker");
                player.func_145747_a((IChatComponent)c);
            } else if (this.compileResult.getCode() == 4) {
                ChatComponentText c = new ChatComponentText("An error occured while compiling ship. See console log for details.");
                player.func_145747_a((IChatComponent)c);
            } else if (this.compileResult.getCode() == 0) {
                ChatComponentText c = new ChatComponentText("Nothing was compiled");
                player.func_145747_a((IChatComponent)c);
            }
        }
        return false;
    }

    public boolean mountShip(EntityPlayer player) {
        if (!this.field_145850_b.field_72995_K && this.compileResult != null && this.compileResult.getCode() == 1) {
            if (!this.compileResult.checkConsistent(this.field_145850_b)) {
                this.sendCompileResult(player, false);
                return false;
            }
            EntityShip entity = this.compileResult.getEntity(this.field_145850_b);
            if (entity != null) {
                entity.setInfo(this.info);
                if (this.field_145850_b.func_72838_d((Entity)entity)) {
                    entity.getCapabilities().spawnSeatEntities();
                    player.func_70078_a((Entity)entity);
                    this.compileResult = null;
                    return true;
                }
            }
        }
        return false;
    }

    public void undoCompilation(EntityPlayer player) {
        this.compileResult = this.prevResult;
        this.prevResult = null;
        this.sendCompileResult(player, false);
        this.sendCompileResult(player, true);
    }

    public void sendCompileResult(EntityPlayer player, boolean prev) {
        if (!this.field_145850_b.field_72995_K) {
            CompileResult res = prev ? this.prevResult : this.compileResult;
            MsgCompileResult msg = new MsgCompileResult(res, prev);
            ArchimedesShipMod.instance.pipeline.sendTo(msg, (EntityPlayerMP)player);
        }
    }

    public Packet func_145844_m() {
        NBTTagCompound compound = new NBTTagCompound();
        this.writeNBTforSending(compound);
        return new S35PacketUpdateTileEntity(this.field_145851_c, this.field_145848_d, this.field_145849_e, 0, compound);
    }

    public void onDataPacket(NetworkManager net, S35PacketUpdateTileEntity packet) {
        this.func_145839_a(packet.func_148857_g());
    }

    public void func_145839_a(NBTTagCompound compound) {
        int id;
        Entity entity;
        super.func_145839_a(compound);
        this.field_145847_g = compound.func_74762_e("meta");
        this.info.shipName = compound.func_74779_i("name");
        if (compound.func_74764_b("ship") && this.field_145850_b != null && (entity = this.field_145850_b.func_73045_a(id = compound.func_74762_e("ship"))) instanceof EntityShip) {
            this.activeShip = (EntityShip)entity;
        }
        if (compound.func_74764_b("res")) {
            this.compileResult = new CompileResult(compound.func_74775_l("res"), this.field_145850_b);
        }
    }

    public void func_145841_b(NBTTagCompound compound) {
        super.func_145841_b(compound);
        compound.func_74768_a("meta", this.field_145847_g);
        compound.func_74778_a("name", this.info.shipName);
        if (this.activeShip != null && !this.activeShip.field_70128_L) {
            compound.func_74768_a("ship", this.activeShip.func_145782_y());
        }
        if (this.compileResult != null) {
            NBTTagCompound comp = new NBTTagCompound();
            this.compileResult.writeNBTFully(comp);
            compound.func_74782_a("res", (NBTBase)comp);
        }
    }

    private void writeNBTforSending(NBTTagCompound compound) {
        super.func_145841_b(compound);
        compound.func_74768_a("meta", this.field_145847_g);
        compound.func_74778_a("name", this.info.shipName);
        if (this.activeShip != null && !this.activeShip.field_70128_L) {
            compound.func_74768_a("ship", this.activeShip.func_145782_y());
        }
        if (this.compileResult != null) {
            NBTTagCompound comp = new NBTTagCompound();
            this.compileResult.writeNBTMetadata(comp);
            compound.func_74782_a("res", (NBTBase)comp);
        }
    }
}

