/*
 * Decompiled with CFR 0.152.
 */
package ckathode.archimedes.chunk;

import ckathode.archimedes.ArchimedesShipMod;
import ckathode.archimedes.chunk.CompileResult;
import ckathode.archimedes.chunk.LocatedBlock;
import ckathode.archimedes.chunk.ShipSizeOverflowException;
import java.util.HashSet;
import net.minecraft.block.Block;
import net.minecraft.world.ChunkPosition;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class ChunkCompiler {
    private World worldObj;
    public final int startX;
    public final int startY;
    public final int startZ;
    private final int maxBlocks;

    public ChunkCompiler(World world, int x, int y, int z) {
        this.worldObj = world;
        this.startX = x;
        this.startY = y;
        this.startZ = z;
        this.maxBlocks = ArchimedesShipMod.instance.modConfig.maxShipChunkBlocks;
    }

    public CompileResult doCompile() {
        CompileResult result = new CompileResult();
        result.xOffset = this.startX;
        result.yOffset = this.startY;
        result.zOffset = this.startZ;
        try {
            this.compileRecursive(result, new HashSet<ChunkPosition>(), this.startX, this.startY, this.startZ);
            result.resultCode = result.shipMarkingBlock == null ? 3 : 1;
        }
        catch (ShipSizeOverflowException e) {
            result.resultCode = 2;
        }
        catch (StackOverflowError e) {
            ArchimedesShipMod.modLog.error("Error while compiling ship", (Throwable)e);
            result.resultCode = 4;
        }
        catch (Exception e) {
            e.printStackTrace();
            result.resultCode = 4;
        }
        return result;
    }

    private void compileRecursive(CompileResult result, HashSet<ChunkPosition> set, int x, int y, int z) throws ShipSizeOverflowException {
        if (result.compiledBlocks.size() > this.maxBlocks) {
            throw new ShipSizeOverflowException();
        }
        ChunkPosition pos = new ChunkPosition(x, y, z);
        if (set.contains(pos)) {
            return;
        }
        set.add(pos);
        Block block = this.worldObj.func_147439_a(x, y, z);
        if (!this.canUseBlockForVehicle(block, x, y, z)) {
            return;
        }
        LocatedBlock lb = new LocatedBlock(block, this.worldObj.func_72805_g(x, y, z), this.worldObj.func_147438_o(x, y, z), pos);
        result.compileBlock(lb);
        if (block == ArchimedesShipMod.blockMarkShip && result.shipMarkingBlock == null) {
            result.shipMarkingBlock = lb;
        }
        this.compileRecursive(result, set, x - 1, y, z);
        this.compileRecursive(result, set, x, y - 1, z);
        this.compileRecursive(result, set, x, y, z - 1);
        this.compileRecursive(result, set, x + 1, y, z);
        this.compileRecursive(result, set, x, y + 1, z);
        this.compileRecursive(result, set, x, y, z + 1);
        if (ArchimedesShipMod.instance.modConfig.connectDiagonalBlocks1) {
            this.compileRecursive(result, set, x - 1, y - 1, z);
            this.compileRecursive(result, set, x + 1, y - 1, z);
            this.compileRecursive(result, set, x + 1, y + 1, z);
            this.compileRecursive(result, set, x - 1, y + 1, z);
            this.compileRecursive(result, set, x - 1, y, z - 1);
            this.compileRecursive(result, set, x + 1, y, z - 1);
            this.compileRecursive(result, set, x + 1, y, z + 1);
            this.compileRecursive(result, set, x - 1, y, z + 1);
            this.compileRecursive(result, set, x, y - 1, z - 1);
            this.compileRecursive(result, set, x, y + 1, z - 1);
            this.compileRecursive(result, set, x, y + 1, z + 1);
            this.compileRecursive(result, set, x, y - 1, z + 1);
        }
    }

    public boolean canUseBlockForVehicle(Block block, int x, int y, int z) {
        return block != null && block != ArchimedesShipMod.blockBuffer && !block.isAir((IBlockAccess)this.worldObj, x, y, z) && !block.func_149688_o().func_76224_d() && !ArchimedesShipMod.instance.modConfig.forbiddenBlocks.contains(block);
    }
}

