/*
 * Decompiled with CFR 0.152.
 */
package ckathode.archimedes.chunk;

import ckathode.archimedes.ArchimedesShipMod;
import ckathode.archimedes.blockitem.TileEntityHelm;
import ckathode.archimedes.chunk.CompileResult;
import ckathode.archimedes.chunk.LocatedBlock;
import ckathode.archimedes.chunk.MobileChunk;
import ckathode.archimedes.entity.EntityShip;
import ckathode.archimedes.util.MathHelperMod;
import java.util.ArrayList;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Vec3;
import net.minecraft.world.ChunkPosition;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class ChunkDecompiler {
    private EntityShip ship;
    public boolean overwrite;

    public ChunkDecompiler(EntityShip entityship) {
        this.ship = entityship;
        this.overwrite = false;
    }

    public boolean canDecompile() {
        if (this.overwrite) {
            return true;
        }
        World world = this.ship.field_70170_p;
        MobileChunk chunk = this.ship.getShipChunk();
        float yaw = (float)Math.round(this.ship.field_70177_z / 90.0f) * 90.0f;
        yaw = (float)Math.toRadians(this.ship.field_70177_z);
        float ox = -chunk.getCenterX();
        float oy = -chunk.minY();
        float oz = -chunk.getCenterZ();
        Vec3 vec = world.func_82732_R().func_72345_a(0.0, 0.0, 0.0);
        for (int i = chunk.minX(); i < chunk.maxX(); ++i) {
            for (int j = chunk.minY(); j < chunk.maxY(); ++j) {
                for (int k = chunk.minZ(); k < chunk.maxZ(); ++k) {
                    if (chunk.func_147437_c(i, j, k)) continue;
                    vec.field_72450_a = (float)i + ox;
                    vec.field_72448_b = (float)j + oy;
                    vec.field_72449_c = (float)k + oz;
                    vec.func_72442_b(yaw);
                    int ix = MathHelperMod.round_double(vec.field_72450_a + this.ship.field_70165_t);
                    int iy = MathHelperMod.round_double(vec.field_72448_b + this.ship.field_70163_u);
                    int iz = MathHelperMod.round_double(vec.field_72449_c + this.ship.field_70161_v);
                    Block block = world.func_147439_a(ix, iy, iz);
                    if (block == null || block.isAir((IBlockAccess)world, ix, iy, iz) || block.func_149688_o().func_76224_d() || ArchimedesShipMod.instance.modConfig.overwritableBlocks.contains(block)) continue;
                    return false;
                }
            }
        }
        return true;
    }

    public CompileResult doDecompile() {
        int iz;
        int iy;
        int ix;
        World world = this.ship.field_70170_p;
        MobileChunk chunk = this.ship.getShipChunk();
        CompileResult result = new CompileResult();
        result.xOffset = Integer.MAX_VALUE;
        result.yOffset = Integer.MAX_VALUE;
        result.zOffset = Integer.MAX_VALUE;
        int currentrot = Math.round(this.ship.field_70177_z / 90.0f) & 3;
        int deltarot = -currentrot & 3;
        this.ship.field_70177_z = (float)currentrot * 90.0f;
        this.ship.field_70125_A = 0.0f;
        float yaw = (float)currentrot * 1.5707964f;
        boolean flag = world.func_82736_K().func_82766_b("doTileDrops");
        world.func_82736_K().func_82764_b("doTileDrops", "false");
        ArrayList<LocatedBlock> postlist = new ArrayList<LocatedBlock>(4);
        float ox = -chunk.getCenterX();
        float oy = -chunk.minY();
        float oz = -chunk.getCenterZ();
        Vec3 vec = world.func_82732_R().func_72345_a(0.0, 0.0, 0.0);
        for (int i = chunk.minX(); i < chunk.maxX(); ++i) {
            for (int j = chunk.minY(); j < chunk.maxY(); ++j) {
                for (int k = chunk.minZ(); k < chunk.maxZ(); ++k) {
                    Block block = chunk.func_147439_a(i, j, k);
                    int meta = chunk.func_72805_g(i, j, k);
                    if (block == Blocks.field_150350_a ? meta == 1 : block.isAir((IBlockAccess)world, i, j, k)) continue;
                    TileEntity tileentity = chunk.func_147438_o(i, j, k);
                    meta = ArchimedesShipMod.instance.metaRotations.getRotatedMeta(block, meta, deltarot);
                    vec.field_72450_a = (float)i + ox;
                    vec.field_72448_b = (float)j + oy;
                    vec.field_72449_c = (float)k + oz;
                    vec.func_72442_b(yaw);
                    ix = MathHelperMod.round_double(vec.field_72450_a + this.ship.field_70165_t);
                    iy = MathHelperMod.round_double(vec.field_72448_b + this.ship.field_70163_u);
                    iz = MathHelperMod.round_double(vec.field_72449_c + this.ship.field_70161_v);
                    if (!world.func_147465_d(ix, iy, iz, block, meta, 2) || block != world.func_147439_a(ix, iy, iz)) {
                        postlist.add(new LocatedBlock(block, meta, tileentity, new ChunkPosition(ix, iy, iz)));
                        continue;
                    }
                    if (meta != world.func_72805_g(ix, iy, iz)) {
                        world.func_72921_c(ix, iy, iz, meta, 2);
                    }
                    if (tileentity != null) {
                        world.func_147455_a(ix, iy, iz, tileentity);
                        tileentity.field_145847_g = meta;
                    }
                    if (!ArchimedesShipMod.instance.metaRotations.hasBlock(block)) {
                        this.rotateBlock(block, world, ix, iy, iz, currentrot);
                        block = world.func_147439_a(ix, iy, iz);
                        meta = world.func_72805_g(ix, iy, iz);
                        tileentity = world.func_147438_o(ix, iy, iz);
                    }
                    LocatedBlock lb = new LocatedBlock(block, meta, tileentity, new ChunkPosition(ix, iy, iz));
                    result.compileBlock(lb);
                    if (block != ArchimedesShipMod.blockMarkShip || i != this.ship.seatX || j != this.ship.seatY || k != this.ship.seatZ) continue;
                    result.shipMarkingBlock = lb;
                }
            }
        }
        world.func_82736_K().func_82764_b("doTileDrops", String.valueOf(flag));
        for (LocatedBlock ilb : postlist) {
            ix = ilb.coords.field_151329_a;
            iy = ilb.coords.field_151327_b;
            iz = ilb.coords.field_151328_c;
            ArchimedesShipMod.modLog.debug("Post-rejoining block: " + ilb.toString());
            world.func_147465_d(ix, iy, iz, ilb.block, ilb.blockMeta, 0);
            result.compileBlock(ilb);
        }
        this.ship.func_70106_y();
        result.resultCode = result.shipMarkingBlock == null || !(result.shipMarkingBlock.tileEntity instanceof TileEntityHelm) ? 3 : (result.checkConsistent(world) ? 1 : 6);
        return result;
    }

    private void rotateBlock(Block block, World world, int x, int y, int z, int deltarot) {
        if ((deltarot &= 3) != 0) {
            if (deltarot == 3) {
                block.rotateBlock(world, x, y, z, ForgeDirection.UP);
            } else {
                for (int r = 0; r < deltarot; ++r) {
                    block.rotateBlock(world, x, y, z, ForgeDirection.DOWN);
                }
            }
        }
    }
}

