/*
 * Decompiled with CFR 0.152.
 */
package ckathode.archimedes.entity;

import ckathode.archimedes.ArchimedesShipMod;
import ckathode.archimedes.blockitem.TileEntityHelm;
import ckathode.archimedes.chunk.ChunkDecompiler;
import ckathode.archimedes.chunk.ChunkIO;
import ckathode.archimedes.chunk.CompileResult;
import ckathode.archimedes.chunk.MobileChunk;
import ckathode.archimedes.chunk.MobileChunkClient;
import ckathode.archimedes.chunk.MobileChunkServer;
import ckathode.archimedes.chunk.ShipSizeOverflowException;
import ckathode.archimedes.control.ShipControllerClient;
import ckathode.archimedes.control.ShipControllerCommon;
import ckathode.archimedes.entity.EntityParachute;
import ckathode.archimedes.entity.EntitySeat;
import ckathode.archimedes.entity.ShipCapabilities;
import ckathode.archimedes.entity.ShipHandlerClient;
import ckathode.archimedes.entity.ShipHandlerCommon;
import ckathode.archimedes.entity.ShipHandlerServer;
import ckathode.archimedes.entity.ShipInfo;
import ckathode.archimedes.util.AABBRotator;
import ckathode.archimedes.util.MathHelperMod;
import cpw.mods.fml.common.registry.IEntityAdditionalSpawnData;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import io.netty.buffer.ByteBuf;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.List;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityBoat;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.DamageSource;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.MathHelper;
import net.minecraft.util.Vec3;
import net.minecraft.world.ChunkPosition;
import net.minecraft.world.World;

public class EntityShip
extends EntityBoat
implements IEntityAdditionalSpawnData {
    public static final float BASE_FORWARD_SPEED = 0.005f;
    public static final float BASE_TURN_SPEED = 0.5f;
    public static final float BASE_LIFT_SPEED = 0.004f;
    private MobileChunk shipChunk;
    private ShipCapabilities capabilities;
    private ShipControllerCommon controller;
    private ShipHandlerCommon handler;
    private ShipInfo info = new ShipInfo();
    private ChunkDecompiler decompiler;
    public float motionYaw;
    public int frontDirection;
    public int seatX;
    public int seatY;
    public int seatZ;
    private Entity prevRiddenByEntity;
    boolean isFlying;
    protected float groundFriction;
    protected float horFriction;
    protected float vertFriction;
    int[] layeredBlockVolumeCount;
    private boolean boatIsEmpty;
    private boolean syncPosWithServer;
    @SideOnly(value=Side.CLIENT)
    private int boatPosRotationIncrements;
    @SideOnly(value=Side.CLIENT)
    private double boatX;
    @SideOnly(value=Side.CLIENT)
    private double boatY;
    @SideOnly(value=Side.CLIENT)
    private double boatZ;
    @SideOnly(value=Side.CLIENT)
    private double boatPitch;
    @SideOnly(value=Side.CLIENT)
    private double boatYaw;
    @SideOnly(value=Side.CLIENT)
    private double boatVelX;
    @SideOnly(value=Side.CLIENT)
    private double boalVelY;
    @SideOnly(value=Side.CLIENT)
    private double boatVelZ;

    public static boolean isAABBInLiquidNotFall(World world, AxisAlignedBB aabb) {
        int i = MathHelper.func_76128_c((double)aabb.field_72340_a);
        int j = MathHelper.func_76128_c((double)(aabb.field_72336_d + 1.0));
        int k = MathHelper.func_76128_c((double)aabb.field_72338_b);
        int l = MathHelper.func_76128_c((double)(aabb.field_72337_e + 1.0));
        int i1 = MathHelper.func_76128_c((double)aabb.field_72339_c);
        int j1 = MathHelper.func_76128_c((double)(aabb.field_72334_f + 1.0));
        for (int x = i; x < j; ++x) {
            for (int y = k; y < l; ++y) {
                for (int z = i1; z < j1; ++z) {
                    Block block = world.func_147439_a(x, y, z);
                    if (block == null || block.func_149688_o() != Material.field_151586_h && block.func_149688_o() != Material.field_151587_i) continue;
                    int j2 = world.func_72805_g(x, y, z);
                    double d0 = y + 1;
                    if (j2 >= 8 || !((d0 = (double)(y + 1) - (double)j2 / 8.0) >= aabb.field_72338_b)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public EntityShip(World world) {
        super(world);
        this.capabilities = new ShipCapabilities(this);
        if (world.field_72995_K) {
            this.initClient();
        } else {
            this.initCommon();
        }
        this.motionYaw = 0.0f;
        this.layeredBlockVolumeCount = null;
        this.frontDirection = 0;
        this.field_70129_M = 0.0f;
        this.groundFriction = 0.9f;
        this.horFriction = 0.994f;
        this.vertFriction = 0.95f;
        this.prevRiddenByEntity = null;
        this.isFlying = false;
        this.boatIsEmpty = false;
        this.syncPosWithServer = true;
        if (world.field_72995_K) {
            this.boatPosRotationIncrements = 0;
            this.boatZ = 0.0;
            this.boatY = 0.0;
            this.boatX = 0.0;
            this.boatYaw = 0.0;
            this.boatPitch = 0.0;
            this.boatVelZ = 0.0;
            this.boalVelY = 0.0;
            this.boatVelX = 0.0;
        }
    }

    @SideOnly(value=Side.CLIENT)
    private void initClient() {
        this.shipChunk = new MobileChunkClient(this.field_70170_p, this);
        this.handler = new ShipHandlerClient(this);
        this.controller = new ShipControllerClient();
    }

    private void initCommon() {
        this.shipChunk = new MobileChunkServer(this.field_70170_p, this);
        this.handler = new ShipHandlerServer(this);
        this.controller = new ShipControllerCommon();
    }

    protected void func_70088_a() {
        this.field_70180_af.func_75682_a(30, (Object)0);
    }

    public MobileChunk getShipChunk() {
        return this.shipChunk;
    }

    public ShipCapabilities getCapabilities() {
        return this.capabilities;
    }

    public ShipControllerCommon getController() {
        return this.controller;
    }

    public ChunkDecompiler getDecompiler() {
        if (this.decompiler == null) {
            this.decompiler = new ChunkDecompiler(this);
        }
        return this.decompiler;
    }

    public void setInfo(ShipInfo shipinfo) {
        if (shipinfo == null) {
            throw new NullPointerException("Cannot set null ship info");
        }
        this.info = shipinfo;
    }

    public ShipInfo getInfo() {
        return this.info;
    }

    public void setPilotSeat(int dir, int seatx, int seaty, int seatz) {
        this.frontDirection = dir;
        this.seatX = seatx;
        this.seatY = seaty;
        this.seatZ = seatz;
    }

    public void func_70106_y() {
        super.func_70106_y();
        this.shipChunk.onChunkUnload();
        this.capabilities.clear();
    }

    public void func_70030_z() {
        super.func_70030_z();
        if (this.shipChunk.isModified) {
            this.shipChunk.isModified = false;
            this.handler.onChunkUpdate();
        }
    }

    public void setRotatedBoundingBox() {
        if (this.shipChunk == null) {
            float hw = this.field_70130_N / 2.0f;
            this.field_70121_D.func_72324_b(this.field_70165_t - (double)hw, this.field_70163_u, this.field_70161_v - (double)hw, this.field_70165_t + (double)hw, this.field_70163_u + (double)this.field_70131_O, this.field_70161_v + (double)hw);
        } else {
            this.field_70121_D.func_72324_b(this.field_70165_t - (double)this.shipChunk.getCenterX(), this.field_70163_u, this.field_70161_v - (double)this.shipChunk.getCenterZ(), this.field_70165_t + (double)this.shipChunk.getCenterX(), this.field_70163_u + (double)this.field_70131_O, this.field_70161_v + (double)this.shipChunk.getCenterZ());
            AABBRotator.rotateAABBAroundY(this.field_70121_D, this.field_70165_t, this.field_70161_v, (float)Math.toRadians(this.field_70177_z));
        }
    }

    public void func_70105_a(float w, float h) {
        float f;
        if (w != this.field_70130_N || h != this.field_70131_O) {
            this.field_70130_N = w;
            this.field_70131_O = h;
            float hw = w / 2.0f;
            this.field_70121_D.func_72324_b(this.field_70165_t - (double)hw, this.field_70163_u, this.field_70161_v - (double)hw, this.field_70165_t + (double)hw, this.field_70163_u + (double)this.field_70131_O, this.field_70161_v + (double)hw);
        }
        this.field_70168_am = (double)(f = w % 2.0f) < 0.375 ? Entity.EnumEntitySize.SIZE_1 : ((double)f < 0.75 ? Entity.EnumEntitySize.SIZE_2 : ((double)f < 1.0 ? Entity.EnumEntitySize.SIZE_3 : ((double)f < 1.375 ? Entity.EnumEntitySize.SIZE_4 : ((double)f < 1.75 ? Entity.EnumEntitySize.SIZE_5 : Entity.EnumEntitySize.SIZE_6))));
    }

    @SideOnly(value=Side.CLIENT)
    public void func_70056_a(double x, double y, double z, float yaw, float pitch, int incr) {
        if (this.boatIsEmpty) {
            this.boatPosRotationIncrements = incr + 5;
        } else {
            double dx = x - this.field_70165_t;
            double dy = y - this.field_70163_u;
            double dz = z - this.field_70161_v;
            double d = dx * dx + dy * dy + dz * dz;
            if (d < 0.3) {
                return;
            }
            this.syncPosWithServer = true;
            this.boatPosRotationIncrements = incr;
        }
        this.boatX = x;
        this.boatY = y;
        this.boatZ = z;
        this.boatYaw = yaw;
        this.boatPitch = pitch;
        this.field_70159_w = this.boatVelX;
        this.field_70181_x = this.boalVelY;
        this.field_70179_y = this.boatVelZ;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_70016_h(double x, double y, double z) {
        this.boatVelX = this.field_70159_w = x;
        this.boalVelY = this.field_70181_x = y;
        this.boatVelZ = this.field_70179_y = z;
    }

    public void func_70071_h_() {
        this.func_70030_z();
        this.field_70169_q = this.field_70165_t;
        this.field_70167_r = this.field_70163_u;
        this.field_70166_s = this.field_70161_v;
        double horvel = Math.sqrt(this.field_70159_w * this.field_70159_w + this.field_70179_y * this.field_70179_y);
        if (this.field_70170_p.field_72995_K && (this.boatIsEmpty || this.syncPosWithServer)) {
            this.handleClientUpdate();
            if (this.boatPosRotationIncrements == 0) {
                this.syncPosWithServer = false;
            }
        } else {
            this.handleServerUpdate(horvel);
        }
    }

    @SideOnly(value=Side.CLIENT)
    protected void handleClientUpdate() {
        if (this.boatPosRotationIncrements > 0) {
            double dx = this.field_70165_t + (this.boatX - this.field_70165_t) / (double)this.boatPosRotationIncrements;
            double dy = this.field_70163_u + (this.boatY - this.field_70163_u) / (double)this.boatPosRotationIncrements;
            double dz = this.field_70161_v + (this.boatZ - this.field_70161_v) / (double)this.boatPosRotationIncrements;
            double ang = MathHelper.func_76138_g((double)(this.boatYaw - (double)this.field_70177_z));
            this.field_70177_z = (float)((double)this.field_70177_z + ang / (double)this.boatPosRotationIncrements);
            this.field_70125_A = (float)((double)this.field_70125_A + (this.boatPitch - (double)this.field_70125_A) / (double)this.boatPosRotationIncrements);
            --this.boatPosRotationIncrements;
            this.func_70107_b(dx, dy, dz);
            this.func_70101_b(this.field_70177_z, this.field_70125_A);
        } else {
            this.func_70107_b(this.field_70165_t + this.field_70159_w, this.field_70163_u + this.field_70181_x, this.field_70161_v + this.field_70179_y);
            if (this.field_70122_E) {
                this.field_70159_w *= (double)this.groundFriction;
                this.field_70181_x *= (double)this.groundFriction;
                this.field_70179_y *= (double)this.groundFriction;
            }
            this.field_70159_w *= (double)this.horFriction;
            this.field_70181_x *= (double)this.vertFriction;
            this.field_70179_y *= (double)this.horFriction;
        }
        this.setRotatedBoundingBox();
    }

    protected void handleServerUpdate(double horvel) {
        double maxvel;
        double newhorvel;
        int belowwater;
        int b0 = 5;
        int bpermeter = (int)((double)b0 * (this.field_70121_D.field_72337_e - this.field_70121_D.field_72338_b));
        float watervolume = 0.0f;
        AxisAlignedBB axisalignedbb = AxisAlignedBB.func_72332_a().func_72299_a(0.0, 0.0, 0.0, 0.0, 0.0, 0.0);
        for (belowwater = 0; belowwater < bpermeter; ++belowwater) {
            double d1 = this.field_70121_D.field_72338_b + (this.field_70121_D.field_72337_e - this.field_70121_D.field_72338_b) * (double)belowwater / (double)bpermeter;
            double d2 = this.field_70121_D.field_72338_b + (this.field_70121_D.field_72337_e - this.field_70121_D.field_72338_b) * (double)(belowwater + 1) / (double)bpermeter;
            axisalignedbb.func_72324_b(this.field_70121_D.field_72340_a, d1, this.field_70121_D.field_72339_c, this.field_70121_D.field_72336_d, d2, this.field_70121_D.field_72334_f);
            if (!EntityShip.isAABBInLiquidNotFall(this.field_70170_p, axisalignedbb)) break;
        }
        if (belowwater > 0 && this.layeredBlockVolumeCount != null) {
            int k = belowwater / b0;
            for (int y = 0; y <= k && y < this.layeredBlockVolumeCount.length; ++y) {
                if (y == k) {
                    watervolume += (float)(this.layeredBlockVolumeCount[y] * (belowwater % b0)) * 1.0f / (float)b0;
                    continue;
                }
                watervolume += (float)this.layeredBlockVolumeCount[y] * 1.0f;
            }
        }
        if (this.field_70122_E) {
            this.isFlying = false;
        }
        float gravity = 0.05f;
        if (watervolume > 0.0f) {
            this.isFlying = false;
            float buoyancyforce = 1.0f * watervolume * gravity;
            float mass = ArchimedesShipMod.instance.modConfig.enableArchimedesLaw ? this.capabilities.getMass() : (float)this.shipChunk.getBlockCount() * 0.34f - (float)this.capabilities.getFloaterCount() * 0.25f - (float)this.capabilities.getBalloonCount() * 0.32f;
            this.field_70181_x += (double)(buoyancyforce / mass);
        }
        if (!this.isFlying()) {
            this.field_70181_x -= (double)gravity;
        }
        if (this.field_70153_n == null && this.prevRiddenByEntity != null) {
            EntityParachute parachute;
            if (ArchimedesShipMod.instance.modConfig.decompileOnDismount) {
                this.alignToGrid();
                this.updateRiderPosition(this.prevRiddenByEntity, this.seatX, this.seatY, this.seatZ, true);
                this.decompileToBlocks(false);
            } else if (!this.field_70170_p.field_72995_K && this.isFlying() && this.field_70170_p.func_72838_d((Entity)(parachute = new EntityParachute(this.field_70170_p, this, this.seatX, this.seatY, this.seatZ)))) {
                this.prevRiddenByEntity.func_70078_a((Entity)parachute);
                this.prevRiddenByEntity.func_70095_a(false);
            }
            this.prevRiddenByEntity = null;
        }
        if (this.field_70153_n == null) {
            if (this.isFlying()) {
                this.field_70181_x -= 8.00000037997961E-4;
            }
        } else {
            this.handlePlayerControl();
            this.prevRiddenByEntity = this.field_70153_n;
        }
        if ((newhorvel = Math.sqrt(this.field_70159_w * this.field_70159_w + this.field_70179_y * this.field_70179_y)) > (maxvel = (double)ArchimedesShipMod.instance.modConfig.speedLimit)) {
            double d = maxvel / newhorvel;
            this.field_70159_w *= d;
            this.field_70179_y *= d;
            newhorvel = maxvel;
        }
        this.field_70181_x = MathHelperMod.clamp_double(this.field_70181_x, -maxvel, maxvel);
        if (this.field_70122_E) {
            this.field_70159_w *= (double)this.groundFriction;
            this.field_70181_x *= (double)this.groundFriction;
            this.field_70179_y *= (double)this.groundFriction;
        }
        this.motionYaw *= 0.7f;
        this.field_70177_z += this.motionYaw;
        this.setRotatedBoundingBox();
        this.func_70091_d(this.field_70159_w, this.field_70181_x, this.field_70179_y);
        this.field_70163_u = Math.min(this.field_70163_u, (double)this.field_70170_p.func_72800_K());
        this.field_70159_w *= (double)this.horFriction;
        this.field_70181_x *= (double)this.vertFriction;
        this.field_70179_y *= (double)this.horFriction;
        this.field_70125_A = 0.0f;
        if (ArchimedesShipMod.instance.modConfig.shipControlType == 0) {
            double maxyawspeed;
            double deltayaw;
            double newyaw = this.field_70177_z;
            double dx = this.field_70169_q - this.field_70165_t;
            double dz = this.field_70166_s - this.field_70161_v;
            if (this.field_70153_n != null && !this.isBraking() && dx * dx + dz * dz > 0.01) {
                newyaw = 270.0 - Math.toDegrees(Math.atan2(dz, dx)) + (double)((float)this.frontDirection * 90.0f);
            }
            if ((deltayaw = MathHelper.func_76138_g((double)(newyaw - (double)this.field_70177_z))) > (maxyawspeed = 2.0)) {
                deltayaw = maxyawspeed;
            }
            if (deltayaw < -maxyawspeed) {
                deltayaw = -maxyawspeed;
            }
            this.field_70177_z = (float)((double)this.field_70177_z + deltayaw);
        }
        this.func_70101_b(this.field_70177_z, this.field_70125_A);
        if (!this.field_70170_p.field_72995_K) {
            List list = this.field_70170_p.func_72839_b((Entity)this, this.field_70121_D.func_72314_b(0.2, 0.0, 0.2));
            if (list != null && !list.isEmpty()) {
                for (Entity entity : list) {
                    if (entity == this.field_70153_n || !entity.func_70104_M() || !(entity instanceof EntityBoat)) continue;
                    entity.func_70108_f((Entity)this);
                }
            }
            for (int l = 0; l < 4; ++l) {
                int i1 = MathHelper.func_76128_c((double)(this.field_70165_t + ((double)(l % 2) - 0.5) * 0.8));
                int j1 = MathHelper.func_76128_c((double)(this.field_70161_v + ((double)(l / 2) - 0.5) * 0.8));
                for (int k1 = 0; k1 < 2; ++k1) {
                    int l1 = MathHelper.func_76128_c((double)this.field_70163_u) + k1;
                    Block block = this.field_70170_p.func_147439_a(i1, l1, j1);
                    if (block == Blocks.field_150433_aE) {
                        this.field_70170_p.func_147468_f(i1, l1, j1);
                        this.field_70123_F = false;
                        continue;
                    }
                    if (block != Blocks.field_150392_bi) continue;
                    this.field_70170_p.func_147480_a(i1, l1, j1, true);
                    this.field_70123_F = false;
                }
            }
        }
    }

    private void handlePlayerControl() {
        if (this.field_70153_n instanceof EntityLivingBase) {
            double throttle = ((EntityLivingBase)this.field_70153_n).field_70701_bs;
            if (this.isFlying()) {
                throttle *= 0.5;
            }
            if (ArchimedesShipMod.instance.modConfig.shipControlType == 1) {
                Vec3 vec = this.field_70170_p.func_82732_R().func_72345_a(this.field_70153_n.field_70159_w, 0.0, this.field_70153_n.field_70179_y);
                vec.func_72442_b((float)Math.toRadians(this.field_70153_n.field_70177_z));
                double steer = ((EntityLivingBase)this.field_70153_n).field_70702_br;
                this.motionYaw = (float)((double)this.motionYaw + steer * 0.5 * (double)this.capabilities.rotationMultiplier * (double)ArchimedesShipMod.instance.modConfig.turnSpeed);
                float yaw = (float)Math.toRadians(180.0f - this.field_70177_z + (float)this.frontDirection * 90.0f);
                vec.field_72450_a = this.field_70159_w;
                vec.field_72449_c = this.field_70179_y;
                vec.func_72442_b(yaw);
                vec.field_72450_a *= 0.9;
                vec.field_72449_c -= throttle * (double)0.005f * (double)this.capabilities.speedMultiplier;
                vec.func_72442_b(-yaw);
                this.field_70159_w = vec.field_72450_a;
                this.field_70179_y = vec.field_72449_c;
            } else if (ArchimedesShipMod.instance.modConfig.shipControlType == 0 && throttle > 0.0) {
                double dsin = -Math.sin(Math.toRadians(this.field_70153_n.field_70177_z));
                double dcos = Math.cos(Math.toRadians(this.field_70153_n.field_70177_z));
                this.field_70159_w += dsin * (double)0.005f * (double)this.capabilities.speedMultiplier;
                this.field_70179_y += dcos * (double)0.005f * (double)this.capabilities.speedMultiplier;
            }
        }
        if (this.controller.getShipControl() != 0) {
            if (this.controller.getShipControl() == 4) {
                this.alignToGrid();
            } else if (this.isBraking()) {
                this.field_70159_w *= (double)this.capabilities.brakeMult;
                this.field_70179_y *= (double)this.capabilities.brakeMult;
                if (this.isFlying()) {
                    this.field_70181_x *= (double)this.capabilities.brakeMult;
                }
            } else if (this.controller.getShipControl() < 3 && this.capabilities.canFly()) {
                int i;
                if (this.controller.getShipControl() == 2) {
                    this.isFlying = true;
                    i = 1;
                } else {
                    i = -1;
                }
                this.field_70181_x += (double)((float)i * 0.004f * this.capabilities.liftMultiplier);
            }
        }
    }

    public boolean func_70072_I() {
        float f = this.field_70130_N;
        this.field_70130_N = 0.0f;
        boolean ret = super.func_70072_I();
        this.field_70130_N = f;
        return ret;
    }

    public boolean isFlying() {
        return this.capabilities.canFly() && (this.isFlying || this.controller.getShipControl() == 2);
    }

    public boolean isBraking() {
        return this.controller.getShipControl() == 3;
    }

    public boolean func_96092_aw() {
        return this.field_70173_aa > 60;
    }

    @SideOnly(value=Side.CLIENT)
    protected void spawnParticles(double horvel) {
        if (this.func_70090_H() && horvel > 0.1625) {
            int j = 0;
            while ((double)j < 1.0 + horvel * 60.0) {
                this.field_70170_p.func_72869_a("splash", this.field_70165_t + (double)((this.field_70146_Z.nextFloat() - 0.5f) * this.field_70130_N), this.field_70163_u, this.field_70161_v + (double)((this.field_70146_Z.nextFloat() - 0.5f) * this.field_70130_N), this.field_70159_w, this.field_70181_x + 1.0, this.field_70179_y);
                ++j;
            }
            j = 0;
            while ((double)j < 1.0 + horvel * 20.0) {
                this.field_70170_p.func_72869_a("bubble", this.field_70165_t + (double)this.field_70146_Z.nextFloat() - 0.5, this.field_70163_u - 0.2, this.field_70161_v + (double)this.field_70146_Z.nextFloat() - 0.5, 0.0, 0.0, 0.0);
                ++j;
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_70270_d(boolean flag) {
        this.boatIsEmpty = flag;
    }

    public boolean shouldRiderSit() {
        return true;
    }

    public void func_70043_V() {
        this.updateRiderPosition(this.field_70153_n, this.seatX, this.seatY, this.seatZ, true);
    }

    public void updateRiderPosition(Entity entity, int seatx, int seaty, int seatz, boolean behind) {
        if (entity != null) {
            float yaw = (float)Math.toRadians(this.field_70177_z);
            int x1 = seatx;
            int y1 = seaty;
            int z1 = seatz;
            if (behind) {
                if (this.frontDirection == 0) {
                    --z1;
                } else if (this.frontDirection == 1) {
                    ++x1;
                } else if (this.frontDirection == 2) {
                    ++z1;
                } else if (this.frontDirection == 3) {
                    --x1;
                }
                Block block = this.shipChunk.func_147439_a(x1, MathHelper.func_76128_c((double)((double)y1 + this.func_70042_X() + entity.func_70033_W())), z1);
                if (block.func_149662_c()) {
                    x1 = seatx;
                    y1 = seaty;
                    z1 = seatz;
                }
            }
            Vec3 vec = this.field_70170_p.func_82732_R().func_72345_a((double)((float)x1 - this.shipChunk.getCenterX()) + 0.5, (double)(y1 - this.shipChunk.minY()) + this.func_70042_X(), (double)((float)z1 - this.shipChunk.getCenterZ()) + 0.5);
            vec.func_72442_b(yaw);
            entity.func_70107_b(this.field_70165_t + vec.field_72450_a, this.field_70163_u + vec.field_72448_b + entity.func_70033_W(), this.field_70161_v + vec.field_72449_c);
        }
    }

    public double func_70042_X() {
        return (double)this.field_70129_M + 0.5;
    }

    protected boolean func_70041_e_() {
        return false;
    }

    public AxisAlignedBB func_70114_g(Entity entity) {
        return entity instanceof EntitySeat || entity.field_70154_o instanceof EntitySeat || entity instanceof EntityLiving ? null : entity.field_70121_D;
    }

    public AxisAlignedBB func_70046_E() {
        return this.field_70121_D;
    }

    public boolean func_70104_M() {
        return this.field_70122_E && !this.func_70090_H() && this.field_70153_n == null;
    }

    public boolean func_70067_L() {
        return !this.field_70128_L;
    }

    public boolean func_70097_a(DamageSource source, float damage) {
        if (source.func_94541_c() && source.func_76346_g() != null && source.func_76346_g().getClass().getName().equals("ckathode.weaponmod.entity.projectile.EntityCannonBall")) {
            double dx = source.func_76346_g().field_70165_t - this.field_70165_t;
            double dy = source.func_76346_g().field_70163_u - this.field_70163_u;
            double dz = source.func_76346_g().field_70161_v - this.field_70161_v;
            Vec3 vec = this.field_70170_p.func_82732_R().func_72345_a(dx, dy, dz);
            vec.func_72442_b((float)Math.toRadians(-this.field_70177_z));
            this.field_70170_p.func_72876_a(source.func_76346_g(), source.func_76346_g().field_70165_t, source.func_76346_g().field_70163_u, source.func_76346_g().field_70161_v, 4.0f, false);
            source.func_76346_g().func_70106_y();
        }
        return false;
    }

    protected void func_70064_a(double distancefallen, boolean onground) {
        if (!this.isFlying()) {
            // empty if block
        }
    }

    protected void func_70069_a(float distance) {
    }

    @SideOnly(value=Side.CLIENT)
    public float func_70053_R() {
        return 0.5f;
    }

    public float getHorizontalVelocity() {
        return (float)Math.sqrt(this.field_70159_w * this.field_70159_w + this.field_70179_y * this.field_70179_y);
    }

    public boolean func_130002_c(EntityPlayer entityplayer) {
        return this.handler.interact(entityplayer);
    }

    public void alignToGrid() {
        this.field_70177_z = (float)Math.round(this.field_70177_z / 90.0f) * 90.0f;
        this.field_70125_A = 0.0f;
        Vec3 vec = this.field_70170_p.func_82732_R().func_72345_a((double)(-this.shipChunk.getCenterX()), (double)(-this.shipChunk.minY()), (double)(-this.shipChunk.getCenterZ()));
        vec.func_72442_b((float)Math.toRadians(this.field_70177_z));
        int ix = MathHelperMod.round_double(vec.field_72450_a + this.field_70165_t);
        int iy = MathHelperMod.round_double(vec.field_72448_b + this.field_70163_u);
        int iz = MathHelperMod.round_double(vec.field_72449_c + this.field_70161_v);
        this.field_70165_t = (double)ix - vec.field_72450_a;
        this.field_70163_u = (double)iy - vec.field_72448_b;
        this.field_70161_v = (double)iz - vec.field_72449_c;
        this.field_70179_y = 0.0;
        this.field_70181_x = 0.0;
        this.field_70159_w = 0.0;
    }

    public boolean decompileToBlocks(boolean overwrite) {
        TileEntity te;
        if (this.field_70170_p.field_72995_K) {
            return true;
        }
        this.func_70043_V();
        ChunkDecompiler decompiler = this.getDecompiler();
        decompiler.overwrite = overwrite;
        if (!decompiler.canDecompile()) {
            if (this.prevRiddenByEntity instanceof EntityPlayer) {
                ChatComponentText c = new ChatComponentText("Cannot decompile ship here");
                ((EntityPlayer)this.prevRiddenByEntity).func_145747_a((IChatComponent)c);
            }
            return false;
        }
        CompileResult result = decompiler.doDecompile();
        if (result.getShipMarker() != null && (te = result.getShipMarker().tileEntity) instanceof TileEntityHelm) {
            ((TileEntityHelm)te).setCompileResult(result);
            ((TileEntityHelm)te).setShipInfo(this.info);
        }
        return true;
    }

    public void dropAsItems() {
        for (int i = this.shipChunk.minX(); i < this.shipChunk.maxX(); ++i) {
            for (int j = this.shipChunk.minY(); j < this.shipChunk.maxY(); ++j) {
                for (int k = this.shipChunk.minZ(); k < this.shipChunk.maxZ(); ++k) {
                    Block block;
                    TileEntity tileentity = this.shipChunk.func_147438_o(i, j, k);
                    if (tileentity instanceof IInventory) {
                        IInventory inv = (IInventory)tileentity;
                        for (int it = 0; it < inv.func_70302_i_(); ++it) {
                            ItemStack is = inv.func_70301_a(it);
                            if (is == null) continue;
                            this.func_70099_a(is, 0.0f);
                        }
                    }
                    if ((block = this.shipChunk.func_147439_a(i, j, k)) == Blocks.field_150350_a) continue;
                    int meta = this.shipChunk.func_72805_g(i, j, k);
                    block.func_149697_b(this.field_70170_p, MathHelper.func_76128_c((double)this.field_70165_t), MathHelper.func_76128_c((double)this.field_70163_u), MathHelper.func_76128_c((double)this.field_70161_v), meta, 0);
                }
            }
        }
    }

    void fillAirBlocks(Set<ChunkPosition> set, int x, int y, int z) {
        if (x < this.shipChunk.minX() - 1 || x > this.shipChunk.maxX() || y < this.shipChunk.minY() - 1 || y > this.shipChunk.maxY() || z < this.shipChunk.minZ() - 1 || z > this.shipChunk.maxZ()) {
            return;
        }
        ChunkPosition pos = new ChunkPosition(x, y, z);
        if (set.contains(pos)) {
            return;
        }
        set.add(pos);
        if (this.shipChunk.setBlockAsFilledAir(x, y, z)) {
            this.fillAirBlocks(set, x, y + 1, z);
            this.fillAirBlocks(set, x - 1, y, z);
            this.fillAirBlocks(set, x, y, z - 1);
            this.fillAirBlocks(set, x + 1, y, z);
            this.fillAirBlocks(set, x, y, z + 1);
        }
    }

    protected void func_70014_b(NBTTagCompound compound) {
        super.func_70014_b(compound);
        ByteArrayOutputStream baos = new ByteArrayOutputStream(this.shipChunk.getMemoryUsage());
        DataOutputStream out = new DataOutputStream(baos);
        try {
            ChunkIO.writeAll(out, this.shipChunk);
            out.flush();
            out.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        compound.func_74773_a("chunk", baos.toByteArray());
        compound.func_74774_a("seatX", (byte)this.seatX);
        compound.func_74774_a("seatY", (byte)this.seatY);
        compound.func_74774_a("seatZ", (byte)this.seatZ);
        compound.func_74774_a("front", (byte)this.frontDirection);
        if (!this.shipChunk.chunkTileEntityMap.isEmpty()) {
            NBTTagList tileentities = new NBTTagList();
            for (TileEntity tileentity : this.shipChunk.chunkTileEntityMap.values()) {
                NBTTagCompound comp = new NBTTagCompound();
                tileentity.func_145841_b(comp);
                tileentities.func_74742_a((NBTBase)comp);
            }
            compound.func_74782_a("tileent", (NBTBase)tileentities);
        }
        compound.func_74778_a("name", this.info.shipName);
    }

    protected void func_70037_a(NBTTagCompound compound) {
        super.func_70037_a(compound);
        byte[] ab = compound.func_74770_j("chunk");
        ByteArrayInputStream bais = new ByteArrayInputStream(ab);
        DataInputStream in = new DataInputStream(bais);
        try {
            ChunkIO.read(in, this.shipChunk);
            in.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        if (compound.func_74764_b("seat")) {
            short s = compound.func_74765_d("seat");
            this.seatX = s & 0xF;
            this.seatY = s >>> 4 & 0xF;
            this.seatZ = s >>> 8 & 0xF;
            this.frontDirection = s >>> 12 & 3;
        } else {
            this.seatX = compound.func_74771_c("seatX");
            this.seatY = compound.func_74771_c("seatZ");
            this.seatZ = compound.func_74771_c("seatZ");
            this.frontDirection = compound.func_74771_c("front");
        }
        NBTTagList tileentities = compound.func_150295_c("tileent", 10);
        if (tileentities != null) {
            for (int i = 0; i < tileentities.func_74745_c(); ++i) {
                NBTTagCompound comp = tileentities.func_150305_b(i);
                TileEntity tileentity = TileEntity.func_145827_c((NBTTagCompound)comp);
                this.shipChunk.setTileEntity(tileentity.field_145851_c, tileentity.field_145848_d, tileentity.field_145849_e, tileentity);
            }
        }
        this.info = new ShipInfo();
        this.info.shipName = compound.func_74779_i("name");
    }

    public void writeSpawnData(ByteBuf data) {
        data.writeByte(this.seatX);
        data.writeByte(this.seatY);
        data.writeByte(this.seatZ);
        data.writeByte(this.frontDirection);
        data.writeShort(this.info.shipName.length());
        data.writeBytes(this.info.shipName.getBytes());
        try {
            ChunkIO.writeAllCompressed(data, this.shipChunk);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (ShipSizeOverflowException ssoe) {
            this.decompileToBlocks(false);
            ArchimedesShipMod.modLog.warn("Ship is too large to be sent");
        }
    }

    public void readSpawnData(ByteBuf data) {
        this.seatX = data.readByte();
        this.seatY = data.readByte();
        this.seatZ = data.readByte();
        this.frontDirection = data.readByte();
        byte[] ab = new byte[data.readShort()];
        data.readBytes(ab);
        this.info.shipName = new String(ab);
        try {
            ChunkIO.readCompressed(data, this.shipChunk);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

