/*
 * Decompiled with CFR 0.152.
 */
package ckathode.archimedes.entity;

import ckathode.archimedes.ArchimedesShipMod;
import ckathode.archimedes.MaterialDensity;
import ckathode.archimedes.entity.EntityEntityAttachment;
import ckathode.archimedes.entity.EntitySeat;
import ckathode.archimedes.entity.EntityShip;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntityFurnace;

public class ShipCapabilities {
    private EntityShip ship;
    public float speedMultiplier;
    public float rotationMultiplier;
    public float liftMultiplier;
    public float brakeMult;
    private int balloons;
    private int floaters;
    private int blockCount;
    private float mass;
    private List<EntityEntityAttachment> seats;
    private FuelInventory fuelInventory;

    ShipCapabilities(EntityShip entityship) {
        this.ship = entityship;
        this.clear();
    }

    public boolean canFly() {
        return ArchimedesShipMod.instance.modConfig.enableAirShips && (float)this.balloons >= (float)this.blockCount * ArchimedesShipMod.instance.modConfig.flyBalloonRatio;
    }

    public int getBlockCount() {
        return this.blockCount;
    }

    public int getBalloonCount() {
        return this.balloons;
    }

    public int getFloaterCount() {
        return this.floaters;
    }

    public float getMass() {
        return this.mass;
    }

    public void addAttachments(EntityEntityAttachment entity) {
        if (this.seats == null) {
            this.seats = new ArrayList<EntityEntityAttachment>(4);
        }
        this.seats.add(entity);
    }

    public List<EntityEntityAttachment> getAttachments() {
        return this.seats;
    }

    protected void onChunkBlockAdded(Block block, int metadata, int x, int y, int z) {
        ++this.blockCount;
        this.mass += MaterialDensity.getDensity(block);
        if (block == ArchimedesShipMod.blockBalloon) {
            ++this.balloons;
        } else if (block == ArchimedesShipMod.blockFloater) {
            ++this.floaters;
        } else if (block == ArchimedesShipMod.blockSeat) {
            if (!this.ship.field_70170_p.field_72995_K) {
                int x1 = this.ship.seatX;
                int y1 = this.ship.seatY;
                int z1 = this.ship.seatZ;
                if (this.ship.frontDirection == 0) {
                    --z1;
                } else if (this.ship.frontDirection == 1) {
                    ++x1;
                } else if (this.ship.frontDirection == 2) {
                    ++z1;
                } else if (this.ship.frontDirection == 3) {
                    --x1;
                }
                if (x != x1 || y != y1 || z != z1) {
                    EntitySeat seat = new EntitySeat(this.ship.field_70170_p, x, y, z);
                    this.addAttachments(seat);
                }
            }
        } else if (block == ArchimedesShipMod.blockEngine) {
            this.speedMultiplier += 0.2f;
            this.rotationMultiplier += 0.1f;
            this.liftMultiplier += 0.2f;
        }
    }

    public boolean mountEntity(Entity entity) {
        if (this.seats == null) {
            return false;
        }
        for (EntityEntityAttachment seat : this.seats) {
            if (seat.field_70153_n == null) {
                entity.func_70078_a((Entity)seat);
                return true;
            }
            if (seat.field_70153_n != entity) continue;
            seat.func_70078_a(null);
            return true;
        }
        return false;
    }

    public void spawnSeatEntities() {
        if (this.seats != null) {
            for (EntityEntityAttachment seat : this.seats) {
                seat.setParentShip(this.ship);
                this.ship.field_70170_p.func_72838_d((Entity)seat);
            }
        }
    }

    public void clear() {
        if (this.seats != null) {
            for (EntityEntityAttachment seat : this.seats) {
                seat.func_70106_y();
            }
            this.seats = null;
        }
        this.liftMultiplier = 1.0f;
        this.rotationMultiplier = 1.0f;
        this.speedMultiplier = 1.0f;
        this.brakeMult = 0.9f;
        this.balloons = 0;
        this.floaters = 0;
        this.blockCount = 0;
        this.mass = 0.0f;
        this.fuelInventory = null;
    }

    public IInventory getFuelInventory() {
        if (this.fuelInventory == null) {
            this.fuelInventory = new FuelInventory();
        }
        return this.fuelInventory;
    }

    public class FuelInventory
    implements IInventory {
        ItemStack itemstack;

        public int func_70302_i_() {
            return 1;
        }

        public ItemStack func_70301_a(int i) {
            return i == 0 ? this.itemstack : null;
        }

        public ItemStack func_70298_a(int i, int n) {
            if (i == 0 && this.itemstack != null) {
                this.itemstack.field_77994_a -= n;
                return this.itemstack;
            }
            return null;
        }

        public ItemStack func_70304_b(int i) {
            return i == 0 ? this.itemstack : null;
        }

        public void func_70299_a(int i, ItemStack is) {
            if (i == 0) {
                this.itemstack = is;
            }
        }

        public String func_145825_b() {
            return "Fuel Inventory";
        }

        public boolean func_145818_k_() {
            return false;
        }

        public int func_70297_j_() {
            return 64;
        }

        public void func_70296_d() {
        }

        public boolean func_70300_a(EntityPlayer player) {
            return player.field_70154_o == ShipCapabilities.this.ship && ((ShipCapabilities)ShipCapabilities.this).ship.field_70153_n == player;
        }

        public void func_70295_k_() {
        }

        public void func_70305_f() {
        }

        public boolean func_94041_b(int i, ItemStack is) {
            return i == 0 && TileEntityFurnace.func_145954_b((ItemStack)is);
        }
    }
}

