/*
 * Decompiled with CFR 0.152.
 */
package mickkay.scenter;

import java.awt.Color;
import mickkay.scenter.Target;
import mickkay.scenter.TargetPart;
import net.minecraft.block.Block;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;

public class BlockScanner {
    private MyTarget target = new MyTarget();

    public void setTarget(Target target) {
        this.target = new MyTarget(target);
    }

    public TargetPart getTargetPart() {
        if (this.target.hasFound()) {
            return this.target.foundTarget;
        }
        return this.target.target.getParts().get(0);
    }

    public Color getTargetColor() {
        return this.target.target.getColor();
    }

    public boolean hasFound() {
        return this.target.hasFound();
    }

    public int getFoundX() {
        return this.target.getX();
    }

    public int getFoundY() {
        return this.target.getY();
    }

    public int getFoundZ() {
        return this.target.getZ();
    }

    public double scan(World world, int chunkCoordX, int chunkCoordZ, int px, int py, int pz) {
        this.target.reset();
        for (int x = -1; x <= 1; ++x) {
            for (int y = -1; y <= 1; ++y) {
                Chunk chunk = world.func_72964_e(chunkCoordX + x, chunkCoordZ + y);
                this.scan(world, chunk, px, py, pz);
            }
        }
        return this.target.getDistance();
    }

    private void scan(World world, Chunk chunk, int px, int py, int pz) {
        if (this.target != null) {
            for (int y = 0; y < 255; ++y) {
                for (int z = 0; z < 16; ++z) {
                    for (int x = 0; x < 16; ++x) {
                        int bz;
                        int bx;
                        double dist;
                        int metaData;
                        Block blk = chunk.func_150810_a(x, y, z);
                        TargetPart part = this.target.target.getMatchingPart(blk, metaData = chunk.func_76628_c(x, y, z));
                        if (part == null || !((dist = this.calculateDistance(bx = chunk.field_76635_g * 16 + x, y, bz = chunk.field_76647_h * 16 + z, px, py, pz)) < this.target.distance)) continue;
                        this.target.distance = dist;
                        this.target.x = bx;
                        this.target.y = y;
                        this.target.z = bz;
                        this.target.foundTarget = part;
                    }
                }
            }
        }
    }

    private double calculateDistance(int x1, int y1, int z1, int x2, int y2, int z3) {
        double dx = x1 - x2;
        double dy = y1 - (y2 - 1);
        double dz = z1 - z3;
        double result = Math.sqrt(dx * dx + dy * dy + dz * dz);
        return result;
    }

    public static class MyTarget {
        public Target target;
        private TargetPart foundTarget;
        private int x = 0;
        private int y = 0;
        private int z = 0;
        private double distance = Double.MAX_VALUE;

        public MyTarget() {
        }

        public MyTarget(Target target) {
            this.target = target;
        }

        public boolean hasFound() {
            return this.foundTarget != null;
        }

        public int getX() {
            return this.x;
        }

        public int getY() {
            return this.y;
        }

        public int getZ() {
            return this.z;
        }

        public double getDistance() {
            return this.distance;
        }

        public void reset() {
            this.foundTarget = null;
            this.distance = Double.MAX_VALUE;
            this.x = 0;
            this.y = 0;
            this.z = 0;
        }

        public ItemStack getItemStack() {
            return this.target.getParts().get((int)0).itemStack;
        }
    }
}

