/*
 * Decompiled with CFR 0.152.
 */
package mickkay.scenter;

import cpw.mods.fml.client.FMLClientHandler;
import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.SidedProxy;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLPostInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import java.awt.Color;
import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import mickkay.scenter.BlockScanner;
import mickkay.scenter.CommonProxy;
import mickkay.scenter.Target;
import mickkay.scenter.config.ScenterModConfig;
import net.minecraft.block.Block;
import net.minecraft.client.entity.EntityClientPlayerMP;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.IChatComponent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(modid="Scenter", name="Scenter", version="1.7.2-3.0.0")
public class ScenterMod {
    private static final String MINECRAFT_KEY_PREFIX = "minecraft:";
    public static final String NAME = "Scenter";
    public static final String ID = "Scenter";
    public static final String VERSION = "1.7.2-3.0.0";
    private static final String SCENTER_COMMON_PROXY = "mickkay.scenter.CommonProxy";
    private static final String SCENTER_CLIENT_PROXY = "mickkay.scenter.ClientProxy";
    private static final String PARTICLE_TYPE = "happyVillager";
    private final Logger logger = LogManager.getLogger((String)ScenterMod.class.getName());
    @Mod.Instance(value="Scenter")
    public static ScenterMod instance;
    @SidedProxy(clientSide="mickkay.scenter.ClientProxy", serverSide="mickkay.scenter.CommonProxy")
    public static CommonProxy proxy;
    private ScenterModConfig config = null;
    public Double distance = null;
    public long lastUpdate = 0L;
    private boolean enabled = false;
    private int targetIndex = 0;
    private BlockScanner blockScanner;
    private List<Target> targets;
    private File standardConfigFile;

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) throws IOException {
        this.standardConfigFile = event.getSuggestedConfigurationFile();
        this.blockScanner = new BlockScanner();
    }

    @Mod.EventHandler
    public void load(FMLInitializationEvent event) {
        proxy.registerEventHandlers();
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent event) throws IOException {
        this.logger.info(String.format("** %s loaded. **", "Scenter"));
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean value) {
        if (value == this.enabled) {
            return;
        }
        if (this.targets == null) {
            this.showAllKnownBlocks();
            try {
                this.initializeTargets();
            }
            catch (Exception e) {
                this.showOnConsole("Scenter can't read targets configuration: " + e.getMessage());
                this.logger.error((Object)e);
            }
            this.targetIndex = 0;
        }
        if (value && this.targets.size() == 0) {
            this.showOnConsole("Can't enable Scenter: no targets definded in config file!");
            return;
        }
        if (value) {
            this.blockScanner.setTarget(this.getTarget(this.targetIndex));
        }
        this.enabled = value;
        this.showOnConsole("Scenter is " + (this.enabled ? "enabled" : "disabled"));
        this.findOres();
    }

    private void findOres() {
        if (!this.enabled) {
            return;
        }
        ScenterMod.instance.lastUpdate = System.currentTimeMillis();
        EntityClientPlayerMP player = FMLClientHandler.instance().getClient().field_71439_g;
        instance.findOres((EntityPlayer)player, false);
    }

    private void initializeTargets() throws IOException {
        this.config = new ScenterModConfig(this.standardConfigFile);
        this.targets = this.config.getTargets();
    }

    private void showAllKnownBlocks() {
        this.logger.info("Showing all registered blocks...");
        Set keys = Block.field_149771_c.func_148742_b();
        LinkedList<String> listOfKeys = new LinkedList<String>();
        for (Object key : keys) {
            if (!(key instanceof String)) continue;
            listOfKeys.add((String)key);
        }
        Collections.sort(listOfKeys);
        StringBuilder builder = new StringBuilder();
        builder.append("These blocks are registered:\n");
        for (String key : listOfKeys) {
            if (key.startsWith(MINECRAFT_KEY_PREFIX)) {
                key = key.substring(MINECRAFT_KEY_PREFIX.length());
            }
            builder.append(key).append("\n");
        }
        this.logger.info(builder.toString());
    }

    public void nextBlockType() {
        this.targetIndex = (this.targetIndex + 1) % this.targets.size();
        this.blockScanner.setTarget(this.getTarget(this.targetIndex));
        this.findOres();
    }

    private Target getTarget(int index) {
        if (this.targets.size() <= index) {
            return null;
        }
        Target target = this.targets.get(index);
        return target;
    }

    public boolean findOres(EntityPlayer p, boolean fixYPos) {
        double dy = fixYPos ? 1.5 : 0.0;
        double minDist = this.blockScanner.scan(p.field_70170_p, p.field_70176_ah, p.field_70164_aj, (int)p.field_70165_t, (int)p.field_70163_u + (int)dy + 1, (int)p.field_70161_v);
        if (minDist < Double.MAX_VALUE) {
            double fromX = p.field_70165_t;
            double fromY = p.field_70163_u;
            double fromZ = p.field_70161_v;
            Color color = this.blockScanner.getTargetColor();
            proxy.spawnParticleTrail(p.field_70170_p, fromX, fromY + dy, fromZ, this.blockScanner.getFoundX(), this.blockScanner.getFoundY(), this.blockScanner.getFoundZ(), color);
            ScenterMod.instance.distance = minDist;
            ScenterMod.instance.lastUpdate = System.currentTimeMillis();
            return true;
        }
        ScenterMod.instance.distance = null;
        ScenterMod.instance.lastUpdate = System.currentTimeMillis();
        return false;
    }

    public String getVersion() {
        return VERSION;
    }

    public ItemStack getTargetItemStack() {
        return this.blockScanner.getTargetPart().itemStack;
    }

    public String getTargetDisplayName() {
        String displayName = this.blockScanner.getTargetPart().getDisplayName();
        if (displayName == null || displayName.trim().length() == 0) {
            displayName = Block.field_149771_c.func_148750_c((Object)this.blockScanner.getTargetPart().block);
        }
        return displayName;
    }

    private synchronized void showOnConsole(String msg) {
        if (FMLClientHandler.instance().getClient() != null && FMLClientHandler.instance().getClient().field_71439_g != null) {
            FMLClientHandler.instance().getClient().field_71439_g.func_145747_a((IChatComponent)new ChatComponentText(msg));
        }
    }
}

