/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.construction.buildingtools;

import com.mrcrayfish.construction.buildingtools.BlockSubData;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.block.BlockAnvil;
import net.minecraft.block.BlockCarpet;
import net.minecraft.block.BlockColored;
import net.minecraft.block.BlockDirt;
import net.minecraft.block.BlockDoublePlant;
import net.minecraft.block.BlockFlower;
import net.minecraft.block.BlockLog;
import net.minecraft.block.BlockNewLeaf;
import net.minecraft.block.BlockNewLog;
import net.minecraft.block.BlockOldLeaf;
import net.minecraft.block.BlockQuartz;
import net.minecraft.block.BlockSand;
import net.minecraft.block.BlockSandStone;
import net.minecraft.block.BlockSapling;
import net.minecraft.block.BlockSilverfish;
import net.minecraft.block.BlockStainedGlass;
import net.minecraft.block.BlockStainedGlassPane;
import net.minecraft.block.BlockStoneBrick;
import net.minecraft.block.BlockStoneSlab;
import net.minecraft.block.BlockTallGrass;
import net.minecraft.block.BlockWall;
import net.minecraft.block.BlockWood;
import net.minecraft.block.BlockWoodSlab;
import net.minecraft.item.Item;

public class BlockData {
    Map<String, BlockSubData> materialData = new HashMap<String, BlockSubData>();
    int length;

    public void addToMaterialList(String blockName, int[] materials) {
        this.length = this.materialData.size();
        int[] data = new int[]{this.fixData(blockName, materials[0]), materials[1]};
        BlockSubData mData = new BlockSubData(blockName, data[0], data[1]);
        int count = 0;
        while (this.materialData.get("material:" + blockName + "metadata:" + mData.getMetadata() + "set:" + count) != null) {
            ++count;
        }
        this.length = count;
        for (int i = 0; i < this.length; ++i) {
            if (this.materialData.get("material:" + blockName + "metadata:" + mData.getMetadata() + "set:" + i) == null || blockName.equals("minecraft:air")) continue;
            BlockSubData data2 = this.materialData.get("material:" + blockName + "metadata:" + mData.getMetadata() + "set:" + i);
            Block block = Block.func_149684_b((String)mData.getBlockName());
            Item item = block.func_149694_d(null, 0, 0, 0);
            int stackSize = item.func_77639_j();
            if (data2.getBlockName().equals(mData.getBlockName()) && data2.getStackSize() < stackSize) {
                mData.addItemToStack(data2.getStackSize());
                this.materialData.put("material:" + blockName + "metadata:" + mData.getMetadata() + "set:" + i, mData);
                continue;
            }
            if (this.materialData.get("material:" + blockName + "metadata:" + mData.getMetadata() + "set:" + (i + 1)) != null) continue;
            this.materialData.put("material:" + blockName + "metadata:" + mData.getMetadata() + "set:" + (i + 1), mData);
        }
        if (this.length == 0 && !blockName.equals("minecraft:air")) {
            this.materialData.put("material:" + blockName + "metadata:" + mData.getMetadata() + "set:" + this.length, mData);
        }
    }

    public void print() {
        for (String key : this.materialData.keySet()) {
            System.out.println(key);
        }
    }

    public BlockSubData[] getMaterials() {
        BlockSubData[] materials = new BlockSubData[this.materialData.size()];
        String[] keys = this.materialData.keySet().toArray(new String[this.materialData.size()]);
        for (int i = 0; i < keys.length; ++i) {
            BlockSubData data = this.materialData.get(keys[i]);
            materials[i] = new BlockSubData(data.getBlockName(), data.getMetadata(), data.getStackSize());
        }
        return materials;
    }

    public int fixData(String blockName, int metadata) {
        Block block = Block.func_149684_b((String)blockName);
        if (block instanceof BlockLog | block instanceof BlockNewLog) {
            if (metadata == 4 | metadata == 8) {
                return 0;
            }
            if (metadata == 10 | metadata == 6) {
                return 2;
            }
            if (metadata == 11 | metadata == 7) {
                return 3;
            }
            if (metadata == 5 | metadata == 9) {
                return 1;
            }
        } else if (block instanceof BlockOldLeaf) {
            if (metadata == 4 | metadata == 8) {
                return 0;
            }
            if (metadata == 5 | metadata == 13) {
                return 1;
            }
            if (metadata == 6 | metadata == 14) {
                return 2;
            }
            if (metadata == 7 | metadata == 15) {
                return 3;
            }
        } else {
            if (block instanceof BlockNewLeaf) {
                if (metadata == 4 | metadata == 8) {
                    return 0;
                }
                if (metadata == 5 | metadata == 9) {
                    return 1;
                }
                return metadata;
            }
            if (block instanceof BlockStoneSlab | block instanceof BlockWoodSlab) {
                if (metadata == 8) {
                    return 0;
                }
                if (metadata == 9) {
                    return 1;
                }
                if (metadata == 10) {
                    return 2;
                }
                if (metadata == 11) {
                    return 3;
                }
                if (metadata == 12) {
                    return 4;
                }
                if (metadata == 13) {
                    return 5;
                }
                if (metadata == 14) {
                    return 6;
                }
                if (metadata == 15) {
                    return 7;
                }
                return metadata;
            }
            if (block instanceof BlockQuartz) {
                if (metadata > 2) {
                    return 2;
                }
                return metadata;
            }
            if (block instanceof BlockWood | block instanceof BlockSandStone | block instanceof BlockTallGrass | block instanceof BlockColored | block instanceof BlockSilverfish | block instanceof BlockStoneBrick | block instanceof BlockWall | block instanceof BlockAnvil | block instanceof BlockCarpet | block instanceof BlockStainedGlass | block instanceof BlockDoublePlant | block instanceof BlockStainedGlassPane | block instanceof BlockFlower | block instanceof BlockDirt | block instanceof BlockSand | block instanceof BlockSapling) {
                return metadata;
            }
        }
        return 0;
    }
}

