/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.construction.buildingtools;

import com.mrcrayfish.construction.buildingtools.ConstructionUtil;
import com.mrcrayfish.construction.buildingtools.MaterialList;
import cpw.mods.fml.common.registry.GameRegistry;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import net.minecraft.block.Block;
import net.minecraft.block.BlockAnvil;
import net.minecraft.block.BlockStairs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.world.World;

public class BuildingToFile {
    BufferedWriter bw;
    String buildingName;
    private String[] filteredIDs = new String[]{"bed", "piston_head", "skull", "iron_door", "wooden_door", "double_wooden_slab", "flowing_water", "water", "flowing_lava", "lava", "farmland", "double_stone_slab", "flower_pot"};
    private String[] newIDs = new String[]{"air", "air", "air", "air", "air", "wooden_slab", "air", "air", "air", "air", "dirt", "stone_slab", "air"};
    private EntityPlayer player;

    public BuildingToFile(EntityPlayer player, String buildingName, int x1, int y1, int z1, int x2, int y2, int z2, int rotation) {
        World world = player.field_70170_p;
        this.player = player;
        try {
            this.buildingName = buildingName;
            File file = new File("buildings/" + buildingName + ".txt");
            FileWriter fw = new FileWriter(file.getAbsoluteFile());
            this.bw = new BufferedWriter(fw);
            this.prepareData(world, x1, y1, z1, x2, y2, z2, rotation);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void prepareData(World world, int x1, int y1, int z1, int x2, int y2, int z2, int rotation) throws IOException {
        int temp;
        int startX = Math.min(x1, x2);
        int startY = Math.min(y1, y2);
        int startZ = Math.min(z1, z2);
        int width = Math.abs(x2 - x1) + 1;
        int height = Math.abs(z2 - z1) + 1;
        int depth = Math.abs(y2 - y1) + 1;
        int offsetX = startX - (int)Math.floor(this.player.field_70142_S);
        int offsetY = startY - (int)Math.floor(this.player.field_70137_T);
        int offsetZ = startZ - (int)Math.floor(this.player.field_70136_U);
        if (rotation == 0) {
            temp = offsetX += width - 1;
            offsetX = offsetZ;
            offsetZ = temp;
            offsetZ *= -1;
        }
        if (rotation == 1) {
            offsetX += width - 1;
            offsetX *= -1;
            offsetZ += height - 1;
            offsetZ *= -1;
        }
        if (rotation == 2) {
            temp = offsetX;
            offsetX = offsetZ += height - 1;
            offsetZ = temp;
            offsetX *= -1;
        }
        int[] offsets = new int[]{offsetX, offsetY, offsetZ};
        this.bw.write("#");
        String[][] names = new String[width][height];
        int[][] metadatas = new int[width][height];
        for (int y = 0; y < depth; ++y) {
            for (int z = 0; z < height; ++z) {
                for (int x = 0; x < width; ++x) {
                    Block block = world.func_147439_a(startX + x, startY + y, startZ + z);
                    String name = GameRegistry.findUniqueIdentifierFor((Block)block).toString();
                    int metadata = world.func_72805_g(startX + x, startY + y, startZ + z);
                    names[x][z] = name;
                    metadatas[x][z] = metadata;
                }
            }
            this.rotateAndFixMetadata(names, metadatas, rotation);
        }
        this.bw.newLine();
        this.bw.write("offset:" + offsets[0] + ":" + offsets[1] + ":" + offsets[2]);
        this.bw.close();
        MaterialList.instance().loadMaterials(this.buildingName);
        ConstructionUtil.addData(this.buildingName);
    }

    private void rotateAndFixMetadata(String[][] ids, int[][] metadatas, int rotation) {
        if (rotation == 3) {
            metadatas = BuildingToFile.rotateM(BuildingToFile.rotateM(BuildingToFile.rotateM(BuildingToFile.fixMetadata(ids, metadatas, 1))));
            ids = BuildingToFile.rotateN(BuildingToFile.rotateN(BuildingToFile.rotateN(ids)));
        } else if (rotation == 0) {
            metadatas = BuildingToFile.rotateM(BuildingToFile.rotateM(BuildingToFile.fixMetadata(ids, metadatas, 2)));
            ids = BuildingToFile.rotateN(BuildingToFile.rotateN(ids));
        } else if (rotation == 1) {
            metadatas = BuildingToFile.rotateM(BuildingToFile.fixMetadata(ids, metadatas, 3));
            ids = BuildingToFile.rotateN(ids);
        }
        this.writeData(ids, metadatas);
    }

    private static String[][] rotateN(String[][] piece) {
        String[][] res = new String[piece[0].length][piece.length];
        for (int x = 0; x < piece.length; ++x) {
            for (int y = 0; y < piece[0].length; ++y) {
                res[res.length - 1 - y][x] = piece[x][y];
            }
        }
        return res;
    }

    private static int[][] rotateM(int[][] piece) {
        int[][] res = new int[piece[0].length][piece.length];
        for (int x = 0; x < piece.length; ++x) {
            for (int y = 0; y < piece[0].length; ++y) {
                res[res.length - 1 - y][x] = piece[x][y];
            }
        }
        return res;
    }

    private static int[][] fixMetadata(String[][] names, int[][] metadata, int times) {
        int[][] newMetadata = metadata;
        String[] generalBlocks = new String[]{"minecraft:ladder", "minecraft:chest", "minecraft:ender_chest", "minecraft:furnace", "minecraft:lit_furnace", "minecraft:piston_head", "minecraft:dispenser", "minecraft:dropper", "minecraft:piston", "minecraft:sticky_piston", "minecraft:hopper"};
        for (int count = 0; count < times; ++count) {
            for (int x = 0; x < names.length; ++x) {
                block2: for (int y = 0; y < names[0].length; ++y) {
                    if (names[x][y] == null) continue;
                    if (names[x][y].equalsIgnoreCase("minecraft:log") | names[x][y].equalsIgnoreCase("minecraft:hay_block")) {
                        if (newMetadata[x][y] == 8) {
                            newMetadata[x][y] = 4;
                        } else if (newMetadata[x][y] == 9) {
                            newMetadata[x][y] = 5;
                        } else if (newMetadata[x][y] == 10) {
                            newMetadata[x][y] = 6;
                        } else if (newMetadata[x][y] == 11) {
                            newMetadata[x][y] = 7;
                        } else if (newMetadata[x][y] == 4) {
                            newMetadata[x][y] = 8;
                        } else if (newMetadata[x][y] == 5) {
                            newMetadata[x][y] = 9;
                        } else if (newMetadata[x][y] == 6) {
                            newMetadata[x][y] = 10;
                        } else if (newMetadata[x][y] == 7) {
                            newMetadata[x][y] = 11;
                        }
                    }
                    if (Block.func_149684_b((String)names[x][y]) instanceof BlockStairs) {
                        if (newMetadata[x][y] == 0) {
                            newMetadata[x][y] = 3;
                        } else if (newMetadata[x][y] == 3) {
                            newMetadata[x][y] = 1;
                        } else if (newMetadata[x][y] == 1) {
                            newMetadata[x][y] = 2;
                        } else if (newMetadata[x][y] == 2) {
                            newMetadata[x][y] = 0;
                        } else if (newMetadata[x][y] == 4) {
                            newMetadata[x][y] = 7;
                        } else if (newMetadata[x][y] == 7) {
                            newMetadata[x][y] = 5;
                        } else if (newMetadata[x][y] == 5) {
                            newMetadata[x][y] = 6;
                        } else if (newMetadata[x][y] == 6) {
                            newMetadata[x][y] = 4;
                        }
                    }
                    if (names[x][y].equalsIgnoreCase("minecraft:bed")) {
                        if (newMetadata[x][y] == 3) {
                            newMetadata[x][y] = 2;
                        } else if (newMetadata[x][y] == 2) {
                            newMetadata[x][y] = 1;
                        } else if (newMetadata[x][y] == 1) {
                            newMetadata[x][y] = 0;
                        } else if (newMetadata[x][y] == 0) {
                            newMetadata[x][y] = 3;
                        } else if (newMetadata[x][y] == 11) {
                            newMetadata[x][y] = 10;
                        } else if (newMetadata[x][y] == 10) {
                            newMetadata[x][y] = 9;
                        } else if (newMetadata[x][y] == 9) {
                            newMetadata[x][y] = 8;
                        } else if (newMetadata[x][y] == 8) {
                            newMetadata[x][y] = 11;
                        }
                    }
                    if (names[x][y].equalsIgnoreCase("minecraft:pumpkin") | names[x][y].equalsIgnoreCase("minecraft:lit_pumpkin") | names[x][y].equalsIgnoreCase("minecraft:tripwire_hook")) {
                        if (newMetadata[x][y] == 1) {
                            newMetadata[x][y] = 0;
                        } else if (newMetadata[x][y] == 0) {
                            newMetadata[x][y] = 3;
                        } else if (newMetadata[x][y] == 3) {
                            newMetadata[x][y] = 2;
                        } else if (newMetadata[x][y] == 2) {
                            newMetadata[x][y] = 1;
                        }
                    }
                    if (Block.func_149684_b((String)names[x][y]) instanceof BlockAnvil | names[x][y].equalsIgnoreCase("minecraft:unpowered_repeater") | names[x][y].equalsIgnoreCase("minecraft:powered_repeater") | names[x][y].equalsIgnoreCase("minecraft:unpowered_comparator") | names[x][y].equalsIgnoreCase("minecraft:powered_comparator")) {
                        if (newMetadata[x][y] == 2) {
                            newMetadata[x][y] = 1;
                        } else if (newMetadata[x][y] == 1) {
                            newMetadata[x][y] = 0;
                        } else if (newMetadata[x][y] == 0) {
                            newMetadata[x][y] = 3;
                        } else if (newMetadata[x][y] == 3) {
                            newMetadata[x][y] = 2;
                        }
                    }
                    if (names[x][y].equalsIgnoreCase("minecraft:stone_button") | names[x][y].equalsIgnoreCase("minecraft:wooden_button") | names[x][y].equalsIgnoreCase("minecraft:lever")) {
                        if (newMetadata[x][y] == 2) {
                            newMetadata[x][y] = 3;
                        } else if (newMetadata[x][y] == 3) {
                            newMetadata[x][y] = 1;
                        } else if (newMetadata[x][y] == 1) {
                            newMetadata[x][y] = 4;
                        } else if (newMetadata[x][y] == 4) {
                            newMetadata[x][y] = 2;
                        } else if (newMetadata[x][y] == 10) {
                            newMetadata[x][y] = 11;
                        } else if (newMetadata[x][y] == 11) {
                            newMetadata[x][y] = 9;
                        } else if (newMetadata[x][y] == 9) {
                            newMetadata[x][y] = 12;
                        } else if (newMetadata[x][y] == 12) {
                            newMetadata[x][y] = 10;
                        }
                    }
                    if (names[x][y].equalsIgnoreCase("minecraft:trapdoor")) {
                        if (newMetadata[x][y] == 2) {
                            newMetadata[x][y] = 1;
                        } else if (newMetadata[x][y] == 1) {
                            newMetadata[x][y] = 0;
                        } else if (newMetadata[x][y] == 0) {
                            newMetadata[x][y] = 3;
                        } else if (newMetadata[x][y] == 3) {
                            newMetadata[x][y] = 2;
                        } else if (newMetadata[x][y] == 6) {
                            newMetadata[x][y] = 5;
                        } else if (newMetadata[x][y] == 5) {
                            newMetadata[x][y] = 7;
                        } else if (newMetadata[x][y] == 7) {
                            newMetadata[x][y] = 4;
                        } else if (newMetadata[x][y] == 4) {
                            newMetadata[x][y] = 6;
                        } else if (newMetadata[x][y] == 10) {
                            newMetadata[x][y] = 9;
                        } else if (newMetadata[x][y] == 9) {
                            newMetadata[x][y] = 11;
                        } else if (newMetadata[x][y] == 11) {
                            newMetadata[x][y] = 8;
                        } else if (newMetadata[x][y] == 8) {
                            newMetadata[x][y] = 10;
                        } else if (newMetadata[x][y] == 14) {
                            newMetadata[x][y] = 13;
                        } else if (newMetadata[x][y] == 13) {
                            newMetadata[x][y] = 15;
                        } else if (newMetadata[x][y] == 15) {
                            newMetadata[x][y] = 12;
                        } else if (newMetadata[x][y] == 12) {
                            newMetadata[x][y] = 14;
                        }
                    }
                    if (names[x][y].equalsIgnoreCase("minecraft:fence_gate") | names[x][y].equalsIgnoreCase("minecraft:wooden_door") | names[x][y].equalsIgnoreCase("minecraft:iron_door")) {
                        if (newMetadata[x][y] == 3) {
                            newMetadata[x][y] = 2;
                        } else if (newMetadata[x][y] == 2) {
                            newMetadata[x][y] = 1;
                        } else if (newMetadata[x][y] == 1) {
                            newMetadata[x][y] = 0;
                        } else if (newMetadata[x][y] == 0) {
                            newMetadata[x][y] = 3;
                        } else if (newMetadata[x][y] == 7) {
                            newMetadata[x][y] = 6;
                        } else if (newMetadata[x][y] == 6) {
                            newMetadata[x][y] = 5;
                        } else if (newMetadata[x][y] == 5) {
                            newMetadata[x][y] = 4;
                        } else if (newMetadata[x][y] == 4) {
                            newMetadata[x][y] = 7;
                        }
                    }
                    if (names[x][y].equalsIgnoreCase("minecraft:sticky_piston") | names[x][y].equalsIgnoreCase("minecraft:piston")) {
                        if (newMetadata[x][y] == 3) {
                            newMetadata[x][y] = 5;
                        } else if (newMetadata[x][y] == 5) {
                            newMetadata[x][y] = 2;
                        } else if (newMetadata[x][y] == 2) {
                            newMetadata[x][y] = 4;
                        } else if (newMetadata[x][y] == 4) {
                            newMetadata[x][y] = 3;
                        } else if (newMetadata[x][y] == 11) {
                            newMetadata[x][y] = 13;
                        } else if (newMetadata[x][y] == 13) {
                            newMetadata[x][y] = 10;
                        } else if (newMetadata[x][y] == 10) {
                            newMetadata[x][y] = 12;
                        } else if (newMetadata[x][y] == 12) {
                            newMetadata[x][y] = 11;
                        }
                    }
                    if (names[x][y].equalsIgnoreCase("minecraft:piston_head")) {
                        if (newMetadata[x][y] == 3) {
                            newMetadata[x][y] = 5;
                        } else if (newMetadata[x][y] == 5) {
                            newMetadata[x][y] = 2;
                        } else if (newMetadata[x][y] == 2) {
                            newMetadata[x][y] = 4;
                        } else if (newMetadata[x][y] == 4) {
                            newMetadata[x][y] = 3;
                        } else if (newMetadata[x][y] == 11) {
                            newMetadata[x][y] = 13;
                        } else if (newMetadata[x][y] == 13) {
                            newMetadata[x][y] = 10;
                        } else if (newMetadata[x][y] == 10) {
                            newMetadata[x][y] = 12;
                        } else if (newMetadata[x][y] == 12) {
                            newMetadata[x][y] = 11;
                        }
                    }
                    if (names[x][y].equalsIgnoreCase("minecraft:torch") | names[x][y].equalsIgnoreCase("minecraft:unlit_redstone_torch") | names[x][y].equalsIgnoreCase("minecraft:redstone_torch")) {
                        if (newMetadata[x][y] == 3) {
                            newMetadata[x][y] = 1;
                        } else if (newMetadata[x][y] == 1) {
                            newMetadata[x][y] = 4;
                        } else if (newMetadata[x][y] == 4) {
                            newMetadata[x][y] = 2;
                        } else if (newMetadata[x][y] == 2) {
                            newMetadata[x][y] = 3;
                        }
                    }
                    if (names[x][y].equalsIgnoreCase("minecraft:vine")) {
                        if (newMetadata[x][y] == 1) {
                            newMetadata[x][y] = 8;
                        } else if (newMetadata[x][y] == 8) {
                            newMetadata[x][y] = 4;
                        } else if (newMetadata[x][y] == 4) {
                            newMetadata[x][y] = 2;
                        } else if (newMetadata[x][y] == 2) {
                            newMetadata[x][y] = 1;
                        }
                    }
                    for (int i = 0; i < generalBlocks.length; ++i) {
                        if (!names[x][y].equalsIgnoreCase(generalBlocks[i])) continue;
                        if (newMetadata[x][y] == 4) {
                            newMetadata[x][y] = 3;
                            continue block2;
                        }
                        if (newMetadata[x][y] == 3) {
                            newMetadata[x][y] = 5;
                            continue block2;
                        }
                        if (newMetadata[x][y] == 5) {
                            newMetadata[x][y] = 2;
                            continue block2;
                        }
                        if (newMetadata[x][y] != 2) continue block2;
                        newMetadata[x][y] = 4;
                        continue block2;
                    }
                }
            }
        }
        return newMetadata;
    }

    private void writeData(String[][] names, int[][] metadatas) {
        try {
            this.bw.newLine();
            for (int z = 0; z < names[0].length; ++z) {
                for (int x = 0; x < names.length; ++x) {
                    String name = names[x][z];
                    int metadata = metadatas[x][z];
                    this.bw.write(name + "-" + metadata + " ");
                }
                this.bw.newLine();
            }
            this.bw.write("#");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

