/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.construction.buildingtools;

import com.mrcrayfish.construction.buildingtools.ConstructionUtil;
import com.mrcrayfish.construction.tileentity.TileEntityBuildingBlock;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import net.minecraft.block.Block;
import net.minecraft.block.BlockAnvil;
import net.minecraft.block.BlockStairs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.IChatComponent;
import net.minecraft.world.World;

public class Construct {
    BufferedReader br;
    String buildingName;
    private static int initX;
    private static int initY;
    private static int initZ;
    private int offsetX;
    private int offsetY;
    private int offsetZ;
    int metadata;

    public Construct(String buildingName, int initX, int initY, int initZ, int metadata) {
        this.buildingName = buildingName;
        Construct.initX = initX;
        Construct.initY = initY;
        Construct.initZ = initZ;
        this.metadata = metadata;
        this.offsetX = ConstructionUtil.getOffsetX(buildingName);
        this.offsetY = ConstructionUtil.getOffsetY(buildingName);
        this.offsetZ = ConstructionUtil.getOffsetZ(buildingName);
    }

    public void constructBuilding(EntityPlayer player, int stage, boolean buildAll) throws IOException {
        EntityPlayerMP playerMP = (EntityPlayerMP)player;
        World world = playerMP.field_70170_p;
        TileEntityBuildingBlock tebb = (TileEntityBuildingBlock)world.func_147438_o(initX, initY, initZ);
        this.offsetX += tebb.offsetX;
        this.offsetY += tebb.offsetY;
        this.offsetZ += tebb.offsetZ;
        File file = new File("buildings/" + this.buildingName + ".txt");
        this.br = new BufferedReader(new InputStreamReader(new FileInputStream(file.getAbsolutePath())));
        String line = null;
        int x = 0;
        int y = -1;
        int z = 0;
        int count = 0;
        int xLength = Construct.getWidth(this.buildingName);
        int yLength = Construct.getHeight(this.buildingName);
        String[][] names = new String[xLength][yLength];
        int[][] metadata = new int[xLength][yLength];
        boolean isBuilding = true;
        if (file.exists()) {
            while (isBuilding) {
                line = this.br.readLine();
                if (line != null) {
                    String[] blockData;
                    String[] blocks;
                    if (line.startsWith("#")) {
                        if (++count > stage && !buildAll) {
                            this.generate(world, y, initX, initY, initZ, names, metadata, this.metadata);
                            isBuilding = false;
                        }
                        if (buildAll) {
                            this.generate(world, y, initX, initY, initZ, names, metadata, this.metadata);
                        }
                        z = 0;
                        if (count == 0) continue;
                        ++y;
                        continue;
                    }
                    if (count == stage && !buildAll) {
                        blocks = line.split("\\s+");
                        for (x = 0; x < blocks.length; ++x) {
                            blockData = blocks[x].split("-");
                            names[x][z] = blockData[0];
                            metadata[x][z] = Integer.parseInt(blockData[1]);
                        }
                        ++z;
                        continue;
                    }
                    if (line.startsWith("#") || line.startsWith("offset")) continue;
                    blocks = line.split("\\s+");
                    for (x = 0; x < blocks.length; ++x) {
                        blockData = blocks[x].split("-");
                        names[x][z] = blockData[0];
                        metadata[x][z] = Integer.parseInt(blockData[1]);
                    }
                    ++z;
                    continue;
                }
                isBuilding = false;
            }
        } else {
            player.func_145747_a((IChatComponent)new ChatComponentText("The structure you are trying to build does not exist on the server. Contact the admin."));
            TileEntity tile_entity = player.field_70170_p.func_147438_o(initX, initY, initZ);
            if (tile_entity instanceof TileEntityBuildingBlock) {
                TileEntityBuildingBlock tileEntityBuildingBlock = (TileEntityBuildingBlock)tile_entity;
                tileEntityBuildingBlock.hasStartedBuilding = false;
            }
        }
    }

    private void generate(World world, int y, int initX, int initY, int initZ, String[][] names, int[][] metadata, int rotation) {
        Block block;
        int z;
        int x;
        String[][] rotatedNames = null;
        int[][] rotatedMetadata = null;
        int offsetX = 0;
        int offsetY = 0;
        int offsetZ = 0;
        offsetY = this.offsetY;
        if (rotation == 2) {
            rotatedNames = Construct.rotateN(Construct.rotateN(names));
            rotatedMetadata = Construct.rotateM(Construct.rotateM(Construct.fixMetadata(names, metadata, 2)));
            offsetX = -this.offsetZ - (rotatedNames.length - 1);
            offsetZ = this.offsetX;
        }
        if (rotation == 5) {
            rotatedNames = Construct.rotateN(Construct.rotateN(Construct.rotateN(names)));
            rotatedMetadata = Construct.rotateM(Construct.rotateM(Construct.rotateM(Construct.fixMetadata(names, metadata, 1))));
            offsetX = -this.offsetX - (rotatedNames.length - 1);
            offsetZ = -this.offsetZ - (rotatedNames[0].length - 1);
        }
        if (rotation == 3) {
            rotatedNames = names;
            rotatedMetadata = metadata;
            offsetX = this.offsetZ;
            offsetZ = -this.offsetX - (rotatedNames[0].length - 1);
        }
        if (rotation == 4) {
            rotatedNames = Construct.rotateN(names);
            rotatedMetadata = Construct.rotateM(Construct.fixMetadata(names, metadata, 3));
            offsetX = this.offsetX;
            offsetZ = this.offsetZ;
        }
        String[][] torchNames = new String[rotatedNames.length][rotatedNames[0].length];
        int[][] torchMetadata = new int[rotatedNames.length][rotatedNames[0].length];
        for (x = 0; x < rotatedNames.length; ++x) {
            for (z = 0; z < rotatedNames[0].length; ++z) {
                if (rotatedNames[x][z] == null || rotatedNames[x][z].equals("minecraft:air")) continue;
                if (rotatedNames[x][z].equals("minecraft:torch") | rotatedNames[x][z] == "minecraft:unlit_redstone_torch" | rotatedNames[x][z] == "minecraft:redstone_torch") {
                    torchNames[x][z] = rotatedNames[x][z];
                    torchMetadata[x][z] = rotatedMetadata[x][z];
                    continue;
                }
                block = Block.func_149684_b((String)rotatedNames[x][z]);
                world.func_147465_d(initX + x + offsetX, initY + y + offsetY, initZ + z + offsetZ, block, rotatedMetadata[x][z], 2);
                if (rotatedNames[x][z].equals("minecraft:wooden_door") | rotatedNames[x][z].equals("minecraft:iron_door")) {
                    world.func_147465_d(initX + x + offsetX, initY + y + offsetY, initZ + z + offsetZ, block, rotatedMetadata[x][z], 1);
                }
                torchNames[x][z] = "minecraft:air";
                torchMetadata[x][z] = 0;
            }
        }
        for (x = 0; x < torchNames.length; ++x) {
            for (z = 0; z < torchNames[0].length; ++z) {
                if (torchNames[x][z] == null || torchNames[x][z].equals("minecraft:air")) continue;
                block = Block.func_149684_b((String)torchNames[x][z]);
                world.func_147465_d(initX + x + offsetX, initY + y + offsetY, initZ + z + offsetZ, block, torchMetadata[x][z], 2);
            }
        }
    }

    private static String[][] rotateN(String[][] piece) {
        String[][] res = new String[piece[0].length][piece.length];
        for (int x = 0; x < piece.length; ++x) {
            for (int y = 0; y < piece[0].length; ++y) {
                res[res.length - 1 - y][x] = piece[x][y];
            }
        }
        return res;
    }

    private static int[][] rotateM(int[][] piece) {
        int[][] res = new int[piece[0].length][piece.length];
        for (int x = 0; x < piece.length; ++x) {
            for (int y = 0; y < piece[0].length; ++y) {
                res[res.length - 1 - y][x] = piece[x][y];
            }
        }
        return res;
    }

    private static int[][] fixMetadata(String[][] names, int[][] metadata, int times) {
        int[][] newMetadata = metadata;
        String[] generalBlocks = new String[]{"minecraft:ladder", "minecraft:chest", "minecraft:ender_chest", "minecraft:furnace", "minecraft:lit_furnace", "minecraft:piston_head", "minecraft:dispenser", "minecraft:dropper", "minecraft:piston", "minecraft:sticky_piston", "minecraft:hopper"};
        for (int count = 0; count < times; ++count) {
            for (int x = 0; x < names.length; ++x) {
                block2: for (int y = 0; y < names[0].length; ++y) {
                    if (names[x][y] == null) continue;
                    if (names[x][y].equalsIgnoreCase("minecraft:log") | names[x][y].equalsIgnoreCase("minecraft:hay_block")) {
                        if (newMetadata[x][y] == 8) {
                            newMetadata[x][y] = 4;
                        } else if (newMetadata[x][y] == 9) {
                            newMetadata[x][y] = 5;
                        } else if (newMetadata[x][y] == 10) {
                            newMetadata[x][y] = 6;
                        } else if (newMetadata[x][y] == 11) {
                            newMetadata[x][y] = 7;
                        } else if (newMetadata[x][y] == 4) {
                            newMetadata[x][y] = 8;
                        } else if (newMetadata[x][y] == 5) {
                            newMetadata[x][y] = 9;
                        } else if (newMetadata[x][y] == 6) {
                            newMetadata[x][y] = 10;
                        } else if (newMetadata[x][y] == 7) {
                            newMetadata[x][y] = 11;
                        }
                    }
                    if (Block.func_149684_b((String)names[x][y]) instanceof BlockStairs) {
                        if (newMetadata[x][y] == 0) {
                            newMetadata[x][y] = 3;
                        } else if (newMetadata[x][y] == 3) {
                            newMetadata[x][y] = 1;
                        } else if (newMetadata[x][y] == 1) {
                            newMetadata[x][y] = 2;
                        } else if (newMetadata[x][y] == 2) {
                            newMetadata[x][y] = 0;
                        } else if (newMetadata[x][y] == 4) {
                            newMetadata[x][y] = 7;
                        } else if (newMetadata[x][y] == 7) {
                            newMetadata[x][y] = 5;
                        } else if (newMetadata[x][y] == 5) {
                            newMetadata[x][y] = 6;
                        } else if (newMetadata[x][y] == 6) {
                            newMetadata[x][y] = 4;
                        }
                    }
                    if (names[x][y].equalsIgnoreCase("minecraft:bed")) {
                        if (newMetadata[x][y] == 3) {
                            newMetadata[x][y] = 2;
                        } else if (newMetadata[x][y] == 2) {
                            newMetadata[x][y] = 1;
                        } else if (newMetadata[x][y] == 1) {
                            newMetadata[x][y] = 0;
                        } else if (newMetadata[x][y] == 0) {
                            newMetadata[x][y] = 3;
                        } else if (newMetadata[x][y] == 11) {
                            newMetadata[x][y] = 10;
                        } else if (newMetadata[x][y] == 10) {
                            newMetadata[x][y] = 9;
                        } else if (newMetadata[x][y] == 9) {
                            newMetadata[x][y] = 8;
                        } else if (newMetadata[x][y] == 8) {
                            newMetadata[x][y] = 11;
                        }
                    }
                    if (names[x][y].equalsIgnoreCase("minecraft:pumpkin") | names[x][y].equalsIgnoreCase("minecraft:lit_pumpkin") | names[x][y].equalsIgnoreCase("minecraft:tripwire_hook")) {
                        if (newMetadata[x][y] == 1) {
                            newMetadata[x][y] = 0;
                        } else if (newMetadata[x][y] == 0) {
                            newMetadata[x][y] = 3;
                        } else if (newMetadata[x][y] == 3) {
                            newMetadata[x][y] = 2;
                        } else if (newMetadata[x][y] == 2) {
                            newMetadata[x][y] = 1;
                        }
                    }
                    if (Block.func_149684_b((String)names[x][y]) instanceof BlockAnvil | names[x][y].equalsIgnoreCase("minecraft:unpowered_repeater") | names[x][y].equalsIgnoreCase("minecraft:powered_repeater") | names[x][y].equalsIgnoreCase("minecraft:unpowered_comparator") | names[x][y].equalsIgnoreCase("minecraft:powered_comparator")) {
                        if (newMetadata[x][y] == 2) {
                            newMetadata[x][y] = 1;
                        } else if (newMetadata[x][y] == 1) {
                            newMetadata[x][y] = 0;
                        } else if (newMetadata[x][y] == 0) {
                            newMetadata[x][y] = 3;
                        } else if (newMetadata[x][y] == 3) {
                            newMetadata[x][y] = 2;
                        }
                    }
                    if (names[x][y].equalsIgnoreCase("minecraft:stone_button") | names[x][y].equalsIgnoreCase("minecraft:wooden_button") | names[x][y].equalsIgnoreCase("minecraft:lever")) {
                        if (newMetadata[x][y] == 2) {
                            newMetadata[x][y] = 3;
                        } else if (newMetadata[x][y] == 3) {
                            newMetadata[x][y] = 1;
                        } else if (newMetadata[x][y] == 1) {
                            newMetadata[x][y] = 4;
                        } else if (newMetadata[x][y] == 4) {
                            newMetadata[x][y] = 2;
                        } else if (newMetadata[x][y] == 10) {
                            newMetadata[x][y] = 11;
                        } else if (newMetadata[x][y] == 11) {
                            newMetadata[x][y] = 9;
                        } else if (newMetadata[x][y] == 9) {
                            newMetadata[x][y] = 12;
                        } else if (newMetadata[x][y] == 12) {
                            newMetadata[x][y] = 10;
                        }
                    }
                    if (names[x][y].equalsIgnoreCase("minecraft:trapdoor")) {
                        if (newMetadata[x][y] == 2) {
                            newMetadata[x][y] = 1;
                        } else if (newMetadata[x][y] == 1) {
                            newMetadata[x][y] = 0;
                        } else if (newMetadata[x][y] == 0) {
                            newMetadata[x][y] = 3;
                        } else if (newMetadata[x][y] == 3) {
                            newMetadata[x][y] = 2;
                        } else if (newMetadata[x][y] == 6) {
                            newMetadata[x][y] = 5;
                        } else if (newMetadata[x][y] == 5) {
                            newMetadata[x][y] = 7;
                        } else if (newMetadata[x][y] == 7) {
                            newMetadata[x][y] = 4;
                        } else if (newMetadata[x][y] == 4) {
                            newMetadata[x][y] = 6;
                        } else if (newMetadata[x][y] == 10) {
                            newMetadata[x][y] = 9;
                        } else if (newMetadata[x][y] == 9) {
                            newMetadata[x][y] = 11;
                        } else if (newMetadata[x][y] == 11) {
                            newMetadata[x][y] = 8;
                        } else if (newMetadata[x][y] == 8) {
                            newMetadata[x][y] = 10;
                        } else if (newMetadata[x][y] == 14) {
                            newMetadata[x][y] = 13;
                        } else if (newMetadata[x][y] == 13) {
                            newMetadata[x][y] = 15;
                        } else if (newMetadata[x][y] == 15) {
                            newMetadata[x][y] = 12;
                        } else if (newMetadata[x][y] == 12) {
                            newMetadata[x][y] = 14;
                        }
                    }
                    if (names[x][y].equalsIgnoreCase("minecraft:fence_gate") | names[x][y].equalsIgnoreCase("minecraft:wooden_door") | names[x][y].equalsIgnoreCase("minecraft:iron_door")) {
                        if (newMetadata[x][y] == 3) {
                            newMetadata[x][y] = 2;
                        } else if (newMetadata[x][y] == 2) {
                            newMetadata[x][y] = 1;
                        } else if (newMetadata[x][y] == 1) {
                            newMetadata[x][y] = 0;
                        } else if (newMetadata[x][y] == 0) {
                            newMetadata[x][y] = 3;
                        } else if (newMetadata[x][y] == 7) {
                            newMetadata[x][y] = 6;
                        } else if (newMetadata[x][y] == 6) {
                            newMetadata[x][y] = 5;
                        } else if (newMetadata[x][y] == 5) {
                            newMetadata[x][y] = 4;
                        } else if (newMetadata[x][y] == 4) {
                            newMetadata[x][y] = 7;
                        }
                    }
                    if (names[x][y].equalsIgnoreCase("minecraft:sticky_piston") | names[x][y].equalsIgnoreCase("minecraft:piston")) {
                        if (newMetadata[x][y] == 3) {
                            newMetadata[x][y] = 5;
                        } else if (newMetadata[x][y] == 5) {
                            newMetadata[x][y] = 2;
                        } else if (newMetadata[x][y] == 2) {
                            newMetadata[x][y] = 4;
                        } else if (newMetadata[x][y] == 4) {
                            newMetadata[x][y] = 3;
                        } else if (newMetadata[x][y] == 11) {
                            newMetadata[x][y] = 13;
                        } else if (newMetadata[x][y] == 13) {
                            newMetadata[x][y] = 10;
                        } else if (newMetadata[x][y] == 10) {
                            newMetadata[x][y] = 12;
                        } else if (newMetadata[x][y] == 12) {
                            newMetadata[x][y] = 11;
                        }
                    }
                    if (names[x][y].equalsIgnoreCase("minecraft:piston_head")) {
                        if (newMetadata[x][y] == 3) {
                            newMetadata[x][y] = 5;
                        } else if (newMetadata[x][y] == 5) {
                            newMetadata[x][y] = 2;
                        } else if (newMetadata[x][y] == 2) {
                            newMetadata[x][y] = 4;
                        } else if (newMetadata[x][y] == 4) {
                            newMetadata[x][y] = 3;
                        } else if (newMetadata[x][y] == 11) {
                            newMetadata[x][y] = 13;
                        } else if (newMetadata[x][y] == 13) {
                            newMetadata[x][y] = 10;
                        } else if (newMetadata[x][y] == 10) {
                            newMetadata[x][y] = 12;
                        } else if (newMetadata[x][y] == 12) {
                            newMetadata[x][y] = 11;
                        }
                    }
                    if (names[x][y].equalsIgnoreCase("minecraft:torch") | names[x][y].equalsIgnoreCase("minecraft:unlit_redstone_torch") | names[x][y].equalsIgnoreCase("minecraft:redstone_torch")) {
                        if (newMetadata[x][y] == 3) {
                            newMetadata[x][y] = 1;
                        } else if (newMetadata[x][y] == 1) {
                            newMetadata[x][y] = 4;
                        } else if (newMetadata[x][y] == 4) {
                            newMetadata[x][y] = 2;
                        } else if (newMetadata[x][y] == 2) {
                            newMetadata[x][y] = 3;
                        }
                    }
                    if (names[x][y].equalsIgnoreCase("minecraft:vine")) {
                        if (newMetadata[x][y] == 1) {
                            newMetadata[x][y] = 8;
                        } else if (newMetadata[x][y] == 8) {
                            newMetadata[x][y] = 4;
                        } else if (newMetadata[x][y] == 4) {
                            newMetadata[x][y] = 2;
                        } else if (newMetadata[x][y] == 2) {
                            newMetadata[x][y] = 1;
                        }
                    }
                    for (int i = 0; i < generalBlocks.length; ++i) {
                        if (!names[x][y].equalsIgnoreCase(generalBlocks[i])) continue;
                        if (newMetadata[x][y] == 4) {
                            newMetadata[x][y] = 3;
                            continue block2;
                        }
                        if (newMetadata[x][y] == 3) {
                            newMetadata[x][y] = 5;
                            continue block2;
                        }
                        if (newMetadata[x][y] == 5) {
                            newMetadata[x][y] = 2;
                            continue block2;
                        }
                        if (newMetadata[x][y] != 2) continue block2;
                        newMetadata[x][y] = 4;
                        continue block2;
                    }
                }
            }
        }
        return newMetadata;
    }

    public static int getWidth(String name) throws IOException {
        File file = new File("buildings/" + name + ".txt");
        BufferedReader br = new BufferedReader(new InputStreamReader(new FileInputStream(file.getAbsolutePath())));
        String line = br.readLine();
        line = br.readLine();
        String[] blocks = line.split("\\s+");
        return blocks.length;
    }

    private static int getHeight(String name) throws IOException {
        int count = -1;
        File file = new File("buildings/" + name + ".txt");
        BufferedReader br = new BufferedReader(new InputStreamReader(new FileInputStream(file.getAbsolutePath())));
        String line = null;
        boolean isReading = true;
        while (isReading && (line = br.readLine()) != null) {
            if (count == -1 | !line.startsWith("#")) {
                ++count;
                continue;
            }
            isReading = false;
        }
        return count;
    }

    public static int getDepth(String buildingName) throws IOException {
        File file = new File("buildings/" + buildingName + ".txt");
        BufferedReader br = new BufferedReader(new InputStreamReader(new FileInputStream(file.getAbsolutePath())));
        int count = 0;
        String line = null;
        while ((line = br.readLine()) != null) {
            if (!line.startsWith("#")) continue;
            ++count;
        }
        return count;
    }

    public static int[] getData(String buildingName) throws IOException {
        File file = new File("buildings/" + buildingName + ".txt");
        BufferedReader br = new BufferedReader(new InputStreamReader(new FileInputStream(file.getAbsolutePath())));
        boolean hasWidth = false;
        boolean hasHeight = false;
        int[] data = new int[6];
        int depth = 0;
        int height = -1;
        String line = null;
        while ((line = br.readLine()) != null) {
            if (line.startsWith("#")) {
                ++depth;
            }
            if (!line.startsWith("#") && !hasWidth) {
                String[] blocks = line.split("\\s+");
                data[0] = blocks.length - 1;
                hasWidth = true;
            }
            if (height == -1 | (!hasHeight && !line.startsWith("#"))) {
                ++height;
                continue;
            }
            hasHeight = true;
        }
        data[1] = height;
        data[2] = depth;
        return data;
    }
}

