/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.construction.network.packets;

import com.mrcrayfish.construction.buildingtools.BuildingToFile;
import com.mrcrayfish.construction.network.AbstractPacket;
import com.mrcrayfish.construction.util.NBTHelper;
import cpw.mods.fml.common.network.ByteBufUtils;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IChatComponent;

public class PacketPencilSave
extends AbstractPacket {
    private String buildingName;
    private int x1;
    private int y1;
    private int z1;
    private int x2;
    private int y2;
    private int z2;
    private int rotation;

    public PacketPencilSave() {
    }

    public PacketPencilSave(String buildingName, int x1, int y1, int z1, int x2, int y2, int z2, int rotation) {
        this.buildingName = buildingName;
        this.x1 = x1;
        this.y1 = y1;
        this.z1 = z1;
        this.x2 = x2;
        this.y2 = y2;
        this.z2 = z2;
        this.rotation = rotation;
    }

    @Override
    public void encodeInto(ChannelHandlerContext ctx, ByteBuf buffer) {
        ByteBufUtils.writeUTF8String((ByteBuf)buffer, (String)this.buildingName);
        buffer.writeInt(this.x1);
        buffer.writeInt(this.y1);
        buffer.writeInt(this.z1);
        buffer.writeInt(this.x2);
        buffer.writeInt(this.y2);
        buffer.writeInt(this.z2);
        buffer.writeInt(this.rotation);
    }

    @Override
    public void decodeInto(ChannelHandlerContext ctx, ByteBuf buffer) {
        this.buildingName = ByteBufUtils.readUTF8String((ByteBuf)buffer);
        this.x1 = buffer.readInt();
        this.y1 = buffer.readInt();
        this.z1 = buffer.readInt();
        this.x2 = buffer.readInt();
        this.y2 = buffer.readInt();
        this.z2 = buffer.readInt();
        this.rotation = buffer.readInt();
    }

    @Override
    public void handleClientSide(EntityPlayer player) {
    }

    @Override
    public void handleServerSide(EntityPlayer player) {
        new BuildingToFile(player, this.buildingName, this.x1, this.y1, this.z1, this.x2, this.y2, this.z2, this.rotation);
        if (player.field_71071_by.func_70448_g() != null) {
            ItemStack currentItem = player.field_71071_by.func_70448_g();
            NBTHelper.setBoolean(currentItem, "corner1", false);
            NBTHelper.setBoolean(currentItem, "corner2", false);
            player.func_70062_b(0, currentItem);
        }
        player.func_145747_a((IChatComponent)new ChatComponentText(EnumChatFormatting.DARK_PURPLE + "---------------------------------------------------"));
        player.func_145747_a((IChatComponent)new ChatComponentText(EnumChatFormatting.AQUA + "Saved the selection as " + this.buildingName + ". You can now draw this selection onto a blueprint through the Planning Table."));
        player.func_145747_a((IChatComponent)new ChatComponentText(EnumChatFormatting.DARK_PURPLE + "---------------------------------------------------"));
        player.func_145747_a((IChatComponent)new ChatComponentText(EnumChatFormatting.AQUA + "If you think your structure is impressive, upload it to http://www.mrcrayfish.com/upload.html for the public to download!"));
        player.func_145747_a((IChatComponent)new ChatComponentText(EnumChatFormatting.DARK_PURPLE + "---------------------------------------------------"));
        player.func_145747_a((IChatComponent)new ChatComponentText(EnumChatFormatting.AQUA + "You can access the saved file at .minecraft/buildings/" + this.buildingName + ".txt"));
    }
}

