/*
 * Decompiled with CFR 0.152.
 */
package aom.common.dimension;

import aom.client.entity.EntityAtlas;
import aom.common.blocks.BlockManager;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.init.Blocks;
import net.minecraft.util.IProgressUpdate;
import net.minecraft.world.ChunkPosition;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.chunk.storage.ExtendedBlockStorage;
import net.minecraft.world.gen.FlatGeneratorInfo;
import net.minecraft.world.gen.FlatLayerInfo;
import net.minecraft.world.gen.NoiseGeneratorOctaves;
import net.minecraft.world.gen.feature.WorldGenDungeons;
import net.minecraft.world.gen.feature.WorldGenLakes;
import net.minecraft.world.gen.structure.MapGenMineshaft;
import net.minecraft.world.gen.structure.MapGenScatteredFeature;
import net.minecraft.world.gen.structure.MapGenStronghold;
import net.minecraft.world.gen.structure.MapGenStructure;
import net.minecraft.world.gen.structure.MapGenVillage;

public class ChunkProviderAtlas
implements IChunkProvider {
    private World worldObj;
    private Random random;
    private final Block[] cachedBlockIDs = new Block[256];
    private final byte[] cachedBlockMetadata = new byte[256];
    private final FlatGeneratorInfo flatWorldGenInfo;
    private final List structureGenerators = new ArrayList();
    private final boolean hasDecoration;
    private final boolean hasDungeons;
    private WorldGenLakes waterLakeGenerator;
    private WorldGenLakes lavaLakeGenerator;
    private static final String __OBFID = "CL_00000391";
    private double[] field_28080_q;
    private double[] field_28079_r;
    private double[] field_28078_s;
    private double[] field_28077_t;
    public Block topBlock;
    public int field_150604_aj;
    public Block fillerBlock;
    public int field_76754_C;
    private NoiseGeneratorOctaves noiseGenerator4;
    private NoiseGeneratorOctaves noiseGenerator5;
    public Block topAetherBlock;
    public Block fillerAetherBlock;

    public ChunkProviderAtlas(World par1World, long par2, boolean par4, String par5Str) {
        this.worldObj = par1World;
        this.random = new Random(par2);
        this.flatWorldGenInfo = FlatGeneratorInfo.func_82651_a((String)par5Str);
        if (par4) {
            Map map = this.flatWorldGenInfo.func_82644_b();
            if (map.containsKey("village")) {
                Map map1 = (Map)map.get("village");
                if (!map1.containsKey("size")) {
                    map1.put("size", "1");
                }
                this.structureGenerators.add(new MapGenVillage(map1));
            }
            if (map.containsKey("biome_1")) {
                this.structureGenerators.add(new MapGenScatteredFeature((Map)map.get("biome_1")));
            }
            if (map.containsKey("mineshaft")) {
                this.structureGenerators.add(new MapGenMineshaft((Map)map.get("mineshaft")));
            }
            if (map.containsKey("stronghold")) {
                this.structureGenerators.add(new MapGenStronghold((Map)map.get("stronghold")));
            }
        }
        this.hasDecoration = this.flatWorldGenInfo.func_82644_b().containsKey("decoration");
        if (this.flatWorldGenInfo.func_82644_b().containsKey("lake")) {
            this.waterLakeGenerator = new WorldGenLakes(Blocks.field_150355_j);
        }
        if (this.flatWorldGenInfo.func_82644_b().containsKey("lava_lake")) {
            this.lavaLakeGenerator = new WorldGenLakes(Blocks.field_150353_l);
        }
        this.hasDungeons = this.flatWorldGenInfo.func_82644_b().containsKey("dungeon");
        for (FlatLayerInfo flatlayerinfo : this.flatWorldGenInfo.func_82650_c()) {
            for (int j = flatlayerinfo.func_82656_d(); j < flatlayerinfo.func_82656_d() + flatlayerinfo.func_82657_a(); ++j) {
                this.cachedBlockIDs[j] = flatlayerinfo.func_151536_b();
                this.cachedBlockMetadata[j] = (byte)flatlayerinfo.func_82658_c();
            }
        }
    }

    public Chunk func_73158_c(int par1, int par2) {
        return this.func_73154_d(par1, par2);
    }

    public void func_28072_a(int i, int j, Block[] abyte0) {
        double d = 0.03125;
        this.field_28079_r = this.noiseGenerator4.func_76304_a(this.field_28079_r, i * 16, j * 16, 0, 16, 16, 1, d, d, 1.0);
        this.field_28078_s = this.noiseGenerator4.func_76304_a(this.field_28078_s, i * 16, 109, j * 16, 16, 1, 16, d, 1.0, d);
        this.field_28077_t = this.noiseGenerator5.func_76304_a(this.field_28077_t, i * 16, j * 16, 0, 16, 16, 1, d * 2.0, d * 2.0, d * 2.0);
        for (int k = 0; k < 16; ++k) {
            for (int l = 0; l < 16; ++l) {
                int i1 = (int)(this.field_28077_t[k + l * 16] / 3.0 + 3.0 + this.random.nextDouble() * 0.25);
                int j1 = -1;
                this.topAetherBlock = Blocks.field_150357_h;
                this.fillerAetherBlock = Blocks.field_150357_h;
                Block byte0 = this.topAetherBlock;
                Block byte1 = this.fillerAetherBlock;
                Block byte2 = BlockManager.holyStone;
                for (int k1 = 127; k1 >= 0; --k1) {
                    int l1 = (l * 16 + k) * 128 + k1;
                    Block byte3 = abyte0[l1];
                    if (byte3 == null) {
                        j1 = -1;
                        continue;
                    }
                    if (byte3 != byte2) continue;
                    if (j1 == -1) {
                        if (i1 <= 0) {
                            byte0 = null;
                            byte1 = byte2;
                        }
                        j1 = i1;
                        if (k1 >= 0) {
                            abyte0[l1] = byte0;
                            continue;
                        }
                        abyte0[l1] = byte1;
                        continue;
                    }
                    if (j1 <= 0) continue;
                    --j1;
                    abyte0[l1] = byte1;
                }
            }
        }
    }

    public Chunk func_73154_d(int par1, int par2) {
        int l;
        Chunk chunk = new Chunk(this.worldObj, par1, par2);
        for (int k = 0; k < this.cachedBlockIDs.length; ++k) {
            Block block = this.cachedBlockIDs[k];
            if (block == null) continue;
            l = k >> 4;
            ExtendedBlockStorage extendedblockstorage = chunk.func_76587_i()[l];
            if (extendedblockstorage == null) {
                chunk.func_76587_i()[l] = extendedblockstorage = new ExtendedBlockStorage(k, !this.worldObj.field_73011_w.field_76576_e);
            }
            for (int i1 = 0; i1 < 16; ++i1) {
                for (int j1 = 0; j1 < 16; ++j1) {
                    extendedblockstorage.func_150818_a(i1, k & 0xF, j1, block);
                    extendedblockstorage.func_76654_b(i1, k & 0xF, j1, (int)this.cachedBlockMetadata[k]);
                }
            }
        }
        chunk.func_76603_b();
        BiomeGenBase[] abiomegenbase = this.worldObj.func_72959_q().func_76933_b((BiomeGenBase[])null, par1 * 16, par2 * 16, 16, 16);
        byte[] abyte = chunk.func_76605_m();
        for (l = 0; l < abyte.length; ++l) {
            abyte[l] = (byte)abiomegenbase[l].field_76756_M;
        }
        for (MapGenStructure mapgenstructure : this.structureGenerators) {
            mapgenstructure.func_151539_a((IChunkProvider)this, this.worldObj, par1, par2, (Block[])null);
        }
        chunk.func_76603_b();
        return chunk;
    }

    public boolean func_73149_a(int par1, int par2) {
        return true;
    }

    public void func_73153_a(IChunkProvider par1IChunkProvider, int par2, int par3) {
        int j2;
        int l1;
        int k = par2 * 16;
        int l = par3 * 16;
        BiomeGenBase biomegenbase = this.worldObj.func_72807_a(k + 16, l + 16);
        boolean flag = false;
        this.random.setSeed(this.worldObj.func_72905_C());
        long i1 = this.random.nextLong() / 2L * 2L + 1L;
        long j1 = this.random.nextLong() / 2L * 2L + 1L;
        this.random.setSeed((long)par2 * i1 + (long)par3 * j1 ^ this.worldObj.func_72905_C());
        for (MapGenStructure mapgenstructure : this.structureGenerators) {
            boolean flag1 = mapgenstructure.func_75051_a(this.worldObj, this.random, par2, par3);
            if (!(mapgenstructure instanceof MapGenVillage)) continue;
            flag |= flag1;
        }
        if (this.waterLakeGenerator != null && !flag && this.random.nextInt(4) == 0) {
            l1 = k + this.random.nextInt(16) + 8;
            int i2 = this.random.nextInt(256);
            j2 = l + this.random.nextInt(16) + 8;
            this.waterLakeGenerator.func_76484_a(this.worldObj, this.random, l1, i2, j2);
        }
        boolean chunk_X = false;
        boolean chunk_Z = false;
        if (!chunk_X && !chunk_Z) {
            EntityAtlas entitydragon = new EntityAtlas(this.worldObj);
            entitydragon.func_70012_b(0.0, 128.0, 0.0, this.random.nextFloat() * 360.0f, 0.0f);
            this.worldObj.func_72838_d((Entity)entitydragon);
        }
        if (this.lavaLakeGenerator != null && !flag && this.random.nextInt(8) == 0) {
            l1 = k + this.random.nextInt(16) + 8;
            int i2 = this.random.nextInt(this.random.nextInt(248) + 8);
            j2 = l + this.random.nextInt(16) + 8;
            if (i2 < 63 || this.random.nextInt(10) == 0) {
                this.lavaLakeGenerator.func_76484_a(this.worldObj, this.random, l1, i2, j2);
            }
        }
        if (this.hasDungeons) {
            for (l1 = 0; l1 < 8; ++l1) {
                int i2 = k + this.random.nextInt(16) + 8;
                j2 = this.random.nextInt(256);
                int k1 = l + this.random.nextInt(16) + 8;
                new WorldGenDungeons().func_76484_a(this.worldObj, this.random, i2, j2, k1);
            }
        }
        if (this.hasDecoration) {
            biomegenbase.func_76728_a(this.worldObj, this.random, k, l);
        }
    }

    public boolean func_73151_a(boolean par1, IProgressUpdate par2IProgressUpdate) {
        return true;
    }

    public void func_104112_b() {
    }

    public boolean func_73156_b() {
        return false;
    }

    public boolean func_73157_c() {
        return true;
    }

    public String func_73148_d() {
        return "FlatLevelSource";
    }

    public List func_73155_a(EnumCreatureType par1EnumCreatureType, int par2, int par3, int par4) {
        BiomeGenBase biomegenbase = this.worldObj.func_72807_a(par2, par4);
        return biomegenbase.func_76747_a(par1EnumCreatureType);
    }

    public ChunkPosition func_147416_a(World p_147416_1_, String p_147416_2_, int p_147416_3_, int p_147416_4_, int p_147416_5_) {
        if ("Stronghold".equals(p_147416_2_)) {
            for (MapGenStructure mapgenstructure : this.structureGenerators) {
                if (!(mapgenstructure instanceof MapGenStronghold)) continue;
                return mapgenstructure.func_151545_a(p_147416_1_, p_147416_3_, p_147416_4_, p_147416_5_);
            }
        }
        return null;
    }

    public int func_73152_e() {
        return 0;
    }

    public void func_82695_e(int par1, int par2) {
        for (MapGenStructure mapgenstructure : this.structureGenerators) {
            mapgenstructure.func_151539_a((IChunkProvider)this, this.worldObj, par1, par2, (Block[])null);
        }
    }
}

