/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.entity;

import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.util.Properties;
import javax.imageio.ImageIO;

public final class PlayerCapeCache {
    private static Properties cacheList;
    private static boolean isLoaded;
    private static final String cacheDirectory = "mods/HDspiffycapes";
    private static final String cacheFile = "capes.properties";

    public static BufferedImage loadcapeByUser(String userName) {
        String capeName;
        if (PlayerCapeCache.loadCacheList() && (capeName = cacheList.getProperty(userName, "")) != "") {
            return PlayerCapeCache.loadcapeByName(capeName);
        }
        return null;
    }

    public static boolean cachecapeByUser(String userName, String capeName, BufferedImage cape) {
        boolean saved = false;
        if (PlayerCapeCache.loadCacheList() && PlayerCapeCache.cachecapeByName(capeName, cape)) {
            try {
                saved = true;
            }
            catch (Exception var5) {
                // empty catch block
            }
        }
        return saved;
    }

    public static BufferedImage loadcapeByName(String capeName) {
        File capeFile;
        BufferedImage cape = null;
        if (PlayerCapeCache.loadCacheList() && (capeFile = new File("mods/HDspiffycapes/" + capeName)).isFile()) {
            try {
                cape = ImageIO.read(capeFile);
            }
            catch (Exception var4) {
                capeFile.delete();
            }
        }
        return cape;
    }

    public static boolean cachecapeByName(String capeName, BufferedImage cape) {
        boolean saved = false;
        if (PlayerCapeCache.loadCacheList()) {
            try {
                File e = new File("mods/HDspiffycapes/" + capeName);
                e.createNewFile();
                ImageIO.write((RenderedImage)cape, "png", e);
                saved = true;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return saved;
    }

    public static boolean updateLastUsed(String userName, String capeName) {
        boolean saved = false;
        if (PlayerCapeCache.loadCacheList()) {
            try {
                cacheList.setProperty(userName, capeName);
                PlayerCapeCache.saveCacheList();
                saved = true;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return saved;
    }

    private static boolean cacheDirExists() {
        File cacheDir = new File(cacheDirectory);
        if (!cacheDir.exists()) {
            cacheDir.mkdirs();
        }
        return cacheDir.exists();
    }

    private static boolean loadCacheList() {
        if (!isLoaded && PlayerCapeCache.cacheDirExists()) {
            cacheList = new Properties();
            try {
                FileInputStream e = new FileInputStream("mods/HDspiffycapes/capes.properties");
                cacheList.load(e);
                e.close();
            }
            catch (Exception var1) {
                cacheList = new Properties();
            }
            isLoaded = true;
        }
        return isLoaded;
    }

    private static boolean saveCacheList() {
        PlayerCapeCache.loadCacheList();
        try {
            FileOutputStream e = new FileOutputStream("mods/HDspiffycapes/capes.properties");
            cacheList.store(e, (String)null);
            e.close();
            return true;
        }
        catch (Exception var1) {
            return false;
        }
    }

    static {
        isLoaded = false;
    }
}

