/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.entity;

import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.util.Properties;
import javax.imageio.ImageIO;

public final class PlayerSkinCache {
    private static Properties cacheList;
    private static boolean isLoaded;
    private static final String cacheDirectory = "mods/HDspiffySkins";
    private static final String cacheFile = "skins.properties";

    public static BufferedImage loadSkinByUser(String userName) {
        String skinName;
        if (PlayerSkinCache.loadCacheList() && (skinName = cacheList.getProperty(userName, "")) != "") {
            return PlayerSkinCache.loadSkinByName(skinName);
        }
        return null;
    }

    public static boolean cacheSkinByUser(String userName, String skinName, BufferedImage skin) {
        boolean saved = false;
        if (PlayerSkinCache.loadCacheList() && PlayerSkinCache.cacheSkinByName(skinName, skin)) {
            try {
                saved = true;
            }
            catch (Exception var5) {
                // empty catch block
            }
        }
        return saved;
    }

    public static BufferedImage loadSkinByName(String skinName) {
        File skinFile;
        BufferedImage skin = null;
        if (PlayerSkinCache.loadCacheList() && (skinFile = new File("mods/HDspiffySkins/" + skinName)).isFile()) {
            try {
                skin = ImageIO.read(skinFile);
            }
            catch (Exception var4) {
                skinFile.delete();
            }
        }
        return skin;
    }

    public static boolean cacheSkinByName(String skinName, BufferedImage skin) {
        boolean saved = false;
        if (PlayerSkinCache.loadCacheList()) {
            try {
                File e = new File("mods/HDspiffySkins/" + skinName);
                e.createNewFile();
                ImageIO.write((RenderedImage)skin, "png", e);
                saved = true;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return saved;
    }

    public static boolean updateLastUsed(String userName, String skinName) {
        boolean saved = false;
        if (PlayerSkinCache.loadCacheList()) {
            try {
                cacheList.setProperty(userName, skinName);
                PlayerSkinCache.saveCacheList();
                saved = true;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return saved;
    }

    private static boolean cacheDirExists() {
        File cacheDir = new File(cacheDirectory);
        if (!cacheDir.exists()) {
            cacheDir.mkdirs();
        }
        return cacheDir.exists();
    }

    private static boolean loadCacheList() {
        if (!isLoaded && PlayerSkinCache.cacheDirExists()) {
            cacheList = new Properties();
            try {
                FileInputStream e = new FileInputStream("mods/HDspiffySkins/skins.properties");
                cacheList.load(e);
                e.close();
            }
            catch (Exception var1) {
                cacheList = new Properties();
            }
            isLoaded = true;
        }
        return isLoaded;
    }

    private static boolean saveCacheList() {
        PlayerSkinCache.loadCacheList();
        try {
            FileOutputStream e = new FileOutputStream("mods/HDspiffySkins/skins.properties");
            cacheList.store(e, (String)null);
            e.close();
            return true;
        }
        catch (Exception var1) {
            return false;
        }
    }

    static {
        isLoaded = false;
    }
}

