/*
 * Decompiled with CFR 0.152.
 */
package ssr;

import cpw.mods.fml.common.FMLLog;
import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLPostInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.event.FMLServerStartingEvent;
import java.io.File;
import net.minecraft.command.ICommand;
import org.apache.logging.log4j.Logger;
import ssr.config.MobBlackList;
import ssr.config.SoulConfig;
import ssr.events.SoulEvents;
import ssr.gameObjs.ObjHandler;
import ssr.utils.CommandKillMobs;
import ssr.utils.EntityWhitelist;
import ssr.utils.TierHandling;

@Mod(modid="SSR", name="Soul Shards: Reborn", version="Alpha 0.8c")
public class SSRCore {
    @Mod.Instance(value="SSR")
    public static SSRCore instance;
    public static final String ID = "SSR";
    public static final String Name = "Soul Shards: Reborn";
    public static final String Version = "Alpha 0.8c";
    public static Logger SoulLog;
    String configDir;
    long timeBegin;
    long timeEnd;

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        this.timeBegin = System.currentTimeMillis();
        this.configDir = event.getModConfigurationDirectory() + "/Soul Shards Reborn/";
        SoulConfig.init(new File(this.configDir + "Main.cfg"));
        TierHandling.init();
        EntityWhitelist.init();
        MobBlackList.init(new File(this.configDir + "Entity Blacklist.cfg"));
        ObjHandler.init();
        SoulEvents.init();
        this.timeEnd = System.currentTimeMillis();
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent event) {
        SoulLog.info("SSR: Mod Loaded successfully in " + (this.timeEnd - this.timeBegin) + " milliseconds");
    }

    @Mod.EventHandler
    public void loadWorld(FMLServerStartingEvent event) {
        event.registerServerCommand((ICommand)new CommandKillMobs());
    }

    static {
        SoulLog = FMLLog.getLogger();
    }
}

