/*
 * Decompiled with CFR 0.152.
 */
package ssr.events;

import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityMobSpawner;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import ssr.config.SoulConfig;
import ssr.gameObjs.ObjHandler;
import ssr.utils.EntityWhitelist;
import ssr.utils.NameTranslation;
import ssr.utils.TierHandling;

public class AbsorbSpawner {
    @SubscribeEvent
    public void playerInteract(PlayerInteractEvent event) {
        EntityPlayer player = event.entityPlayer;
        World world = player.field_70170_p;
        if (!world.field_72995_K && SoulConfig.canAbsorbSpawners && player != null && player.func_70694_bm() != null && player.func_70694_bm().func_77973_b() == ObjHandler.sShard) {
            ItemStack stack = player.func_70694_bm();
            TileEntity tile = world.func_147438_o(event.x, event.y, event.z);
            TileEntityMobSpawner spawner = null;
            if (tile instanceof TileEntityMobSpawner) {
                spawner = (TileEntityMobSpawner)tile;
            }
            if (spawner != null) {
                String entName = spawner.func_145881_a().func_98276_e();
                String translate = NameTranslation.entityName(entName);
                if (EntityWhitelist.isEntityAccepted(translate) && !SoulConfig.easyVanillaAbsorb) {
                    if (!stack.func_77942_o()) {
                        stack.func_77982_d(new NBTTagCompound());
                        stack.field_77990_d.func_74778_a("EntityType", "empty");
                    }
                    NBTTagCompound nbt = stack.field_77990_d;
                    String nbtName = nbt.func_74779_i("EntityType");
                    int nbtKills = nbt.func_74762_e("KillCount");
                    int tier = nbt.func_74762_e("Tier");
                    if ((nbtName.equals("empty") || translate.equals(nbtName)) && (nbtKills != TierHandling.getMax(5) || nbtName.equals("empty"))) {
                        int totalKills = nbtKills + 200;
                        totalKills = totalKills > TierHandling.getMax(5) ? TierHandling.getMax(5) : totalKills;
                        nbt.func_74768_a("KillCount", totalKills);
                        if (nbtName.equals("empty")) {
                            nbt.func_74778_a("EntityType", translate);
                            nbt.func_74778_a("EntityId", entName);
                            EntityLiving entLiv = (EntityLiving)spawner.func_145881_a().func_98281_h();
                            ItemStack heldItem = entLiv.func_71124_b(0);
                            if (heldItem != null && !nbt.func_74767_n("HasItem")) {
                                nbt.func_74757_a("HasItem", true);
                                NBTTagCompound nbt2 = new NBTTagCompound();
                                heldItem.func_77955_b(nbt2);
                                nbt.func_74782_a("Item", (NBTBase)nbt2);
                            }
                        }
                        world.func_147468_f(event.x, event.y, event.z);
                    }
                } else if (SoulConfig.easyVanillaAbsorb) {
                    if (!stack.func_77942_o()) {
                        stack.func_77982_d(new NBTTagCompound());
                        stack.field_77990_d.func_74778_a("EntityType", "empty");
                    }
                    NBTTagCompound nbt = stack.field_77990_d;
                    String nbtName = nbt.func_74779_i("EntityType");
                    int nbtKills = nbt.func_74762_e("KillCount");
                    if (nbtName.equals("empty")) {
                        nbt.func_74778_a("EntityType", translate);
                        nbt.func_74778_a("EntityId", entName);
                        EntityLiving entLiv = (EntityLiving)spawner.func_145881_a().func_98281_h();
                        ItemStack heldItem = entLiv.func_71124_b(0);
                        if (heldItem != null && !nbt.func_74767_n("HasItem")) {
                            nbt.func_74757_a("HasItem", true);
                            NBTTagCompound nbt2 = new NBTTagCompound();
                            heldItem.func_77955_b(nbt2);
                            nbt.func_74782_a("Item", (NBTBase)nbt2);
                        }
                    }
                    if (nbtKills < TierHandling.getMax(5)) {
                        nbtKills = (nbtKills += SoulConfig.vanillaBonus) > TierHandling.getMax(5) ? TierHandling.getMax(5) : nbtKills;
                        nbt.func_74768_a("KillCount", nbtKills);
                        world.func_147468_f(event.x, event.y, event.z);
                    }
                }
            }
        }
    }
}

