/*
 * Decompiled with CFR 0.152.
 */
package tconstruct.blocks.component;

import java.util.ArrayList;
import net.minecraft.block.Block;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagIntArray;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import tconstruct.common.TContent;
import tconstruct.library.component.TankLayerScan;
import tconstruct.library.util.CoordTuple;
import tconstruct.library.util.IServantLogic;

public class SmelteryScan
extends TankLayerScan {
    public ArrayList<CoordTuple> lavaTanks = new ArrayList();

    public SmelteryScan(TileEntity te, Block ... id) {
        super(te, id);
    }

    @Override
    public void checkValidStructure() {
        this.lavaTanks.clear();
        super.checkValidStructure();
    }

    @Override
    protected boolean checkAir(int x, int y, int z) {
        Block block = Block.field_71973_m[this.world.func_72798_a(x, y, z)];
        return block == null || block.isAirBlock(this.world, x, y, z) || block == TContent.tankAir;
    }

    @Override
    protected boolean checkServant(int x, int y, int z) {
        Block block = Block.field_71973_m[this.world.func_72798_a(x, y, z)];
        if (block == null || block.isAirBlock(this.world, x, y, z) || !this.isValidBlock(x, y, z)) {
            return false;
        }
        if (!block.hasTileEntity(this.world.func_72805_g(x, y, z))) {
            return false;
        }
        TileEntity be = this.world.func_72796_p(x, y, z);
        if (be instanceof IServantLogic) {
            boolean ret = ((IServantLogic)be).setPotentialMaster(this.imaster, this.world, x, y, z);
            if (ret && block == TContent.lavaTank) {
                this.lavaTanks.add(new CoordTuple(x, y, z));
            }
            return ret;
        }
        return false;
    }

    @Override
    protected void finalizeStructure() {
        super.finalizeStructure();
        if (this.lavaTanks.size() < 1) {
            this.completeStructure = false;
        } else {
            for (CoordTuple coord : this.airCoords) {
                if (this.world.func_72798_a(coord.x, coord.y, coord.z) == TContent.tankAir.field_71990_ca) continue;
                this.world.func_94575_c(coord.x, coord.y, coord.z, TContent.tankAir.field_71990_ca);
                IServantLogic servant = (IServantLogic)this.world.func_72796_p(coord.x, coord.y, coord.z);
                servant.verifyMaster(this.imaster, this.world, this.master.field_70329_l, this.master.field_70330_m, this.master.field_70327_n);
            }
        }
    }

    @Override
    protected void invalidateStructure() {
        super.invalidateStructure();
        for (CoordTuple coord : this.airCoords) {
            TileEntity servant = this.world.func_72796_p(coord.x, coord.y, coord.z);
            if (!(servant instanceof IServantLogic)) continue;
            ((IServantLogic)servant).invalidateMaster(this.imaster, this.world, this.master.field_70329_l, this.master.field_70330_m, this.master.field_70327_n);
        }
    }

    @Override
    protected void invalidateBlocksAbove(int height) {
        for (CoordTuple coord : this.airCoords) {
            TileEntity servant;
            if (coord.y < height || !((servant = this.world.func_72796_p(coord.x, coord.y, coord.z)) instanceof IServantLogic)) continue;
            ((IServantLogic)servant).invalidateMaster(this.imaster, this.world, this.master.field_70329_l, this.master.field_70330_m, this.master.field_70327_n);
        }
    }

    @Override
    public void cleanup() {
        super.cleanup();
        for (CoordTuple coord : this.airCoords) {
            TileEntity te = this.world.func_72796_p(coord.x, coord.y, coord.z);
            if (te == null || !(te instanceof IServantLogic)) continue;
            ((IServantLogic)te).invalidateMaster(this.imaster, this.world, this.master.field_70329_l, this.master.field_70330_m, this.master.field_70327_n);
        }
    }

    @Override
    public void readNetworkNBT(NBTTagCompound tags) {
        super.readNetworkNBT(tags);
        NBTTagList tanks = tags.func_74761_m("Tanks");
        if (tanks != null) {
            this.lavaTanks.clear();
            for (int i = 0; i < tanks.func_74745_c(); ++i) {
                NBTTagIntArray tag = (NBTTagIntArray)tanks.func_74743_b(i);
                int[] coord = tag.field_74749_a;
                this.layerAirCoords.add(new CoordTuple(coord[0], coord[1], coord[2]));
            }
        }
    }

    @Override
    public void writeNetworkNBT(NBTTagCompound tags) {
        super.writeNetworkNBT(tags);
        NBTTagList tanks = new NBTTagList();
        for (CoordTuple coord : this.lavaTanks) {
            tanks.func_74742_a((NBTBase)new NBTTagIntArray("coord", new int[]{coord.x, coord.y, coord.z}));
        }
        tags.func_74782_a("Tanks", (NBTBase)tanks);
    }
}

