/*
 * Decompiled with CFR 0.152.
 */
package tconstruct.client.block;

import cpw.mods.fml.client.registry.ISimpleBlockRenderingHandler;
import cpw.mods.fml.client.registry.RenderingRegistry;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import tconstruct.blocks.logic.TankAirLogic;
import tconstruct.client.block.BlockSkinRenderHelper;

public class TankAirRender
implements ISimpleBlockRenderingHandler {
    public static int model = RenderingRegistry.getNextAvailableRenderId();
    private static final double capacity = 2592.0;

    public void renderInventoryBlock(Block block, int metadata, int modelID, RenderBlocks renderer) {
    }

    public boolean renderWorldBlock(IBlockAccess world, int x, int y, int z, Block block, int modelID, RenderBlocks renderer) {
        if (modelID == model) {
            TankAirLogic logic = (TankAirLogic)world.func_72796_p(x, y, z);
            if (logic.hasItem()) {
                ItemStack item = logic.func_70301_a(0);
                if (item.func_77973_b() instanceof ItemBlock) {
                    Block inv = Block.field_71973_m[item.field_77993_c];
                    renderer.func_82774_a(inv.func_71858_a(1, item.func_77960_j()));
                    renderer.func_78612_b(inv, x, y, z);
                    renderer.func_78595_a();
                }
            } else if (logic.hasFluids()) {
                int base = 0;
                for (FluidStack fluidstack : logic.getFluids()) {
                    Fluid fluid = fluidstack.getFluid();
                    renderer.func_83020_a(0.0, this.getBaseAmount(base), 0.0, 1.0, this.getHeightAmount(base, fluidstack.amount), 1.0);
                    if (fluid.canBePlacedInWorld()) {
                        BlockSkinRenderHelper.renderMetadataBlock(Block.field_71973_m[fluid.getBlockID()], 0, x, y, z, renderer, world);
                    } else {
                        BlockSkinRenderHelper.renderLiquidBlock(fluid.getStillIcon(), fluid.getFlowingIcon(), x, y, z, renderer, world);
                    }
                    base += fluidstack.amount;
                }
            }
        }
        return true;
    }

    private double getBaseAmount(int base) {
        return (double)base / 2592.0;
    }

    private double getHeightAmount(int base, int amount) {
        return (double)(base + amount) / 2592.0;
    }

    public boolean shouldRender3DInInventory() {
        return true;
    }

    public int getRenderId() {
        return model;
    }
}

