/*
 * Decompiled with CFR 0.152.
 */
package tconstruct.modifiers.tools;

import java.util.Arrays;
import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import tconstruct.library.tools.ToolCore;
import tconstruct.modifiers.tools.ToolModTypeFilter;

public class ModRedstone
extends ToolModTypeFilter {
    String tooltipName = "\u00a74Haste";
    int max = 50;

    public ModRedstone(int effect, ItemStack[] items, int[] values) {
        super(effect, "Redstone", items, values);
    }

    @Override
    protected boolean canModify(ItemStack tool, ItemStack[] input) {
        ToolCore toolItem = (ToolCore)tool.func_77973_b();
        if (!this.validType(toolItem)) {
            return false;
        }
        NBTTagCompound tags = tool.func_77978_p().func_74775_l("InfiTool");
        if (!tags.func_74764_b(this.key)) {
            return tags.func_74762_e("Modifiers") > 0;
        }
        int[] keyPair = tags.func_74759_k(this.key);
        if (keyPair[0] + this.matchingAmount(input) <= keyPair[1]) {
            return true;
        }
        if (keyPair[0] == keyPair[1]) {
            return tags.func_74762_e("Modifiers") > 0;
        }
        return false;
    }

    @Override
    public void modify(ItemStack[] input, ItemStack tool) {
        int modifiers;
        int[] keyPair;
        NBTTagCompound tags = tool.func_77978_p().func_74775_l("InfiTool");
        int increase = this.matchingAmount(input);
        if (tags.func_74764_b(this.key)) {
            keyPair = tags.func_74759_k(this.key);
            if (keyPair[0] % this.max == 0) {
                keyPair[0] = keyPair[0] + increase;
                keyPair[1] = keyPair[1] + this.max;
                tags.func_74783_a(this.key, keyPair);
                modifiers = tags.func_74762_e("Modifiers");
                tags.func_74768_a("Modifiers", --modifiers);
            } else {
                keyPair[0] = keyPair[0] + increase;
                tags.func_74783_a(this.key, keyPair);
            }
            this.updateModTag(tool, keyPair);
        } else {
            modifiers = tags.func_74762_e("Modifiers");
            tags.func_74768_a("Modifiers", --modifiers);
            String modName = "\u00a74Redstone (" + increase + "/" + this.max + ")";
            int tooltipIndex = this.addToolTip(tool, this.tooltipName, modName);
            keyPair = new int[]{increase, this.max, tooltipIndex};
            tags.func_74783_a(this.key, keyPair);
        }
        int miningSpeed = tags.func_74762_e("MiningSpeed");
        tags.func_74768_a("MiningSpeed", miningSpeed += increase * 8);
        String[] type = new String[]{"MiningSpeed2", "MiningSpeedHandle", "MiningSpeedExtra"};
        for (int i = 0; i < 3; ++i) {
            if (!tags.func_74764_b(type[i])) continue;
            int speed = tags.func_74762_e(type[i]);
            tags.func_74768_a(type[i], speed += increase * 8);
        }
        if (tags.func_74764_b("DrawSpeed")) {
            int baseDrawSpeed = tags.func_74762_e("BaseDrawSpeed");
            int drawSpeed = (int)((float)baseDrawSpeed - 0.1f * (float)baseDrawSpeed * ((float)keyPair[0] / 50.0f));
            tags.func_74768_a("DrawSpeed", drawSpeed);
        }
    }

    void updateModTag(ItemStack tool, int[] keys) {
        NBTTagCompound tags = tool.func_77978_p().func_74775_l("InfiTool");
        String tip = "ModifierTip" + keys[2];
        String modName = "\u00a74Redstone (" + keys[0] + "/" + keys[1] + ")";
        tags.func_74778_a(tip, modName);
    }

    @Override
    public boolean validType(ToolCore tool) {
        List<String> list = Arrays.asList(tool.toolCategories());
        return list.contains("harvest") || list.contains("utility") || list.contains("bow");
    }
}

