/*
 * Decompiled with CFR 0.152.
 */
package tconstruct.util.player;

import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.IPlayerTracker;
import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.network.PacketDispatcher;
import cpw.mods.fml.common.network.Player;
import cpw.mods.fml.relauncher.Side;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.lang.ref.WeakReference;
import java.util.Random;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EnumEntitySize;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.network.packet.Packet;
import net.minecraft.network.packet.Packet250CustomPayload;
import net.minecraftforge.event.ForgeSubscribe;
import net.minecraftforge.event.entity.living.LivingFallEvent;
import net.minecraftforge.event.entity.player.PlayerDropsEvent;
import tconstruct.common.TContent;
import tconstruct.library.tools.AbilityHelper;
import tconstruct.util.config.PHConstruct;
import tconstruct.util.player.ArmorExtended;
import tconstruct.util.player.KnapsackInventory;
import tconstruct.util.player.TPlayerStats;

public class TPlayerHandler
implements IPlayerTracker {
    public ConcurrentHashMap<String, TPlayerStats> playerStats = new ConcurrentHashMap();
    Random rand = new Random();

    public void onPlayerLogin(EntityPlayer entityplayer) {
        NBTTagCompound tags = entityplayer.getEntityData();
        if (!tags.func_74764_b("TConstruct")) {
            tags.func_74766_a("TConstruct", new NBTTagCompound());
        }
        TPlayerStats stats = new TPlayerStats();
        stats.player = new WeakReference<EntityPlayer>(entityplayer);
        stats.armor = new ArmorExtended();
        stats.armor.init(entityplayer);
        stats.armor.readFromNBT(entityplayer);
        stats.knapsack = new KnapsackInventory();
        stats.knapsack.init(entityplayer);
        stats.knapsack.readFromNBT(entityplayer);
        stats.level = entityplayer.field_71068_ca;
        stats.hunger = entityplayer.func_71024_bL().func_75116_a();
        stats.beginnerManual = tags.func_74775_l("TConstruct").func_74767_n("beginnerManual");
        stats.materialManual = tags.func_74775_l("TConstruct").func_74767_n("materialManual");
        stats.smelteryManual = tags.func_74775_l("TConstruct").func_74767_n("smelteryManual");
        if (!PHConstruct.enableHealthRegen) {
            entityplayer.field_70170_p.func_82736_K().func_82764_b("naturalRegeneration", "false");
        }
        if (!stats.beginnerManual) {
            NBTTagList list;
            NBTTagCompound compound;
            ItemStack pattern;
            ItemStack diary;
            stats.beginnerManual = true;
            tags.func_74775_l("TConstruct").func_74757_a("beginnerManual", true);
            if (PHConstruct.beginnerBook && !entityplayer.field_71071_by.func_70441_a(diary = new ItemStack(TContent.manualBook))) {
                AbilityHelper.spawnItemAtPlayer(entityplayer, diary);
            }
            if (entityplayer.field_71092_bJ.toLowerCase().equals("fudgy_fetus")) {
                pattern = new ItemStack(TContent.woodPattern, 1, 22);
                compound = new NBTTagCompound();
                compound.func_74766_a("display", new NBTTagCompound());
                compound.func_74775_l("display").func_74778_a("Name", "\u00a7fFudgy_Fetus' Full Guard Pattern");
                list = new NBTTagList();
                list.func_74742_a((NBTBase)new NBTTagString("Lore", "\u00a72\u00a7oThe creator and the creation"));
                list.func_74742_a((NBTBase)new NBTTagString("Lore", "\u00a72\u00a7oare united at last!"));
                compound.func_74775_l("display").func_74782_a("Lore", (NBTBase)list);
                pattern.func_77982_d(compound);
                AbilityHelper.spawnItemAtPlayer(entityplayer, pattern);
            }
            if (entityplayer.field_71092_bJ.toLowerCase().equals("zerokyuuni")) {
                pattern = new ItemStack(Item.field_77669_D);
                compound = new NBTTagCompound();
                compound.func_74766_a("display", new NBTTagCompound());
                compound.func_74775_l("display").func_74778_a("Name", "\u00a78Cheaty Inventory");
                list = new NBTTagList();
                list.func_74742_a((NBTBase)new NBTTagString("Lore", "\u00a72\u00a7oNyaa~"));
                compound.func_74775_l("display").func_74782_a("Lore", (NBTBase)list);
                pattern.func_77982_d(compound);
                AbilityHelper.spawnItemAtPlayer(entityplayer, pattern);
            }
        }
        this.playerStats.put(entityplayer.field_71092_bJ, stats);
        if (PHConstruct.gregtech && Loader.isModLoaded((String)"GregTech-Addon")) {
            PHConstruct.gregtech = false;
            if (PHConstruct.lavaFortuneInteraction) {
                entityplayer.func_71035_c("Warning: Cross-mod Exploit Present!");
                entityplayer.func_71035_c("Solution 1: Disable Reverse Smelting recipes from GregTech.");
                entityplayer.func_71035_c("Solution 2: Disable Auto-Smelt/Fortune interaction from TConstruct.");
            }
        }
        this.updatePlayerInventory(entityplayer, stats);
    }

    void updatePlayerInventory(EntityPlayer player, TPlayerStats stats) {
        ByteArrayOutputStream bos = new ByteArrayOutputStream(8);
        DataOutputStream outputStream = new DataOutputStream(bos);
        try {
            outputStream.writeByte(4);
            stats.armor.writeInventoryToStream(outputStream);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        Packet250CustomPayload packet = new Packet250CustomPayload();
        packet.field_73630_a = "TConstruct";
        packet.field_73629_c = bos.toByteArray();
        packet.field_73628_b = bos.size();
        PacketDispatcher.sendPacketToPlayer((Packet)packet, (Player)((Player)player));
    }

    public void onPlayerLogout(EntityPlayer entityplayer) {
        this.savePlayerStats(entityplayer, true);
    }

    public void onPlayerChangedDimension(EntityPlayer entityplayer) {
        this.savePlayerStats(entityplayer, false);
        this.updatePlayerInventory(entityplayer, this.getPlayerStats(entityplayer.field_71092_bJ));
    }

    void savePlayerStats(EntityPlayer player, boolean clean) {
        TPlayerStats stats;
        if (player != null && (stats = this.getPlayerStats(player.field_71092_bJ)) != null && stats.armor != null) {
            stats.armor.saveToNBT(player);
            stats.knapsack.saveToNBT(player);
            if (clean) {
                this.playerStats.remove(player.field_71092_bJ);
            }
        }
    }

    public void onPlayerRespawn(EntityPlayer entityplayer) {
        TPlayerStats stats = this.getPlayerStats(entityplayer.field_71092_bJ);
        stats.player = new WeakReference<EntityPlayer>(entityplayer);
        stats.armor.recalculateHealth(entityplayer, stats);
        if (PHConstruct.keepLevels) {
            entityplayer.field_71068_ca = stats.level;
        }
        if (PHConstruct.keepHunger) {
            entityplayer.func_71024_bL().func_75122_a(-1 * (20 - stats.hunger), 0.0f);
        }
        NBTTagCompound tags = entityplayer.getEntityData();
        NBTTagCompound tTag = new NBTTagCompound();
        tTag.func_74757_a("beginnerManual", stats.beginnerManual);
        tTag.func_74757_a("materialManual", stats.materialManual);
        tTag.func_74757_a("smelteryManual", stats.smelteryManual);
        tags.func_74766_a("TConstruct", tTag);
        Side side = FMLCommonHandler.instance().getEffectiveSide();
        if (side == Side.CLIENT && PHConstruct.keepHunger) {
            entityplayer.func_71024_bL().func_75114_a(stats.hunger);
        }
        this.updatePlayerInventory(entityplayer, this.getPlayerStats(entityplayer.field_71092_bJ));
    }

    @ForgeSubscribe
    public void livingFall(LivingFallEvent evt) {
        if (evt.entityLiving instanceof EntityPlayer) {
            evt.distance -= 1.0f;
        }
    }

    @ForgeSubscribe
    public void playerDrops(PlayerDropsEvent evt) {
        TPlayerStats stats = this.getPlayerStats(evt.entityPlayer.field_71092_bJ);
        stats.level = evt.entityPlayer.field_71068_ca / 2;
        int hunger = evt.entityPlayer.func_71024_bL().func_75116_a();
        stats.hunger = hunger < 6 ? 6 : evt.entityPlayer.func_71024_bL().func_75116_a();
    }

    public TPlayerStats getPlayerStats(String username) {
        TPlayerStats stats = this.playerStats.get(username);
        if (stats == null) {
            stats = new TPlayerStats();
            this.playerStats.put(username, stats);
        }
        return stats;
    }

    public EntityPlayer getEntityPlayer(String username) {
        TPlayerStats stats = this.playerStats.get(username);
        if (stats == null) {
            return null;
        }
        return (EntityPlayer)stats.player.get();
    }

    public void updateSize(String user, float offset) {
    }

    public static void setEntitySize(float width, float height, Entity entity) {
        float que;
        if (width != entity.field_70130_N || height != entity.field_70131_O) {
            entity.field_70130_N = width;
            entity.field_70131_O = height;
            entity.field_70121_D.field_72336_d = entity.field_70121_D.field_72340_a + (double)entity.field_70130_N;
            entity.field_70121_D.field_72334_f = entity.field_70121_D.field_72339_c + (double)entity.field_70130_N;
            entity.field_70121_D.field_72337_e = entity.field_70121_D.field_72338_b + (double)entity.field_70131_O;
        }
        entity.field_70168_am = (double)(que = width % 2.0f) < 0.375 ? EnumEntitySize.SIZE_1 : ((double)que < 0.75 ? EnumEntitySize.SIZE_2 : ((double)que < 1.0 ? EnumEntitySize.SIZE_3 : ((double)que < 1.375 ? EnumEntitySize.SIZE_4 : ((double)que < 1.75 ? EnumEntitySize.SIZE_5 : EnumEntitySize.SIZE_6))));
    }
}

