/*
 * Decompiled with CFR 0.152.
 */
package tconstruct.blocks;

import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.Icon;
import net.minecraft.world.World;
import tconstruct.TConstruct;
import tconstruct.blocks.logic.CraftingStationLogic;
import tconstruct.blocks.logic.PartBuilderLogic;
import tconstruct.blocks.logic.PatternChestLogic;
import tconstruct.blocks.logic.StencilTableLogic;
import tconstruct.blocks.logic.ToolForgeLogic;
import tconstruct.blocks.logic.ToolStationLogic;
import tconstruct.common.TContent;
import tconstruct.common.TProxyCommon;
import tconstruct.library.TConstructRegistry;
import tconstruct.library.blocks.InventorySlab;
import tconstruct.util.config.PHConstruct;

public class CraftingSlab
extends InventorySlab {
    public CraftingSlab(int id, Material material) {
        super(id, material);
        this.func_71849_a(TConstructRegistry.blockTab);
        this.func_71848_c(2.0f);
        this.func_71884_a(Block.field_71967_e);
    }

    @Override
    public String[] getTextureNames() {
        String[] textureNames = new String[]{"craftingstation_top", "craftingstation_slab_side", "craftingstation_bottom", "toolstation_top", "toolstation_slab_side", "toolstation_bottom", "partbuilder_oak_top", "partbuilder_slab_side", "partbuilder_oak_bottom", "stenciltable_oak_top", "stenciltable_slab_side", "stenciltable_oak_bottom", "patternchest_top", "patternchest_slab_side", "patternchest_bottom", "toolforge_top", "toolforge_slab_side", "toolforge_top"};
        return textureNames;
    }

    public Icon func_71858_a(int side, int meta) {
        return this.icons[meta % 8 * 3 + this.getTextureIndex(side)];
    }

    public int getTextureIndex(int side) {
        if (side == 0) {
            return 2;
        }
        if (side == 1) {
            return 0;
        }
        return 1;
    }

    public AxisAlignedBB func_71911_a_(World world, int x, int y, int z) {
        int metadata = world.func_72805_g(x, y, z);
        if (metadata == 5) {
            return AxisAlignedBB.func_72332_a().func_72299_a((double)x + this.field_72026_ch, (double)y + this.field_72023_ci, (double)z + this.field_72024_cj, (double)x + this.field_72021_ck, (double)y + this.field_72022_cl - 0.125, (double)z + this.field_72019_cm);
        }
        return AxisAlignedBB.func_72332_a().func_72299_a((double)x + this.field_72026_ch, (double)y + this.field_72023_ci, (double)z + this.field_72024_cj, (double)x + this.field_72021_ck, (double)y + this.field_72022_cl, (double)z + this.field_72019_cm);
    }

    @Override
    public TileEntity createTileEntity(World world, int metadata) {
        switch (metadata % 8) {
            case 0: {
                return new CraftingStationLogic();
            }
            case 1: {
                return new ToolStationLogic();
            }
            case 2: {
                return new PartBuilderLogic();
            }
            case 3: {
                return new StencilTableLogic();
            }
            case 4: {
                return new PatternChestLogic();
            }
            case 5: {
                return new ToolForgeLogic();
            }
        }
        return null;
    }

    @Override
    public Integer getGui(World world, int x, int y, int z, EntityPlayer entityplayer) {
        int meta = world.func_72805_g(x, y, z) % 8;
        switch (meta) {
            case 0: {
                return TProxyCommon.craftingStationID;
            }
            case 1: {
                return TProxyCommon.toolStationID;
            }
            case 2: {
                return TProxyCommon.partBuilderID;
            }
            case 3: {
                return TProxyCommon.stencilTableID;
            }
            case 4: {
                return TProxyCommon.patternChestID;
            }
            case 5: {
                return TProxyCommon.toolForgeID;
            }
        }
        return -1;
    }

    @Override
    public Object getModInstance() {
        return TConstruct.instance;
    }

    public void func_71879_a(int id, CreativeTabs tab, List list) {
        for (int iter = 0; iter < 6; ++iter) {
            list.add(new ItemStack(id, 1, iter));
        }
    }

    @Override
    public void func_71860_a(World world, int x, int y, int z, EntityLivingBase entityliving, ItemStack stack) {
        int meta;
        if (PHConstruct.freePatterns && (meta = world.func_72805_g(x, y, z)) == 4) {
            PatternChestLogic logic = (PatternChestLogic)world.func_72796_p(x, y, z);
            for (int i = 1; i <= 13; ++i) {
                logic.func_70299_a(i - 1, new ItemStack(TContent.woodPattern, 1, i));
            }
            logic.func_70299_a(13, new ItemStack(TContent.woodPattern, 1, 22));
        }
        super.func_71860_a(world, x, y, z, entityliving, stack);
    }
}

