/*
 * Decompiled with CFR 0.152.
 */
package tconstruct.items.tools;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import mods.battlegear2.items.ItemShield;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.Icon;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import tconstruct.common.TContent;
import tconstruct.library.ActiveToolMod;
import tconstruct.library.TConstructRegistry;
import tconstruct.library.crafting.ToolBuilder;
import tconstruct.library.tools.AbilityHelper;
import tconstruct.library.tools.HarvestTool;

public class Hammer
extends HarvestTool {
    static Material[] materials = new Material[]{Material.field_76246_e, Material.field_76243_f, Material.field_76260_u, Material.field_76264_q, Material.field_76233_E, Material.field_82717_g};

    public Hammer(int itemID) {
        super(itemID, 2);
        this.func_77655_b("InfiTool.Hammer");
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public int getRenderPasses(int metadata) {
        return 10;
    }

    @Override
    public int getPartAmount() {
        return 4;
    }

    @Override
    public int durabilityTypeAccessory() {
        return 2;
    }

    @Override
    public int durabilityTypeExtra() {
        return 2;
    }

    @Override
    protected String getHarvestType() {
        return "pickaxe";
    }

    @Override
    protected Material[] getEffectiveMaterials() {
        return materials;
    }

    @Override
    public Item getHeadItem() {
        return TContent.hammerHead;
    }

    @Override
    public Item getHandleItem() {
        return TContent.toughRod;
    }

    @Override
    public Item getAccessoryItem() {
        return TContent.largePlate;
    }

    @Override
    public Item getExtraItem() {
        return TContent.largePlate;
    }

    @Override
    public float getDurabilityModifier() {
        return 4.5f;
    }

    @Override
    public String getIconSuffix(int partType) {
        switch (partType) {
            case 0: {
                return "_hammer_head";
            }
            case 1: {
                return "_hammer_handle_broken";
            }
            case 2: {
                return "_hammer_handle";
            }
            case 3: {
                return "_hammer_front";
            }
            case 4: {
                return "_hammer_back";
            }
        }
        return "";
    }

    @Override
    public String getEffectSuffix() {
        return "_hammer_effect";
    }

    @Override
    public String getDefaultFolder() {
        return "hammer";
    }

    @Override
    public Icon getIcon(ItemStack stack, int renderPass) {
        NBTTagCompound tags = stack.func_77978_p();
        if (tags != null) {
            tags = stack.func_77978_p().func_74775_l("InfiTool");
            if (renderPass < this.getPartAmount()) {
                if (renderPass == 0) {
                    if (tags.func_74767_n("Broken")) {
                        return (Icon)this.brokenIcons.get(tags.func_74762_e("RenderHandle"));
                    }
                    return (Icon)this.handleIcons.get(tags.func_74762_e("RenderHandle"));
                }
                if (renderPass == 1) {
                    return (Icon)this.headIcons.get(tags.func_74762_e("RenderHead"));
                }
                if (renderPass == 2) {
                    return (Icon)this.accessoryIcons.get(tags.func_74762_e("RenderAccessory"));
                }
                if (renderPass == 3) {
                    return (Icon)this.extraIcons.get(tags.func_74762_e("RenderExtra"));
                }
            } else if (renderPass == this.getPartAmount()) {
                if (tags.func_74764_b("Effect1")) {
                    return (Icon)this.effectIcons.get(tags.func_74762_e("Effect1"));
                }
            } else if (renderPass == this.getPartAmount() + 1) {
                if (tags.func_74764_b("Effect2")) {
                    return (Icon)this.effectIcons.get(tags.func_74762_e("Effect2"));
                }
            } else if (renderPass == this.getPartAmount() + 2) {
                if (tags.func_74764_b("Effect3")) {
                    return (Icon)this.effectIcons.get(tags.func_74762_e("Effect3"));
                }
            } else if (renderPass == this.getPartAmount() + 3) {
                if (tags.func_74764_b("Effect4")) {
                    return (Icon)this.effectIcons.get(tags.func_74762_e("Effect4"));
                }
            } else if (renderPass == this.getPartAmount() + 4) {
                if (tags.func_74764_b("Effect5")) {
                    return (Icon)this.effectIcons.get(tags.func_74762_e("Effect5"));
                }
            } else if (renderPass == this.getPartAmount() + 5 && tags.func_74764_b("Effect6")) {
                return (Icon)this.effectIcons.get(tags.func_74762_e("Effect6"));
            }
            return blankSprite;
        }
        return emptyIcon;
    }

    @Override
    public void func_77633_a(int id, CreativeTabs tab, List list) {
        super.func_77633_a(id, tab, list);
        ItemStack tool = ToolBuilder.instance.buildTool(new ItemStack(this.getHeadItem(), 1, 10), new ItemStack(this.getHandleItem(), 1, 8), new ItemStack(this.getAccessoryItem(), 1, 11), new ItemStack(this.getExtraItem(), 1, 11), "InfiMiner");
        NBTTagCompound tags = tool.func_77978_p().func_74775_l("InfiTool");
        tags.func_74768_a("Modifiers", 0);
        tags.func_74768_a("Attack", 21474836);
        tags.func_74768_a("TotalDurability", 21474836);
        tags.func_74768_a("BaseDurability", 21474836);
        tags.func_74768_a("MiningSpeed", 21474836);
        tags.func_74768_a("Unbreaking", 10);
        tags.func_74757_a("Built", true);
        list.add(tool);
    }

    @Override
    public boolean onBlockStartBreak(ItemStack stack, int x, int y, int z, EntityPlayer player) {
        MovingObjectPosition mop;
        if (!stack.func_77942_o()) {
            return false;
        }
        World world = player.field_70170_p;
        int blockID = world.func_72798_a(x, y, z);
        int meta = world.func_72805_g(x, y, z);
        Block block = Block.field_71973_m[blockID];
        if (!stack.func_77942_o()) {
            return false;
        }
        if (block == null) {
            return super.onBlockStartBreak(stack, x, y, z, player);
        }
        float blockHardness = block.func_71934_m(world, x, y, z);
        boolean validStart = false;
        for (int iter = 0; iter < materials.length; ++iter) {
            if (materials[iter] != block.field_72018_cp) continue;
            validStart = true;
            break;
        }
        if (block == Block.field_72006_bl) {
            validStart = true;
        }
        if ((mop = AbilityHelper.raytraceFromEntity(world, (Entity)player, true, 4.5)) == null || !validStart) {
            return super.onBlockStartBreak(stack, x, y, z, player);
        }
        int xRange = 1;
        int yRange = 1;
        int zRange = 1;
        switch (mop.field_72310_e) {
            case 0: 
            case 1: {
                yRange = 0;
                break;
            }
            case 2: 
            case 3: {
                zRange = 0;
                break;
            }
            case 4: 
            case 5: {
                xRange = 0;
            }
        }
        NBTTagCompound tags = stack.func_77978_p().func_74775_l("InfiTool");
        int toolLevel = tags.func_74762_e("HarvestLevel");
        for (int xPos = x - xRange; xPos <= x + xRange; ++xPos) {
            for (int yPos = y - yRange; yPos <= y + yRange; ++yPos) {
                for (int zPos = z - zRange; zPos <= z + zRange; ++zPos) {
                    float localHardness;
                    if (tags.func_74767_n("Broken")) continue;
                    int localblockID = world.func_72798_a(xPos, yPos, zPos);
                    Block localBlock = Block.field_71973_m[localblockID];
                    int localMeta = world.func_72805_g(xPos, yPos, zPos);
                    int hlvl = MinecraftForge.getBlockHarvestLevel((Block)localBlock, (int)localMeta, (String)this.getHarvestType());
                    float f = localHardness = localBlock == null ? Float.MAX_VALUE : localBlock.func_71934_m(world, xPos, yPos, zPos);
                    if (hlvl > toolLevel || !((double)localHardness - 1.5 <= (double)blockHardness)) continue;
                    boolean cancelHarvest = false;
                    for (ActiveToolMod mod : TConstructRegistry.activeModifiers) {
                        if (!mod.beforeBlockBreak(this, stack, xPos, yPos, zPos, (EntityLivingBase)player)) continue;
                        cancelHarvest = true;
                    }
                    if (cancelHarvest || localBlock == null || localHardness < 0.0f) continue;
                    for (int iter = 0; iter < materials.length; ++iter) {
                        if (materials[iter] != localBlock.field_72018_cp && localBlock != Block.field_72006_bl) continue;
                        if (!player.field_71075_bZ.field_75098_d) {
                            if (localBlock.removeBlockByPlayer(world, player, xPos, yPos, zPos)) {
                                localBlock.func_71898_d(world, xPos, yPos, zPos, localMeta);
                            }
                            localBlock.func_71893_a(world, player, xPos, yPos, zPos, localMeta);
                            localBlock.func_71846_a(world, xPos, yPos, zPos, localMeta, player);
                            if (!(blockHardness > 0.0f)) continue;
                            this.func_77660_a(stack, world, localblockID, xPos, yPos, zPos, (EntityLivingBase)player);
                            continue;
                        }
                        world.func_94571_i(xPos, yPos, zPos);
                    }
                }
            }
        }
        if (!world.field_72995_K) {
            world.func_72926_e(2001, x, y, z, blockID + (meta << 12));
        }
        return true;
    }

    @Override
    public float getStrVsBlock(ItemStack stack, Block block, int meta) {
        if (!stack.func_77942_o()) {
            return 1.0f;
        }
        NBTTagCompound tags = stack.func_77978_p().func_74775_l("InfiTool");
        if (tags.func_74767_n("Broken")) {
            return 0.1f;
        }
        Material[] materials = this.getEffectiveMaterials();
        for (int i = 0; i < materials.length; ++i) {
            if (materials[i] != block.field_72018_cp) continue;
            return this.getblockSpeed(tags, block, meta);
        }
        return super.getStrVsBlock(stack, block, meta);
    }

    float getblockSpeed(NBTTagCompound tags, Block block, int meta) {
        float mineSpeed = tags.func_74762_e("MiningSpeed");
        int heads = 1;
        if (tags.func_74764_b("MiningSpeed2")) {
            mineSpeed += (float)tags.func_74762_e("MiningSpeed2");
            ++heads;
        }
        if (tags.func_74764_b("MiningSpeedHandle")) {
            mineSpeed += (float)tags.func_74762_e("MiningSpeedHandle");
            ++heads;
        }
        if (tags.func_74764_b("MiningSpeedExtra")) {
            mineSpeed += (float)tags.func_74762_e("MiningSpeedExtra");
            ++heads;
        }
        float trueSpeed = mineSpeed / ((float)heads * 300.0f);
        int hlvl = MinecraftForge.getBlockHarvestLevel((Block)block, (int)meta, (String)this.getHarvestType());
        int durability = tags.func_74762_e("Damage");
        float stonebound = tags.func_74760_g("Shoddy");
        float bonusLog = (float)Math.log((float)durability / 216.0f + 1.0f) * 2.0f * stonebound;
        trueSpeed += bonusLog;
        if (hlvl <= tags.func_74762_e("HarvestLevel")) {
            return trueSpeed;
        }
        return 0.1f;
    }

    @Override
    public String[] toolCategories() {
        return new String[]{"weapon", "harvest", "melee", "bludgeoning"};
    }

    @Override
    public boolean allowOffhand(ItemStack mainhand, ItemStack offhand) {
        try {
            return offhand.func_77973_b() instanceof ItemShield;
        }
        catch (Exception e) {
            return false;
        }
    }

    @Override
    public boolean isOffhandHandDual(ItemStack off) {
        return false;
    }

    @Override
    public boolean sheatheOnBack(ItemStack item) {
        return true;
    }

    @Override
    public boolean willAllowOffhandWeapon() {
        return false;
    }

    @Override
    public boolean isOffhandHandDualWeapon() {
        return false;
    }

    @Override
    public boolean sheatheOnBack() {
        return true;
    }
}

