/*
 * Decompiled with CFR 0.152.
 */
package SecurityCraft.forge.network.packets;

import SecurityCraft.forge.mod_SecurityCraft;
import SecurityCraft.forge.network.packets.AbstractPacket;
import SecurityCraft.forge.network.packets.PacketCheckKeypadCode;
import SecurityCraft.forge.network.packets.PacketCreateExplosion;
import SecurityCraft.forge.network.packets.PacketSetBlock;
import SecurityCraft.forge.network.packets.PacketSetISFields;
import SecurityCraft.forge.network.packets.PacketSetKeycardLevel;
import SecurityCraft.forge.network.packets.PacketSetKeypadCode;
import SecurityCraft.forge.network.packets.PacketUpdateClient;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.network.FMLEmbeddedChannel;
import cpw.mods.fml.common.network.FMLOutboundHandler;
import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.common.network.internal.FMLProxyPacket;
import cpw.mods.fml.relauncher.Side;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.MessageToMessageCodec;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumMap;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.network.INetHandler;
import net.minecraft.network.NetHandlerPlayServer;

@ChannelHandler.Sharable
public class PacketPipeline
extends MessageToMessageCodec<FMLProxyPacket, AbstractPacket> {
    private EnumMap<Side, FMLEmbeddedChannel> channels;
    private LinkedList<Class<? extends AbstractPacket>> packets = new LinkedList();
    private boolean isPostInitialized = false;

    public boolean registerPacket(Class<? extends AbstractPacket> par1Class) {
        if (this.packets.size() > 256) {
            mod_SecurityCraft.log("Packet size is over 256! This may not work correctly.", true);
            return false;
        }
        if (this.packets.contains(par1Class)) {
            mod_SecurityCraft.log("Packets list already contains " + par1Class.getCanonicalName() + ". There is no need to re-register it.");
            return false;
        }
        if (this.isPostInitialized) {
            mod_SecurityCraft.log("Trying to register a packet post-initialization...");
            return false;
        }
        this.packets.add(par1Class);
        return true;
    }

    private void registerPackets() {
        this.registerPacket(PacketSetKeypadCode.class);
        this.registerPacket(PacketCheckKeypadCode.class);
        this.registerPacket(PacketSetISFields.class);
        this.registerPacket(PacketSetBlock.class);
        this.registerPacket(PacketCreateExplosion.class);
        this.registerPacket(PacketSetKeycardLevel.class);
        this.registerPacket(PacketUpdateClient.class);
    }

    protected void encode(ChannelHandlerContext par1Ctx, AbstractPacket par2Packet, List<Object> par3List) throws Exception {
        ByteBuf buffer = Unpooled.buffer();
        Class<?> classObj = par2Packet.getClass();
        if (!this.packets.contains(par2Packet.getClass())) {
            throw new NullPointerException("No packet registered for: " + par2Packet.getClass().getCanonicalName());
        }
        byte discriminator = (byte)this.packets.indexOf(classObj);
        buffer.writeByte((int)discriminator);
        par2Packet.encodeInto(par1Ctx, buffer);
        FMLProxyPacket proxyPacket = new FMLProxyPacket(buffer.copy(), (String)par1Ctx.channel().attr(NetworkRegistry.FML_CHANNEL).get());
        par3List.add(proxyPacket);
    }

    protected void decode(ChannelHandlerContext par1Ctx, FMLProxyPacket par2Packet, List<Object> par3List) throws Exception {
        ByteBuf payload = par2Packet.payload();
        byte discriminator = payload.readByte();
        Class<? extends AbstractPacket> classObj = this.packets.get(discriminator);
        if (classObj == null) {
            throw new NullPointerException("No packet registered for discriminator: " + discriminator);
        }
        AbstractPacket packet = classObj.newInstance();
        packet.decodeInto(par1Ctx, payload.slice());
        switch (FMLCommonHandler.instance().getEffectiveSide()) {
            case CLIENT: {
                EntityPlayer player = this.getClientPlayer();
                packet.handleClientSide(player);
                break;
            }
            case SERVER: {
                INetHandler netHandler = (INetHandler)par1Ctx.channel().attr(NetworkRegistry.NET_HANDLER).get();
                EntityPlayerMP player = ((NetHandlerPlayServer)netHandler).field_147369_b;
                packet.handleServerSide((EntityPlayer)player);
                break;
            }
        }
        par3List.add(packet);
    }

    public void initialize() {
        this.channels = NetworkRegistry.INSTANCE.newChannel("SecurityCraft", new ChannelHandler[]{this});
        this.registerPackets();
    }

    public void postInitialize() {
        if (this.isPostInitialized) {
            return;
        }
        this.isPostInitialized = true;
        Collections.sort(this.packets, new Comparator<Class<? extends AbstractPacket>>(){

            @Override
            public int compare(Class<? extends AbstractPacket> par1Class, Class<? extends AbstractPacket> par2Class) {
                int com = String.CASE_INSENSITIVE_ORDER.compare(par1Class.getCanonicalName(), par2Class.getCanonicalName());
                if (com == 0) {
                    com = par1Class.getCanonicalName().compareTo(par2Class.getCanonicalName());
                }
                return com;
            }
        });
    }

    public EntityPlayer getClientPlayer() {
        return Minecraft.func_71410_x().field_71439_g;
    }

    public void sendToAll(AbstractPacket message) {
        this.channels.get(Side.SERVER).writeAndFlush((Object)message);
    }

    public void sendTo(AbstractPacket message, EntityPlayerMP player) {
        this.channels.get(Side.SERVER).attr(FMLOutboundHandler.FML_MESSAGETARGET).set((Object)FMLOutboundHandler.OutboundTarget.PLAYER);
        this.channels.get(Side.SERVER).attr(FMLOutboundHandler.FML_MESSAGETARGETARGS).set((Object)player);
        this.channels.get(Side.SERVER).writeAndFlush((Object)message);
    }

    public void sendToAllAround(AbstractPacket message, NetworkRegistry.TargetPoint point) {
        this.channels.get(Side.SERVER).attr(FMLOutboundHandler.FML_MESSAGETARGET).set((Object)FMLOutboundHandler.OutboundTarget.ALLAROUNDPOINT);
        this.channels.get(Side.SERVER).attr(FMLOutboundHandler.FML_MESSAGETARGETARGS).set((Object)point);
        this.channels.get(Side.SERVER).writeAndFlush((Object)message);
    }

    public void sendToDimension(AbstractPacket message, int dimensionId) {
        this.channels.get(Side.SERVER).attr(FMLOutboundHandler.FML_MESSAGETARGET).set((Object)FMLOutboundHandler.OutboundTarget.DIMENSION);
        this.channels.get(Side.SERVER).attr(FMLOutboundHandler.FML_MESSAGETARGETARGS).set((Object)dimensionId);
        this.channels.get(Side.SERVER).writeAndFlush((Object)message);
    }

    public void sendToServer(AbstractPacket message) {
        this.channels.get(Side.SERVER).attr(FMLOutboundHandler.FML_MESSAGETARGET).set((Object)FMLOutboundHandler.OutboundTarget.TOSERVER);
        this.channels.get(Side.CLIENT).writeAndFlush((Object)message);
    }
}

