/*
 * Decompiled with CFR 0.152.
 */
package mods.battlegear2.api.core;

import com.google.common.io.ByteArrayDataInput;
import com.google.common.io.ByteArrayDataOutput;
import cpw.mods.fml.common.eventhandler.Event;
import cpw.mods.fml.common.eventhandler.EventBus;
import java.io.Closeable;
import java.io.IOException;
import mods.battlegear2.api.IAllowItem;
import mods.battlegear2.api.IOffhandDual;
import mods.battlegear2.api.core.BattlegearTranslator;
import mods.battlegear2.api.core.InventoryPlayerBattle;
import mods.battlegear2.api.shield.IShield;
import mods.battlegear2.api.weapons.IBattlegearWeapon;
import mods.battlegear2.api.weapons.WeaponRegistry;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IEntityMultiPart;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.boss.EntityDragonPart;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.item.EnumAction;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemBow;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemSword;
import net.minecraft.item.ItemTool;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.Potion;
import net.minecraft.stats.AchievementList;
import net.minecraft.stats.StatBase;
import net.minecraft.stats.StatList;
import net.minecraft.util.DamageSource;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.player.AttackEntityEvent;

public class BattlegearUtils {
    public static final EventBus RENDER_BUS = new EventBus();
    private static String[] itemBlackListMethodNames = World.class.getName().equals("net.minecraft.world.World") ? new String[]{"onItemUse", "onItemRightClick"} : new String[]{BattlegearTranslator.getMapedMethodName("Item", "func_77648_a", "onItemUse"), BattlegearTranslator.getMapedMethodName("Item", "func_77659_a", "onItemRightClick")};
    private static Class[][] itemBlackListMethodParams = new Class[][]{{ItemStack.class, EntityPlayer.class, World.class, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, Float.TYPE, Float.TYPE, Float.TYPE}, {ItemStack.class, World.class, EntityPlayer.class}};

    public static boolean isBlockingWithShield(EntityPlayer player) {
        if (!player.func_70093_af()) {
            return false;
        }
        ItemStack offhand = ((InventoryPlayerBattle)player.field_71071_by).getCurrentOffhandWeapon();
        return offhand != null && offhand.func_77973_b() instanceof IShield;
    }

    public static boolean isPlayerInBattlemode(EntityPlayer player) {
        return ((InventoryPlayerBattle)player.field_71071_by).isBattlemode();
    }

    public static void setPlayerCurrentItem(EntityPlayer player, ItemStack stack, int offset) {
        ((InventoryPlayerBattle)player.field_71071_by).setInventorySlotContents(player.field_71071_by.field_70461_c + offset, stack, false);
    }

    public static void setPlayerCurrentItem(EntityPlayer player, ItemStack stack) {
        BattlegearUtils.setPlayerCurrentItem(player, stack, 0);
    }

    public static boolean isWeapon(ItemStack main) {
        boolean valid;
        if (main.func_77973_b() instanceof IBattlegearWeapon) {
            return true;
        }
        if (WeaponRegistry.isWeapon(main)) {
            return true;
        }
        boolean bl = valid = main.func_77976_d() == 1 && main.func_77958_k() > 0 && !main.func_77981_g();
        if (valid) {
            valid = main.func_77973_b() instanceof ItemSword || main.func_77973_b() instanceof ItemBow || main.func_77973_b() instanceof ItemTool;
        }
        return valid;
    }

    public static boolean isMainHand(ItemStack main, ItemStack off) {
        if (main.func_77973_b() instanceof IAllowItem) {
            return ((IAllowItem)main.func_77973_b()).allowOffhand(main, off);
        }
        if (WeaponRegistry.isMainHand(main)) {
            return true;
        }
        if (BattlegearUtils.isWeapon(main)) {
            boolean mainhand;
            boolean rightClick = BattlegearUtils.checkForRightClickFunction(main.func_77973_b(), main);
            boolean offhand = !(main.func_77973_b() instanceof ItemTool) && !(main.func_77973_b() instanceof ItemBow) && !rightClick;
            boolean bl = mainhand = !(main.func_77973_b() instanceof ItemBow) && !rightClick;
            if (mainhand) {
                if (offhand) {
                    WeaponRegistry.addDualWeapon(main);
                } else {
                    WeaponRegistry.addTwoHanded(main);
                }
                return true;
            }
            if (offhand) {
                WeaponRegistry.addOffhandWeapon(main);
            }
        }
        return false;
    }

    public static boolean isOffHand(ItemStack off) {
        if (off.func_77973_b() instanceof IOffhandDual) {
            return ((IOffhandDual)off.func_77973_b()).isOffhandHandDual(off);
        }
        if (off.func_77973_b() instanceof IShield || off.func_77973_b() instanceof ItemBlock) {
            return true;
        }
        if (WeaponRegistry.isOffHand(off)) {
            return true;
        }
        if (BattlegearUtils.isWeapon(off)) {
            boolean mainhand;
            boolean rightClick = BattlegearUtils.checkForRightClickFunction(off.func_77973_b(), off);
            boolean offhand = !(off.func_77973_b() instanceof ItemTool) && !(off.func_77973_b() instanceof ItemBow) && !rightClick;
            boolean bl = mainhand = !(off.func_77973_b() instanceof ItemBow) && !rightClick;
            if (offhand) {
                if (mainhand) {
                    WeaponRegistry.addDualWeapon(off);
                } else {
                    WeaponRegistry.addOffhandWeapon(off);
                }
                return true;
            }
            if (mainhand) {
                WeaponRegistry.addTwoHanded(off);
            }
        }
        return false;
    }

    public static boolean checkForRightClickFunction(Item item, ItemStack stack) {
        try {
            if (item.func_77661_b(stack) == EnumAction.block || item.func_77661_b(stack) == EnumAction.none) {
                Class<?> c = item.getClass();
                while (!(c.equals(Item.class) || c.equals(ItemTool.class) || c.equals(ItemSword.class))) {
                    try {
                        try {
                            c.getDeclaredMethod(itemBlackListMethodNames[0], itemBlackListMethodParams[0]);
                            return true;
                        }
                        catch (NoSuchMethodException ignored) {
                            try {
                                c.getDeclaredMethod(itemBlackListMethodNames[1], itemBlackListMethodParams[1]);
                                return true;
                            }
                            catch (NoSuchMethodException ignored2) {
                            }
                        }
                    }
                    catch (NoClassDefFoundError noClassDefFoundError) {
                        // empty catch block
                    }
                    c = c.getSuperclass();
                }
                return false;
            }
            return true;
        }
        catch (NullPointerException e) {
            return true;
        }
    }

    public static ItemStack readItemStack(ByteArrayDataInput par0DataInputStream) throws IOException {
        ItemStack itemstack = null;
        int short1 = par0DataInputStream.readInt();
        if (short1 >= 0) {
            byte b0 = par0DataInputStream.readByte();
            short short2 = par0DataInputStream.readShort();
            itemstack = new ItemStack(Item.func_150899_d((int)short1), (int)b0, (int)short2);
            itemstack.field_77990_d = BattlegearUtils.readNBTTagCompound(par0DataInputStream);
        }
        return itemstack;
    }

    public static NBTTagCompound readNBTTagCompound(ByteArrayDataInput par0DataInputStream) throws IOException {
        short short1 = par0DataInputStream.readShort();
        if (short1 < 0) {
            return null;
        }
        byte[] abyte = new byte[short1];
        par0DataInputStream.readFully(abyte);
        return CompressedStreamTools.func_74792_a((byte[])abyte);
    }

    public static void writeItemStack(ByteArrayDataOutput par1DataOutputStream, ItemStack par0ItemStack) throws IOException {
        if (par0ItemStack == null) {
            par1DataOutputStream.writeShort(-1);
        } else {
            par1DataOutputStream.writeInt(Item.func_150891_b((Item)par0ItemStack.func_77973_b()));
            par1DataOutputStream.writeByte(par0ItemStack.field_77994_a);
            par1DataOutputStream.writeShort(par0ItemStack.func_77960_j());
            NBTTagCompound nbttagcompound = null;
            if (par0ItemStack.func_77973_b().func_77645_m() || par0ItemStack.func_77973_b().func_77651_p()) {
                nbttagcompound = par0ItemStack.field_77990_d;
            }
            BattlegearUtils.writeNBTTagCompound(nbttagcompound, par1DataOutputStream);
        }
    }

    protected static void writeNBTTagCompound(NBTTagCompound par0NBTTagCompound, ByteArrayDataOutput par1DataOutputStream) throws IOException {
        if (par0NBTTagCompound == null) {
            par1DataOutputStream.writeShort(-1);
        } else {
            byte[] abyte = CompressedStreamTools.func_74798_a((NBTTagCompound)par0NBTTagCompound);
            par1DataOutputStream.writeShort((int)((short)abyte.length));
            par1DataOutputStream.write(abyte);
        }
    }

    public static InventoryPlayer replaceInventory(EntityPlayer entityPlayer) {
        return new InventoryPlayerBattle(entityPlayer);
    }

    public static void attackTargetEntityWithCurrentOffItem(EntityPlayer player, Entity par1Entity) {
        player.field_71071_by.field_70461_c += InventoryPlayerBattle.WEAPON_SETS;
        if (MinecraftForge.EVENT_BUS.post((Event)new AttackEntityEvent(player, par1Entity))) {
            player.field_71071_by.field_70461_c -= InventoryPlayerBattle.WEAPON_SETS;
            return;
        }
        ItemStack stack = player.func_71045_bC();
        if (stack != null && stack.func_77973_b().onLeftClickEntity(stack, player, par1Entity)) {
            player.field_71071_by.field_70461_c -= InventoryPlayerBattle.WEAPON_SETS;
            return;
        }
        if (par1Entity.func_70075_an() && !par1Entity.func_85031_j((Entity)player)) {
            float f = (float)player.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111126_e();
            int i = 0;
            float f1 = 0.0f;
            if (par1Entity instanceof EntityLivingBase) {
                f1 = EnchantmentHelper.func_77512_a((EntityLivingBase)player, (EntityLivingBase)((EntityLivingBase)par1Entity));
                i += EnchantmentHelper.func_77507_b((EntityLivingBase)player, (EntityLivingBase)((EntityLivingBase)par1Entity));
            }
            if (player.func_70051_ag()) {
                ++i;
            }
            if (f > 0.0f || f1 > 0.0f) {
                boolean flag2;
                boolean flag;
                boolean bl = flag = player.field_70143_R > 0.0f && !player.field_70122_E && !player.func_70617_f_() && !player.func_70090_H() && !player.func_70644_a(Potion.field_76440_q) && player.field_70154_o == null && par1Entity instanceof EntityLivingBase;
                if (flag && f > 0.0f) {
                    f *= 1.5f;
                }
                f += f1;
                boolean flag1 = false;
                int j = EnchantmentHelper.func_90036_a((EntityLivingBase)player);
                if (par1Entity instanceof EntityLivingBase && j > 0 && !par1Entity.func_70027_ad()) {
                    flag1 = true;
                    par1Entity.func_70015_d(1);
                }
                if (flag2 = par1Entity.func_70097_a(DamageSource.func_76365_a((EntityPlayer)player), f)) {
                    IEntityMultiPart ientitymultipart;
                    if (i > 0) {
                        par1Entity.func_70024_g((double)(-MathHelper.func_76126_a((float)(player.field_70177_z * (float)Math.PI / 180.0f)) * (float)i * 0.5f), 0.1, (double)(MathHelper.func_76134_b((float)(player.field_70177_z * (float)Math.PI / 180.0f)) * (float)i * 0.5f));
                        player.field_70159_w *= 0.6;
                        player.field_70179_y *= 0.6;
                        player.func_70031_b(false);
                    }
                    if (flag) {
                        player.func_71009_b(par1Entity);
                    }
                    if (f1 > 0.0f) {
                        player.func_71047_c(par1Entity);
                    }
                    if (f >= 18.0f) {
                        player.func_71029_a((StatBase)AchievementList.field_75999_E);
                    }
                    player.func_130011_c(par1Entity);
                    if (par1Entity instanceof EntityLivingBase) {
                        EnchantmentHelper.func_151384_a((EntityLivingBase)((EntityLivingBase)par1Entity), (Entity)player);
                    }
                    EnchantmentHelper.func_151385_b((EntityLivingBase)player, (Entity)par1Entity);
                    ItemStack itemstack = player.func_71045_bC();
                    Entity object = par1Entity;
                    if (par1Entity instanceof EntityDragonPart && (ientitymultipart = ((EntityDragonPart)par1Entity).field_70259_a) != null && ientitymultipart instanceof EntityLivingBase) {
                        object = ientitymultipart;
                    }
                    if (itemstack != null && object instanceof EntityLivingBase) {
                        itemstack.func_77961_a((EntityLivingBase)object, player);
                        if (itemstack.field_77994_a <= 0) {
                            player.func_71028_bD();
                        }
                    }
                    if (par1Entity instanceof EntityLivingBase) {
                        player.func_71064_a(StatList.field_75951_w, Math.round(f * 10.0f));
                        if (j > 0) {
                            par1Entity.func_70015_d(j * 4);
                        }
                    }
                    player.func_71020_j(0.3f);
                } else if (flag1) {
                    par1Entity.func_70066_B();
                }
            }
        }
        player.field_71071_by.field_70461_c -= InventoryPlayerBattle.WEAPON_SETS;
    }

    public static void closeStream(Closeable c) {
        try {
            if (c != null) {
                c.close();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

