/*
 * Decompiled with CFR 0.152.
 */
package mods.battlegear2.client.renderer;

import java.util.List;
import mods.battlegear2.client.utils.ImageCache;
import mods.battlegear2.heraldry.TileEntityFlagPole;
import mods.battlegear2.utils.BattlegearConfig;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import org.lwjgl.opengl.GL11;

public class FlagPoleTileRenderer
extends TileEntitySpecialRenderer {
    public static final int period = 250;
    public static final int flag_sections = 16;

    public static double getZLevel(float x, float size, long time) {
        return Math.pow(x, 0.5 / (double)(size / 5.0f)) * Math.sin(Math.PI * (double)(-x / size * 3.0f + (float)(time % 250L) / 125.0f)) / 4.0;
    }

    public void func_147500_a(TileEntity tileentity, double d0, double d1, double d2, float f) {
        if (tileentity instanceof TileEntityFlagPole) {
            Minecraft.func_71410_x().field_71446_o.func_110577_a(TextureMap.field_110575_b);
            int type = tileentity.func_145832_p();
            int side = BattlegearConfig.banner.getOrient(tileentity.func_145832_p());
            GL11.glPushMatrix();
            GL11.glTranslated((double)d0, (double)d1, (double)d2);
            GL11.glColor3f((float)1.0f, (float)1.0f, (float)1.0f);
            switch (side) {
                case 0: {
                    this.renderYFlagPole(tileentity, d0, d1, d2, f, type, side);
                    this.renderYFlag(tileentity, d0, d1, d2, f, type, side);
                    break;
                }
                case 1: {
                    this.renderZFlagPole(tileentity, d0, d1, d2, f, type, side);
                    this.renderZFlag(tileentity, d0, d1, d2, f, type, side);
                    break;
                }
                case 2: {
                    GL11.glRotatef((float)90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                    GL11.glTranslatef((float)-1.0f, (float)0.0f, (float)0.0f);
                    this.renderZFlagPole(tileentity, d0, d1, d2, f, type, side);
                    this.renderZFlag(tileentity, d0, d1, d2, f, type, side);
                }
            }
            GL11.glPopMatrix();
        }
    }

    private void renderZFlag(TileEntity tileentity, double d0, double d1, double d2, float f, int type, int side) {
        Tessellator tess = Tessellator.field_78398_a;
        if (((TileEntityFlagPole)tileentity).hasFlag()) {
            GL11.glEnable((int)3042);
            GL11.glBlendFunc((int)770, (int)771);
            List<ItemStack> flags = ((TileEntityFlagPole)tileentity).getFlags();
            GL11.glDisable((int)2896);
            GL11.glMatrixMode((int)5890);
            GL11.glPushMatrix();
            GL11.glRotatef((float)-90.0f, (float)0.0f, (float)0.0f, (float)1.0f);
            for (int flagIndex = 0; flagIndex < flags.size(); ++flagIndex) {
                ItemStack flag = flags.get(flagIndex);
                ImageCache.setTexture(flag);
                long time = System.currentTimeMillis();
                for (int i = 0; i < 16; ++i) {
                    tess.func_78382_b();
                    double z1 = FlagPoleTileRenderer.getZLevel((float)(16 - i) / 16.0f + (float)flagIndex, 5.0f, time) / 5.0;
                    double z2 = FlagPoleTileRenderer.getZLevel((float)(16 - i + 1) / 16.0f + (float)flagIndex, 5.0f, time) / 5.0;
                    tess.func_78374_a(0.5 + z1, (double)((float)(-flagIndex) + (float)(i + 1) / 16.0f - 0.125f), 0.0, (double)((float)(i + 1) / 16.0f), 0.999);
                    tess.func_78374_a(0.5 + z2, (double)((float)(-flagIndex) + (float)i / 16.0f - 0.125f), 0.0, (double)((float)i / 16.0f), 0.999);
                    tess.func_78374_a(0.5 + z2, (double)((float)(-flagIndex) + (float)i / 16.0f - 0.125f), 1.0, (double)((float)i / 16.0f), 0.001);
                    tess.func_78374_a(0.5 + z1, (double)((float)(-flagIndex) + (float)(i + 1) / 16.0f - 0.125f), 1.0, (double)((float)(i + 1) / 16.0f), 0.001);
                    tess.func_78374_a(0.5 + z1, (double)((float)(-flagIndex) + (float)(i + 1) / 16.0f - 0.125f), 1.0, (double)((float)(i + 1) / 16.0f), 0.001);
                    tess.func_78374_a(0.5 + z2, (double)((float)(-flagIndex) + (float)i / 16.0f - 0.125f), 1.0, (double)((float)i / 16.0f), 0.001);
                    tess.func_78374_a(0.5 + z2, (double)((float)(-flagIndex) + (float)i / 16.0f - 0.125f), 0.0, (double)((float)i / 16.0f), 0.999);
                    tess.func_78374_a(0.5 + z1, (double)((float)(-flagIndex) + (float)(i + 1) / 16.0f - 0.125f), 0.0, (double)((float)(i + 1) / 16.0f), 0.999);
                    tess.func_78381_a();
                }
            }
            GL11.glPopMatrix();
            GL11.glMatrixMode((int)5888);
            GL11.glEnable((int)2896);
            GL11.glDisable((int)3042);
        }
    }

    private void renderZFlagPole(TileEntity tileentity, double d0, double d1, double d2, float f, int type, int side) {
        IIcon icon = BattlegearConfig.banner.func_149691_a(2, type);
        Tessellator tess = Tessellator.field_78398_a;
        tess.func_78382_b();
        tess.func_78374_a(0.5625, 0.875, 0.0, (double)icon.func_94214_a((double)BattlegearConfig.banner.getTextDim(type, 0)), (double)icon.func_94207_b((double)BattlegearConfig.banner.getTextDim(type, 0)));
        tess.func_78374_a(0.5625, 1.0, 0.0, (double)icon.func_94214_a((double)BattlegearConfig.banner.getTextDim(type, 1)), (double)icon.func_94207_b((double)BattlegearConfig.banner.getTextDim(type, 0)));
        tess.func_78374_a(0.5625, 1.0, 1.0, (double)icon.func_94214_a((double)BattlegearConfig.banner.getTextDim(type, 1)), (double)icon.func_94207_b((double)BattlegearConfig.banner.getTextDim(type, 4)));
        tess.func_78374_a(0.5625, 0.875, 1.0, (double)icon.func_94214_a((double)BattlegearConfig.banner.getTextDim(type, 0)), (double)icon.func_94207_b((double)BattlegearConfig.banner.getTextDim(type, 4)));
        tess.func_78381_a();
        tess.func_78382_b();
        tess.func_78374_a(0.4375, 0.875, 0.0, (double)icon.func_94214_a((double)BattlegearConfig.banner.getTextDim(type, 2)), (double)icon.func_94207_b((double)BattlegearConfig.banner.getTextDim(type, 0)));
        tess.func_78374_a(0.5625, 0.875, 0.0, (double)icon.func_94214_a((double)BattlegearConfig.banner.getTextDim(type, 1)), (double)icon.func_94207_b((double)BattlegearConfig.banner.getTextDim(type, 0)));
        tess.func_78374_a(0.5625, 0.875, 1.0, (double)icon.func_94214_a((double)BattlegearConfig.banner.getTextDim(type, 1)), (double)icon.func_94207_b((double)BattlegearConfig.banner.getTextDim(type, 4)));
        tess.func_78374_a(0.4375, 0.875, 1.0, (double)icon.func_94214_a((double)BattlegearConfig.banner.getTextDim(type, 2)), (double)icon.func_94207_b((double)BattlegearConfig.banner.getTextDim(type, 4)));
        tess.func_78381_a();
        tess.func_78382_b();
        tess.func_78374_a(0.4375, 0.875, 1.0, (double)icon.func_94214_a((double)BattlegearConfig.banner.getTextDim(type, 2)), (double)icon.func_94207_b((double)BattlegearConfig.banner.getTextDim(type, 4)));
        tess.func_78374_a(0.4375, 1.0, 1.0, (double)icon.func_94214_a((double)BattlegearConfig.banner.getTextDim(type, 3)), (double)icon.func_94207_b((double)BattlegearConfig.banner.getTextDim(type, 4)));
        tess.func_78374_a(0.4375, 1.0, 0.0, (double)icon.func_94214_a((double)BattlegearConfig.banner.getTextDim(type, 3)), (double)icon.func_94207_b((double)BattlegearConfig.banner.getTextDim(type, 0)));
        tess.func_78374_a(0.4375, 0.875, 0.0, (double)icon.func_94214_a((double)BattlegearConfig.banner.getTextDim(type, 2)), (double)icon.func_94207_b((double)BattlegearConfig.banner.getTextDim(type, 0)));
        tess.func_78381_a();
        tess.func_78382_b();
        tess.func_78374_a(0.4375, 1.0, 1.0, (double)icon.func_94214_a((double)BattlegearConfig.banner.getTextDim(type, 2)), (double)icon.func_94207_b((double)BattlegearConfig.banner.getTextDim(type, 4)));
        tess.func_78374_a(0.5625, 1.0, 1.0, (double)icon.func_94214_a((double)BattlegearConfig.banner.getTextDim(type, 1)), (double)icon.func_94207_b((double)BattlegearConfig.banner.getTextDim(type, 4)));
        tess.func_78374_a(0.5625, 1.0, 0.0, (double)icon.func_94214_a((double)BattlegearConfig.banner.getTextDim(type, 1)), (double)icon.func_94207_b((double)BattlegearConfig.banner.getTextDim(type, 0)));
        tess.func_78374_a(0.4375, 1.0, 0.0, (double)icon.func_94214_a((double)BattlegearConfig.banner.getTextDim(type, 2)), (double)icon.func_94207_b((double)BattlegearConfig.banner.getTextDim(type, 0)));
        tess.func_78381_a();
        icon = BattlegearConfig.banner.func_149691_a(0, type);
        tess.func_78382_b();
        tess.func_78374_a(0.4375, 1.0, 0.0, (double)icon.func_94214_a(10.0), (double)icon.func_94207_b(10.0));
        tess.func_78374_a(0.5625, 1.0, 0.0, (double)icon.func_94214_a(6.0), (double)icon.func_94207_b(10.0));
        tess.func_78374_a(0.5625, 0.875, 0.0, (double)icon.func_94214_a(6.0), (double)icon.func_94207_b(6.0));
        tess.func_78374_a(0.4375, 0.875, 0.0, (double)icon.func_94214_a(10.0), (double)icon.func_94207_b(6.0));
        tess.func_78381_a();
        tess.func_78382_b();
        tess.func_78374_a(0.4375, 0.875, 1.0, (double)icon.func_94214_a(10.0), (double)icon.func_94207_b(6.0));
        tess.func_78374_a(0.5625, 0.875, 1.0, (double)icon.func_94214_a(6.0), (double)icon.func_94207_b(6.0));
        tess.func_78374_a(0.5625, 1.0, 1.0, (double)icon.func_94214_a(6.0), (double)icon.func_94207_b(10.0));
        tess.func_78374_a(0.4375, 1.0, 1.0, (double)icon.func_94214_a(10.0), (double)icon.func_94207_b(10.0));
        tess.func_78381_a();
    }

    private void renderYFlag(TileEntity tileentity, double d0, double d1, double d2, float f, int type, int side) {
        Tessellator tess = Tessellator.field_78398_a;
        if (((TileEntityFlagPole)tileentity).hasFlag()) {
            GL11.glEnable((int)3042);
            GL11.glBlendFunc((int)770, (int)771);
            List<ItemStack> flags = ((TileEntityFlagPole)tileentity).getFlags();
            GL11.glDisable((int)2896);
            for (int flagIndex = 0; flagIndex < flags.size(); ++flagIndex) {
                ItemStack flag = flags.get(flagIndex);
                ImageCache.setTexture(flag);
                long time = System.currentTimeMillis();
                for (int i = 0; i < 16; ++i) {
                    tess.func_78382_b();
                    double z1 = FlagPoleTileRenderer.getZLevel((float)i / 16.0f + (float)flagIndex, 3.0f, time);
                    double z2 = FlagPoleTileRenderer.getZLevel((float)(i + 1) / 16.0f + (float)flagIndex, 3.0f, time);
                    tess.func_78374_a((double)(0.4375f - (float)i / 16.0f - (float)flagIndex), 0.0, 0.5 + z1, (double)((float)i / 16.0f), 0.999);
                    tess.func_78374_a((double)(0.4375f - (float)(i + 1) / 16.0f - (float)flagIndex), 0.0, 0.5 + z2, (double)((float)(i + 1) / 16.0f), 0.999);
                    tess.func_78374_a((double)(0.4375f - (float)(i + 1) / 16.0f - (float)flagIndex), 1.0025, 0.5 + z2, (double)((float)(i + 1) / 16.0f), 0.001);
                    tess.func_78374_a((double)(0.4375f - (float)i / 16.0f - (float)flagIndex), 1.0025, 0.5 + z1, (double)((float)i / 16.0f), 0.001);
                    tess.func_78374_a((double)(0.4375f - (float)i / 16.0f - (float)flagIndex), 1.0025, 0.5 + z1, (double)((float)i / 16.0f), 0.001);
                    tess.func_78374_a((double)(0.4375f - (float)(i + 1) / 16.0f - (float)flagIndex), 1.0025, 0.5 + z2, (double)((float)(i + 1) / 16.0f), 0.001);
                    tess.func_78374_a((double)(0.4375f - (float)(i + 1) / 16.0f - (float)flagIndex), 0.0, 0.5 + z2, (double)((float)(i + 1) / 16.0f), 0.999);
                    tess.func_78374_a((double)(0.4375f - (float)i / 16.0f - (float)flagIndex), 0.0, 0.5 + z1, (double)((float)i / 16.0f), 0.999);
                    tess.func_78381_a();
                }
            }
            GL11.glEnable((int)2896);
            GL11.glDisable((int)3042);
        }
    }

    private void renderYFlagPole(TileEntity tileentity, double d0, double d1, double d2, float f, int type, int side) {
        IIcon icon = BattlegearConfig.banner.func_149691_a(2, type);
        Tessellator tess = Tessellator.field_78398_a;
        tess.func_78382_b();
        tess.func_78374_a(0.4375, 0.0, 0.5625, (double)icon.func_94214_a((double)BattlegearConfig.banner.getTextDim(type, 0)), (double)icon.func_94207_b((double)BattlegearConfig.banner.getTextDim(type, 0)));
        tess.func_78374_a(0.5625, 0.0, 0.5625, (double)icon.func_94214_a((double)BattlegearConfig.banner.getTextDim(type, 1)), (double)icon.func_94207_b((double)BattlegearConfig.banner.getTextDim(type, 0)));
        tess.func_78374_a(0.5625, 1.0, 0.5625, (double)icon.func_94214_a((double)BattlegearConfig.banner.getTextDim(type, 1)), (double)icon.func_94207_b((double)BattlegearConfig.banner.getTextDim(type, 4)));
        tess.func_78374_a(0.4375, 1.0, 0.5625, (double)icon.func_94214_a((double)BattlegearConfig.banner.getTextDim(type, 0)), (double)icon.func_94207_b((double)BattlegearConfig.banner.getTextDim(type, 4)));
        tess.func_78381_a();
        tess.func_78382_b();
        tess.func_78374_a(0.5625, 0.0, 0.5625, (double)icon.func_94214_a((double)BattlegearConfig.banner.getTextDim(type, 1)), (double)icon.func_94207_b((double)BattlegearConfig.banner.getTextDim(type, 0)));
        tess.func_78374_a(0.5625, 0.0, 0.4375, (double)icon.func_94214_a((double)BattlegearConfig.banner.getTextDim(type, 2)), (double)icon.func_94207_b((double)BattlegearConfig.banner.getTextDim(type, 0)));
        tess.func_78374_a(0.5625, 1.0, 0.4375, (double)icon.func_94214_a((double)BattlegearConfig.banner.getTextDim(type, 2)), (double)icon.func_94207_b((double)BattlegearConfig.banner.getTextDim(type, 4)));
        tess.func_78374_a(0.5625, 1.0, 0.5625, (double)icon.func_94214_a((double)BattlegearConfig.banner.getTextDim(type, 1)), (double)icon.func_94207_b((double)BattlegearConfig.banner.getTextDim(type, 4)));
        tess.func_78381_a();
        tess.func_78382_b();
        tess.func_78374_a(0.5625, 0.0, 0.4375, (double)icon.func_94214_a((double)BattlegearConfig.banner.getTextDim(type, 2)), (double)icon.func_94207_b((double)BattlegearConfig.banner.getTextDim(type, 0)));
        tess.func_78374_a(0.4375, 0.0, 0.4375, (double)icon.func_94214_a((double)BattlegearConfig.banner.getTextDim(type, 3)), (double)icon.func_94207_b((double)BattlegearConfig.banner.getTextDim(type, 0)));
        tess.func_78374_a(0.4375, 1.0, 0.4375, (double)icon.func_94214_a((double)BattlegearConfig.banner.getTextDim(type, 3)), (double)icon.func_94207_b((double)BattlegearConfig.banner.getTextDim(type, 4)));
        tess.func_78374_a(0.5625, 1.0, 0.4375, (double)icon.func_94214_a((double)BattlegearConfig.banner.getTextDim(type, 2)), (double)icon.func_94207_b((double)BattlegearConfig.banner.getTextDim(type, 4)));
        tess.func_78381_a();
        tess.func_78382_b();
        tess.func_78374_a(0.4375, 0.0, 0.4375, (double)icon.func_94214_a((double)BattlegearConfig.banner.getTextDim(type, 3)), (double)icon.func_94207_b((double)BattlegearConfig.banner.getTextDim(type, 0)));
        tess.func_78374_a(0.4375, 0.0, 0.5625, (double)icon.func_94214_a((double)BattlegearConfig.banner.getTextDim(type, 4)), (double)icon.func_94207_b((double)BattlegearConfig.banner.getTextDim(type, 0)));
        tess.func_78374_a(0.4375, 1.0, 0.5625, (double)icon.func_94214_a((double)BattlegearConfig.banner.getTextDim(type, 4)), (double)icon.func_94207_b((double)BattlegearConfig.banner.getTextDim(type, 4)));
        tess.func_78374_a(0.4375, 1.0, 0.4375, (double)icon.func_94214_a((double)BattlegearConfig.banner.getTextDim(type, 3)), (double)icon.func_94207_b((double)BattlegearConfig.banner.getTextDim(type, 4)));
        tess.func_78381_a();
        icon = BattlegearConfig.banner.func_149691_a(0, type);
        tess.func_78382_b();
        tess.func_78374_a(0.4375, 0.0, 0.4375, (double)icon.func_94214_a(6.0), (double)icon.func_94207_b(6.0));
        tess.func_78374_a(0.5625, 0.0, 0.4375, (double)icon.func_94214_a(10.0), (double)icon.func_94207_b(6.0));
        tess.func_78374_a(0.5625, 0.0, 0.5625, (double)icon.func_94214_a(10.0), (double)icon.func_94207_b(10.0));
        tess.func_78374_a(0.4375, 0.0, 0.5625, (double)icon.func_94214_a(6.0), (double)icon.func_94207_b(10.0));
        tess.func_78381_a();
        tess.func_78382_b();
        tess.func_78374_a(0.5625, 1.0, 0.4375, (double)icon.func_94214_a(6.0), (double)icon.func_94207_b(6.0));
        tess.func_78374_a(0.4375, 1.0, 0.4375, (double)icon.func_94214_a(10.0), (double)icon.func_94207_b(6.0));
        tess.func_78374_a(0.4375, 1.0, 0.5625, (double)icon.func_94214_a(10.0), (double)icon.func_94207_b(10.0));
        tess.func_78374_a(0.5625, 1.0, 0.5625, (double)icon.func_94214_a(6.0), (double)icon.func_94207_b(10.0));
        tess.func_78381_a();
    }
}

