/*
 * Decompiled with CFR 0.152.
 */
package mods.battlegear2.client.renderer;

import mods.battlegear2.api.heraldry.HeraldryData;
import mods.battlegear2.api.heraldry.HeraldryTextureSmall;
import mods.battlegear2.api.heraldry.IHeraldryItem;
import mods.battlegear2.api.heraldry.RefreshableTexture;
import mods.battlegear2.items.HeraldryCrest;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.entity.RenderItem;
import net.minecraft.client.renderer.texture.DynamicTexture;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.IItemRenderer;
import org.lwjgl.opengl.GL11;

public class HeraldryCrestItemRenderer
implements IItemRenderer {
    private RenderItem itemRenderer;
    public static final ResourceLocation map_overlay = new ResourceLocation("battlegear2", "textures/heraldry/Background.png");

    public boolean handleRenderType(ItemStack item, IItemRenderer.ItemRenderType type) {
        return item.func_77973_b() instanceof HeraldryCrest && ((IHeraldryItem)item.func_77973_b()).hasHeraldry(item) && (type == IItemRenderer.ItemRenderType.INVENTORY || type == IItemRenderer.ItemRenderType.FIRST_PERSON_MAP);
    }

    public boolean shouldUseRenderHelper(IItemRenderer.ItemRenderType type, ItemStack item, IItemRenderer.ItemRendererHelper helper) {
        return false;
    }

    public void renderItem(IItemRenderer.ItemRenderType type, ItemStack item, Object ... data) {
        if (this.itemRenderer == null) {
            this.itemRenderer = new RenderItem();
        }
        byte[] heraldryData = ((IHeraldryItem)item.func_77973_b()).getHeraldry(item);
        switch (type) {
            case INVENTORY: {
                this.doInventoryRendering(item, new HeraldryData(heraldryData), (IHeraldryItem)item.func_77973_b());
                break;
            }
            case FIRST_PERSON_MAP: {
                this.doMapRendering(item, new HeraldryData(heraldryData), (IHeraldryItem)item.func_77973_b());
            }
        }
    }

    private void doMapRendering(ItemStack item, HeraldryData heraldryData, IHeraldryItem item1) {
        GL11.glPushMatrix();
        Tessellator tess = Tessellator.field_78398_a;
        Minecraft.func_71410_x().func_110434_K().func_110577_a(map_overlay);
        tess.func_78382_b();
        tess.func_78374_a(-8.0, 136.0, -0.01, 0.0, 1.0);
        tess.func_78374_a(136.0, 136.0, -0.01, 1.0, 1.0);
        tess.func_78374_a(136.0, -8.0, -0.01, 1.0, 0.0);
        tess.func_78374_a(-8.0, -8.0, -0.01, 0.0, 0.0);
        tess.func_78381_a();
        RefreshableTexture currentCrest = new RefreshableTexture(32, 32);
        currentCrest.refreshWith(heraldryData, false);
        ResourceLocation crestLocation = Minecraft.func_71410_x().func_110434_K().func_110578_a("gui_crest", (DynamicTexture)currentCrest);
        Object texture = Minecraft.func_71410_x().func_110434_K().func_110581_b(crestLocation);
        if (texture == null) {
            texture = new HeraldryTextureSmall(heraldryData);
            Minecraft.func_71410_x().func_110434_K().func_110579_a(crestLocation, texture);
        }
        Minecraft.func_71410_x().func_110434_K().func_110577_a(crestLocation);
        tess.func_78382_b();
        tess.func_78374_a(8.0, 120.0, -0.015, 0.0, 1.0);
        tess.func_78374_a(120.0, 120.0, -0.015, 1.0, 1.0);
        tess.func_78374_a(120.0, 8.0, -0.015, 1.0, 0.0);
        tess.func_78374_a(8.0, 8.0, -0.015, 0.0, 0.0);
        tess.func_78381_a();
        GL11.glPopMatrix();
    }

    private void doInventoryRendering(ItemStack item, HeraldryData heraldryData, IHeraldryItem heraldryItem) {
        Minecraft.func_71410_x().func_110434_K().func_110577_a(map_overlay);
        this.renderTexturedQuad(0, 0, this.itemRenderer.field_77023_b, 16, 16);
        IIcon icon = heraldryItem.getBaseIcon(item);
        this.itemRenderer.field_77023_b += 100.0f;
        GL11.glPushMatrix();
        RefreshableTexture currentCrest = new RefreshableTexture(32, 32);
        currentCrest.refreshWith(heraldryData, false);
        ResourceLocation crestLocation = Minecraft.func_71410_x().func_110434_K().func_110578_a("gui_crest", (DynamicTexture)currentCrest);
        Object texture = Minecraft.func_71410_x().func_110434_K().func_110581_b(crestLocation);
        if (texture == null) {
            texture = new HeraldryTextureSmall(heraldryData);
            Minecraft.func_71410_x().func_110434_K().func_110579_a(crestLocation, texture);
        }
        Minecraft.func_71410_x().func_110434_K().func_110577_a(crestLocation);
        this.renderTexturedQuad(2, 2, this.itemRenderer.field_77023_b, 12, 12);
        GL11.glPopMatrix();
        this.itemRenderer.field_77023_b -= 100.0f;
    }

    public void renderTexturedQuad(int x, int y, float z, int width, int height) {
        Tessellator tessellator = Tessellator.field_78398_a;
        tessellator.func_78382_b();
        tessellator.func_78374_a((double)(x + 0), (double)(y + height), (double)z, 0.0, 1.0);
        tessellator.func_78374_a((double)(x + width), (double)(y + height), (double)z, 1.0, 1.0);
        tessellator.func_78374_a((double)(x + width), (double)(y + 0), (double)z, 1.0, 0.0);
        tessellator.func_78374_a((double)(x + 0), (double)(y + 0), (double)z, 0.0, 0.0);
        tessellator.func_78381_a();
    }
}

