/*
 * Decompiled with CFR 0.152.
 */
package mods.battlegear2.coremod.transformers;

import java.util.List;
import java.util.ListIterator;
import mods.battlegear2.api.core.BattlegearTranslator;
import mods.battlegear2.coremod.transformers.TransformerBase;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.FieldInsnNode;
import org.objectweb.asm.tree.FieldNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.InsnNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.VarInsnNode;

public class EntityOtherPlayerMPTransformer
extends TransformerBase {
    private String itemStackClassName;
    private String entityOtherPlayerMPClassName;
    private String playerInventoryFieldName;
    private String onUpdateMethodName;
    private String onUpdateMethodDesc;
    private String setCurrentItemMethodName;
    private String setCurrentItemMethodDesc;
    private String isItemInUseFieldName;
    private String limbSwingFieldName;

    public EntityOtherPlayerMPTransformer() {
        super("net.minecraft.client.entity.EntityOtherPlayerMP");
    }

    private void processOnUpdateMethod2(MethodNode mn) {
        this.sendPatchLog("onUpdate");
        InsnList newList = new InsnList();
        ListIterator it = mn.instructions.iterator();
        boolean done = false;
        while (it.hasNext() && !done) {
            AbstractInsnNode node = (AbstractInsnNode)it.next();
            if (node instanceof FieldInsnNode && node.getOpcode() == 181 && ((FieldInsnNode)node).owner.equals(this.entityOtherPlayerMPClassName) && ((FieldInsnNode)node).name.equals(this.limbSwingFieldName)) {
                newList.add(node);
                newList.add((AbstractInsnNode)new VarInsnNode(25, 0));
                newList.add((AbstractInsnNode)new VarInsnNode(25, 0));
                newList.add((AbstractInsnNode)new VarInsnNode(25, 0));
                newList.add((AbstractInsnNode)new FieldInsnNode(180, this.entityOtherPlayerMPClassName, this.isItemInUseFieldName, "Z"));
                newList.add((AbstractInsnNode)new MethodInsnNode(184, "mods/battlegear2/client/utils/BattlegearClientUtils", "entityOtherPlayerIsItemInUseHook", "(L" + this.entityOtherPlayerMPClassName + ";Z)Z"));
                newList.add((AbstractInsnNode)new FieldInsnNode(181, this.entityOtherPlayerMPClassName, this.isItemInUseFieldName, "Z"));
                node = (AbstractInsnNode)it.next();
                while (!(node instanceof InsnNode) || node.getOpcode() != 177) {
                    node = (AbstractInsnNode)it.next();
                }
                newList.add(node);
                while (it.hasNext()) {
                    node = (AbstractInsnNode)it.next();
                    newList.add(node);
                }
                done = true;
                continue;
            }
            newList.add(node);
        }
        mn.instructions = newList;
    }

    private void processSetCurrentItemMethod(MethodNode mn) {
        this.sendPatchLog("setCurrentItem");
        EntityOtherPlayerMPTransformer.replaceInventoryArrayAccess(mn, this.entityOtherPlayerMPClassName, this.playerInventoryFieldName, 4, 3, 3);
    }

    @Override
    boolean processMethods(List<MethodNode> methods) {
        int found = 0;
        for (MethodNode mn : methods) {
            if (mn.name.equals(this.setCurrentItemMethodName) && mn.desc.equals(this.setCurrentItemMethodDesc)) {
                this.processSetCurrentItemMethod(mn);
                ++found;
            }
            if (!mn.name.equals(this.onUpdateMethodName) || !mn.desc.equals(this.onUpdateMethodDesc)) continue;
            this.processOnUpdateMethod2(mn);
            ++found;
        }
        return found == 2;
    }

    @Override
    boolean processFields(List<FieldNode> fields) {
        return true;
    }

    @Override
    void setupMappings() {
        this.itemStackClassName = BattlegearTranslator.getMapedClassName("item.ItemStack");
        this.entityOtherPlayerMPClassName = BattlegearTranslator.getMapedClassName("client.entity.EntityOtherPlayerMP");
        this.isItemInUseFieldName = BattlegearTranslator.getMapedFieldName("EntityOtherPlayerMP", "field_71186_a", "isItemInUse");
        this.limbSwingFieldName = BattlegearTranslator.getMapedFieldName("EntityLivingBase", "field_70754_ba", "limbSwing");
        this.playerInventoryFieldName = BattlegearTranslator.getMapedFieldName("EntityPlayer", "field_71071_by", "inventory");
        this.setCurrentItemMethodName = BattlegearTranslator.getMapedMethodName("EntityOtherPlayerMP", "func_70062_b", "setCurrentItemOrArmor");
        this.setCurrentItemMethodDesc = BattlegearTranslator.getMapedMethodDesc("EntityOtherPlayerMP", "func_70062_b", "(IL" + this.itemStackClassName + ";)V");
        this.onUpdateMethodName = BattlegearTranslator.getMapedMethodName("EntityOtherPlayerMP", "func_70071_h_", "onUpdate");
        this.onUpdateMethodDesc = BattlegearTranslator.getMapedMethodDesc("EntityOtherPlayerMP", "func_70071_h_", "()V");
    }
}

